

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMProcessDDBPruningRequest.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMProcessDDBPruningRequest.sp,v $ $Id: MMProcessDDBPruningRequest.sp,v 1.1.6.2 2018/10/19 15:17:19 anarulkar Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 		PROCEDURE: "MMProcessDDBPruningRequest"			|
--	|									|
--	| Execute the stored procedure to fetch the pruned archfiles		|
--	| from MMDeletedAF table.						|
-- 	+-----------------------------------------------------------------------+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MMProcessDDBPruningRequest')
BEGIN
	print '>>> Drop Stored Procedure: MMProcessDDBPruningRequest <<<'
	drop procedure MMProcessDDBPruningRequest
END
IF EXISTS (select * from GxQscripts where name='MMProcessDDBPruningRequest')
	delete from GxQscripts where name = 'MMProcessDDBPruningRequest'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMProcessDDBPruningRequest')
	delete from GXDBVersions where aliasname = 'MMProcessDDBPruningRequest'
GO
print '... Creating Procedure: MMProcessDDBPruningRequest'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MMProcessDDBPruningRequest
  @i_SIDBStoreId int,
  @i_SubStoreId int,
  @i_afXML NVARCHAR(MAX),
  @i_reserve int
AS
  DECLARE @o_SIDBStoreId int
  DECLARE @o_archFileId bigint
SET NOCOUNT ON
DECLARE     @retVal     INTEGER = 0
DECLARE @handle                 int
DECLARE @substoreBit INT = 0
DECLARE @batchCount INT = 0
EXEC sp_xml_preparedocument @handle OUTPUT, @i_afXML
if object_id('tempdb.dbo.#receivedAFFromSIDB') is not null DROP TABLE #receivedAFFromSIDB
if object_id('tempdb.dbo.#sendAFFromCS') is not null DROP TABLE #sendAFFromCS
DECLARE @substoreBits TABLE (SIDBStoreId int, SubStoreId int, subStoreBit int)
CREATE TABLE #receivedAFFromSIDB (SIDBStoreId int, SubStoreId int, archFileId bigint, subStoreBitField int)
CREATE TABLE #sendAFFromCS (SIDBStoreId int, archFileId bigint)
DECLARE @subStoreBitField INT = 0
SELECT @batchCount = value FROM MMConfigs WITH (READUNCOMMITTED) WHERE name = 'MMS2_CONFIG_DDB_VALIDATION_BATCH_COUNT'
    INSERT INTO #receivedAFFromSIDB
    SELECT @i_SIDBStoreId, @i_SubStoreId, T.archFileId, subStoreBitField
    FROM OPENXML(@handle, '/AFXML/AF', 0)
    WITH   (archFileId      int '@AFId',
        subStoreBitField        int '@bit') T
    INSERT INTO @substoreBits
    SELECT SIDBStoreId, SubStoreId, POWER(2, ((ROW_NUMBER() OVER (ORDER BY SubStoreId ASC)) -1))
    FROM    IdxSIDBSubStore WITH (NOLOCK)
    WHERE   SIDBStoreId =  @i_SIDBStoreId
    SELECT @subStoreBitField = subStoreBit
    FROM @substoreBits
    WHERE SubStoreId = @i_SubStoreId
    UPDATE MMDAF
    SET subStoreBitField |= @subStoreBitField
    FROM MMDeletedAF MMDAF, #receivedAFFromSIDB T
    WHERE MMDAF.SIDBStoreId = T.SIDBStoreId
    AND MMDAF.archFileId = T.archFileId
    INSERT INTO #sendAFFromCS
    SELECT TOP (@batchCount) D.SIDBStoreId, D.archFileId
    FROM MMDeletedAF D WITH (READUNCOMMITTED), @substoreBits S
    WHERE D.SIDBStoreId = @i_SIDBStoreId
    AND D.SIDBStoreId = S.SIDBStoreId
    AND S.SubStoreId = @i_SubStoreId
    AND D.subStoreBitField & S.subStoreBit = 0
    AND D.archFileId > 0
    GROUP BY D.SIDBStoreId, S.SubStoreId, D.archFileId, D.Status
ORDER BY (D.Status & 2) desc
    UPDATE D
SET Status |= 2
    FROM MMDeletedAF D, #sendAFFromCS T
    WHERE D.SIDBStoreId = @i_SIDBStoreId
    AND D.SIDBStoreId = T.SIDBStoreId
    AND D.archFileId = T.archFileId
    SELECT SIDBStoreId, archFileId
    FROM #sendAFFromCS
if object_id('tempdb.dbo.#receivedAFFromSIDB') is not null DROP TABLE #receivedAFFromSIDB
if object_id('tempdb.dbo.#sendAFFromCS') is not null DROP TABLE #sendAFFromCS
RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'MMProcessDDBPruningRequest')
	delete from GxQscripts where name = 'MMProcessDDBPruningRequest'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMProcessDDBPruningRequest')
	delete from GXDBVersions where aliasname = 'MMProcessDDBPruningRequest'
GO

insert into GXDBVersions values(2, 'MMProcessDDBPruningRequest',  '00010001000600020000', 'MMProcessDDBPruningRequest', '00010001000600020000')
GO

