

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMProcessBadChunkInfoList.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
--	Author: anarulkar
--	Date:   05/22/2014
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMProcessBadChunkInfoList.sp,v $ $Id: MMProcessBadChunkInfoList.sp,v 1.4.2.14 2020/09/30 02:31:12 sjohnson Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MMProcessBadChunkInfoList')
BEGIN
	print '>>> Drop Stored Procedure: MMProcessBadChunkInfoList <<<'
	drop procedure MMProcessBadChunkInfoList
END
IF EXISTS (select * from GxQscripts where name='MMProcessBadChunkInfoList')
	delete from GxQscripts where name = 'MMProcessBadChunkInfoList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMProcessBadChunkInfoList')
	delete from GXDBVersions where aliasname = 'MMProcessBadChunkInfoList'
GO
print '... Creating Procedure: MMProcessBadChunkInfoList'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MMProcessBadChunkInfoList
  @i_infoXml xml,
  @i_processJobId int,
  @i_hostId int
AS
  DECLARE @jobId INTEGER;
  DECLARE @commCellId INTEGER;
  DECLARE @copyId INTEGER;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE @now int = dbo.getUnixTime(GETUTCDATE())
DECLARE @BadChunkReviewStores TABLE (SIDBStoreId INT, StoreEligible INT)
DECLARE @BadChunkLimit INT
DECLARE @retVal INTEGER
/* Output Table
CREATE TABLE #MMProcessBadChunkInfoList_Output (jobId int, archFileCCId int, copyId int)
*/
if object_id('tempdb.dbo.#tempBadChunkInfoList') is not null DROP TABLE #tempBadChunkInfoList
CREATE TABLE #tempBadChunkInfoList (chunkId bigint, chunkCommCellId int, mountPathId int, SIDBStoreId int, volId int, archFileId int, jobId int, copyId int, archFileCCId int, flags int)
DECLARE @archFileCopyTable TABLE (archFileId INTEGER, commCellId INTEGER, archCopyId INTEGER)
INSERT	INTO #tempBadChunkInfoList
SELECT	T.c.value('@chunk', 'bigint'), T.c.value('@chunkCCId', 'int'), T.c.value('@mpId', 'int'), T.c.value('@StoreId', 'int'), T.c.value('@volId', 'int'), T.c.value('@afId', 'int'), 0, T.c.value('@copyId', 'int'), 0, T.c.value('@flags', 'int')
FROM	@i_infoXml.nodes('/r/h') T(c)
SELECT  @retVal = @@ERROR
IF (@retVal != 0) GOTO CX_EXIT
--create additional rows where the chunkId/AFId combination is not matching. This will happen in dedup case where it might be reading a chunk and send curr AFId instead of origAF.
--in such case the chunkId set may not belong to the AFId set.
INSERT INTO #tempBadChunkInfoList
SELECT ACM.archChunkId, ACM.chunkCommCellId, T.mountPathId, T.SIDBStoreId, T.volId, ACM.archFileId, ACM.jobId, ACM.archCopyId, ACM.commCellId, T.flags
FROM #tempBadChunkInfoList T
	INNER JOIN archChunkMapping ACM WITH (READUNCOMMITTED) ON T.chunkId = ACM.archChunkId AND T.chunkCommCellId = ACM.chunkCommCellId
WHERE T.archFileId <> ACM.archFileId
-- Pick SIDBStoreId from MMVolume if it wasnt sent.
UPDATE T
SET T.SIDBStoreId = V.SIDBStoreId
FROM #tempBadChunkInfoList T INNER JOIN MMVolume V ON T.VolId = V.VolumeId
WHERE T.SIDBStoreId = 0  AND T.VolId <> 0
--Update the appropriate job/copy information
UPDATE T
SET T.copyId = AFCD.archCopyId,
T.archFileCCId = AFCD.commCellId,
T.SIDBStoreId = AFCD.SIDBStoreId
FROM #tempBadChunkInfoList T, archFileCopyDedup AFCD WITH (READUNCOMMITTED)
WHERE T.archFileId = AFCD.archFileId
AND ((T.SIDBStoreId = AFCD.SIDBStoreId AND T.SIDBStoreId > 0)
	OR (T.copyId = AFCD.archCopyId AND T.copyId > 0))
AND T.archFileId > 0
SELECT  @retVal = @@ERROR
IF (@retVal != 0) GOTO CX_EXIT
--For all those rows where we could not figure out copyId due to AFId = 0, check if we can figure out using chunkId (if not pruned from CSDB)
UPDATE T
SET T.copyId = ACM.archCopyId,
T.archFileCCId = ACM.commCellId,
T.jobId = ACM.jobId,
T.SIDBStoreId = AFCD.SIDBStoreId
FROM #tempBadChunkInfoList T, archChunkMapping ACM WITH (READUNCOMMITTED), archFileCopyDedup AFCD WITH (READUNCOMMITTED)
WHERE (T.copyId = 0 OR T.SIDBStoreId = 0)
AND T.chunkId = ACM.archChunkId
AND T.chunkCommCellId = ACM.chunkCommCellId
AND ((T.SIDBStoreId = AFCD.SIDBStoreId AND T.SIDBStoreId > 0)
	OR (T.copyId = AFCD.archCopyId AND T.copyId > 0))
AND ACM.archFileId = AFCD.archFileId
SELECT  @retVal = @@ERROR
IF (@retVal != 0) GOTO CX_EXIT
--For all those rows where we could not figure out copyId due to SIDBStoreId = 0, check if we can figure out using AFId + ChunkId
UPDATE T
SET T.copyId = ACM.archCopyId,
T.jobId = ACM.jobId,
T.archFileCCId = ACM.commCellId
FROM #tempBadChunkInfoList T, archChunkMapping ACM WITH (READUNCOMMITTED)
WHERE T.copyId = 0
AND T.SIDBStoreId = 0
AND T.chunkId = ACM.archChunkId
AND T.archFileId = ACM.archFileId
AND T.chunkCommCellId = ACM.chunkCommCellId
SELECT  @retVal = @@ERROR
IF (@retVal != 0) GOTO CX_EXIT
--Update jobIds for archFileId
UPDATE T
SET T.jobId = AF.jobId
FROM #tempBadChunkInfoList T, archFile AF WITH (READUNCOMMITTED)
WHERE T.archFileId = AF.id
AND T.archFileCCId = AF.commCellId
AND T.archFileId > 0
AND T.jobId = 0
SELECT  @retVal = @@ERROR
IF (@retVal != 0) GOTO CX_EXIT
-- All figured out. Mark verification failed and bad.
-- On archChunk table
UPDATE AC
SET AC.flags = AC.flags | 8192, ModifiedTime = @now
FROM archChunk AC, (SELECT DISTINCT ChunkId, chunkCommCellId FROM #tempBadChunkInfoList) T
WHERE T.chunkId = AC.id AND T.chunkCommCellId = AC.CommCellId
SELECT  @retVal = @@ERROR
IF (@retVal != 0) GOTO CX_EXIT
-- On archChunkMapping table
UPDATE ACM
SET ACM.flags = ((ACM.flags & (~255)) | 4) | 8192, ModifiedTime = @now
OUTPUT INSERTED.archFileId, INSERTED.CommCellId, INSERTED.archCopyId INTO @archFileCopyTable
FROM archChunkMapping ACM, (SELECT DISTINCT ChunkId, chunkCommCellId FROM #tempBadChunkInfoList) T
WHERE T.chunkId = ACM.archChunkId AND T.chunkCommCellId = ACM.chunkCommCellId
SELECT  @retVal = @@ERROR
IF (@retVal != 0) GOTO CX_EXIT
-- On archFileCopy table
-- If EDGE archive file, we should mark archFile chunk is bad across all copies to avoid chunk reuse
UPDATE AFC
SET AFC.flags = AFC.flags | 8192, ModifiedTime = @now
FROM archFileCopy AFC,
		 (SELECT archFileId, CommCellId, archCopyId
		 FROM @archFileCopyTable
		 UNION
		 SELECT archFileId, archFileCCId, copyId
		 FROM  #tempBadChunkInfoList) T,
		 archFile AF WITH (NOLOCK)
WHERE T.archFileId = AFC.archFileId AND T.CommCellId = AFC.CommCellId
	 AND T.archFileId = AF.id AND T.CommCellId = AF.CommCellId
AND ((AF.flags & (32768|2097152)) > 0 OR T.archCopyId = AFC.archCopyId)
SELECT  @retVal = @@ERROR
IF (@retVal != 0) GOTO CX_EXIT
--Redirect and Insert rows that are sent from non-scalable recon (new flag added only for bAllowAddRecordsOnChunkFailure) to archChunkToSyncDDBFailedChunks
INSERT INTO archChunkToSyncDDBFailedChunks (adminJobId, SIDBStoreId, VolumeId, ChunkId, ChunkCommCellId, SrcMAId, Modified, Flags)
SELECT DISTINCT @i_processJobId, T.SIDBStoreId, AC.VolumeId, T.chunkId, T.chunkCommCellId, @i_hostId, @now, T.flags
FROM #tempBadChunkInfoList T
	JOIN ArchChunk AC WITH (NOLOCK) ON AC.id = T.chunkId AND AC.commCellId = T.chunkCommCellId
	LEFT OUTER JOIN archChunkToSyncDDBFailedChunks ACSF ON ACSF.ChunkId = T.ChunkId AND ACSF.chunkcommCellId = T.chunkcommCellId AND ACSF.SIDBStoreId = T.SIDBStoreId AND ACSF.adminJobId = @i_processjobId
WHERE ((T.Flags & 4) = 4)
	 AND (ACSF.Chunkid IS NULL)
--Insert those rows which are not present in archChunkDDBDrop. Do it only for SIDBStoreId > 0
INSERT INTO archChunkDDBDrop(archChunkId, chunkCommCellId, SIDBStoreId, mountPathId, volumeId, insertTime, flags, reserveInt, reserveBigInt, reserveStr)
SELECT DISTINCT T.chunkId, T.chunkCommCellId, T.SIDBStoreId, 0, 0, @now, T.flags, @i_processJobId, @i_hostId, ''
FROM #tempBadChunkInfoList T
	LEFT OUTER JOIN archChunkDDBDrop ACDD ON ACDD.archChunkId = T.chunkId AND ACDD.chunkCommCellId = T.chunkCommcellId AND ACDD.SIDBStoreId = T.SIDBStoreId
WHERE (T.SIDBStoreId > 0) AND ((T.Flags & 4) = 0) -- Do not mark chunk bad in DDB for recon cases
AND (ACDD.archChunkId IS NULL)
SELECT  @retVal = @@ERROR
IF (@retVal != 0) GOTO CX_EXIT
SELECT @BadChunkLimit = ISNULL(value, 1000) FROM MMConfigs WHERE name = 'MMCONFIG_DDB_BAD_CHUNKS_LIMIT'
/*
Logic for putting store/chunks into review:
First step is to check if there are Bad CHunks limit number of chunks in current 5 mins window
If yes, there are two further steps for eligibility:
1] Either we have 200 chunks with same insertTime in this 5 mins window
2] OR we have another chunk with review pending flag set in this 5 mins window
The idea is that a batch of review pending chunks is triggered only when we also have 200 chunks with same insert time
If a batch has been started, then continue extend the window to every subsequent 5 min window as long as we keep finding limit chunks.
The batch is broken when 5 mins have elapsed since the last chunk in pending review and we dont have limit chunks in 5 min window.
*/
INSERT INTO @BadChunkReviewStores
SELECT SIDBStoreId, 0
FROM archChunkDDBDrop
WHERE 	insertTime between (@now - (5*60)) AND @now
AND 	(flags & 8) = 0
GROUP BY SIDBStoreId
HAVING COUNT(archChunkId) > @BadChunkLimit
--Continue batch
UPDATE BCR
SET StoreEligible = 1
FROM @BadChunkReviewStores BCR
JOIN ArchChunkDDBDrop ACDrop ON BCR.SIDBStoreId = ACDrop.SIDBStoreId
WHERE ACDrop.insertTime between (@now - 5*60) AND @now
AND (ACDrop.flags & (1 | 8)) = 1
AND StoreEligible = 0
--Trigger new batch if not already done so
UPDATE BCR
SET StoreEligible = 1
FROM @BadChunkReviewStores BCR
JOIN (	SELECT ACDrop.SIDBStoreId as SIDBStoreId, COUNT(Distinct archChunkId) as ChunkCount
		FROM archChunkDDBDrop ACDrop
		JOIN @BadChunkReviewStores Stores ON ACDrop.SIDBStoreId = Stores.SIDBStoreId
WHERE ((ACDrop.flags & 8) = 0)
		AND (ACDrop.insertTime between (@now - 5*60) AND @now)
		GROUP BY ACDrop.SIDBStoreId, InsertTime
		HAVING COUNT(distinct ArchChunkId) >= 200) BatchStart ON BatchStart.SIDBStoreId = BCR.SIDBStoreId
WHERE StoreEligible = 0
UPDATE ACDrop
SET flags = flags | 1
FROM archChunkDDBDrop ACDrop
JOIN @BadChunkReviewStores Stores ON ACDrop.SIDBStoreId = Stores.SIDBStoreId
WHERE ACDrop.insertTime between (@now - (5*60)) AND @now
AND (ACDrop.flags &  (1 | 8)) = 0
	AND Stores.StoreEligible = 1
SELECT  @retVal = @@ERROR
IF (@retVal != 0) GOTO CX_EXIT
UPDATE STORE
SET extendedFlags = extendedFlags | 16
FROM IdxSIDBStore STORE
JOIN @BadChunkReviewStores RStore ON STORE.SIDBStoreId = RStore.SIDBStoreId
WHERE 	(STORE.extendedFlags & 16) = 0
AND		RStore.StoreEligible = 1
SELECT  @retVal = @@ERROR
IF (@retVal != 0) GOTO CX_EXIT
-- delete invalid chunks so that jobs are not marked as verification failed.
DELETE T
FROM #tempBadChunkInfoList T
	INNER JOIN archChunk AC WITH (READUNCOMMITTED) ON AC.id = T.chunkId AND AC.commCellId = T.chunkCommCellId
	LEFT OUTER JOIN archChunkMapping ACM WITH (READUNCOMMITTED) ON AC.id = ACM.archChunkId AND AC.commCellId = ACM.chunkCommCellId
WHERE AC.physicalSize = 0
AND AC.logicalSize = 0
AND ((ACM.archChunkId IS NULL) OR (ACM.chunkNumber = 0))
IF EXISTS (SELECT * from MMConfigs WITH (NOLOCK) WHERE name = 'MMCONFIG_MARK_JOB_VERIFICATION_FAILED_FOR_READ_ERRORS' AND value > 0)
BEGIN
	--On Job level
	UPDATE JMDS
	SET archCheckStatus = 6, -- ACS_FAILED
	archCheckEndTime = @now
	FROM JMJobDataStats JMDS
	JOIN #tempBadChunkInfoList T ON JMDS.jobId = T.jobId AND JMDS.commCellId = T.archFileCCId AND JMDS.archGrpCopyId = T.copyId
WHERE (T.flags & 2) = 0
END
SELECT  @retVal = @@ERROR
IF (@retVal != 0) GOTO CX_EXIT
CX_EXIT:
IF OBJECT_ID('tempdb.dbo.#MMProcessBadChunkInfoList_Output') IS NOT NULL
BEGIN
	INSERT INTO #MMProcessBadChunkInfoList_Output
	SELECT DISTINCT T.jobId, T.archFileCCId, T.copyId
	FROM #tempBadChunkInfoList T
END
ELSE
BEGIN
	SELECT DISTINCT T.jobId, T.archFileCCId, T.copyId
	FROM #tempBadChunkInfoList T
END
RETURN	@retVal
if object_id('tempdb.dbo.#tempBadChunkInfoList') is not null DROP TABLE #tempBadChunkInfoList
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'MMProcessBadChunkInfoList')
	delete from GxQscripts where name = 'MMProcessBadChunkInfoList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMProcessBadChunkInfoList')
	delete from GXDBVersions where aliasname = 'MMProcessBadChunkInfoList'
GO

insert into GXDBVersions values(2, 'MMProcessBadChunkInfoList',  '00010004000200140000', 'MMProcessBadChunkInfoList', '00010004000200140000')
GO

