

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMPowerOnIfCloudVM.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMPowerOnIfCloudVM.sp,v $ $Id: MMPowerOnIfCloudVM.sp,v 1.1.2.15 2019/12/03 21:51:24 prasanthm Exp $";
--  +-----------------------------------------------------------------------+
--  |       PROCEDURE	:	"MMPowerOnIfCloudVM"               				|
--  |       Author	    :	prasanthm                            			|
--  | Execute the System stored procedure to fetch the physical files   	|
--  | .. for the (current) database.                    					|
--  +-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MMPowerOnIfCloudVM')
BEGIN
	print '>>> Drop Stored Procedure: MMPowerOnIfCloudVM <<<'
	drop procedure MMPowerOnIfCloudVM
END
IF EXISTS (select * from GxQscripts where name='MMPowerOnIfCloudVM')
	delete from GxQscripts where name = 'MMPowerOnIfCloudVM'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMPowerOnIfCloudVM')
	delete from GXDBVersions where aliasname = 'MMPowerOnIfCloudVM'
GO
print '... Creating Procedure: MMPowerOnIfCloudVM'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMPowerOnIfCloudVM
  @i_HostId Integer,
  @i_JobId Integer,
  @i_callerFlag Integer,
  @i_commCellId Integer = 2,
  @i_RMRequestId Integer = 0
AS
  DECLARE @o_retCode Integer
DECLARE @IsCloudVMManagementEnabled INTEGER = 0
DECLARE @retCode INTEGER = 0
DECLARE @JobType INTEGER = 1
SELECT @IsCloudVMManagementEnabled = value FROM MMConfigs WITH (NOLOCK) WHERE name = 'MMCONFIG_CLOUD_VM_MANAGEMENT_ENABLED_FLAG'
DECLARE @currentUTCTime BIGINT = dbo.GetUnixTime(GetUTCDate())
-- If the power mangement feature not enabled or power management not enabled on the MediaAgent
IF @IsCloudVMManagementEnabled = 0 OR NOT EXISTS ( SELECT 1 FROM MMHost WITH(NOLOCK) WHERE clientId = @i_HostId AND (Attribute & 32768) = 32768)
BEGIN
	GOTO SP_EXIT
END
IF (@i_callerFlag & 2 ) = 0 AND
	EXISTS(SELECT top 1 1 FROM MMVMPowerMgmtReq VPM WITH(NOLOCK)
			INNER JOIN MMPowerMgmtJobToVMMap VMMAP WITH(NOLOCK) ON VPM.RequestId = VMMAP.RequestId
WHERE VPM.HostId = @i_HostId AND (VPM.Flags & 4) = 0 AND VPM.FailureReason = 2 AND VPM.LastUpdateTime > (@currentUTCTime - (10*60))
AND (@i_JobId = 0 OR (VMMAP.EntityId = @i_JobId AND VMMAP.EntityType = 1))
			ORDER BY VPM.RequestId DESC)
BEGIN
SET @retCode = 66503
	GOTO SP_EXIT
END
IF @i_JobId IN (0,-1)
BEGIN
	SET @i_JobId = 0
	SET @JobType = 0
END
IF @i_commCellId = 0
	SET @i_commCellId = 2
/* If Power On Request */
DECLARE @PowerStatus INTEGER = 0
DECLARE @requestId INTEGER = 0
-- Virtual Machine already running
SELECT top 1 @PowerStatus = PowerStatus FROM MMPowerMgmtHost WITH (NOLOCK) WHERE HostId = @i_HostId AND PowerStatus IN (2, 3)
IF @PowerStatus > 0
BEGIN
	SELECT top 1 @requestId = RequestId FROM MMVMPowerMgmtReq VPM WITH(NOLOCK)
WHERE VPM.HostId = @i_HostId AND (VPM.Flags & 4) = 0
							ORDER BY RequestId DESC
	IF @requestId = 0
		GOTO NEW_REQUEST
	IF NOT EXISTS( SELECT 1 FROM MMPowerMgmtJobToVMMap VM WITH(NOLOCK) WHERE VM.EntityType = @JobType AND VM.EntityId = @i_JobId AND VM.EntityCommCellId = @i_commCellId
					AND VM.HostId = @i_HostId AND VM.RequestId = @requestId AND VM.Flag = @i_callerFlag AND VM.RMRequestId = @i_RMRequestId)
	BEGIN
		INSERT INTO MMPowerMgmtJobToVMMap (HostId, EntityType, EntityId, EntityCommCellId, RequestId, Flag, RMRequestId, ReqStartTime)
		SELECT @i_HostId, @JobType , @i_JobId, @i_commCellId, @requestId, @i_callerFlag, @i_RMRequestId, @currentUTCTime
	END
IF @PowerStatus = 2
SET @retCode = 346
	GOTO SP_EXIT
END
-- Power on request already present
SELECT top 1 @requestId = RequestId FROM MMVMPowerMgmtReq VPM WITH(NOLOCK)
WHERE VPM.HostId = @i_HostId AND VPM.RequestStatus IN (1 , 2 )
AND (VPM.Flags & 4) = 0
									ORDER BY RequestId DESC
IF @requestId <> 0
BEGIN
	-- If the same request comes
	IF NOT EXISTS( SELECT 1 FROM MMPowerMgmtJobToVMMap VM WITH(NOLOCK) WHERE VM.EntityType = @JobType AND VM.EntityId = @i_JobId AND VM.EntityCommCellId = @i_commCellId
					AND VM.HostId = @i_HostId AND VM.RequestId = @requestId AND VM.Flag = @i_callerFlag AND VM.RMRequestId = @i_RMRequestId)
	BEGIN
		INSERT INTO MMPowerMgmtJobToVMMap (HostId, EntityType, EntityId, EntityCommCellId, RequestId, Flag, RMRequestId, ReqStartTime)
		SELECT @i_HostId, @JobType, @i_JobId, @i_commCellId, @requestId, @i_callerFlag, @i_RMRequestId, @currentUTCTime
	END
SET @retCode = 346
	GOTO SP_EXIT
END
NEW_REQUEST:
-- New Request
DECLARE @TmpRequestTbl TABLE(Id INTEGER)
-- inserting into primary table
INSERT INTO MMVMPowerMgmtReq (HostId , requestStatus, failureReason, flags, ReqStartTime, ReqExpiryTime, RetryCount, LastUpdateTime)
OUTPUT INSERTED.RequestId INTO @TmpRequestTbl
SELECT @i_HostId, 1, 0, @i_callerFlag , @currentUTCTime , 0, 0, @currentUTCTime
SELECT TOP 1 @requestId = Id FROM @TmpRequestTbl
-- inserting into secondary table
INSERT INTO MMPowerMgmtJobToVMMap (HostId, EntityType, EntityId, EntityCommCellId, RequestId, Flag, RMRequestId, ReqStartTime)
SELECT @i_HostId, @JobType, @i_JobId, @i_commCellId, @requestId, @i_callerFlag, @i_RMRequestId, @currentUTCTime
SET @retCode = 346
SP_EXIT:
IF OBJECT_ID('tempdb.dbo.#tmpPowerVMRetCode') IS NOT NULL
	INSERT INTO #tmpPowerVMRetCode SELECT @i_HostId, @retCode
ELSE
	SELECT @retCode
GO

IF EXISTS (select * from GxQscripts where name = 'MMPowerOnIfCloudVM')
	delete from GxQscripts where name = 'MMPowerOnIfCloudVM'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMPowerOnIfCloudVM')
	delete from GXDBVersions where aliasname = 'MMPowerOnIfCloudVM'
GO

insert into GXDBVersions values(2, 'MMPowerOnIfCloudVM',  '00010001000200150000', 'MMPowerOnIfCloudVM', '00010001000200150000')
GO

