

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMOnRemoveClientGrpPowerMgmt.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--  +-----------------------------------------------------------------------+
--  |       PROCEDURE	:	"MMOnRemoveClientGrpPowerMgmt"               	|
--  |       Author	    :	ksanghvi                            		|
--  | Execute the System stored procedure to fetch the physical files   	|
--  | .. for the (current) database.                    			|
--  +-----------------------------------------------------------------------+
--  -- Input XML Format
--  -- <App_SetOnRemoveClientGrpPowerMgmt>
--  --      <removeClient val = "id1"/>
--  --      <removeClient val = "id2"/>
--  --      ..
--  -- </App_SetOnRemoveClientGrpPowerMgmt>
-- Following Line Indicates new Class.  It should be identical to filename!
SET ANSI_NULLS ON
SET NOCOUNT ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MMOnRemoveClientGrpPowerMgmt')
BEGIN
	print '>>> Drop Stored Procedure: MMOnRemoveClientGrpPowerMgmt <<<'
	drop procedure MMOnRemoveClientGrpPowerMgmt
END
IF EXISTS (select * from GxQscripts where name='MMOnRemoveClientGrpPowerMgmt')
	delete from GxQscripts where name = 'MMOnRemoveClientGrpPowerMgmt'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMOnRemoveClientGrpPowerMgmt')
	delete from GXDBVersions where aliasname = 'MMOnRemoveClientGrpPowerMgmt'
GO
print '... Creating Procedure: MMOnRemoveClientGrpPowerMgmt'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MMOnRemoveClientGrpPowerMgmt
  @i_clientGroupID INT,
  @i_xmlText XML
AS
  DECLARE @o_errorCode INT
  DECLARE @o_errorMessage NVARCHAR(MAX)
DECLARE @vClientID 		INT = 0
-- Proc called only when power mgmt is enabled on client group
DECLARE @enablePowerMgmt 	INT = 1
DECLARE @clientGroupName        NVARCHAR(MAX)
DECLARE @errorMessage		NVARCHAR(MAX) = N''
DECLARE @errorCode              INT = 0
DECLARE @mediaAgentID			INT
DECLARE @repClientGroupId       INT = 0
DECLARE @powerManagementEnabled INT
SET @powerManagementEnabled = (select value from MMConfigs WITH (NOLOCK) where name = 'MMCONFIG_CLOUD_VM_MANAGEMENT_ENABLED_FLAG')
IF @powerManagementEnabled <> 1
    BEGIN
SET @errorCode		= 0
		SET @errorMessage	= 'No power management configured'
        	SELECT @errorCode,@errorMessage
		return;
    END
-- Check whether ClientGroup is valid
SELECT TOP 1 @clientGroupName = ACG.name FROM APP_ClientGroup AS ACG WITH (NOLOCK) WHERE ACG.id = @i_clientGroupID
IF @clientGroupName IS NULL
	BEGIN
SET @errorCode		= 100
		SET @errorMessage	= 'Client Group does not exist'
        	SELECT @errorCode,@errorMessage
		return;
	END
if object_id('tempdb.dbo.#mAgentRemovedCGList') is not null DROP TABLE #mAgentRemovedCGList
CREATE TABLE #mAgentRemovedCGList(
	mAgentID	INT
)
-- Insert all Amazon/Azure based Media Agents ID's into #mAgentRemovedCGList temp table which honor client group settings
IF (@i_xmlText.exist('App_SetOnRemoveClientGrpPowerMgmt/removeClient') <> 0)
-- Some clients were removed from the client group, reconfigure only them
    BEGIN
        INSERT INTO #mAgentRemovedCGList
        SELECT a.b.value('@val','INT')
        FROM @i_xmlText.nodes('App_SetOnRemoveClientGrpPowerMgmt/removeClient') a(b)
        INNER JOIN APP_ClientProp AS CPR WITH (NOLOCK) ON CPR.componentNameId = a.b.value('@val','INT') AND CPR.attrName = 'VSA HyperVisor Type'
INNER JOIN MMPowerMgmtHost AS MPH WITH (NOLOCK) ON MPH.HostId = CPR.componentNameId AND MPH.Flags & 1024 = 0
        WHERE ( CAST(CPR.attrVal AS INTEGER) & (1 | 16 | 32 | 64 | 512) ) > 0   -- AMAZON_VM = 16, AZURE_VM = 32, VMWARE_VM = 1, GOOGLE_CLOUD_VM = 64, KUBERNETES_VM = 512
    END
ELSE
-- Client group is being deleted -> So reconfigure all
    BEGIN
        INSERT INTO #mAgentRemovedCGList
        SELECT APP.id FROM APP_Client AS APP WITH (NOLOCK)
        INNER JOIN APP_ClientGroupAssoc AS ACGA WITH (NOLOCK) ON APP.id = ACGA.clientId
INNER JOIN MMPowerMgmtHost AS MPH WITH (NOLOCK) ON MPH.HostId = APP.id AND MPH.Flags & 1024 = 0
        INNER JOIN APP_ClientProp AS CPR WITH (NOLOCK) ON CPR.componentNameId = APP.id AND CPR.attrName = 'VSA HyperVisor Type' AND CPR.modified = 0
        WHERE  ACGA.clientGroupId = @i_clientGroupID
        AND ( CAST(CPR.attrVal AS INTEGER) & (1 | 16 | 32 | 64 | 512) ) > 0   -- AMAZON_VM = 16, AZURE_VM = 32, VMWARE_VM = 1, GOOGLE_CLOUD_VM = 64, KUBERNETES_VM = 512
    END
IF (@@ERROR <> 0)
	BEGIN
		SET @errorCode 		= @@ERROR
		SET @errorMessage	= 'Failed to retrieve Cloud Media Agents'
		GOTO ERROR_EXIT
	END
BEGIN TRANSACTION
DECLARE cur CURSOR FOR
    SELECT mAgentID FROM #mAgentRemovedCGList
OPEN cur
FETCH NEXT FROM cur INTO @mediaAgentID
WHILE @@FETCH_STATUS = 0
BEGIN
    -- Check if the current MediaAgent and ClientGroup do not have the same CloudController
    IF NOT EXISTS (SELECT 1 FROM MMPowerMgmtHost AS MPH WITH (NOLOCK)
			    INNER JOIN APP_ComponentProp AS ACP WITH (NOLOCK) ON MPH.ControllerNode = CAST(ACP.longVal AS INTEGER)
AND ACP.propertyTypeId = 3502 AND ACP.componentId = @i_clientGroupID
AND ACP.modified = 0 AND ACP.componentType = 8
			    WHERE MPH.HostId = @mediaAgentID)
        BEGIN
            GOTO FETCH_NEXT_MEDIA_AGENT
        END
    -- Check if the current MediaAgent is only part of this ClientGroup
    IF NOT EXISTS(SELECT 1 FROM APP_ClientGroupAssoc WITH (NOLOCK)
                    WHERE clientGroupId <> @i_clientGroupID
                    AND clientId = @mediaAgentID)
        BEGIN
            SET @enablePowerMgmt = 0
            GOTO RECONFIGURE_MEDIA_AGENT
        END
    -- Check if current MediaAgent has a common CloudController with any other ClientGroup on which power mgmt is enabled
    SELECT TOP 1 @repClientGroupId = ACGA.clientGroupId, @vClientID = MPH.ControllerNode  FROM APP_ClientGroupAssoc AS ACGA WITH (NOLOCK)
    INNER JOIN MMPowerMgmtHost AS MPH WITH (NOLOCK) ON ACGA.clientId = MPH.HostId
INNER JOIN APP_ComponentProp AS ACPR WITH (NOLOCK) ON ACPR.componentId =  ACGA.clientGroupId AND CAST(ACPR.longVal AS INTEGER) = MPH.ControllerNode AND ACPR.componentType = 8 AND ACPR.modified = 0 AND ACPR.propertyTypeId = 3502
INNER JOIN APP_ComponentProp AS ACPS WITH (NOLOCK) ON ACPS.componentId = ACPR.componentId AND ACPS.componentType = 8 AND ACPS.modified = 0 AND ACPS.propertyTypeId = 3501 AND ACPS.longVal = 1
    WHERE  ACGA.clientGroupId <> @i_clientGroupID AND ACGA.clientId = @mediaAgentID
    IF (@@ERROR <> 0)
		BEGIN
            SET @errorCode 		= @@ERROR
            SET @errorMessage	= 'Query Failed'
            GOTO QUIT_WITH_ROLLBACK
        END
    IF @repClientGroupId <> 0
    BEGIN
       GOTO RECONFIGURE_MEDIA_AGENT
    END
    -- Select random client group which does not have same cloud controller as current media agent but power management is enabled on it
    SELECT TOP 1 @vClientID = ACPR.longVal, @repClientGroupId = ACPR.componentId FROM APP_ClientGroupAssoc AS ACGA WITH (NOLOCK)
INNER JOIN APP_ComponentProp AS ACPR WITH (NOLOCK) ON ACPR.componentId = ACGA.clientGroupId AND ACPR.componentType = 8 AND ACPR.modified = 0 AND ACPR.propertyTypeId = 3502
INNER JOIN APP_ComponentProp AS ACPS WITH (NOLOCK) ON ACPS.componentId = ACPR.componentId AND ACPS.componentType = 8 AND ACPS.modified = 0 AND ACPS.propertyTypeId = 3501 AND ACPS.longVal = 1
    WHERE ACGA.clientId = @mediaAgentID AND ACGA.clientGroupId <> @i_clientGroupID
    IF @vClientID = 0
	BEGIN
		SET @enablePowerMgmt = 0
	END
    RECONFIGURE_MEDIA_AGENT:
    UPDATE MMHost SET Attribute =	CASE
										WHEN (@enablePowerMgmt = 1)
THEN (Attribute | 32768)
ELSE (Attribute & ~32768)
									END
	WHERE ClientId = @mediaAgentID
    IF (@@ERROR <> 0)
        BEGIN
            SET @errorCode 		= @@ERROR
            SET @errorMessage	= 'Failed to update MMHost table'
            GOTO QUIT_WITH_ROLLBACK
        END
    UPDATE MMPowerMgmtHost SET ControllerNode = @vClientID, isEnabled = @enablePowerMgmt, ClientGroupId = @repClientGroupId
    WHERE HostId = @mediaAgentID
    IF (@@ERROR <> 0)
        BEGIN
            SET @errorCode 		= @@ERROR
            SET @errorMessage	= 'Failed to update MMPowerMgmtHost table'
            GOTO QUIT_WITH_ROLLBACK
        END
    FETCH_NEXT_MEDIA_AGENT:
    -- Reset loop variables to defaults
    SET @vClientID = 0
    SET @repClientGroupId = 0
    SET @enablePowerMgmt = 1
    FETCH NEXT FROM cur INTO @mediaAgentID
END
CLOSE cur
DEALLOCATE cur
-- Set props as modified for deleted client group
IF (@i_xmlText.exist('App_SetOnRemoveClientGrpPowerMgmt/removeClient')  =  0)
    BEGIN
        UPDATE APP_ComponentProp SET modified = dbo.GetUnixTime(GETDATE())
WHERE propertyTypeId = 3502
        AND componentId = @i_clientGroupID
		UPDATE APP_ComponentProp SET modified = dbo.GetUnixTime(GETDATE())
WHERE  propertyTypeId = 3501
        AND componentId = @i_clientGroupID
    END
COMMIT TRANSACTION
GOTO ERROR_EXIT
QUIT_WITH_ROLLBACK:
	IF ( @@TRANCOUNT > 0 ) ROLLBACK TRANSACTION
    GOTO ERROR_EXIT
ERROR_EXIT:
    DROP TABLE #mAgentRemovedCGList
    SELECT @errorCode,@errorMessage
GO

IF EXISTS (select * from GxQscripts where name = 'MMOnRemoveClientGrpPowerMgmt')
	delete from GxQscripts where name = 'MMOnRemoveClientGrpPowerMgmt'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMOnRemoveClientGrpPowerMgmt')
	delete from GXDBVersions where aliasname = 'MMOnRemoveClientGrpPowerMgmt'
GO

insert into GXDBVersions values(2, 'MMOnRemoveClientGrpPowerMgmt',  '00000000000000000000', 'MMOnRemoveClientGrpPowerMgmt', '00000000000000000000')
GO

