

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMOnAddClientGrpPowerMgmt.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--  +-----------------------------------------------------------------------+
--  |       PROCEDURE	:	"MMOnAddClientGrpPowerMgmt"               	|
--  |       Author	    :	ksanghvi                            		|
--  | Execute the System stored procedure to fetch the physical files   |
--  | .. for the (current) database.                    			    |
--  +-----------------------------------------------------------------------+
--  -- Input XML Format
--  -- <App_SetOnAddClientGrpPowerMgmt>
--  --      <addClient val ="id1"/>
--  --      <addClient val ="id2"/>
--  --      ..
--  -- </App_SetOnAddClientGrpPowerMgmt>
-- Following Line Indicates new Class.  It should be identical to filename!
SET ANSI_NULLS ON
SET NOCOUNT ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MMOnAddClientGrpPowerMgmt')
BEGIN
	print '>>> Drop Stored Procedure: MMOnAddClientGrpPowerMgmt <<<'
	drop procedure MMOnAddClientGrpPowerMgmt
END
IF EXISTS (select * from GxQscripts where name='MMOnAddClientGrpPowerMgmt')
	delete from GxQscripts where name = 'MMOnAddClientGrpPowerMgmt'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMOnAddClientGrpPowerMgmt')
	delete from GXDBVersions where aliasname = 'MMOnAddClientGrpPowerMgmt'
GO
print '... Creating Procedure: MMOnAddClientGrpPowerMgmt'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MMOnAddClientGrpPowerMgmt
  @i_clientGroupID INT,
  @i_enablePowerMgmt INT,
  @i_xmlText XML
AS
  DECLARE @o_Result XML;
DECLARE @vClientID              INT = 0
DECLARE @clientGroupName        NVARCHAR(MAX)
DECLARE @errorMessage		NVARCHAR(MAX)
DECLARE @errorCode              INT = 0
DECLARE @proxyXML		XML
DECLARE @hasCommon		INT = 0
DECLARE @hasActiveProxies	INT = 0
DECLARE @mediaAgentID		INT
DECLARE @resultXML		XML
DECLARE @powerManagementEnabled INT
SET @powerManagementEnabled = (select value from MMConfigs WITH (NOLOCK) where name = 'MMCONFIG_CLOUD_VM_MANAGEMENT_ENABLED_FLAG')
IF @powerManagementEnabled <> 1
	BEGIN
SET @errorCode		= 0
			SET @errorMessage	= 'No power management configured'
			SET @resultXML		= (SELECT	1	as TAG,
							NULL		as Parent,
							@errorCode	as [App_GenericResp!1!errorCode],
							@errorMessage	as [App_GenericResp!1!errorMessage]
							FOR XML EXPLICIT
						);
			SELECT @resultXML;
			return;
	END
if object_id('tempdb.dbo.#mAgentAddedCGList') is not null DROP TABLE #mAgentAddedCGList
CREATE TABLE #mAgentAddedCGList(
	mAgentID	INT
)
if object_id('tempdb.dbo.#mAgentCommon') is not null DROP TABLE #mAgentCommon
CREATE TABLE #mAgentCommon(
	mAgentID	INT,
	commonMAName NVARCHAR(MAX)
)
if object_id('tempdb.dbo.#mAgentProxy') is not null DROP TABLE #mAgentProxy
CREATE TABLE #mAgentProxy (
	mAgentID	INT,
	commonProxyMAName NVARCHAR(MAX)
)
DECLARE @proxyAssocTable TABLE(
	proxiesXML XML
)
-- Check whether ClientGroup is valid
SELECT TOP 1 @clientGroupName = ACG.name FROM APP_ClientGroup AS ACG WITH (NOLOCK) WHERE ACG.id = @i_clientGroupID
IF @clientGroupName IS NULL
	BEGIN
SET @errorCode		= 100
		SET @errorMessage	= 'Client Group does not exist'
		SET @resultXML		= (SELECT	1	as TAG,
						NULL		as Parent,
						@errorCode	as [App_GenericResp!1!errorCode],
						@errorMessage	as [App_GenericResp!1!errorMessage]
						FOR XML EXPLICIT
					);
		SELECT @resultXML;
		return;
	END
SELECT @vClientID = longVal FROM APP_ComponentProp WITH (NOLOCK)
WHERE propertyTypeId = 3502
AND componentType = 8
AND componentId = @i_clientGroupID
AND modified = 0
-- Insert only Amazon/Azure Clients which honour client group settings
IF (@i_xmlText.exist('App_SetOnAddClientGrpPowerMgmt/addClient') <> 0)
    BEGIN
        INSERT INTO #mAgentAddedCGList
        SELECT a.b.value('@val','INT')
        FROM @i_xmlText.nodes('App_SetOnAddClientGrpPowerMgmt/addClient') a(b)
        INNER JOIN APP_ClientProp AS CPR WITH (NOLOCK) ON CPR.componentNameId = a.b.value('@val','INT') AND CPR.attrName = 'VSA HyperVisor Type' AND CPR.modified = 0
        LEFT OUTER JOIN MMPowerMgmtHost AS MPH WITH (NOLOCK) ON MPH.HostId = CPR.componentNameId
        WHERE ( CAST(CPR.attrVal AS INTEGER) & (1 | 16 | 32 | 64 | 512) ) > 0   -- AMAZON_VM = 16, AZURE_VM = 32, VMWARE_VM = 1, GOOGLE_CLOUD_VM = 64, KUBERNETES_VM = 512
AND (MPH.HostId IS NULL OR (MPH.Flags & 1024) = 0)
    END
ELSE
    BEGIN
        INSERT INTO #mAgentAddedCGList
        SELECT APP.id FROM APP_Client AS APP WITH (NOLOCK)
        INNER JOIN APP_ClientGroupAssoc AS ACGA WITH (NOLOCK) ON APP.id = ACGA.clientId
        LEFT OUTER JOIN MMPowerMgmtHost AS MPH WITH (NOLOCK) ON MPH.HostId = APP.id
        INNER JOIN APP_ClientProp AS CPR WITH (NOLOCK) ON CPR.componentNameId = APP.id AND CPR.attrName = 'VSA HyperVisor Type' AND CPR.modified = 0
        WHERE ACGA.clientGroupId = @i_clientGroupID
        AND ( CAST(CPR.attrVal AS INTEGER) & (1 | 16 | 32 | 64 | 512) ) > 0   -- AMAZON_VM = 16, AZURE_VM = 32, VMWARE_VM = 1, GOOGLE_CLOUD_VM = 64, KUBERNETES_VM = 512
AND (MPH.HostId IS NULL OR (MPH.Flags & 1024) = 0)
    END
IF (@@ERROR <> 0)
	BEGIN
		SET @errorCode 		= @@ERROR
		SET @errorMessage	= 'Failed to retrieve Cloud Media Agents'
		GOTO ERROR_EXIT
	END
-- Check whether the newly added clients are part of the VC, insert that into #mAgentCommon
SELECT TOP 1 @proxyXML =  CAST(AIP.attrVal AS XML) FROM APP_InstanceProp AS AIP WITH (NOLOCK)
INNER JOIN APP_Application AS APP WITH (NOLOCK) ON APP.instance = AIP.componentNameId AND AIP.modified=0
WHERE AIP.attrName = 'Vs Member Servers' AND APP.appTypeId=106  AND APP.clientId = @vClientID
IF (@@ERROR <> 0)
	BEGIN
		SET @errorCode 		= @@ERROR
		SET @errorMessage	= 'Failed to retrieve common MediaAgents/Proxies for CloudController and ClientGroup'
		GOTO ERROR_EXIT
	END
INSERT INTO #mAgentCommon
SELECT a.b.value('@clientId','INT'),AC.name
FROM @proxyXML.nodes('/App_MemberServers/memberServers/client') a(b)
INNER JOIN #mAgentAddedCGList AS M ON M.mAgentID = a.b.value('@clientId','INT')
INNER JOIN APP_Client AS AC WITH (NOLOCK) ON AC.id = a.b.value('@clientId','INT')
-- Remove the common elements from #mAgentAddedCGList, but keep them in #mAgentCommon
IF EXISTS (SELECT 1 FROM #mAgentCommon)
	BEGIN
		SET @hasCommon = 1
		DELETE #mAgentAddedCGList FROM #mAgentAddedCGList AS A
		INNER JOIN #mAgentCommon AS B ON A.mAgentID = B.mAgentID
	END
-- Put all active Cloud Controllers proxies XML into a proxyTable
INSERT INTO @proxyAssocTable
SELECT DISTINCT AIP.attrVal from APP_InstanceProp AS AIP WITH (NOLOCK)
INNER JOIN APP_Application AS APP WITH (NOLOCK) ON APP.instance = AIP.componentNameId AND APP.appTypeId = 106
INNER JOIN MMPowerMgmtHost AS MPH WITH (NOLOCK) ON MPH.ControllerNode = APP.clientId AND MPH.isEnabled = 1
AND CAST(AIP.attrName AS NVARCHAR) = 'Vs Member Servers'
AND AIP.modified = 0
IF (@@ERROR <> 0)
	BEGIN
		SET @errorCode 		= @@ERROR
		SET @errorMessage	= 'Failed to retrieve Active Cloud Controllers proxy XMLs'
		GOTO ERROR_EXIT
	END
-- Loop through all the proxy associations and add the active proxies into #mAgentProxy table
DECLARE proxyCur CURSOR FOR
	SELECT proxiesXML FROM @proxyAssocTable
OPEN proxyCur
FETCH NEXT FROM proxyCur INTO @proxyXML
WHILE @@FETCH_STATUS = 0
BEGIN
	INSERT INTO #mAgentProxy
	SELECT a.b.value('@clientId','INT'),a.b.value('@clientName','NVARCHAR(MAX)')
	FROM @proxyXML.nodes('/App_MemberServers/memberServers/client') a(b)
	LEFT OUTER JOIN #mAgentProxy AS M ON M.mAgentID = a.b.value('@clientId','INT')
	WHERE a.b.value('@clientId','INT') IS NOT NULL AND M.mAgentID IS NULL
	FETCH NEXT FROM proxyCur INTO @proxyXML
END
CLOSE proxyCur
DEALLOCATE proxyCur
-- Now keep only common proxies into #mAgentProxy and then remove them from #mAgentAddedCGList
DELETE #mAgentProxy FROM #mAgentProxy AS PXY
LEFT OUTER JOIN #mAgentAddedCGList AS MA ON PXY.mAgentID = MA.mAgentID
WHERE MA.mAgentID IS NULL
IF EXISTS (SELECT 1 FROM #mAgentProxy)
	BEGIN
		SET @hasActiveProxies = 1
		DELETE #mAgentAddedCGList FROM #mAgentAddedCGList AS MA
		LEFT OUTER JOIN #mAgentProxy AS PXY ON PXY.mAgentID = MA.mAgentID
		WHERE PXY.mAgentID IS NOT NULL
	END
-- SET THE vClientID AND PowerMgmtEnabled status for remaining clients
BEGIN TRANSACTION
UPDATE MMHost SET Attribute =	CASE
									WHEN (@i_enablePowerMgmt = 1)
THEN (Attribute | 32768)
ELSE (Attribute & ~32768)
							END
WHERE ClientId IN (SELECT mAgentID FROM #mAgentAddedCGList)
IF (@@ERROR <> 0)
		BEGIN
			SET @errorCode 		= @@ERROR
			SET @errorMessage	= 'Failed to update MMHost flag'
			GOTO QUIT_WITH_ROLLBACK
		END
UPDATE MMPowerMgmtHost SET isEnabled =  @i_enablePowerMgmt
WHERE HostId IN (SELECT mAgentID FROM #mAgentAddedCGList)
IF (@@ERROR <> 0)
	BEGIN
		SET @errorCode 		= @@ERROR
		SET @errorMessage	= 'Failed to update MMPowerMgmtHost table'
		GOTO QUIT_WITH_ROLLBACK
	END
IF @i_enablePowerMgmt = 1
	BEGIN
	UPDATE MMPowerMgmtHost SET ControllerNode =  @vClientID, ClientGroupId = @i_clientGroupID
	WHERE HostId IN (SELECT mAgentID FROM #mAgentAddedCGList)
	IF (@@ERROR <> 0)
		BEGIN
			SET @errorCode 		= @@ERROR
			SET @errorMessage	= 'Failed to update MMPowerMgmtHost table'
			GOTO QUIT_WITH_ROLLBACK
		END
	END
INSERT INTO MMPowerMgmtHost (HostId, isEnabled, LastPowerMgmtUpdateTime, ControllerNode, PowerStatus, Flags, NoPowerOff, LastAccessTime, UseCountForIndexServer, FailedPowerOperation, FailureReason, ClientGroupId, PowerStateTransitTime)
SELECT TMP.mAgentID, @i_enablePowerMgmt, dbo.GetUnixTime(GETUTCDATE()), @vClientID, 0, 0, 0, dbo.GetUnixTime(GETUTCDATE()), 0, 0, NULL, @i_clientGroupID, 0
FROM #mAgentAddedCGList TMP
INNER JOIN MMHost MH WITH (NOLOCK) ON MH.ClientId = TMP.mAgentID
LEFT OUTER JOIN MMPowerMgmtHost VM WITH (NOLOCK) ON VM.HostId = TMP.mAgentID
WHERE VM.HostId IS NULL
COMMIT TRANSACTION
SET @resultXML = (SELECT
					(SELECT @errorCode 			as '@errorCode',
					 		@hasCommon			as '@hasCommon',
							@hasActiveProxies 	as '@hasActiveProxies',
					 		(SELECT commonMAName as 'commonMA'
					  		FROM #mAgentCommon
					  		FOR XML PATH(''),TYPE),
							(SELECT commonProxyMAName as 'commonProxy'
							FROM #mAgentProxy
							FOR XML PATH(''),TYPE)
					FOR XML PATH('App_SetClientGroupCloudVMManagementInfoResp'), TYPE)
				)
GOTO END_SAVE
QUIT_WITH_ROLLBACK:
	IF ( @@TRANCOUNT > 0 ) ROLLBACK TRANSACTION
ERROR_EXIT:
	SET @resultXML	= (SELECT	1				as TAG,
								NULL			as Parent,
								@errorCode		as [App_GenericResp!1!errorCode],
								@errorMessage	as [App_GenericResp!1!errorMessage]
								FOR XML EXPLICIT
						);
END_SAVE:
	DROP TABLE #mAgentAddedCGList
	DROP TABLE #mAgentCommon
	DROP TABLE #mAgentProxy
	SELECT @resultXML;
GO

IF EXISTS (select * from GxQscripts where name = 'MMOnAddClientGrpPowerMgmt')
	delete from GxQscripts where name = 'MMOnAddClientGrpPowerMgmt'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMOnAddClientGrpPowerMgmt')
	delete from GXDBVersions where aliasname = 'MMOnAddClientGrpPowerMgmt'
GO

insert into GXDBVersions values(2, 'MMOnAddClientGrpPowerMgmt',  '00000000000000000000', 'MMOnAddClientGrpPowerMgmt', '00000000000000000000')
GO

