

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMMountpathCredentialAssociation.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2017  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMMountpathCredentialAssociation.sp,v $ $Id: MMMountpathCredentialAssociation.sp,v 1.1.2.2 2020/12/29 18:57:52 pveeravalli Exp $";
--
--  +=================================================================================================================================================+
--  |   Procedure:  MMMountpathCredentialAssociation
--  |
--  |   Description:  Creates/Updates an association between credential and mountpathId
--  |
--  |   Input:  EntityId, CredentialId
--  |
--  |   Output:  -1   Invalid credentialId
--  |            -2   Invalid mountpathId
--  |            -3   No changes
--  |             0   Add new entry in MMMountpathCredentialAssoc
--  |             1   Update existing association in MMMountpathCredentialAssoc
--  |
--  |   Notes:   If a valid credential ID was passed and If there are no entries with this combination (mountpathId,assocId)it adds new entry .
--  |		    If combination exits update to new credential association
--  |
--  |   Revisions  Author			Description
--  |   ---------  -----------		-------------------------------------------------------------------------------------------------
--  |   1.1        pveeravalli	 	Stored procedure to create a credential association association OR update existing association
--  +====================================================================================================================================================+
--
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='MMMountpathCredentialAssociation')
BEGIN
	print '>>> Drop Stored Procedure: MMMountpathCredentialAssociation <<<'
	drop procedure MMMountpathCredentialAssociation
END
IF EXISTS (select * from GxQscripts where name='MMMountpathCredentialAssociation')
	delete from GxQscripts where name = 'MMMountpathCredentialAssociation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMMountpathCredentialAssociation')
	delete from GXDBVersions where aliasname = 'MMMountpathCredentialAssociation'
GO
print '... Creating Procedure: MMMountpathCredentialAssociation'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure MMMountpathCredentialAssociation
  @i_entityId integer,
  @i_credentialId integer,
  @i_entityTypeId integer
AS
  DECLARE @o_result integer = -1
  DECLARE @o_oldCredentialName NVARCHAR(255) = ''
SET NOCOUNT ON
DECLARE @assocId integer = 0
DECLARE @deviceId integer = 0
DECLARE @existingCredentialId integer = 0
-- -1   Invalid credentialId
-- -2   Invalid mountpathId
-- -3   No changes
--  0   Add new entry in APP_CredentialAssoc
--  1   Update existing association in APP_CredentialAssoc
IF (@i_entityTypeId = 52)
BEGIN
	SELECT @deviceId = deviceID  FROM MMMountPathToStorageDevice M WITH (READUNCOMMITTED)
	WHERE M.MountpathId = @i_entityId
SELECT @i_entityId = @deviceId, @i_entityTypeId = 185
END
SELECT @existingCredentialId = ACS.credentialId, @assocId = ACS.assocId, @o_oldCredentialName = AC.credentialName
FROM APP_CredentialAssoc ACS WITH (READUNCOMMITTED)   INNER JOIN  APP_Credentials AC WITH (READUNCOMMITTED)
ON ACS.credentialId = AC.credentialId
WHERE ACS.entityId = @i_entityId AND ACS.entityType = @i_entityTypeId
IF NOT EXISTS(SELECT credentialId FROM APP_Credentials WITH (READUNCOMMITTED) WHERE credentialId = @i_credentialId)
        SET @o_result = -1
ELSE IF (@i_entityId = 0)
        SET @o_result = -2
ELSE IF(@i_credentialId = @existingCredentialId)
	    -- No changes needed
	    SET @o_result = -3
ELSE IF (@assocId > 0)
	     -- Update existing mountpaths assocId to latest
		 BEGIN
			UPDATE APP_CredentialAssoc SET credentialId = @i_credentialId  WHERE assocId = @assocId
			SET @o_result = 1
		 END
ELSE
		BEGIN
			-- No association exists, create the association now
            INSERT INTO APP_CredentialAssoc (credentialId, entityType, entityId)
            VALUES(@i_credentialId, @i_entityTypeId, @i_entityId)
			SET @o_result = 2
		END
SELECT @o_result,@o_oldCredentialName
SET NOCOUNT OFF;
GO

IF EXISTS (select * from GxQscripts where name = 'MMMountpathCredentialAssociation')
	delete from GxQscripts where name = 'MMMountpathCredentialAssociation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMMountpathCredentialAssociation')
	delete from GXDBVersions where aliasname = 'MMMountpathCredentialAssociation'
GO

insert into GXDBVersions values(2, 'MMMountpathCredentialAssociation',  '00010001000200020000', 'MMMountpathCredentialAssociation', '00010001000200020000')
GO

