

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMMediaChecker.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2007  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- This Stored Procedure is used to check the Mismatch in LibraryId and SpareGroupId
-- assigned to Media
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMMediaChecker <<<'

IF EXISTS (select * from sysobjects where name='MMMediaChecker')
	drop procedure MMMediaChecker
IF EXISTS (select * from GxQscripts where name='MMMediaChecker')
	delete from GxQscripts where name = 'MMMediaChecker'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMMediaChecker')
	delete from GXDBVersions where aliasname = 'MMMediaChecker'
GO
print '... Creating Procedure: MMMediaChecker'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMMediaChecker
  @i_reserveParam integer
AS
  DECLARE @o_LibraryId integer
  DECLARE @o_MediaId integer
  DECLARE @o_Barcode varchar(256)
  DECLARE @o_SprGrpIdInMedia integer
  DECLARE @o_ReserveParam1 integer
  DECLARE @o_ReserveParam2 integer
  DECLARE @o_StrReserveParam NVARCHAR (255)
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
	-- Fetch all the Media for which SpareGroup and Library are not matching
	SELECT LibraryId, MediaId, Barcode, SpareGroupId, 0 , 0, ''
	FROM MMMedia AS MM
WHERE LibraryId IN (SELECT LibraryId FROM MMLibrary WHERE LibraryTypeId = 1)
		AND SpareGroupId NOT IN (SELECT SpareGroupId FROM MMSpareGroup WHERE LibraryId = MM.LibraryId)
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'MMMediaChecker')
	delete from GxQscripts where name = 'MMMediaChecker'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMMediaChecker')
	delete from GXDBVersions where aliasname = 'MMMediaChecker'
GO

insert into GXDBVersions values(2, 'MMMediaChecker',  '00000000000000000000', 'MMMediaChecker', '00000000000000000000')
GO

