

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMMarkInactiveMagneticVolumesFull.sp] ---------- 

/******************************************************************************/
/*  Copyright (c) CommVault Systems                                           */
/*  All Rights Reserved                                                       */
/*                                                                            */
/*  THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF CommVault Systems          */
/*  The copyright notice above does not evidence any                          */
/*  actual or intended publication of such source code.                       */
/*                                                                            */
/*  File name   :  MMMarkInactiveMagneticVolumesFull.sp                       */
/*                                                                            */
/******************************************************************************/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMMarkInactiveMagneticVolumesFull.sp,v $ $Id: MMMarkInactiveMagneticVolumesFull.sp,v 1.1.4.3 2018/03/27 08:43:39 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMMarkInactiveMagneticVolumesFull <<<'

IF EXISTS (select * from sysobjects where name='MMMarkInactiveMagneticVolumesFull')
	drop procedure MMMarkInactiveMagneticVolumesFull
IF EXISTS (select * from GxQscripts where name='MMMarkInactiveMagneticVolumesFull')
	delete from GxQscripts where name = 'MMMarkInactiveMagneticVolumesFull'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMMarkInactiveMagneticVolumesFull')
	delete from GXDBVersions where aliasname = 'MMMarkInactiveMagneticVolumesFull'
GO
print '... Creating Procedure: MMMarkInactiveMagneticVolumesFull'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MMMarkInactiveMagneticVolumesFull
AS
  DECLARE @o_retCode INT
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
BEGIN TRY
DECLARE @l_intervalHoursForMagVols INT = 24
DECLARE @l_intervalHoursForGFSVols INT = 720
	SELECT @l_intervalHoursForMagVols = value FROM MMConfigs WITH(NOLOCK)
	WHERE name = 'MMS2_CONFIG_STRING_MAGNETIC_MARKFULL_INTERVAL_HOURS'
	SELECT @l_intervalHoursForGFSVols = value FROM MMConfigs WITH(NOLOCK)
	WHERE name = 'MMS2_CONFIG_STRING_MAGNETIC_GFS_MARKFULL_INTERVAL_HOURS'
	DECLARE @l_currentTime INT = (SELECT dbo.GetUnixTime(GETUTCDATE()))
	DECLARE @l_timeToMarkFullForMagVols INT = (@l_currentTime - (@l_intervalHoursForMagVols * 60 * 60))
	DECLARE @l_timeToMarkFullForGFSVols INT = (@l_currentTime - (@l_intervalHoursForGFSVols * 60 * 60))
	/* Flags for the volume
	enum VolumeFlags
	{
	    VOL_INVALID,
	    VOL_ACTIVE,
	    VOL_FULL,
	    VOL_READONLY,        /* Got error during write */
	    VOL_BAD,             /* Should not read or write */
	    VOL_IDLE,
	    VOL_RECYCLE,         /* Indicate this volume needs to be recycled by MLM */
	    VOL_ACTIVE_APPEND,   /* This volume can be used again for backup */
	    VOL_ACTIVE_REFRESH   /* This volume can only be used for Media Refreshing */
	};
	*/
UPDATE Vol SET VolumeFlags = 2 /*VOL_FULL*/, VolumeFullReason = 42036, VolumeFullTime = @l_currentTime
	FROM MMVolume Vol INNER JOIN MMMountPath MP WITH(NOLOCK) ON Vol.MediaSideId = MP.mediaSideId
WHERE Vol.RecordingFormatId = 10001 AND Vol.VolumeFlags IN (1 /*VOL_ACTIVE*/, 7 /*VOL_ACTIVE_APPEND*/)
AND Vol.LastbackupTime <= @l_timeToMarkFullForMagVols AND Vol.LastBackupTime > 0 AND (MP.Attribute & 64) = 0
UPDATE Vol SET VolumeFlags = 2 /*VOL_FULL*/, VolumeFullReason = 42036, VolumeFullTime = @l_currentTime
	FROM MMVolume Vol INNER JOIN MMMountPath MP WITH(NOLOCK) ON Vol.MediaSideId = MP.mediaSideId
WHERE Vol.RecordingFormatId = 10001 AND Vol.VolumeFlags IN (1 /*VOL_ACTIVE*/, 7 /*VOL_ACTIVE_APPEND*/)
AND Vol.LastbackupTime <= @l_timeToMarkFullForGFSVols AND Vol.LastBackupTime > 0 AND (MP.Attribute & 64) > 0
	SELECT 0
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR);
	THROW
	SELECT -1
END CATCH
GO

IF EXISTS (select * from GxQscripts where name = 'MMMarkInactiveMagneticVolumesFull')
	delete from GxQscripts where name = 'MMMarkInactiveMagneticVolumesFull'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMMarkInactiveMagneticVolumesFull')
	delete from GXDBVersions where aliasname = 'MMMarkInactiveMagneticVolumesFull'
GO

insert into GXDBVersions values(2, 'MMMarkInactiveMagneticVolumesFull',  '00010001000400030000', 'MMMarkInactiveMagneticVolumesFull', '00010001000400030000')
GO

