

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMMPMoveDBInit.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MMMPMoveDBInit')
BEGIN
	print '>>> Drop Stored Procedure: MMMPMoveDBInit <<<'
	drop procedure MMMPMoveDBInit
END
IF EXISTS (select * from GxQscripts where name='MMMPMoveDBInit')
	delete from GxQscripts where name = 'MMMPMoveDBInit'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMMPMoveDBInit')
	delete from GXDBVersions where aliasname = 'MMMPMoveDBInit'
GO
print '... Creating Procedure: MMMPMoveDBInit'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MMMPMoveDBInit
  @i_jobId INTEGER,						
  @i_sourceMaId INTEGER,			
  @i_targetMaId INTEGER,		
  @i_sourcePath VARCHAR(1024),
  @i_targetPath VARCHAR(1024),
  @i_deviceId INTEGER,
  @i_mpMoveMetaData XML
AS
  DECLARE @errorCode INTEGER
  DECLARE @errorMsg NVARCHAR(MAX)
  DECLARE @moveId INTEGER
  DECLARE @phaseId INTEGER
  DECLARE @currBatchId INTEGER
  DECLARE @transferId INTEGER
  DECLARE @transferStreamId INTEGER
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
SET @ErrorCode = 0
SET @ErrorMsg =  ''
IF NOT EXISTS(SELECT 1 FROM MMMountPathMove WHERE JobId = @i_jobId)
BEGIN
	BEGIN TRY
		BEGIN TRAN
			INSERT INTO MMDataTransferRequest(JobId, Flags, ReserveField1, ReserveField2, ReserveFieldStr)
				VALUES	(@i_jobId, 	0, 0, 0, '')
			SELECT @transferId = SCOPE_IDENTITY()
			INSERT INTO MMDataTransferStreams(TransferId, SourceMAClientId, TargetMAClientId, DataToCopyMB, DataCopiedMB, CurrentTransferSpeed,
						StreamStatus, PercentVerified, Flags, LastUpdateTime, ReserveField1, ReserveField2, ReserveFieldStr, TotalNumberOfFiles, NumberOfFilesProcessed)
				VALUES	(@transferId,	--TransferId
					@i_sourceMaId,	--SourceMAClientId
					@i_targetMaId,	--TargetMAClientId
					0,				--DataToCopyMB
					0,				--DataCopiedMB
					0,				--CurrentTransferSpeed
					1,				--StreamStatus --DDBMOVE_IN_PROGRESS
					0,				--PercentVerified
					0,				--Flags
					0,				--LastUpdateTime
					0,				--ReserveField1
					0,				--ReserveField2
					'',				--ReserveFieldStr
					0,				--TotalNumberOfFiles
					0				--NumberOfFilesProcessed
				)
			SELECT @transferStreamId = SCOPE_IDENTITY()
			INSERT INTO MMDataTransferStreamToFiles (TransferStreamId, FileName, FileType, ReserveField1, ReserveField2, ReserveFieldStr, DDBSourcePath, DDBTargetPath)
				VALUES	(@transferStreamId, '', 2/*MOVE_PARTITION_MOUNT_PATH_FILE*/, 0, 0, '', @i_sourcePath, @i_targetPath)
			INSERT INTO MMMountPathMove (JobId, StreamId, PhaseId, Flags, Status, ReserveField, ReserveString, DeviceId, Metadata)
				VALUES	(@i_jobId, 			--JobId
					@transferStreamId, 	--StreamId
					1, 					--PhaseId PHASE_MOVE_FULL_VOLUME
					0, 					--Flags
					0, 					--Status MP_MOVE_IN_PROGRESS
					-1, 				--ReserveField -To keep track, No of MaxConcurrentWriters is changed or not
					'',					--ReserveString
					@i_deviceId, 		--deviceId
					@i_mpMoveMetaData	--Metadata
				)
		COMMIT TRAN
	END TRY
	BEGIN CATCH
		ROLLBACK TRAN
		SET @ErrorCode = ISNULL(ERROR_NUMBER(), 1)
		SET @ErrorMsg =  ISNULL(ERROR_MESSAGE(), '')
	END CATCH
END
ELSE
BEGIN
	UPDATE DTS
	SET StreamStatus = 1, --DDBMOVE_IN_PROGRESS
Flags &= (~(1 | 2 | 4)) --Ideally these shouldn't have been set at all
	FROM MMDataTransferStreams DTS
		INNER JOIN MMDataTransferRequest DTR ON DTR.TransferId = DTS.TransferId
	WHERE DTR.JobId = @i_jobId
END
SELECT 	@ErrorCode, @ErrorMsg,
		MPM.MoveId, MPM.PhaseId, MPM.CurrBatchId,
		DTS.TransferId, DTS.TransferStreamId
FROM MMMountPathMove MPM
	INNER JOIN MMDataTransferStreams DTS ON DTS.TransferStreamId = MPM.StreamId
WHERE JobId = @i_jobId

IF EXISTS (select * from GxQscripts where name = 'MMMPMoveDBInit')
	delete from GxQscripts where name = 'MMMPMoveDBInit'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMMPMoveDBInit')
	delete from GXDBVersions where aliasname = 'MMMPMoveDBInit'
GO

insert into GXDBVersions values(2, 'MMMPMoveDBInit',  '00000000000000000000', 'MMMPMoveDBInit', '00000000000000000000')
GO

