

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMIsVolumePartOfSILO.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2008  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMIsVolumePartOfSILO.sp,v $ $Id: MMIsVolumePartOfSILO.sp,v 1.6.274.2 2018/03/20 00:05:21 jiechen Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 		PROCEDURE: "MMIsVolumePartOfSILO"				|
--	|									|
--	| Execute the System stored procedure to fetch the physical files	|
--	| .. for the (current) database.					|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMIsVolumePartOfSILO <<<'

IF EXISTS (select * from sysobjects where name='MMIsVolumePartOfSILO')
	drop procedure MMIsVolumePartOfSILO
IF EXISTS (select * from GxQscripts where name='MMIsVolumePartOfSILO')
	delete from GxQscripts where name = 'MMIsVolumePartOfSILO'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMIsVolumePartOfSILO')
	delete from GXDBVersions where aliasname = 'MMIsVolumePartOfSILO'
GO
print '... Creating Procedure: MMIsVolumePartOfSILO'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMIsVolumePartOfSILO
  @i_volumeId integer,
  @i_reserveParam integer
AS
  DECLARE @o_isPartOfSILO integer
  DECLARE @o_reserveOutput integer
	--
	-- Check if in archfilesilovolume table.
	--
	IF EXISTS
	(
		SELECT top 1 AFSV.siloVolumeId
		FROM ArchFileSiloVolume AFSV WITH (READUNCOMMITTED)
		WHERE AFSV.siloVolumeId = @i_volumeId
	)
	BEGIN
		GOTO IS_SILO
	END
/*
	--
	-- Check if associated to a copy (by sidbstoreId) that has
	-- the silo-to-tape option enabled.
	--
	IF EXISTS
	(
		SELECT top 1 AGC.id
		FROM ArchGroupCopy AGC WITH (READUNCOMMITTED), MMVolume MV WITH (READUNCOMMITTED),
					archCopySIDBStore SIDB WITH (READUNCOMMITTED)
		WHERE MV.VolumeId = @i_volumeId AND
				MV.SIDBStoreId = SIDB.SIDBStoreId AND
				SIDB.CopyId > 0 AND
				SIDB.CopyId = AGC.id AND
((AGC.dedupeFlags & 2097152) > 0)
	)
	BEGIN
		GOTO IS_SILO
	END
*/
	--
	-- From 9.0, knowing whether data on the store is going to be SILO-ed is known by the flag on
	-- the store table itself, not on the copy.
	-- See MR [54336: Volumes from 80 store will fail to get deleted after upgrading and enabling SILO on the SP] for details.
	--
	IF EXISTS
	(
		SELECT top 1 SIDB.SIDBStoreId
		FROM MMVolume MV WITH (READUNCOMMITTED), IdxSIDBStore SIDB WITH (READUNCOMMITTED)
		WHERE MV.VolumeId = @i_volumeId AND
				MV.SIDBStoreId = SIDB.SIDBStoreId AND
((SIDB.flags & 2097152) > 0)
	)
	BEGIN
		GOTO IS_SILO
	END
	GOTO IS_NOT_SILO
	IS_SILO:
		SELECT 1, 0
		GOTO PROC_EXIT
	IS_NOT_SILO:
		SELECT 0, 0
		GOTO PROC_EXIT
PROC_EXIT:
GO

IF EXISTS (select * from GxQscripts where name = 'MMIsVolumePartOfSILO')
	delete from GxQscripts where name = 'MMIsVolumePartOfSILO'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMIsVolumePartOfSILO')
	delete from GXDBVersions where aliasname = 'MMIsVolumePartOfSILO'
GO

insert into GXDBVersions values(2, 'MMIsVolumePartOfSILO',  '00010006027400020000', 'MMIsVolumePartOfSILO', '00010006027400020000')
GO

