

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMIsReconRunningForStoreAndSubStore.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMIsReconRunningForStoreAndSubStore.sp,v $ $Id: MMIsReconRunningForStoreAndSubStore.sp,v 1.1.2.1 2018/09/21 04:03:57 anarulkar Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMIsReconRunningForStoreAndSubStore <<<'

IF EXISTS (select * from sysobjects where name='MMIsReconRunningForStoreAndSubStore')
	drop procedure MMIsReconRunningForStoreAndSubStore
IF EXISTS (select * from GxQscripts where name='MMIsReconRunningForStoreAndSubStore')
	delete from GxQscripts where name = 'MMIsReconRunningForStoreAndSubStore'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMIsReconRunningForStoreAndSubStore')
	delete from GXDBVersions where aliasname = 'MMIsReconRunningForStoreAndSubStore'
GO
print '... Creating Procedure: MMIsReconRunningForStoreAndSubStore'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MMIsReconRunningForStoreAndSubStore
  @i_SIDBStoreId INTEGER,
  @i_SubStoreId INTEGER
AS
  DECLARE @o_isReconRunning integer;
SET @o_isReconRunning = 0
DECLARE @tblRunningDDBSyncJobs  TABLE (JobId    int)
DECLARE @tblRunningSubStores    TABLE (SIDBStoreId int, SubStoreId int)
DECLARE @jobId int = 0
INSERT INTO @tblRunningDDBSyncJobs
SELECT jobId
FROM JMJobInfo JMINFO WITH (READUNCOMMITTED)
WHERE JMINFO.OpType = 80 /* DEDUPDBSYNC */
AND dbo.GetJobOption(jobId, 1777365717/* DEDUPDBSYNCOPTION__SIDBSTORE_ID */) = @i_SIDBStoreId
DECLARE jobList CURSOR FOR
SELECT jobId FROM @tblRunningDDBSyncJobs
OPEN jobList
FETCH NEXT FROM jobList INTO @jobId
WHILE @@FETCH_STATUS = 0
BEGIN
	INSERT INTO @tblRunningSubStores
	SELECT  I.SIDBStoreId, T.t_substoreId
            FROM IdxSIDBSubStore I WITH (NOLOCK),
                (
                    SELECT sb.value('@val', 'INT') AS t_substoreId
                    FROM
                    (
                        select CAST(value AS XML) AS xmlstr
                        from dbo.GetAllJobOptions(@jobId)
                        where optionId=34449693 -- DEDUPDBSYNCOPTION__SUB_STORE_ID_LIST
                    ) AS O
                    CROSS APPLY O.xmlstr.nodes ('SubStoreIdList') R(sb)
                ) T
            WHERE I.Status = 1
            AND T.t_substoreId = I.SubStoreId
FETCH NEXT FROM jobList INTO @jobId
END
CLOSE jobList
DEALLOCATE jobList
IF EXISTS (SELECT 1 FROM @tblRunningSubStores WHERE SIDBStoreId = @i_SIDBStoreId AND SubStoreId = @i_SubStoreId)
	SET @o_isReconRunning = 1
SELECT @o_isReconRunning
return
GO

IF EXISTS (select * from GxQscripts where name = 'MMIsReconRunningForStoreAndSubStore')
	delete from GxQscripts where name = 'MMIsReconRunningForStoreAndSubStore'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMIsReconRunningForStoreAndSubStore')
	delete from GXDBVersions where aliasname = 'MMIsReconRunningForStoreAndSubStore'
GO

insert into GXDBVersions values(2, 'MMIsReconRunningForStoreAndSubStore',  '00010001000200010000', 'MMIsReconRunningForStoreAndSubStore', '00010001000200010000')
GO

