

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMIsPowerManagementAllowed.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--  +-----------------------------------------------------------------------+
--  |       PROCEDURE	:	"MMIsPowerManagementAllowed"               	|
--  |       Author	    :	ksanghvi                            			|
--  | Execute the System stored procedure to fetch the physical files   	|
--  | .. for the (current) database.                    					|
--  +-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MMIsPowerManagementAllowed')
BEGIN
	print '>>> Drop Stored Procedure: MMIsPowerManagementAllowed <<<'
	drop procedure MMIsPowerManagementAllowed
END
IF EXISTS (select * from GxQscripts where name='MMIsPowerManagementAllowed')
	delete from GxQscripts where name = 'MMIsPowerManagementAllowed'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMIsPowerManagementAllowed')
	delete from GXDBVersions where aliasname = 'MMIsPowerManagementAllowed'
GO
print '... Creating Procedure: MMIsPowerManagementAllowed'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMIsPowerManagementAllowed
  @i_entityID INTEGER,
  @i_entityType INTEGER,
  @i_vClientId INTEGER = 0
AS
  DECLARE @o_retCode INTEGER
DECLARE @retCode INTEGER = 1
IF (@i_entityType = 11)
	BEGIN
		-- Should not allow power management operations from GUI
		DECLARE @HyperVisorType INTEGER = 0
		SELECT @HyperVisorType = CAST(attrVal as INTEGER) FROM APP_ClientProp WITH (NOLOCK) WHERE componentNameId = @i_entityID AND attrName = 'VSA HyperVisor Type' AND modified = 0
		IF (@HyperVisorType & 512) > 0	-- KUBERNETES_VM
		BEGIN
			SET @retCode = 0
			GOTO EXIT1;
		END
		--client used as proxy in a vclient used for power management (if i_vClientId !=0 then proxy in vclient to be used for power management)
		SELECT  @retCode = (CASE WHEN MPH.ControllerNode IS NULL THEN -1 ELSE 0 END)
		FROM 	APP_InstanceProp AS AIP WITH (NOLOCK)
INNER JOIN APP_Application AS APP WITH (NOLOCK) ON APP.instance = AIP.componentNameId AND APP.appTypeId = 106
				LEFT OUTER JOIN MMPowerMgmtHost AS MPH WITH (NOLOCK) ON MPH.ControllerNode = APP.clientId AND MPH.isEnabled = 1
		WHERE 	AIP.attrName = 'Vs Member Servers' AND AIP.modified = 0 AND AIP.attrVal LIKE '%clientId="'+CAST(@i_entityID AS VARCHAR(100))+'"%'
				AND (MPH.ControllerNode IS NOT NULL OR APP.clientId = @i_vClientId)
	END
EXIT1:
--The sp returns 1 if it power management is allowed, 0 if it is not allowed cause the MAs are proxies for vclient used for power management, -1 if MA is proxy for a given vclient(we check this before we assign a vclient for power management)
SELECT @retCode
GO

IF EXISTS (select * from GxQscripts where name = 'MMIsPowerManagementAllowed')
	delete from GxQscripts where name = 'MMIsPowerManagementAllowed'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMIsPowerManagementAllowed')
	delete from GXDBVersions where aliasname = 'MMIsPowerManagementAllowed'
GO

insert into GXDBVersions values(2, 'MMIsPowerManagementAllowed',  '00000000000000000000', 'MMIsPowerManagementAllowed', '00000000000000000000')
GO

