

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMIsMountPathSingleInstanced.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2006  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMIsMountPathSingleInstanced.sp,v $ $Id: MMIsMountPathSingleInstanced.sp,v 1.17.88.9 2020/02/21 02:14:55 prasanthm Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 		PROCEDURE: "MMIsMountPathSingleInstanced"				|
--	|									|
--	| Execute the System stored procedure to fetch the physical files	|
--	| .. for the (current) database.					|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MMIsMountPathSingleInstanced')
BEGIN
	print '>>> Drop Stored Procedure: MMIsMountPathSingleInstanced <<<'
	drop procedure MMIsMountPathSingleInstanced
END
IF EXISTS (select * from GxQscripts where name='MMIsMountPathSingleInstanced')
	delete from GxQscripts where name = 'MMIsMountPathSingleInstanced'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMIsMountPathSingleInstanced')
	delete from GXDBVersions where aliasname = 'MMIsMountPathSingleInstanced'
GO
print '... Creating Procedure: MMIsMountPathSingleInstanced'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMIsMountPathSingleInstanced
  @i_mountPathId integer,
  @i_reserveParam integer
AS
  DECLARE @o_isSingleInstanced integer
  DECLARE @o_StoreList XML
  DECLARE @o_reserveOutput integer
	DECLARE @StoreListXML XML = ''
	DECLARE @isSingleInstanced INT = 0
	DECLARE @i_isOverrideInPlace INTEGER
	SET @i_isOverrideInPlace = 0
	SELECT @i_isOverrideInPlace = value
	FROM MMConfigs
	WHERE name = 'MMS2_CONFIG_ALLOW_DEDEDUPED_MOUNTPATH_DECONFIG'
	--
	--PrasadNara: Changes to check for the deleting MP id.
	--Allow deconfig only when config param value is the deleting MP id
	--
	IF @i_isOverrideInPlace = @i_mountPathId
	BEGIN
		SET @isSingleInstanced = 0
		GOTO PROC_EXIT
	END
	DECLARE @lt_StoresOnMP table (SIDBStoreId int)
	--Select distinct stores on MountPath
	INSERT INTO @lt_StoresOnMP
	SELECT DISTINCT SIDBStoreId
	FROM MMVolume MV WITH (READUNCOMMITTED), MMMountPath MP WITH (READUNCOMMITTED)
	WHERE (MV.MediaSideId = MP.MediaSideId AND MP.MountPathId = @i_mountPathId)
		AND MV.SIDBStoreId > 0
	--
	--PrasadNara: Allow deconfing only in below cases
	--1. All volumes are recyclable on all stores of MP
	--	 AND all stores are sealed OR copy deleted
	--   AND no valid jobs for all stores OR all volumes are siloed to tape allow deconfig
	--2. In all other cases don't allow deconfig.
	--
	DELETE S
	FROM @lt_StoresOnMP S
	WHERE
	NOT EXISTS
	(
		--
		--Check for recyclable volumes on all stores of MP.
		--
		SELECT 1
		FROM MMVolume MV WITH (READUNCOMMITTED)
		WHERE S.SIDBStoreId = MV.SIDBStoreId AND MV.VolumeFlags <> 6
	)
	AND
	(
		NOT EXISTS
		(
			--
			--Check for all stores are sealed or not.
			--
			SELECT 1
			FROM IdxSIDBStore STORE WITH (READUNCOMMITTED)
			WHERE S.SIDBStoreId = STORE.SIDBStoreId AND STORE.SealedTime = 0
		)
		OR NOT EXISTS
		(
			--
			--Check for copy is deleted or not when store is active.
			--
			SELECT 1
			FROM IdxSIDBStore STORE WITH (READUNCOMMITTED)
INNER JOIN archCopySIDBStore CS WITH (READUNCOMMITTED) ON S.SIDBStoreId = CS.SIDBStoreId AND ((CS.Flags & 4) > 0)
			INNER JOIN ArchGroupCopy AGC WITH (READUNCOMMITTED)	ON CS.copyId = AGC.id
			WHERE S.SIDBStoreId = STORE.SIDBStoreId AND STORE.SealedTime = 0
		)
	)
	/*
	Commenting this block because
	We already check all the volumes on store are recyclable and all the stores are sealed.
	Checking for archFileCopyDedup also to verify if there are valid references is redundant,
	as if there is any valid job which can possibly reference to volumes in the mount path being deleted then it should be a non-recyclable volume.
	AND
	(
		NOT EXISTS
		(
			--
			--Check for jobs present on stores or not.
			--
			SELECT 1
			FROM archFile AF WITH (READUNCOMMITTED)
				INNER JOIN archFileCopyDedup AFD WITH (READUNCOMMITTED) ON AF.id = AFD.archFileId AND AF.commCellId = AFD.commCellId
				INNER JOIN @lt_StoresOnMP S ON AFD.SIDBStoreId = S.SIDBStoreId
				INNER JOIN App_Application APP WITH (READUNCOMMITTED) ON AF.appId = APP.id
				LEFT OUTER JOIN archGroupCopy AGC WITH (READUNCOMMITTED) ON APP.id = AGC.siloAppId
			WHERE AGC.id IS NULL
		)
		OR NOT EXISTS
		(
			--
			--Check for all volumes are siloed to tape or not in case of silo.
			--
			SELECT 1
			FROM @lt_StoresOnMP S INNER JOIN MMVolume MV WITH (READUNCOMMITTED)
			ON S.SIDBStoreId = MV.SIDBStoreId
			WHERE MV.SiloStatus <> 3
		)
	)
	*/
	AND
    (
        NOT EXISTS
        (
            --
            --Check if all volumes are pruned on the SILO Restored mount path
            --Changes done for MR : 141772
            --
			SELECT	1
			FROM	MMVolume MV WITH (NOLOCK), MMMountPath MP WITH (NOLOCK)
			WHERE	MV.CurrMountPathId = MP.MountPathId
				AND	MV.CurrMountPathId = @i_mountPathId
AND	MV.Attributes & 2 = 0
				AND MV.VolumeFlags <> 6
				AND	MV.SiloStatus > 0
				AND MV.SIDBStoreId = S.SIDBStoreId
        )
    )
	IF NOT EXISTS(SELECT 1 FROM @lt_StoresOnMP)
	BEGIN
		SET @isSingleInstanced = 0
	END
	ELSE
	BEGIN
		SET @StoreListXML = (select SIDBStoreId from @lt_StoresOnMP FOR XML PATH(''))
		SET @isSingleInstanced = 1
	END
PROC_EXIT:
	IF OBJECT_ID('tempdb..#SingleInstancedResultTable') IS NOT NULL
	BEGIN
		INSERT INTO #SingleInstancedResultTable
			SELECT @isSingleInstanced, @StoreListXML, 0
	END
	ELSE
	BEGIN
		SELECT @isSingleInstanced, @StoreListXML, 0
	END
GO

IF EXISTS (select * from GxQscripts where name = 'MMIsMountPathSingleInstanced')
	delete from GxQscripts where name = 'MMIsMountPathSingleInstanced'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMIsMountPathSingleInstanced')
	delete from GXDBVersions where aliasname = 'MMIsMountPathSingleInstanced'
GO

insert into GXDBVersions values(2, 'MMIsMountPathSingleInstanced',  '00010017008800090000', 'MMIsMountPathSingleInstanced', '00010017008800090000')
GO

