

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMIsMediaAgentLANFree.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2006  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMIsMediaAgentLANFree.sp,v $ $Id: MMIsMediaAgentLANFree.sp,v 1.7.54.2 2018/03/20 20:06:22 jiechen Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 		PROCEDURE: "MMIsMediaAgentLANFree"				|
--	|									|
--	| Execute the System stored procedure to fetch the physical files	|
--	| .. for the (current) database.					|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMIsMediaAgentLANFree <<<'

IF EXISTS (select * from sysobjects where name='MMIsMediaAgentLANFree')
	drop procedure MMIsMediaAgentLANFree
IF EXISTS (select * from GxQscripts where name='MMIsMediaAgentLANFree')
	delete from GxQscripts where name = 'MMIsMediaAgentLANFree'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMIsMediaAgentLANFree')
	delete from GXDBVersions where aliasname = 'MMIsMediaAgentLANFree'
GO
print '... Creating Procedure: MMIsMediaAgentLANFree'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMIsMediaAgentLANFree
  @maClientId integer
AS
declare @i_MAClientId INTEGER
  DECLARE @IsLanFree integer
	set @i_MAClientId  = @maClientId
	declare @l_tSPs table (SPId Integer primary key, MAIsDefault Integer)
	-- get the drivepoolMA
	insert into @l_tSPs
	select AG.Id, MAX(DPATH.Flag & 1)
	from MMDrivePool as DRVPOOL
				INNER JOIN MMDataPath as DPATH ON DPATH.DrivePoolId = DRVPOOL.DrivePoolId
				INNER JOIN ArchGroup as AG ON AG.DefaultCopy = DPATH.CopyId
	where DRVPOOL.ClientId = @i_MAClientId
	group by AG.Id, AG.DefaultCopy
	if (@@ROWCOUNT = 0) GOTO NODATAPATHS
	-- get all apps that are using the storage policy where the MA has a datapath
	-- already populate the top priority subclient datapath MA as the prefered MA for the App - reset it later if not
	-- actually using SC datapaths
	declare @l_TpreferredMAForApp TABLE (AppId Integer, ClientId Integer, SPId Integer, preferredMA Integer, usesSCDatapaths Integer)
	insert into  @l_TpreferredMAForApp
	SELECT App.id, App.clientId, tSPs.SPId, 0,
		CASE WHEN
					NOT EXISTS (
							SELECT TOP 1 DataPathId FROM APP_AppToDataPath WITH (NOLOCK)
							WHERE componentNameId = App.id
							)
			THEN 0
			ELSE 	ISNULL(
						(
							SELECT cast(attrVal as int) FROM APP_SubClientProp WITH (NOLOCK)
							WHERE componentnameId = App.Id AND modified = 0
							AND attrName = N'Full Failover to SP dataPaths'
							--AND attrVal > 0
						), 0
					)
		END
	FROM APP_Application as App with (nolock), @l_tSPs as tSPs
	WHERE App.dataArchGrpID = tSPs.SPId
	UNION
	SELECT App.id, App.clientId, tSPs.SPId, 0,
		CASE WHEN
					NOT EXISTS (
							SELECT TOP 1 DataPathId FROM APP_AppToDataPath WITH (NOLOCK)
							WHERE componentNameId = App.id
							)
			THEN 0
			ELSE 	ISNULL(
						(
							SELECT cast(attrVal as int) FROM APP_SubClientProp WITH (NOLOCK)
							WHERE componentnameId = App.Id AND modified = 0
							AND attrName = N'Full Failover to SP dataPaths'
							--AND attrVal > 0
						), 0
					)
		END
	FROM APP_Application as App with (nolock), @l_tSPs as tSPs
	WHERE App.logArchGrpID = tSPs.SPId
	UPDATE @l_TpreferredMAForApp
	SET		preferredMA = b.ClientId
	FROM	@l_TpreferredMAForApp a,
			(
				SELECT	TOP 1 tmp.AppId as Id, DRVPool.ClientId as ClientId
				FROM	@l_TpreferredMAForApp AS tmp, APP_appToDataPath AS A2DP WITH (NOLOCK),
						MMDataPath as DPATH WITH (NOLOCK), MMDrivePool AS DRVPool WITH (NOLOCK)
				WHERE	tmp.usesSCDatapaths > 0 AND A2DP.componentNameId = tmp.AppId
				AND		DPATH.DataPathId = A2DP.DataPathId AND DRVPool.DrivePoolId = DPATH.DrivePoolId
				ORDER BY A2DP.precedence
			) b
	WHERE	a.AppId = b.Id
	-- reset the preferred MA to 0 for the ones not using subclient datapaths
	--UPDATE @l_TpreferredMAForApp
	--SET preferredMA = 0
	--WHERE preferredMA <> 0 AND usesSCDatapaths = 0
	-- delete the ones from the list we are sure the apps are not normally targeted at this MA
	DELETE FROM @l_TpreferredMAForApp
	WHERE PreferredMA <> @i_MAClientId  AND PreferredMA <> 0
	DECLARE @proxyHost TABLE (AppId int, hostId int)
	INSERT INTO @proxyHost
	SELECT SC.componentNameId, CL.id
	FROM	APP_SubClientProp as SC WITH (NOLOCK), APP_Client AS CL WITH (NOLOCK)
	WHERE	SC.componentNameId > 0 AND SC.modified = 0
	AND SC.attrName = N'Proxy Host'
	AND CL.net_hostname = SC.attrVal
	-- update the clientId to be the actual backup host
	UPDATE @l_TpreferredMAForApp
	SET ClientId = host.hostId
	FROM @l_TpreferredMAForApp AS tt, @proxyHost AS host
	WHERE host.AppId = tt.AppId
	-- delete the ones where the MA is the client (if the list is empty, we are LAN free)
	DELETE FROM @l_TpreferredMAForApp
	WHERE ClientId = @i_MAClientId
	-- if the list is empty, we are LAN free
	IF NOT EXISTS (SELECT TOP 1 clientId FROM @l_TpreferredMAForApp)
	BEGIN
		GOTO LANFREE
	END
	-- if we have a preferred SC MA (ie the MA we are looking at, all others were deleted)
	-- and the client is different to the MA looked at -> not lan free
	IF EXISTS (SELECT PreferredMA FROM @l_TpreferredMAForApp WHERE ClientId <> preferredMA AND preferredMA <> 0)
	BEGIN
		GOTO NOT_LANFREE
	END
	-- we have now already checked all places which the MA was known to be preferred datapath
	DELETE FROM @l_TpreferredMAForApp  WHERE preferredMA <> 0
	-- now link the remaining appIds to the storage policy table we defined first - if the MA is defaultMA for any of the
	-- storage policies in the list, then the MA is LANMA, else LANFREEMA
	IF EXISTS
	(
		SELECT TOP 1 SPId
		FROM   @l_tSPs
		WHERE  MAIsDefault = 1 AND
		SpId IN
		(
			SELECT distinct SPId FROM @l_TpreferredMAForApp
		)
	)
	BEGIN
				GOTO NOT_LANFREE
	END
	ELSE
	BEGIN
		GOTO LANFREE
	END
	GOTO PROC_EXIT
	NODATAPATHS:
	-- no drivepools found using this MA
	-- If exist any active DDB substore then LAN else LANFREE
	IF EXISTS
	(
		select TOP 1 1 from IdxSIDBSubStore where ClientId = @i_MAClientId AND SealedTime = 0
	)
	GOTO NOT_LANFREE
	--no drivepools,no ddbs
	SELECT 1
	GOTO PROC_EXIT
	NOT_LANFREE:
	SELECT 0
	GOTO PROC_EXIT
	LANFREE:
	SELECT 1
	GOTO PROC_EXIT
PROC_EXIT:
GO

IF EXISTS (select * from GxQscripts where name = 'MMIsMediaAgentLANFree')
	delete from GxQscripts where name = 'MMIsMediaAgentLANFree'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMIsMediaAgentLANFree')
	delete from GXDBVersions where aliasname = 'MMIsMediaAgentLANFree'
GO

insert into GXDBVersions values(2, 'MMIsMediaAgentLANFree',  '00010007005400020000', 'MMIsMediaAgentLANFree', '00010007005400020000')
GO

