

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMIsEntityHasArchiverJob.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2006  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMIsEntityHasArchiverJob.sp,v $ $Id: MMIsEntityHasArchiverJob.sp,v 1.9.88.7 2019/12/21 21:53:43 prasanthm Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 		PROCEDURE: "MMIsEntityHasArchiverJob"							|
--	|																		|
--	| To check for the archiverJob exists or not in the given entity		|
--	| 																		|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MMIsEntityHasArchiverJob')
BEGIN
	print '>>> Drop Stored Procedure: MMIsEntityHasArchiverJob <<<'
	drop procedure MMIsEntityHasArchiverJob
END
IF EXISTS (select * from GxQscripts where name='MMIsEntityHasArchiverJob')
	delete from GxQscripts where name = 'MMIsEntityHasArchiverJob'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMIsEntityHasArchiverJob')
	delete from GXDBVersions where aliasname = 'MMIsEntityHasArchiverJob'
GO
print '... Creating Procedure: MMIsEntityHasArchiverJob'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MMIsEntityHasArchiverJob
  @i_CheckForArchiveJobReq xml,
  @i_reserveParam integer
AS
  DECLARE @o_hasArchiverJob integer
  DECLARE @o_reserveOutput integer
  DECLARE @o_hasEdgeBackupJobs integer
	DECLARE @l_HasArchiverJob  int
	DECLARE @l_HasReferenceCopyJob int
	DECLARE @l_hasEdgeBackupJobs int
	SET @l_HasArchiverJob = 0
	SET @l_HasReferenceCopyJob = 0
	SET @l_hasEdgeBackupJobs = 0
	DECLARE @lt_Entities TABLE (entityId int, entityType int, commCellId int)
	--Note: We are using "ENTITY_TYPE_MEDIA_TYPE_ENTITY" for "ENTITY_TYPE_MEDIA_ENTITY"
	INSERT INTO @lt_Entities
	SELECT
			CASE
WHEN (PARAM.value('@_type_','INTEGER')) = 3 THEN ISNULL ((PARAM.value('@clientId','INTEGER')),0)
WHEN (PARAM.value('@_type_','INTEGER')) = 4 THEN ISNULL ((PARAM.value('@applicationId','INTEGER')),0)
WHEN (PARAM.value('@_type_','INTEGER')) = 5 THEN ISNULL ((PARAM.value('@instanceId','INTEGER')),0)
WHEN (PARAM.value('@_type_','INTEGER')) = 6 THEN ISNULL ((PARAM.value('@backupsetId','INTEGER')),0)
WHEN (PARAM.value('@_type_','INTEGER')) = 7 THEN ISNULL ((PARAM.value('@subclientId','INTEGER')),0)
WHEN (PARAM.value('@_type_','INTEGER')) = 18 THEN ISNULL ((PARAM.value('@copyId','INTEGER')),0)
WHEN (PARAM.value('@_type_','INTEGER')) = 17 THEN ISNULL ((PARAM.value('@storagePolicyId','INTEGER')),0)
WHEN (PARAM.value('@_type_','INTEGER')) = 9 THEN ISNULL ((PARAM.value('@libraryId','INTEGER')),0)
WHEN (PARAM.value('@_type_','INTEGER')) = 52 THEN ISNULL ((PARAM.value('@mountPathId','INTEGER')),0)
WHEN (PARAM.value('@_type_','INTEGER')) = 70 THEN ISNULL ((PARAM.value('@mediaTypeId','INTEGER')),0)
			END,
			ISNULL ((PARAM.value('@_type_','INTEGER')),0),
			2
	FROM @i_CheckForArchiveJobReq.nodes('/MediaManager_CheckForArchiveJobReq/entityList') AS messageXML(param)
	INSERT INTO @lt_Entities
	SELECT
			ISNULL ((PARAM.value('@jobId','INTEGER')),0),
10001,
			ISNULL ((PARAM.value('@commCellId','INTEGER')),0)
	FROM @i_CheckForArchiveJobReq.nodes('/MediaManager_CheckForArchiveJobReq/jobEntityList') AS messageXML(param)
	--DECLARE @lt_Jobs TABLE (jobId int, commCellId int, appId int, copiedTime int, copyId int, entityType int)
	IF (OBJECT_ID('tempdb..#lt_Jobs') IS NOT NULL)
		DROP TABLE #lt_Jobs
	CREATE TABLE #lt_Jobs (jobId int, commCellId int, appId int, copiedTime int, copyId int, entityType int)
	CREATE INDEX Idx_lt_jobs_appId ON #lt_Jobs(appId)
IF EXISTS(SELECT 1 FROM @lt_Entities WHERE entityType = 3)
	BEGIN
		INSERT INTO #lt_Jobs
		SELECT JS.JobId, JS.commCellId, JS.appId, JS.copiedTime, JS.archGrpCopyId, EN.entityType
		FROM JMJobDataStats JS WITH (READUNCOMMITTED)
			INNER JOIN APP_Application SC WITH (READUNCOMMITTED) ON JS.appId = SC.Id
			INNER JOIN @lt_Entities EN ON SC.clientId = EN.entityId
			--INNER JOIN ArchGroup AG WITH (READUNCOMMITTED) ON JS.archGrpCopyId = AG.defaultCopy
WHERE (JS.disabled & 256) = 0
AND EN.entityType = 3
	END
IF EXISTS(SELECT 1 FROM @lt_Entities WHERE entityType = 4)
	BEGIN
		INSERT INTO #lt_Jobs
		SELECT JS.JobId, JS.commCellId, JS.appId, JS.copiedTime, JS.archGrpCopyId, EN.entityType
		FROM JMJobDataStats JS WITH (READUNCOMMITTED)
			INNER JOIN APP_Application SC WITH (READUNCOMMITTED) ON JS.appId = SC.Id
			INNER JOIN APP_IDAName IDA WITH (READUNCOMMITTED) ON SC.appTypeId = IDA.appTypeId AND SC.clientId = IDA.clientId
			INNER JOIN @lt_Entities EN ON IDA.Id = EN.entityId
			--INNER JOIN ArchGroup AG WITH (READUNCOMMITTED) ON JS.archGrpCopyId = AG.defaultCopy
WHERE (JS.disabled & 256) = 0
AND EN.entityType = 4
	END
IF EXISTS(SELECT 1 FROM @lt_Entities WHERE entityType = 5)
	BEGIN
		INSERT INTO #lt_Jobs
		SELECT JS.JobId, JS.commCellId, JS.appId, JS.copiedTime, JS.archGrpCopyId, EN.entityType
		FROM JMJobDataStats JS WITH (READUNCOMMITTED)
			INNER JOIN APP_Application SC WITH (READUNCOMMITTED) ON JS.appId = SC.Id
			INNER JOIN @lt_Entities EN ON SC.instance = EN.entityId
			--INNER JOIN ArchGroup AG WITH (READUNCOMMITTED) ON JS.archGrpCopyId = AG.defaultCopy
WHERE (JS.disabled & 256) = 0
AND EN.entityType = 5
	END
IF EXISTS(SELECT 1 FROM @lt_Entities WHERE entityType = 6)
	BEGIN
		INSERT INTO #lt_Jobs
		SELECT JS.JobId, JS.commCellId, JS.appId, JS.copiedTime, JS.archGrpCopyId, EN.entityType
		FROM JMJobDataStats JS WITH (READUNCOMMITTED)
			INNER JOIN APP_Application SC WITH (READUNCOMMITTED) ON JS.appId = SC.Id
			INNER JOIN @lt_Entities EN ON SC.backupSet = EN.entityId
			--INNER JOIN ArchGroup AG WITH (READUNCOMMITTED) ON JS.archGrpCopyId = AG.defaultCopy
WHERE (JS.disabled & 256) = 0
AND EN.entityType = 6
	END
IF EXISTS(SELECT 1 FROM @lt_Entities WHERE entityType = 7)
	BEGIN
		INSERT INTO #lt_Jobs
		SELECT JS.JobId, JS.commCellId, JS.appId, JS.copiedTime, JS.archGrpCopyId, EN.entityType
		FROM JMJobDataStats JS WITH (READUNCOMMITTED)
			INNER JOIN @lt_Entities EN ON JS.appId = EN.entityId
WHERE (JS.disabled & 256) = 0
AND EN.entityType = 7
	END
IF EXISTS(SELECT 1 FROM @lt_Entities WHERE entityType = 18)
	BEGIN
		INSERT INTO #lt_Jobs
		SELECT JS.JobId, JS.commCellId, JS.appId, JS.copiedTime, JS.archGrpCopyId, EN.entityType
		FROM JMJobDataStats JS WITH (READUNCOMMITTED)
			INNER JOIN @lt_Entities EN ON JS.archGrpCopyId = EN.entityId
			--INNER JOIN ArchGroup AG WITH (READUNCOMMITTED) ON JS.archGrpCopyId = AG.defaultCopy
WHERE (JS.disabled & 256) = 0
AND EN.entityType = 18
	END
IF EXISTS(SELECT 1 FROM @lt_Entities WHERE entityType = 17)
	BEGIN
		INSERT INTO #lt_Jobs
		SELECT JS.JobId, JS.commCellId, JS.appId, JS.copiedTime, JS.archGrpCopyId, EN.entityType
		FROM JMJobDataStats JS WITH (READUNCOMMITTED)
			INNER JOIN @lt_Entities EN ON JS.archGrpId = EN.entityId
			--INNER JOIN ArchGroup AG WITH (READUNCOMMITTED) ON AGC.Id = AG.defaultCopy
WHERE (JS.disabled & 256) = 0
AND EN.entityType = 17
	END
IF EXISTS(SELECT 1 FROM @lt_Entities WHERE entityType = 9)
	BEGIN
		INSERT INTO @lt_Entities
SELECT MP.MountPathId, 52, 2
		FROM MMLibrary LB WITH (READUNCOMMITTED)
			INNER JOIN MMMountPath MP WITH (READUNCOMMITTED) ON LB.libraryId = MP.libraryId
			INNER JOIN @lt_Entities EN ON LB.libraryId = EN.entityId
WHERE EN.entityType = 9
	END
IF EXISTS(SELECT 1 FROM @lt_Entities WHERE entityType = 52)
	BEGIN
		INSERT INTO @lt_Entities
SELECT MS.MediaId, 70, 2
		FROM MMMountPath MP WITH (READUNCOMMITTED)
			INNER JOIN MMMediaSide MS WITH (READUNCOMMITTED) ON MP.MediaSideId = MS.MediaSideId
			INNER JOIN @lt_Entities EN ON MP.mountPathId = EN.entityId
WHERE EN.entityType = 52
	END
IF EXISTS(SELECT 1 FROM @lt_Entities WHERE entityType = 70)
	BEGIN
		INSERT INTO #lt_Jobs
		SELECT JS.JobId, JS.commCellId, JS.appId, JS.copiedTime, JS.archGrpCopyId, EN.entityType
		FROM MMVolume MV WITH (READUNCOMMITTED) INNER JOIN archChunk AC WITH (READUNCOMMITTED) ON MV.VolumeId = AC.VolumeId
			INNER JOIN ArchChunkMapping ACM WITH (READUNCOMMITTED) ON AC.id = ACM.archChunkId AND AC.commcellId = ACM.chunkCommcellId
			INNER JOIN JMJobDataStats JS WITH (READUNCOMMITTED) ON ACM.JobId = JS.JobId AND ACM.chunkCommCellId = JS.commCellId AND ACM.archCopyId = JS.archGrpCopyId
			INNER JOIN @lt_Entities EN ON MV.MediaId = EN.entityId
			--INNER JOIN ArchGroup AG WITH (READUNCOMMITTED) ON ACM.archCopyId = AG.defaultCopy
WHERE (JS.disabled & 256) = 0
AND EN.entityType = 70
	END
IF EXISTS(SELECT 1 FROM @lt_Entities WHERE entityType = 10001)
	BEGIN
		INSERT INTO #lt_Jobs
		SELECT JS.JobId, JS.commCellId, JS.appId, JS.copiedTime, JS.archGrpCopyId, EN.entityType
		FROM JMJobDataStats JS WITH (READUNCOMMITTED)
			INNER JOIN @lt_Entities EN ON JS.JobId = EN.entityId AND JS.commCellId = EN.commCellId
			--INNER JOIN ArchGroup AG WITH (READUNCOMMITTED) ON JS.archGrpCopyId = AG.defaultCopy
WHERE (JS.disabled & 256) = 0
AND EN.entityType = 10001
	END
	-- Check for archiver jobs
	IF EXISTS
	(
		SELECT 1
		FROM APP_IDATypeHandlingInfo IDT WITH (READUNCOMMITTED) INNER JOIN APP_Application APP WITH (READUNCOMMITTED)
			ON IDT.AppTypeId = APP.AppTypeId
			INNER JOIN #lt_Jobs JS ON APP.Id = JS.appId
			--INNER JOIN ArchGroup AG WITH (READUNCOMMITTED) ON JS.copyId = AG.defaultCopy
		WHERE IDT.isDMAppType = 1
	)
	OR EXISTS
	(
		SELECT 1
		FROM #lt_Jobs JS INNER JOIN App_SubClientProp SCP WITH (READUNCOMMITTED) ON JS.appId = SCP.ComponentNameId
			INNER JOIN archGroupCopy AGC WITH (READUNCOMMITTED) ON JS.copyId = AGC.id
			--ArchGroup AG WITH (READUNCOMMITTED)
		WHERE SCP.attrName = 'Is Turbo SubClient' AND SCP.attrVal = 1
			AND SCP.created < JS.copiedTime
			AND AGC.isSnapCopy = 0
			--AND (JS.copyId = AG.defaultCopy OR JS.copyId = AG.defaultSnapCopy)
	)
	BEGIN
		SET @l_HasArchiverJob = 1
	END
	-- Check for reference copy jobs
	IF EXISTS
	(
		SELECT 	1
		FROM 	APP_Application APP WITH (READUNCOMMITTED)
				INNER JOIN #lt_Jobs JS ON APP.Id = JS.appId
WHERE 	APP.subclientStatus & 0x10000 = 0x10000
AND JS.EntityType IN (18, 17, 9, 52, 70, 10001)
	)
	BEGIN
		SET @l_HasReferenceCopyJob = 1
	END
	-- Check for edge backups
	IF EXISTS
	(
		SELECT 1
		FROM ArchFIle af WITH (READUNCOMMITTED), #lt_Jobs t
		WHERE t.jobID = af.jobID AND t.commCellId = af.commCellId
AND af.flags & (32768|2097152) <> 0
	)
	BEGIN
		SET @l_hasEdgeBackupJobs = 1
	END
	SELECT	@l_HasArchiverJob, @l_HasReferenceCopyJob, @l_hasEdgeBackupJobs
PROC_EXIT:
IF (OBJECT_ID('tempdb..#lt_Jobs') IS NOT NULL)
		DROP TABLE #lt_Jobs
GO

IF EXISTS (select * from GxQscripts where name = 'MMIsEntityHasArchiverJob')
	delete from GxQscripts where name = 'MMIsEntityHasArchiverJob'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMIsEntityHasArchiverJob')
	delete from GXDBVersions where aliasname = 'MMIsEntityHasArchiverJob'
GO

insert into GXDBVersions values(2, 'MMIsEntityHasArchiverJob',  '00010009008800070000', 'MMIsEntityHasArchiverJob', '00010009008800070000')
GO

