

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMIsDDBOrMPConfiguredInBase.sp] ---------- 

/******************************************************************************/
/*  Copyright (c) CommVault Systems                                           */
/*  All Rights Reserved                                                       */
/*                                                                            */
/*  THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF CommVault Systems          */
/*  The copyright notice above does not evidence any                          */
/*  actual or intended publication of such source code.                       */
/*                                                                            */
/*  File name   :  MMIsDDBOrMPConfiguredInBase.sp                             */
/*                                                                            */
/*  Description :  Stored procedure to check if DDB or Mount Path is 		  */
/*					configured in Base directory of this MediaAgent 		  */
/*                                                                            */
/******************************************************************************/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMIsDDBOrMPConfiguredInBase.sp,v $ $Id: MMIsDDBOrMPConfiguredInBase.sp,v 1.3.70.1 2018/03/22 02:56:28 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMIsDDBOrMPConfiguredInBase <<<'

IF EXISTS (select * from sysobjects where name='MMIsDDBOrMPConfiguredInBase')
	drop procedure MMIsDDBOrMPConfiguredInBase
IF EXISTS (select * from GxQscripts where name='MMIsDDBOrMPConfiguredInBase')
	delete from GxQscripts where name = 'MMIsDDBOrMPConfiguredInBase'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMIsDDBOrMPConfiguredInBase')
	delete from GXDBVersions where aliasname = 'MMIsDDBOrMPConfiguredInBase'
GO
print '... Creating Procedure: MMIsDDBOrMPConfiguredInBase'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MMIsDDBOrMPConfiguredInBase
  @i_mediaAgentId INTEGER
AS
  DECLARE @r_retCode INTEGER;
  DECLARE @r_isConfigured INTEGER;
	--This will turn off message: "xxx rows affected".
	SET NOCOUNT ON
	DECLARE @retVal int = 0
	DECLARE @isConfigured int = 0
	DECLARE @installDir nvarchar(255)
	SELECT @installDir = install_dir FROM App_Platform WITH(NOLOCK) WHERE clientId = @i_mediaAgentId AND platformType = 2
	SET @retVal = @@ERROR
	IF(@retVal > 0)
		GOTO PROC_EXIT
	DECLARE @pathSeparator char(1)
	IF LEFT(@installDir,1) = '/'
		SET @pathSeparator = '/'
	ELSE
		SET @pathSeparator = '\'
	SELECT @installDir = @installDir+ CASE WHEN RIGHT(@installDir, 1) = @pathSeparator THEN '%' ELSE @pathSeparator + '%' END
	/*DDB is configured*/
	IF EXISTS(SELECT 1 FROM IdxAccessPath IdxPath WITH(NOLOCK) INNER JOIN IdxSIDBSubStore SubStore WITH(NOLOCK) ON IdxPath.IdxAccessPathId = SubStore.IdxAccessPathId AND IdxPath.clientId = @i_mediaAgentId
	WHERE IdxPath.path like @installDir)
	 	SET @isConfigured = @isConfigured | 1
	IF EXISTS(SELECT 1 FROM MMDeviceController WITH(NOLOCK) WHERE folder like @installDir AND ClientId = @i_mediaAgentId)
	BEGIN
		SET @isConfigured = @isConfigured | 2
		GOTO PROC_EXIT
	END
	IF EXISTS(SELECT 1 FROM MMMountPath MP WITH(NOLOCK) INNER JOIN MMDrivePool DP WITH(NOLOCK) ON DP.MasterPoolId = MP.MasterPoolId
	WHERE MountPathName like @installDir AND DP.clientId = @i_mediaAgentId)
		SET @isConfigured = @isConfigured | 2
PROC_EXIT:
	SELECT @retVal, @isConfigured
GO

IF EXISTS (select * from GxQscripts where name = 'MMIsDDBOrMPConfiguredInBase')
	delete from GxQscripts where name = 'MMIsDDBOrMPConfiguredInBase'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMIsDDBOrMPConfiguredInBase')
	delete from GXDBVersions where aliasname = 'MMIsDDBOrMPConfiguredInBase'
GO

insert into GXDBVersions values(2, 'MMIsDDBOrMPConfiguredInBase',  '00010003007000010000', 'MMIsDDBOrMPConfiguredInBase', '00010003007000010000')
GO

