

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMIsCopyUsingMetallicLibrary.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2017  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMIsCopyUsingMetallicLibrary.sp,v $ $Id: MMIsCopyUsingMetallicLibrary.sp,v 1.2.4.2 2021/01/27 00:11:10 pveeravalli Exp $";
--
--  +=================================================================================================================================================+
--  |   Procedure:  MMIsCopyUsingMetallicLibrary
--  |
--  |   Description:  Creates/Updates an association between credential and mountpathId
--  |
--  |   Input:  copyId
--  |
--  |   Output:   1   Copy using Metallic Library
--  |             0   Copy is not using Metallic Library
--  |                 If MMConfig 'MMS2_CONFIG_ALLOW_METALLIC_CLOUD_COPY_AS_SOURCE_COPY' is to '1' then ignore validation
--  |
--  |   Revisions  Author			Description
--  |   ---------  -----------		-------------------------------------------------------------------------------------------------
--  |   1.1        pveeravalli	 	Stored procedure to check if copy using Metallic Library
--  +====================================================================================================================================================+
--
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='MMIsCopyUsingMetallicLibrary')
BEGIN
	print '>>> Drop Stored Procedure: MMIsCopyUsingMetallicLibrary <<<'
	drop procedure MMIsCopyUsingMetallicLibrary
END
IF EXISTS (select * from GxQscripts where name='MMIsCopyUsingMetallicLibrary')
	delete from GxQscripts where name = 'MMIsCopyUsingMetallicLibrary'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMIsCopyUsingMetallicLibrary')
	delete from GXDBVersions where aliasname = 'MMIsCopyUsingMetallicLibrary'
GO
print '... Creating Procedure: MMIsCopyUsingMetallicLibrary'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure MMIsCopyUsingMetallicLibrary
  @i_spId INT,
  @i_copyId INT
AS
  DECLARE @o_result INT = 0 
SET NOCOUNT ON
	IF EXISTS (SELECT 1 FROM MMConfigs WHERE name = 'MMS2_CONFIG_ALLOW_METALLIC_CLOUD_COPY_AS_SOURCE_COPY' and value = 1)
		BEGIN
			 SELECT @o_result = 0
	    END
    ELSE
        BEGIN
		   IF @i_copyId = 0
		      BEGIN
		 		 SELECT @i_copyId = defaultCopy FROM Archgroup AG WITH(READUNCOMMITTED) WHERE id = @i_spId
		      END
		   IF EXISTS(SELECT 1
	                FROM MMDataPath MCF INNER JOIN MMDrivePool AS MDP WITH(READUNCOMMITTED) ON MCF.DrivePoolId = MDP.DrivePoolId
	                INNER JOIN MMMasterPool as MMP WITH(READUNCOMMITTED) ON MDP.MasterPoolId = MMP.MasterPoolId
        	        INNER JOIN MMLibrary as ML WITH(READUNCOMMITTED) ON ML.libraryId = MMP.LibraryId
	                INNER JOIN MMMountPath MP WITH(READUNCOMMITTED) ON  MP.LibraryId = ML.LibraryId
	                INNER JOIN MMMountPathToStorageDevice AS MPS WITH(READUNCOMMITTED)  ON MPS.MountPathId = MP.MountPathId
	                INNER JOIN MMDevice AS MD WITH(READUNCOMMITTED) on MD.DeviceId = MPS.DeviceId
	                WHERE MCF.CopyId = @i_copyId AND
MD.DisplayDeviceTypeId = 400)
                       BEGIN
                            SET @o_result = 1
                       END
	   END
SELECT @o_result
SET NOCOUNT OFF;
GO

IF EXISTS (select * from GxQscripts where name = 'MMIsCopyUsingMetallicLibrary')
	delete from GxQscripts where name = 'MMIsCopyUsingMetallicLibrary'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMIsCopyUsingMetallicLibrary')
	delete from GXDBVersions where aliasname = 'MMIsCopyUsingMetallicLibrary'
GO

insert into GXDBVersions values(2, 'MMIsCopyUsingMetallicLibrary',  '00010002000400020000', 'MMIsCopyUsingMetallicLibrary', '00010002000400020000')
GO

