

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMInsertDeletedMPToPhysicalCleanup.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMInsertDeletedMPToPhysicalCleanup.sp,v $ $Id: MMInsertDeletedMPToPhysicalCleanup.sp,v 1.1.2.7 2020/11/09 09:27:17 prasanthm Exp $";
--  +-----------------------------------------------------------------------+
--  |       PROCEDURE	:	"MMInsertDeletedMPToPhysicalCleanup"               				|
--  |       Author	    :	prasanthm                            			|
--  | Execute the System stored procedure to fetch the physical files   	|
--  | .. for the (current) database.                    					|
--  +-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='MMInsertDeletedMPToPhysicalCleanup')
BEGIN
	print '>>> Drop Stored Procedure: MMInsertDeletedMPToPhysicalCleanup <<<'
	drop procedure MMInsertDeletedMPToPhysicalCleanup
END
IF EXISTS (select * from GxQscripts where name='MMInsertDeletedMPToPhysicalCleanup')
	delete from GxQscripts where name = 'MMInsertDeletedMPToPhysicalCleanup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMInsertDeletedMPToPhysicalCleanup')
	delete from GXDBVersions where aliasname = 'MMInsertDeletedMPToPhysicalCleanup'
GO
print '... Creating Procedure: MMInsertDeletedMPToPhysicalCleanup'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure MMInsertDeletedMPToPhysicalCleanup
  @i_MountpathId Integer
AS
  DECLARE @o_ErrorCode INTEGER
DECLARE @retCode INTEGER = 0
DECLARE @currentUTCTime INTEGER = dbo.GetUnixTime(GetUTCDate())
DECLARE @mountpath VARCHAR(1024) = ''
SELECT @mountpath = MountPathName FROM MMMountPath WHERE MountPathId = @i_mountpathId
if object_id('tempdb.dbo.#TmpDeviceControllerTbl') is not null DROP TABLE #TmpDeviceControllerTbl
CREATE TABLE #TmpDeviceControllerTbl (
			clientId INT,
			deviceId INT,
			deviceType INT,
folder VARCHAR(1024),
userName VARCHAR(1024),
userPassword VARCHAR(2048),
			credentialAssocId INT
			)
INSERT INTO #TmpDeviceControllerTbl
	SELECT MDC.ClientId, MDC.DeviceId, MD.DeviceTypeId, MDC.Folder, MDC.UserName, MDC.UserPassword, MDC.CredentialAssocId
	FROM MMMountPathToStorageDevice MP2SD WITH(NOLOCK)
		INNER JOIN MMDeviceController MDC WITH(NOLOCK) ON MDC.DeviceId = MP2SD.DeviceId
		INNER JOIN MMDevice MD WITH(NOLOCK) ON MDC.DeviceId = MD.DeviceId
		INNER JOIN MMHost MH WITH(NOLOCK) ON MH.ClientId = MDC.ClientId
		INNER JOIN APP_Client CL WITH(NOLOCK) ON CL.id = MH.ClientId
INNER JOIN simInstalledPackages SIM WITH(NOLOCK) ON SIM.ClientId = CL.id AND SIM.simPackageID IN ( 51,1301 )
	WHERE MDC.DeviceAccessible = 1 AND MDC.DeviceControllerEnabled = 1 AND MH.MmHostEnabled = 1 AND MH.MmHostSoftState = 1 AND MP2SD.MountPathId = @i_mountpathId
AND (MDC.DeviceAccessType & 2) = 2
AND (MDC.DeviceAccessType & 16) = 0
AND ( CL.releaseId > 16 OR (CL.releaseId = 16 AND SIM.HighestSP >= 20 ) )
exec MMS2GetDeviceControllerCredentials '#TmpDeviceControllerTbl', 'credentialAssocId', 'userName', 'userPassword'
DECLARE @DeletedMPXml XML
select top 1 @DeletedMPXml = '<EVGui_DeletedMPDetails MediaAgentId="' + CONVERT(VARCHAR(20),clientId) + '" DeviceType="' + CONVERT(VARCHAR(10),deviceType) + '" MountPath = "' + folder + '/' + @mountpath + '" userName="'+ userName +'" password="'+ userPassword + '"/>' from #TmpDeviceControllerTbl
EXEC MMGetSetMMTask 0, 0, 1, @DeletedMPXml, 0
IF (@@ERROR <> 0)
BEGIN
    SET @retCode = @@ERROR
	GOTO EXITEND
END
EXITEND:
if object_id('tempdb.dbo.#TmpDeviceControllerTbl') is not null DROP TABLE #TmpDeviceControllerTbl
SELECT @retCode
GO

IF EXISTS (select * from GxQscripts where name = 'MMInsertDeletedMPToPhysicalCleanup')
	delete from GxQscripts where name = 'MMInsertDeletedMPToPhysicalCleanup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMInsertDeletedMPToPhysicalCleanup')
	delete from GXDBVersions where aliasname = 'MMInsertDeletedMPToPhysicalCleanup'
GO

insert into GXDBVersions values(2, 'MMInsertDeletedMPToPhysicalCleanup',  '00010001000200070000', 'MMInsertDeletedMPToPhysicalCleanup', '00010001000200070000')
GO

