

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMInsertDeletedMPToDDB.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMInsertDeletedMPToDDB.sp,v $ $Id: MMInsertDeletedMPToDDB.sp,v 1.1.2.2 2020/03/04 19:58:09 prasanthm Exp $";
--  +-----------------------------------------------------------------------+
--  |       PROCEDURE	:	"MMInsertDeletedMPToDDB"               				|
--  |       Author	    :	prasanthm                            			|
--  | Execute the System stored procedure to fetch the physical files   	|
--  | .. for the (current) database.                    					|
--  +-----------------------------------------------------------------------+
-- Store list XML format - <SIDBStoreId>95</SIDBStoreId><SIDBStoreId>98</SIDBStoreId><SIDBStoreId>101</SIDBStoreId>
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MMInsertDeletedMPToDDB')
BEGIN
	print '>>> Drop Stored Procedure: MMInsertDeletedMPToDDB <<<'
	drop procedure MMInsertDeletedMPToDDB
END
IF EXISTS (select * from GxQscripts where name='MMInsertDeletedMPToDDB')
	delete from GxQscripts where name = 'MMInsertDeletedMPToDDB'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMInsertDeletedMPToDDB')
	delete from GXDBVersions where aliasname = 'MMInsertDeletedMPToDDB'
GO
print '... Creating Procedure: MMInsertDeletedMPToDDB'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MMInsertDeletedMPToDDB
  @i_MountpathId Integer,
  @i_SIDBListXML XML
AS
  DECLARE @o_ErrorCode INTEGER
DECLARE @DDBListForMP TABLE(SIDBStoreId INT)
DECLARE @mediaSideId INTEGER = 0
DECLARE @retCode INTEGER = 0
INSERT INTO @DDBListForMP
SELECT TBL.col.value('.','integer')
FROM @i_SIDBListXML.nodes('SIDBStoreId') TBL(col)
IF EXISTS(SELECT 1 FROM @DDBListForMP)
BEGIN
	INSERT INTO MMDeletedMPToDDB
	SELECT @i_MountpathId, SIDBStoreId FROM @DDBListForMP
	IF (@@ERROR <> 0)
	BEGIN
		SET @retCode = @@ERROR
		GOTO EXITEND
	END
	SELECT @mediaSideId = MediaSideId FROM MMMountPath WITH (NOLOCK)
	WHERE MountPathId = @i_MountpathId
	DELETE MV
	FROM MMVolume MV
	INNER JOIN @DDBListForMP TMP ON MV.MediaSideId = @mediaSideId AND TMP.SIDBStoreId = MV.SIDBStoreId
	IF (@@ERROR <> 0)
	BEGIN
		SET @retCode = @@ERROR
		GOTO EXITEND
	END
END
EXITEND:
SELECT @retCode
GO

IF EXISTS (select * from GxQscripts where name = 'MMInsertDeletedMPToDDB')
	delete from GxQscripts where name = 'MMInsertDeletedMPToDDB'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMInsertDeletedMPToDDB')
	delete from GXDBVersions where aliasname = 'MMInsertDeletedMPToDDB'
GO

insert into GXDBVersions values(2, 'MMInsertDeletedMPToDDB',  '00010001000200020000', 'MMInsertDeletedMPToDDB', '00010001000200020000')
GO

