

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMInsertDDBResyncHistory.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMInsertDDBResyncHistory <<<'

IF EXISTS (select * from sysobjects where name='MMInsertDDBResyncHistory')
	drop procedure MMInsertDDBResyncHistory
IF EXISTS (select * from GxQscripts where name='MMInsertDDBResyncHistory')
	delete from GxQscripts where name = 'MMInsertDDBResyncHistory'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMInsertDDBResyncHistory')
	delete from GXDBVersions where aliasname = 'MMInsertDDBResyncHistory'
GO
print '... Creating Procedure: MMInsertDDBResyncHistory'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMInsertDDBResyncHistory
  @SIDBStoreId INT,
  @CommcellId INT,
  @MaintenanceTime INT,
  @ResyncFlags INT,
  @AttemptNo INT,
  @MaintenanceReason INT,
  @MaintenanceReasonDesc VARCHAR(256),
  @ResyncStartTime INT,
  @ResyncStatus INT,
  @NumResyncedAfIds INT,
  @TurnAroundTime INT,
  @AddedTime INT,
  @ValidationProgress INT,
  @PruningProgress INT
AS
-- MOdified for checkin 8858
-- Update if exists. Insert if not.
IF EXISTS (SELECT
				*
		   FROM
				IdxSIDBResyncHistory
		   WHERE
				SIDBStoreId = @SIDBStoreId AND
				CommcellId = @CommcellId AND
				MaintenanceTime = @MaintenanceTime AND
				AttemptNo = @AttemptNo)
BEGIN
	UPDATE
		IdxSIDBResyncHistory
	SET
		MaintenanceReason = @MaintenanceReason,
		MaintenancereasonDesc = @MaintenanceReasonDesc,
		ResyncStartTime = @ResyncStartTime,
		ResyncStatus = @ResyncStatus,
		NumResyncedAfIds = @NumResyncedAfIds,
		TurnAroundTime = @TurnAroundTime,
		ResyncFlags = @ResyncFlags,
		ValidationProgress = CASE WHEN @ValidationProgress > ValidationProgress THEN @ValidationProgress ELSE ValidationProgress END,
		PruningProgress = CASE WHEN @PruningProgress > PruningProgress THEN @PruningProgress ELSE PruningProgress END
	WHERE
		SIDBStoreId = @SIDBStoreId AND
		CommcellId = @CommcellId AND
		MaintenanceTime = @MaintenanceTime AND
		AttemptNo = @AttemptNo
	IF @ResyncStatus <> -1
		UPDATE IdxSIDBStore
SET	Flags = Flags & (~1073741824)
		WHERE SIDBStoreId = @SIDBStoreId
END
ELSE
BEGIN
IF NOT EXISTS (SELECT * FROM IdxSIDBStore WHERE SIDBStoreId = @SIDBStoreId AND CommcellId = @CommcellId AND Flags & 33554432 <> 0)
	BEGIN
		RAISERROR ('Store is not marked for resync', 15, 1)
		RETURN
	END
	INSERT INTO
	IdxSIDBResyncHistory (SIDBStoreId, CommcellId, MaintenanceTime, ResyncFlags, AttemptNo, MaintenanceReason, MaintenancereasonDesc,
		ResyncStartTime, ResyncStatus, NumResyncedAfIds, TurnAroundTime, AddedTime, ValidationProgress, PruningProgress)
	VALUES (@SIDBStoreId, @CommcellId, @MaintenanceTime, @ResyncFlags, @AttemptNo, @MaintenanceReason, @MaintenanceReasonDesc,
		@ResyncStartTime, @ResyncStatus, @NumResyncedAfIds, @TurnAroundTime, @AddedTime, @ValidationProgress, @PruningProgress)
	UPDATE IdxSIDBStore
SET	Flags = Flags | 1073741824
	WHERE SIDBStoreId = @SIDBStoreId
END
GO

IF EXISTS (select * from GxQscripts where name = 'MMInsertDDBResyncHistory')
	delete from GxQscripts where name = 'MMInsertDDBResyncHistory'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMInsertDDBResyncHistory')
	delete from GXDBVersions where aliasname = 'MMInsertDDBResyncHistory'
GO

insert into GXDBVersions values(2, 'MMInsertDDBResyncHistory',  '00000000000000000000', 'MMInsertDDBResyncHistory', '00000000000000000000')
GO

