

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMInfrastructurePoolSet.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2018  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--	+===================================================================+
--	|  				MMInfrastructurePoolSet								|
--	|		 Procedure to set infrastructure pool information			|
--	+===================================================================+
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMInfrastructurePoolSet.sp,v $ $Id: MMInfrastructurePoolSet.sp,v 1.1.4.5 2020/10/27 23:33:15 nuppu Exp $"
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='MMInfrastructurePoolSet')
BEGIN
	print '>>> Drop Stored Procedure: MMInfrastructurePoolSet <<<'
	drop procedure MMInfrastructurePoolSet
END
IF EXISTS (select * from GxQscripts where name='MMInfrastructurePoolSet')
	delete from GxQscripts where name = 'MMInfrastructurePoolSet'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMInfrastructurePoolSet')
	delete from GXDBVersions where aliasname = 'MMInfrastructurePoolSet'
GO
print '... Creating Procedure: MMInfrastructurePoolSet'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure MMInfrastructurePoolSet
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @inXmlReq XML
-----------------------------------------------------------
AS
  DECLARE @outXMLResp XML
SET NOCOUNT ON
BEGIN
	DECLARE @errorCode				INT = 0
	DECLARE @errorString			NVARCHAR(1024) = ''
	DECLARE @nowTime				INT = datediff(second, '01/01/1970', GETDATE())
	DECLARE @infrastructurePoolId	INT = 0
	DECLARE @accessNodesGroupId		INT = 0
	DECLARE @indexServerClientid	INT = 0
	DECLARE @extendedProp			XML = ''
	DECLARE @flags					INT = 0  -- resevered for future use
	DECLARE @infraPoolAppType		INT = 1
	DECLARE @operationType			INT = 1  --1:Add, 2:Edit
	DECLARE @infraPoolOpType_ADD	INT = 1
	DECLARE @infraPoolOpType_EDIT	INT = 2
	DECLARE @MigratedPoolTag		NVARCHAR(MAX) = 'Migrated ResourcePool'
	DECLARE @storagePoolName		NVARCHAR(MAX) = ''
	DECLARE @resourcePoolName		NVARCHAR(MAX) = ''
	SELECT 	@infrastructurePoolId = ISNULL((ref.value('(poolInfo/storagePool/@storagePoolId)[1]','INT')), 0),
		   @accessNodesGroupId = ISNULL((ref.value('(poolInfo/accessNodesGroup/@clientGroupId)[1]','INT')), 0),
		   @indexServerClientid = ISNULL((ref.value('(poolInfo/indexServer/@clientId)[1]','INT')), 0),
		   @extendedProp = ref.query('(poolInfo/extendedProp)'),
		   @infraPoolAppType = ISNULL(ref.value('@appType', 'INT'), 1), -- default to 1 for O356, Exchange & GSuite
		   @operationType = ISNULL(ref.value('@operationType', 'INT'), 1)
	FROM @inXmlReq.nodes ('App_InfrastructurePoolSetReq') R(ref)
	IF((0 = @infrastructurePoolId) OR ( 0 = @accessNodesGroupId) OR (0 = @indexServerClientid AND @infraPoolAppType = 2)) -- indexServer is not applicable for salesforce
	BEGIN
		SET @errorCode = 1
		SET @errorString = 'Please check infrastrcture details are set in App_InfrastructurePoolSetReq.'
		GOTO ERROR_EXIT
	END
	IF NOT EXISTS (SELECT id FROM APP_ClientGroup (nolock) WHERE id = @accessNodesGroupId)
	BEGIN
		SET @errorCode = 1
		SET @errorString = 'Please check access nodes group id is valid.'
		GOTO ERROR_EXIT
	END
	IF NOT EXISTS (SELECT id FROM ArchGroup (nolock) WHERE id = @infrastructurePoolId)
	BEGIN
		SET @errorCode = 1
		SET @errorString = 'Please check storage pool id is valid.'
		GOTO ERROR_EXIT
	END
	IF NOT EXISTS (SELECT id FROM APP_Client(nolock) WHERE id = @indexServerClientid)
	BEGIN
		SET @errorCode = 1
		SET @errorString = 'Please check index server id valid.'
		GOTO ERROR_EXIT
	END
	IF @operationType = @infraPoolOpType_ADD AND
	 EXISTS (SELECT resourcePoolId FROM App_ResourcePool (nolock) WHERE storagePoolId = @infrastructurePoolId AND appType = @infraPoolAppType AND modified = 0)
	BEGIN
		SET @errorCode = 1
		SET @errorString = 'Adding redundant StoragePoolId and infrastructurePool appType is not allowed.'
		GOTO ERROR_EXIT
	END
	BEGIN TRY
			IF @operationType = @infraPoolOpType_EDIT
			BEGIN
				--update modified time on existing entry if any
				UPDATE APP_ResourcePool SET modified = @nowTime
				WHERE storagePoolId = @infrastructurePoolId AND appType = @infraPoolAppType AND modified = 0
			END
			BEGIN	--Insert new entry
				SET @storagePoolName = (SELECT name from archGroup WHERE id = @infrastructurePoolId)
				SET @resourcePoolName = @storagePoolName + ' ' + @MigratedPoolTag
				INSERT INTO APP_ResourcePool (resourcePoolName, storagePoolId, accessNodesGroupId, indexServerClientId, created, modified, flags, appType,extendedProps)
				VALUES(@resourcePoolName, @infrastructurePoolId, @accessNodesGroupId, @indexServerClientid, @nowTime,0,@flags,@infraPoolAppType,@extendedProp)
			END
	END TRY
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		SELECT @errorCode = ERROR_NUMBER(), @errorString = ERROR_MESSAGE()
	END CATCH
ERROR_EXIT:
	SET @outXMLResp = (SELECT ISNULL(@errorCode, 0) AS '@errorCode', ISNULL(@errorString, '') AS '@errorMessage' FOR XML PATH('App_GenericResp'))
	SELECT @outXMLResp
END
SET NOCOUNT OFF

IF EXISTS (select * from GxQscripts where name = 'MMInfrastructurePoolSet')
	delete from GxQscripts where name = 'MMInfrastructurePoolSet'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMInfrastructurePoolSet')
	delete from GXDBVersions where aliasname = 'MMInfrastructurePoolSet'
GO

insert into GXDBVersions values(2, 'MMInfrastructurePoolSet',  '00010001000400050000', 'MMInfrastructurePoolSet', '00010001000400050000')
GO

