

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMInfrastructurePoolGet.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2018  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--	+===================================================================+
--	|  				MMInfrastructurePoolGet								 |
--	|		 Procedure to get infrastructure pool information			 |
--	| Use temp table #tmpResultSetForMMInfrastructurePoolGet if executed |
--  | via EXEC MMInfrastructurePoolGet	@inXmlReq				   	  	 |
--	+===================================================================+
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMInfrastructurePoolGet.sp,v $ $Id: MMInfrastructurePoolGet.sp,v 1.1.4.10.8.1 2021/01/28 23:41:32 nuppu Exp $"
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='MMInfrastructurePoolGet')
BEGIN
	print '>>> Drop Stored Procedure: MMInfrastructurePoolGet <<<'
	drop procedure MMInfrastructurePoolGet
END
IF EXISTS (select * from GxQscripts where name='MMInfrastructurePoolGet')
	delete from GxQscripts where name = 'MMInfrastructurePoolGet'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMInfrastructurePoolGet')
	delete from GXDBVersions where aliasname = 'MMInfrastructurePoolGet'
GO
print '... Creating Procedure: MMInfrastructurePoolGet'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure MMInfrastructurePoolGet
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @inOutXmlReq XML	OUTPUT
-----------------------------------------------------------
AS
  DECLARE @outXMLResp XML 
SET NOCOUNT ON
BEGIN
	DECLARE @errorCode				INT = 0
	DECLARE @errorString			NVARCHAR(1024) = ''
	DECLARE @infrastructurePoolId	INT = 0
	DECLARE @storagePoolId			INT = 0
	DECLARE @storagePolicyId		INT = 0
	DECLARE @planId					INT = 0
	DECLARE @OPERATION				INT = 0  -- 0-Listing | 1-Lookup
	DECLARE @infraPoolAppType		INT = 1
	SET @storagePoolId = ISNULL((@inOutXmlReq.value('(/App_InfrastructurePoolGetReq/poolInfo/storagePool/@storagePoolId)[1]','INT')), 0)
	SET @storagePolicyId = ISNULL((@inOutXmlReq.value('(/App_InfrastructurePoolGetReq/storagePolicy/@storagePolicyId)[1]','INT')), 0)
	SET @planId = ISNULL((@inOutXmlReq.value('(/App_InfrastructurePoolGetReq/plan/@planId)[1]','INT')), 0)
	SET @infraPoolAppType = ISNULL(@inOutXmlReq.value('(/App_InfrastructurePoolGetReq/@appType)[1]', 'INT'), 1) -- default to1 for O365, Exchange & GSuite app type
	IF (@infraPoolAppType = 11 /*AZURE_AD*/ OR @infraPoolAppType = 7 /*D365*/) AND NOT EXISTS (SELECT TOP 1 appType FROM  APP_ResourcePool (nolock) RP where appType = @infraPoolAppType AND modified = 0)
	BEGIN
		SET @errorCode = 1
		SET @errorString = 'Please check infrastructure pool configuration associated with given storagePoolId is valid.'
		GOTO ERROR_EXIT
	END
	IF NOT EXISTS (SELECT TOP 1 appType FROM  APP_ResourcePool (nolock) RP where appType = @infraPoolAppType AND modified = 0)
		SET @infraPoolAppType = 1 -- default to O365 if required infraPoolApptype is not found.
	IF(0 != @planId)
	BEGIN
		--get the storagePolicy associated with plan
SELECT @storagePolicyId = ISNULL(dbo.AppPlanGetEntityValueV2(@planId, 'Storage policy', default), 0)
		SET	@OPERATION = 1
	END
	IF(0 = @storagePoolId AND 0 != @storagePolicyId)
	BEGIN
		SET	@OPERATION = 1
		--get storeagePoolId from storagePolicyId
		SELECT TOP 1 @storagePoolId = ISNULL(GAG.id, 0)
		FROM   ArchGroup DAG (nolock)
              INNER JOIN ArchGroupCopy DC (nolock) ON DAG.id = DC.archGroupId AND DAG.defaultCopy = DC.id
              LEFT OUTER JOIN ArchCopyToGlobalPolicy DC2GC (nolock) ON DC.id = DC2GC.copyId
              LEFT OUTER JOIN ArchGroup GAG (nolock) ON DC2GC.globalPolicyId = GAG.id
			  WHERE DAG.id = @storagePolicyId
	END
	SET @outXMLResp = (SELECT 'true' as '@isConfigured', ( SELECT RP.resourcePoolId as '@resourcePoolId', RP.appType as '@infraPoolAppType',
								(SELECT P.id as '@storagePoolId', P.name as '@storagePoolName' FOR XML PATH('storagePool'), TYPE),
								(SELECT CG.id as '@clientGroupId', CG.name as '@clientGroupName' FOR XML PATH('accessNodesGroup'), TYPE),
								(SELECT C.id as '@clientId', C.name as '@clientName' FOR XML PATH('indexServer'), TYPE),
								extendedProps  as [node()]
								FROM APP_ResourcePool (nolock) RP
								INNER JOIN ArchGroup (nolock) P ON RP.storagePoolId = P.id
								INNER JOIN App_ClientGroup CG (nolock) ON  RP.accessNodesGroupId = CG.id
								INNER JOIN App_Client C (nolock) ON RP.indexServerClientId = C.id
								WHERE RP.modified = 0 AND ( (@OPERATION = 0 /*Listing*/) OR ( @OPERATION = 1 /*Lookup*/ AND RP.storagePoolId = @storagePoolId AND RP.appType = @infraPoolAppType))
							FOR XML PATH('poolInfo'),TYPE)
					FOR XML PATH('App_InfrastructurePoolResp'))
	IF (0 = @outXMLResp.exist('App_InfrastructurePoolResp/poolInfo'))
	BEGIN
		SET @errorCode = 1
		SET @errorString = 'Please check infrastructure details associated with given storagePoolId are valid.'
		GOTO ERROR_EXIT
	END
ERROR_EXIT:
	IF @errorCode <> 0
		SET @outXMLResp = (SELECT 'false' as '@isConfigured', ISNULL(@errorCode,0) AS '@errorCode', ISNULL(@errorString,'') AS '@errorMessage' FOR XML PATH('App_InfrastructurePoolResp'))
	IF @outXMLResp IS NULL
		SET @outXMLResp = '<App_InfrastructurePoolResp/>'
	SET @inOutXmlReq = @outXMLResp
	--Caller has requested output in tmp table
	IF OBJECT_ID('tempdb..#tmpResultSetForMMInfrastructurePoolGet') IS NOT NULL
    BEGIN
        INSERT INTO #tmpResultSetForMMInfrastructurePoolGet
        SELECT @outXMLResp
    END
    ELSE
	BEGIN
		SELECT @outXMLResp
	END
END
SET NOCOUNT OFF

IF EXISTS (select * from GxQscripts where name = 'MMInfrastructurePoolGet')
	delete from GxQscripts where name = 'MMInfrastructurePoolGet'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMInfrastructurePoolGet')
	delete from GXDBVersions where aliasname = 'MMInfrastructurePoolGet'
GO

insert into GXDBVersions values(2, 'MMInfrastructurePoolGet',  'v1.1.4.10.8.1', 'MMInfrastructurePoolGet', 'v1.1.4.10.8.1')
GO

