

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMInfrastructurePoolDelete.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2018  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--	+===================================================================+
--	|  		MMInfrastructurePoolDelete									|
--	|		Procedure to get infrastructure pool information			|
--	+===================================================================+
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMInfrastructurePoolDelete.sp,v $ $Id: MMInfrastructurePoolDelete.sp,v 1.1.4.2 2018/08/23 16:27:40 nlakade Exp $"
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMInfrastructurePoolDelete <<<'

IF EXISTS (select * from sysobjects where name='MMInfrastructurePoolDelete')
	drop procedure MMInfrastructurePoolDelete
IF EXISTS (select * from GxQscripts where name='MMInfrastructurePoolDelete')
	delete from GxQscripts where name = 'MMInfrastructurePoolDelete'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMInfrastructurePoolDelete')
	delete from GXDBVersions where aliasname = 'MMInfrastructurePoolDelete'
GO
print '... Creating Procedure: MMInfrastructurePoolDelete'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MMInfrastructurePoolDelete
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @inXmlReq XML
-----------------------------------------------------------
AS
  DECLARE @outXMLResp XML
SET NOCOUNT ON
BEGIN
	DECLARE @errorCode			INT = 0
	DECLARE @errorString		NVARCHAR(1024) = ''
	DECLARE @infrastructurePoolId		INT = 0
	DECLARE @nowTime			INT = datediff(second, '01/01/1970', GETDATE())
	SET @infrastructurePoolId = ISNULL((@inXmlReq.value('(/App_InfrastructurePoolDeleteReq/poolInfo/storagePool/@storagePoolId)[1]','INT')), 0)
	IF(0 = @infrastructurePoolId)
	BEGIN
		SET @errorCode = 1
		SET @errorString = 'StoragePoolId is required to lookup infrastrcture pool details.'
		GOTO ERROR_EXIT
	END
	BEGIN TRY
		DELETE MMInfrastructurePool WHERE infrastructurePoolId = @infrastructurePoolId
	END TRY
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		SELECT @errorCode = ERROR_NUMBER(), @errorString = ERROR_MESSAGE()
	END CATCH
ERROR_EXIT:
	SET @outXMLResp = (SELECT ISNULL(@errorCode, 0) AS '@errorCode', ISNULL(@errorString, '') AS '@errorMessage' FOR XML PATH('App_GenericResp'))
	SELECT @outXMLResp
END
SET NOCOUNT OFF

IF EXISTS (select * from GxQscripts where name = 'MMInfrastructurePoolDelete')
	delete from GxQscripts where name = 'MMInfrastructurePoolDelete'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMInfrastructurePoolDelete')
	delete from GXDBVersions where aliasname = 'MMInfrastructurePoolDelete'
GO

insert into GXDBVersions values(2, 'MMInfrastructurePoolDelete',  '00010001000400020000', 'MMInfrastructurePoolDelete', '00010001000400020000')
GO

