

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMIncreaseArchiveCounters.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMIncreaseArchiveCounters <<<'

IF EXISTS (select * from sysobjects where name='MMIncreaseArchiveCounters')
	drop procedure MMIncreaseArchiveCounters
IF EXISTS (select * from GxQscripts where name='MMIncreaseArchiveCounters')
	delete from GxQscripts where name = 'MMIncreaseArchiveCounters'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMIncreaseArchiveCounters')
	delete from GXDBVersions where aliasname = 'MMIncreaseArchiveCounters'
GO
print '... Creating Procedure: MMIncreaseArchiveCounters'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMIncreaseArchiveCounters
  @increaseBy INTEGER,
  @DRRestoreTime INTEGER
AS
  DECLARE @tablename NVARCHAR(64)
  DECLARE @oldValue INT
  DECLARE @newValue INT
DECLARE @output TABLE (tablename NVARCHAR(64), oldValue INT, newValue INT)
-- Execute as sysadmin because we need to reseed identity columns using DBCC CHECKIDENT.
-- db_cvexecutor doesn't have permission to do this.
-- Escalated permissions will automatically revert when this stored procs exits.
EXECUTE AS LOGIN = 'sqladmin_cv'
-- log old counters
INSERT INTO @output
SELECT TABLE_NAME, ISNULL(IDENT_CURRENT(TABLE_NAME), 0), 0
FROM INFORMATION_SCHEMA.TABLES
WHERE TABLE_NAME IN ('gxjobcounter', 'archfile', 'mmvolume', 'idxsidbstore', 'idxsidbsubstore')
INSERT INTO @output
SELECT 'ArchChunk', ISNULL(MAX(next_l), 0), 0 FROM GxCounter
WHERE name = 'Chunk_Counter'
-- make the change
SELECT @newValue = IDENT_CURRENT ('GxJobCounter')+@increaseBy
IF @newValue IS NOT NULL
	DBCC CHECKIDENT ('GxJobCounter', RESEED, @newValue)
SELECT @newValue = IDENT_CURRENT ('MMVolume')+@increaseBy
IF @newValue IS NOT NULL
	DBCC CHECKIDENT ('MMVolume', RESEED, @newValue)
SELECT @newValue = IDENT_CURRENT ('ArchFile')+@increaseBy
IF @newValue IS NOT NULL
	DBCC CHECKIDENT ('ArchFile', RESEED, @newValue)
SELECT @newValue = IDENT_CURRENT ('IdxSIDBStore') + 10
IF @newValue IS NOT NULL
	DBCC CHECKIDENT ('IdxSIDBStore', RESEED, @newValue)
SELECT @newValue = IDENT_CURRENT ('IdxSIDBSubStore') + 10
IF @newValue IS NOT NULL
	DBCC CHECKIDENT ('IdxSIDBSubStore', RESEED, @newValue)
UPDATE GxCounter
SET next_l = next_l + @increaseBy
WHERE name = 'Chunk_Counter'
-- log new counters
UPDATE @output
SET newValue = ISNULL(IDENT_CURRENT(TABLE_NAME), 0)
FROM INFORMATION_SCHEMA.TABLES
WHERE TABLE_NAME IN ('gxjobcounter', 'archfile', 'mmvolume', 'idxsidbstore', 'idxsidbsubstore')
AND tablename = TABLE_NAME
UPDATE @output
SET newValue = next_l
FROM GxCounter GC
WHERE GC.name = 'Chunk_Counter'
AND tablename = 'ArchChunk'
-- persist in MMCounterIncrHistory
INSERT INTO MMCounterIncrHistory (DRRestoreTime, TableName, OldValue, NewValue, CreatedTime)
SELECT ISNULL (@DRRestoreTime, 0), TableName, OldValue, NewValue, dbo.GetUnixTime (CURRENT_TIMESTAMP)
FROM @output
-- done
SELECT * FROM @output
GO

IF EXISTS (select * from GxQscripts where name = 'MMIncreaseArchiveCounters')
	delete from GxQscripts where name = 'MMIncreaseArchiveCounters'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMIncreaseArchiveCounters')
	delete from GXDBVersions where aliasname = 'MMIncreaseArchiveCounters'
GO

insert into GXDBVersions values(2, 'MMIncreaseArchiveCounters',  '00000000000000000000', 'MMIncreaseArchiveCounters', '00000000000000000000')
GO

