

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMHasPrunableMagData.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2007  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMHasPrunableMagData.sp,v $ $Id: MMHasPrunableMagData.sp,v 1.1.300.3 2019/03/21 16:11:06 anarulkar Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 		PROCEDURE: "MMHasPrunableMagData"				|
--	|									|
--	| Execute the System stored procedure to fetch the physical files	|
--	| .. for the (current) database.					|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MMHasPrunableMagData')
BEGIN
	print '>>> Drop Stored Procedure: MMHasPrunableMagData <<<'
	drop procedure MMHasPrunableMagData
END
IF EXISTS (select * from GxQscripts where name='MMHasPrunableMagData')
	delete from GxQscripts where name = 'MMHasPrunableMagData'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMHasPrunableMagData')
	delete from GXDBVersions where aliasname = 'MMHasPrunableMagData'
GO
print '... Creating Procedure: MMHasPrunableMagData'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMHasPrunableMagData
  @i_reserveParam integer
AS
  DECLARE @o_hasMagData integer
  DECLARE @o_reserveOutput integer
	DECLARE @tblDDBs TABLE (SIDBStoreId INT)
	DECLARE @removableMediaPruning      INT = 0
	DECLARE @currentTime INT = 0
	SET     @currentTime = dbo.GetUnixTime(GETUTCDATE())
	SELECT @removableMediaPruning = value
	FROM MMConfigs WITH (NOLOCK)
	WHERE name = 'MMS2_CONFIG_ENABLE_REMOVABLE_MEDIA_PRUNING'
	-- Find the stores which are pending zeroref pruning.
	INSERT INTO @tblDDBs
	SELECT distinct I.SIDBStoreId
	FROM IdxSIDBStore I WITH (READUNCOMMITTED)
	    INNER JOIN archCopySIDBStore C WITH (READUNCOMMITTED) ON I.SIDBStoreId = C.SIDBStoreId
	    INNER JOIN IdxSIDBSubStore SUB WITH (READUNCOMMITTED) ON I.SIDBStoreId = SUB.SIDBStoreId
	    INNER JOIN (SELECT SIDBStoreId, SubStoreId, max(ModifiedTime) as ModifiedTime
	     FROM IdxSIDBUsageHistory WITH (READUNCOMMITTED)
	     GROUP BY SIDBStoreId, SubStoreId) T ON I.SIDBStoreId = T.SIDBStoreId
	    INNER JOIN IdxSIDBUsageHistory U WITH (READUNCOMMITTED) ON T.SIDBStoreId = U.SIDBStoreId AND T.SubStoreId = U.SubStoreId AND T.ModifiedTime = U.ModifiedTime
	WHERE I.commCellId = 2
AND I.flags & 256 = 0
	AND I.Status <> 1
AND I.flags & 2097152 = 0
	AND U.ZeroRefCount > 0
AND I.flags & 536870912 > 0
	-- Insert dummy AFs in MMDeletedAF for above collected DDB engines for MM to start pruning.
	INSERT INTO MMDeletedAF (archFileId, VolumeId, Status, Retry, copyId, cclip,
             CapacityFreedBytes, ArchChunkId, MountPathId, SIDBStoreId, CommCellId, DeletedTime, FailureErrorCode, subStoreBitField, sidbPruningFlag, appSizeFreedBytes, reserveInt)
SELECT 0x7FFFFFFF, 0, 0, 0, 0, '',
		0, 0, 0, T.SIDBStoreId, 2, @currentTime, 0, 0, 0, 0, 0
	FROM @tblDDBs T
LEFT OUTER JOIN MMDeletedAF D WITH (READUNCOMMITTED) ON T.SIDBStoreId = D.SIDBStoreId  AND D.MountPathId = 0 AND D.VolumeId = 0 AND D.ArchChunkId = 0 AND D.archFileId = 0x7FFFFFFF
	WHERE D.archFileId IS NULL
	-- For dedup pruning (phase 2), we may have entires in MMDeletedAF with ChunkId=Vol=MPId=0.
	-- Still MM needs to trigger pruning or else phase 2 and 3 pruning may not happen.
	IF EXISTS
	(
		SELECT top 1 DAF.MountPathId
		FROM MMMountPath MP WITH (READUNCOMMITTED), MMDeletedAF DAF WITH (READUNCOMMITTED)
		WHERE (DAF.MountPathId > 0 OR DAF.SIDBStoreId > 0) AND MP.MountPathId = DAF.MountPathId
	)
	OR
	(
	(@removableMediaPruning > 0)
	AND
	EXISTS
	(
		SELECT 1 FROM MMVolume vol WITH (READUNCOMMITTED) INNER JOIN MMDeletedAF daf WITH (READUNCOMMITTED) ON vol.VolumeId = daf.VolumeId
		INNER JOIN MMMedia med WITH (READUNCOMMITTED) ON vol.MediaId = med.MediaId
WHERE med.MediaTypeId >= 11001 AND med.MediaTypeId <= 11999
	)
	)
	BEGIN
		GOTO HAS_PRUNABLE_MAG
	END
	ELSE
	BEGIN
		GOTO NOT_HAS_PRUNABLE_MAG
	END
	GOTO PROC_EXIT
	HAS_PRUNABLE_MAG:
		SELECT 1, 0
		GOTO PROC_EXIT
	NOT_HAS_PRUNABLE_MAG:
		SELECT 0, 0
		GOTO PROC_EXIT
PROC_EXIT:
GO

IF EXISTS (select * from GxQscripts where name = 'MMHasPrunableMagData')
	delete from GxQscripts where name = 'MMHasPrunableMagData'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMHasPrunableMagData')
	delete from GXDBVersions where aliasname = 'MMHasPrunableMagData'
GO

insert into GXDBVersions values(2, 'MMHasPrunableMagData',  '00010001030000030000', 'MMHasPrunableMagData', '00010001030000030000')
GO

