

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMGroupReconJobForSubstore.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMGroupReconJobForSubstore.sp,v $ $Id: MMGroupReconJobForSubstore.sp,v 1.1.2.2 2019/03/15 22:11:12 anarulkar Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MMGroupReconJobForSubstore')
BEGIN
	print '>>> Drop Stored Procedure: MMGroupReconJobForSubstore <<<'
	drop procedure MMGroupReconJobForSubstore
END
IF EXISTS (select * from GxQscripts where name='MMGroupReconJobForSubstore')
	delete from GxQscripts where name = 'MMGroupReconJobForSubstore'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGroupReconJobForSubstore')
	delete from GXDBVersions where aliasname = 'MMGroupReconJobForSubstore'
GO
print '... Creating Procedure: MMGroupReconJobForSubstore'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MMGroupReconJobForSubstore
  @i_infoXML xml,
  @i_reserve integer
AS
  DECLARE @o_SIDBStoreId INTEGER
  DECLARE @o_SubStoreId INTEGER
  DECLARE @o_JobGroupNo INTEGER
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
-- Determine if SubStore LastSnapTime, corruptionTime, SnapLogSequence are set / matching for a reconstructed substores. Also check that store is resiliency enabled
-- If not then all the substores have to be reconstructed as part of same job.
--Entities to match
-- LastSnapTime		- 1
-- CorruptionTime	- 2
-- SnapLogSequence 	- 3
DECLARE	@tmpSubStoresInGroup TABLE
(
	SIDBStoreId			integer,
	SubStoreId			integer,
	LastSnapTime			integer,
	CorruptionTime			integer,
	IsSnapLogSeqSet			integer,
	GroupNumber			integer
)
DECLARE @resiliencyEnable	INTEGER = 0
DECLARE @SIDBStoreId INTEGER = 0
DECLARE	@SubStoreId		INTEGER = 0
DECLARE	@LastSnapTime		INTEGER = 0
DECLARE	@CorruptionTime		INTEGER = 0
DECLARE @IsSnapLogSeqSet	INTEGER = 0
DECLARE @GroupNumber		INTEGER = 0
DECLARE @timeDiffAllowed	INTEGER = 48
DECLARE @timeDiffAllowedInSec	INTEGER = 0
DECLARE @maxGroupNum		INTEGER = 0
-- Get the info from the input into table var
INSERT INTO @tmpSubStoresInGroup
SELECT  T.c.value('@StoreId', 'int'), T.c.value('@SubStoreId', 'int'), 0, 0, 0, 1
FROM    @i_infoXml.nodes('/r/h') T(c)
SELECT @SIDBStoreId = SIDBStoreId
FROM @tmpSubStoresInGroup
SELECT @resiliencyEnable = (AGC.dedupeFlags & 8)
FROM archGroupCopy AGC WITH (NOLOCK)
	INNER JOIN archCopySIDBStore AGCSI WITH (NOLOCK) ON AGC.id = AGCSI.copyId
WHERE AGCSI.SIDBStoreId = @SIDBStoreId
SELECT @timeDiffAllowed = value
FROM MMConfigs WITH (READUNCOMMITTED)
WHERE name = 'MMCONFIG_ALLOWED_TIME_INTERVAL_FOR_RECON_IN_HRS'
SET @timeDiffAllowedInSec = @timeDiffAllowed * 60 * 60
IF EXISTS (SELECT 1 FROM MMConfigs WITH (READUNCOMMITTED) WHERE name = 'MMCONFIG_SEPERATE_RECON_FOR_SUBSTORE_DISABLED' AND value > 0)
	GOTO CX_EXIT
IF @resiliencyEnable > 0
BEGIN
UPDATE T
SET LastSnapTime = I.LastSnapTime,
CorruptionTime = I.CorruptionTime,
IsSnapLogSeqSet = (CASE WHEN len(I.SnapLogSequence) > 0 THEN 1 ELSE 0 END)
FROM @tmpSubStoresInGroup T, IdxSIDBSubStore I WITH (READUNCOMMITTED)
WHERE T.SIDBStoreId = I.SIDBStoreId
AND T.SubStoreId = I.SubStoreId
DECLARE curOffSubStore CURSOR LOCAL FORWARD_ONLY FOR
SELECT SIDBStoreId, SubStoreId, LastSnapTime, CorruptionTime, IsSnapLogSeqSet, GroupNumber
FROM @tmpSubStoresInGroup
ORDER BY SubStoreId
OPEN curOffSubStore
FETCH NEXT FROM curOffSubStore INTO @SIDBStoreId, @SubStoreId, @LastSnapTime, @CorruptionTime, @IsSnapLogSeqSet, @GroupNumber
WHILE @@FETCH_STATUS = 0
BEGIN
	SELECT @maxGroupNum = max(GroupNumber) FROM @tmpSubStoresInGroup
	-- Assuming all the substores are already grouped
	-- Un-group all the reconstructing substores based on the lastSnapTime. If lastSnapTime difference is more than 48 Hrs then split the group.
	UPDATE @tmpSubStoresInGroup
	SET GroupNumber = @maxGroupNum + 1
	WHERE GroupNumber = @GroupNumber
	AND SubStoreId > @SubStoreId   -- All substores greater than current iteration
	AND (((LastSnapTime < (@LastSnapTime - @timeDiffAllowedInSec)) AND @LastSnapTime > 0) OR
		(LastSnapTime > (@LastSnapTime + @timeDiffAllowedInSec)))
	-- if some substores after the above are still grouped, then un-group them based on corruption time
	UPDATE @tmpSubStoresInGroup
	SET GroupNumber = @maxGroupNum + 1
	WHERE GroupNumber = @GroupNumber
	AND (((CorruptionTime < (@CorruptionTime - @timeDiffAllowedInSec)) AND (@CorruptionTime > 0)) OR
		(CorruptionTime > (@CorruptionTime + @timeDiffAllowedInSec)))
	-- Un-group based of whether SnapLogSequence is set or not.
	UPDATE @tmpSubStoresInGroup
	SET GroupNumber = @maxGroupNum + 1
	WHERE GroupNumber = @GroupNumber
	AND IsSnapLogSeqSet <> @IsSnapLogSeqSet
	FETCH NEXT FROM curOffSubStore INTO @SIDBStoreId, @SubStoreId, @LastSnapTime, @CorruptionTime, @IsSnapLogSeqSet, @GroupNumber
END
CLOSE curOffSubStore
DEALLOCATE curOffSubStore
END
CX_EXIT:
-- Return the info
SELECT SIDBStoreId, SubStoreId, GroupNumber
FROM @tmpSubStoresInGroup
ORDER BY GroupNumber
RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'MMGroupReconJobForSubstore')
	delete from GxQscripts where name = 'MMGroupReconJobForSubstore'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGroupReconJobForSubstore')
	delete from GXDBVersions where aliasname = 'MMGroupReconJobForSubstore'
GO

insert into GXDBVersions values(2, 'MMGroupReconJobForSubstore',  '00010001000200020000', 'MMGroupReconJobForSubstore', '00010001000200020000')
GO

