

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMGetXMLCompatibleLibrariesForMediaList.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMGetXMLCompatibleLibrariesForMediaList <<<'

IF EXISTS (select * from sysobjects where name='MMGetXMLCompatibleLibrariesForMediaList')
	drop procedure MMGetXMLCompatibleLibrariesForMediaList
IF EXISTS (select * from GxQscripts where name='MMGetXMLCompatibleLibrariesForMediaList')
	delete from GxQscripts where name = 'MMGetXMLCompatibleLibrariesForMediaList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetXMLCompatibleLibrariesForMediaList')
	delete from GXDBVersions where aliasname = 'MMGetXMLCompatibleLibrariesForMediaList'
GO
print '... Creating Procedure: MMGetXMLCompatibleLibrariesForMediaList'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MMGetXMLCompatibleLibrariesForMediaList
  @i_MediaIdList XML
AS
  DECLARE @r_LibraryId INT
  DECLARE @r_LibraryAliasName nvarchar(128)
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
/*Local Variables*/
 DECLARE @mediaList TABLE(mediaId int)
 DECLARE @libIds TABLE(libraryId int, mediaTypeId int)
 DECLARE @libCount TABLE(libraryId int, countLibMedia int)
DECLARE @l_libraries TABLE(libraryId int, libraryAliasName nvarchar(128))
 DECLARE @l_CountMediaType INT
 DECLARE @addShelfs    INT = 0
BEGIN
 SET @addShelfs = ISNULL( (SELECT  TOP 1 value FROM   MMConfigs WITH (NOLOCK)   WHERE   name = 'MMCONFIG_SHOW_SHELFS_IN_DESTINATION_LIBRARY_LIST'),0)
 INSERT INTO @mediaList(mediaID)
 SELECT  ID.value('@val','INT')
 FROM @i_MediaIdList.nodes('/EVGui_MMGetCompatibleLibrariesForMediaReq/mediaIdList')  ParamValues(ID)
 INSERT INTO @libIds(libraryId ,mediaTypeId )
 SELECT DISTINCT MMP.LibraryId,ML.mediaId
 FROM MMMedia MD INNER JOIN @mediaList ML ON MD.mediaId = ML.mediaId
	INNER JOIN MMRecFmtMedtyp MMR ON  MD.mediaTypeID = MMR.mediaTypeID
				          OR (MD.mediaTypeID = MMR.CleaningMediaTypeId AND (MD.mediaTypeID !=0) )
	INNER JOIN MMDrive 	MDR ON MDR.driveTypeId = MMR.driveTypeId
	INNER JOIN MMMasterPool MMP ON MMP.masterPoolID = MDR.masterPoolID
 INSERT @libCount(libraryId , countLibMedia )
 select libraryId , count(*)
 from @libIds
 group by libraryId
 /* Find Common library for media list */
 select @l_CountMediaType = count(DISTINCT mediaTypeId) from @libIds
 INSERT INTO @l_libraries(libraryId ,libraryAliasName )
 SELECT Mlib.libraryId,Mlib.AliasName FROM @libCount LC,MMLibrary MLib
 where LC.countLibMedia = @l_CountMediaType AND
	  MLib.libraryId = LC.libraryId
 IF(@addShelfs > 0)
 BEGIN
	INSERT INTO @l_libraries(libraryId ,libraryAliasName )
SELECT LibraryId, AliasName from MMLibrary WITH (NOLOCK) where LibraryTypeId = 8
 END
/*Return List of libraryIds and library AliasNames*/
 Select * from @l_libraries
END

IF EXISTS (select * from GxQscripts where name = 'MMGetXMLCompatibleLibrariesForMediaList')
	delete from GxQscripts where name = 'MMGetXMLCompatibleLibrariesForMediaList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetXMLCompatibleLibrariesForMediaList')
	delete from GXDBVersions where aliasname = 'MMGetXMLCompatibleLibrariesForMediaList'
GO

insert into GXDBVersions values(2, 'MMGetXMLCompatibleLibrariesForMediaList',  '00000000000000000000', 'MMGetXMLCompatibleLibrariesForMediaList', '00000000000000000000')
GO

