

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMGetVolumesForStore.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMGetVolumesForStore.sp,v $ $Id: MMGetVolumesForStore.sp,v 1.1.2.5 2018/03/20 00:05:03 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMGetVolumesForStore <<<'

IF EXISTS (select * from sysobjects where name='MMGetVolumesForStore')
	drop procedure MMGetVolumesForStore
IF EXISTS (select * from GxQscripts where name='MMGetVolumesForStore')
	delete from GxQscripts where name = 'MMGetVolumesForStore'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetVolumesForStore')
	delete from GXDBVersions where aliasname = 'MMGetVolumesForStore'
GO
print '... Creating Procedure: MMGetVolumesForStore'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MMGetVolumesForStore
  @i_storeId integer,
  @i_lastFetchVolumeId integer,
  @i_jobId bigint,
  @i_reserve integer
AS
  DECLARE @o_VolumeId integer
  DECLARE @o_MountPathId integer
DECLARE @maxVolumeId	int = 0
DECLARE @numVolumes	int = 0
SET NOCOUNT ON
SELECT @maxVolumeId = attributeValueInt
   FROM JMJobOptions WITH (NOLOCK)
WHERE jobId = @i_jobId AND commcellId = 2
AND attributeId = 65
IF @i_lastFetchVolumeId = 0
BEGIN
	SELECT @maxVolumeId = MAX(VolumeId), @numVolumes = count(*)
	FROM MMVolume WITH (READUNCOMMITTED)
	WHERE SIDBStoreId = @i_storeId
	SELECT @maxVolumeId, @numVolumes
	UNION ALL
	SELECT T.VolumeId, T.MountPathId
	FROM
	(
	SELECT Top 200 V.VolumeId, M.MountPathId
	FROM MMVolume V WITH (READUNCOMMITTED), MMMountPath M WITH (READUNCOMMITTED)
	WHERE V.SIDBStoreId = @i_storeId
	AND V.VolumeId > @i_lastFetchVolumeId
	AND V.MediaSideId = M.MediaSideId
	ORDER BY V.VolumeId ASC, M.MountPathId ASC
	) T
END
ELSE
BEGIN
SELECT Top 200 VolumeId, MountPathId
FROM MMVolume V WITH (READUNCOMMITTED), MMMountPath M WITH (READUNCOMMITTED)
WHERE V.SIDBStoreId = @i_storeId
AND V.VolumeId > @i_lastFetchVolumeId
AND V.MediaSideId = M.MediaSideId
AND V.VolumeId <= @maxVolumeId
ORDER BY V.VolumeId ASC, M.MountPathId ASC
END
GO

IF EXISTS (select * from GxQscripts where name = 'MMGetVolumesForStore')
	delete from GxQscripts where name = 'MMGetVolumesForStore'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetVolumesForStore')
	delete from GXDBVersions where aliasname = 'MMGetVolumesForStore'
GO

insert into GXDBVersions values(2, 'MMGetVolumesForStore',  '00010001000200050000', 'MMGetVolumesForStore', '00010001000200050000')
GO

