

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMGetUnusedSIDBStores.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2007  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMGetUnusedSIDBStores.sp,v $ $Id: MMGetUnusedSIDBStores.sp,v 1.22.12.5 2019/02/21 13:47:14 shubhamagrawal Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MMGetUnusedSIDBStores')
BEGIN
	print '>>> Drop Stored Procedure: MMGetUnusedSIDBStores <<<'
	drop procedure MMGetUnusedSIDBStores
END
IF EXISTS (select * from GxQscripts where name='MMGetUnusedSIDBStores')
	delete from GxQscripts where name = 'MMGetUnusedSIDBStores'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetUnusedSIDBStores')
	delete from GXDBVersions where aliasname = 'MMGetUnusedSIDBStores'
GO
print '... Creating Procedure: MMGetUnusedSIDBStores'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMGetUnusedSIDBStores
  @i_CommCellId integer,
  @i_reserveParam integer
AS
-- Following are the "columns" returned, in the order in which they are returned
  DECLARE @o_SIDBStoreId integer
  DECLARE @o_SIDBStoreName varchar(256)
  DECLARE @o_SIDBStoreAliasName NVARCHAR(256)
  DECLARE @o_CommCellId integer
  DECLARE @o_CopyId integer
  DECLARE @o_IdxCacheId integer
  DECLARE @o_IdxAccessPathId integer
  DECLARE @o_ClientId integer
  DECLARE @o_FirstBackupTime integer
  DECLARE @o_MinObjSizeKB integer
  DECLARE @o_oldestEligibleObjArchiveTime integer
  DECLARE @o_SignatureType integer
  DECLARE @o_flags integer
  DECLARE @o_TotalDataSizeBytes bigint
  DECLARE @o_InstancedDataSizeBytes bigint
  DECLARE @o_Status integer
  DECLARE @o_LastAccessTime integer
DECLARE @now integer = 0
SET @now = dbo.GetUnixTime(GETUTCDATE())
DECLARE @pruneInterval integer = 0
SELECT @pruneInterval = ISNULL(value, 0) FROM MMConfigs WHERE name = 'MMCONFIG_DDB_MIN_INTERVAL_IN_HRS_FOR_CLEANUP_AFTER_CREATION'
IF (@pruneInterval <= 0)
BEGIN
SET @pruneInterval = 1
END
	if object_id('tempdb.dbo.#tmpUnusedSIDBs') is not null DROP TABLE #tmpUnusedSIDBs
	create table #tmpUnusedSIDBs (SIDBStoreId	integer)
	IF (@i_reserveParam = 0)
	BEGIN
		INSERT	INTO #tmpUnusedSIDBs
		SELECT	DISTINCT I.SIDBStoreId
		FROM 	IdxSIDBStore I WITH (NOLOCK) LEFT OUTER JOIN archCopySIDBStore A WITH (NOLOCK)
			ON	I.SIDBStoreId = A.SIDBStoreId AND I.CommCellId = A.CommCellId
		WHERE	I.SIDBStoreId > 0 AND (@i_CommCellId = 0 OR I.CommCellId = @i_CommCellId)
AND (A.SIDBStoreId IS NULL OR (I.flags & 256) > 0)
AND (I.flags & 1024 = 0) -- for ddb move.
AND NOT EXISTS(SELECT SubStoreId FROM IdxSIDBSubStore SS WITH (NOLOCK) WHERE SS.SIDBStoreId = I.SIDBStoreId AND SS.flags & 1024 = 1024)
			AND (I.CreatedTime < (@now - @pruneInterval*60*60)) -- ensure that store is older than a day.
		IF @@ROWCOUNT > 0
		BEGIN
			DELETE	#tmpUnusedSIDBs
			FROM	#tmpUnusedSIDBs A,
					(SELECT DISTINCT SIDBStoreId FROM MMVolume WITH (NOLOCK) WHERE SIDBStoreId > 0) T
			WHERE	A.SIDBStoreId = T.SIDBStoreId
			DELETE	#tmpUnusedSIDBs
			FROM	#tmpUnusedSIDBs A,
					(SELECT DISTINCT SIDBStoreId FROM MMDeletedAF WITH (NOLOCK) WHERE SIDBStoreId > 0) T
			WHERE	A.SIDBStoreId = T.SIDBStoreId
		END
	END
	ELSE
	BEGIN
		declare		@l_compareTime	DATETIME
		declare		@tblStorePrimingStores TABLE (SIDBStoreId int)
		declare		@tblCopies TABLE (copyId int, dedupeFlags int, siloInCache int)
		declare 	@l_numDaysSIDBBkwdRef int = 0
		SET	@l_compareTime = DATEADD (mi, -5, GETUTCDATE())
		--for DDBs hosted on MA version 9.0
		INSERT	INTO #tmpUnusedSIDBs
		SELECT	DISTINCT I.SIDBStoreId
		FROM 	IdxSIDBStore I WITH (READUNCOMMITTED)
			INNER JOIN archCopySIDBStore SC WITH (READUNCOMMITTED) ON I.SIDBStoreId = SC.SIDBStoreId
			INNER JOIN archGroupCopy C WITH (READUNCOMMITTED) ON SC.CopyId = C.id
		WHERE	I.SIDBStoreId > 0 AND (@i_CommCellId = 0 OR I.CommCellId = @i_CommCellId)
			AND
			(
				(
					I.SIDBSiloedTime > 0
					AND I.SIDBSiloedTime < dbo.getUnixTime(@l_compareTime)
					AND I.SIDBSiloStatus = 2 -- DDB_ARCHIVED
				)
				OR
				(
I.Status = 1
				)
			)
			AND I.SealedTime > 0
AND (C.dedupeFlags & 131072) > 0
AND I.SIDBStoreId IN (SELECT SIDBStoreId FROM IdxSIDBSubStore IDX WITH (READUNCOMMITTED), APP_Client AC WITH (READUNCOMMITTED) WHERE (IDX.clientId = AC.id AND AC.releaseId = 14) OR IDX.clientId = 1)
			AND NOT EXISTS (SELECT VolumeId FROM MMVolume WITH (READUNCOMMITTED) WHERE SiloStatus < 2)
		--for DDBs hosted on MA version 10.0, we dont need to check for SIDBSiloedTime and SIDBSiloStatus since these are no longer updated.
		INSERT	INTO #tmpUnusedSIDBs
		SELECT	DISTINCT I.SIDBStoreId
		FROM 	IdxSIDBStore I WITH (READUNCOMMITTED)
			INNER JOIN archCopySIDBStore SC WITH (READUNCOMMITTED) ON I.SIDBStoreId = SC.SIDBStoreId
			INNER JOIN archGroupCopy C WITH (READUNCOMMITTED) ON SC.CopyId = C.id
		WHERE	I.SIDBStoreId > 0 AND (@i_CommCellId = 0 OR I.CommCellId = @i_CommCellId)
			AND I.SealedTime > 0
AND (C.dedupeFlags & 131072) > 0
AND I.SIDBStoreId IN (SELECT SIDBStoreId FROM IdxSIDBSubStore IDX WITH (READUNCOMMITTED), APP_Client AC WITH (READUNCOMMITTED) WHERE ((IDX.clientId = AC.id AND AC.releaseId >= 15) OR IDX.clientId = 1) AND (IDX.flags & 2048) = 0)
		-- find stores which should be prevented from deleting due to store priming
		INSERT INTO @tblCopies
		SELECT id, dedupeFlags, silosInCache FROM archGroupCopy WITH (READUNCOMMITTED)
WHERE dedupeFlags & 2 > 0
AND dedupeFlags & 2097152 > 0
		BEGIN
			DECLARE @copyId INT = 0
			DECLARE @dedupeFlags INT = 0
			DECLARE @silosInCache INT = 0
			DECLARE CopyCursor CURSOR FOR
			SELECT copyId, dedupeFlags, siloInCache
			FROM @tblCopies
			OPEN CopyCursor
			FETCH NEXT FROM CopyCursor INTO @copyId, @dedupeFlags, @silosInCache
			WHILE (@@FETCH_STATUS = 0)
			BEGIN
IF (@dedupeFlags & 2097152) > 0
				BEGIN
			                INSERT INTO @tblStorePrimingStores
			                SELECT I.SIDBStoreId
	        		        FROM IdxSIDBStore as I WITH (READUNCOMMITTED)
WHERE I.Status <> 1
					AND I.SealedTime > 0
					AND I.SIDBStoreId in (SELECT top(@silosInCache + 1) SIDBStoreId from archCopySidbStore WITH (READUNCOMMITTED) where CopyId = @copyId )
		        	        AND NOT EXISTS
	        	        	             (select VolumeId from MMVolume WITH (READUNCOMMITTED) where SiloStatus = 3 /* SILO_VOLUME_MIGRATED_OFFDISK is value 3*/ and SIDBStoreId = I.SIDBStoreId)
		        	        AND I.SIDBSiloStatus <> 3 -- DDB_ARCHIVED_OFFDISK
AND I.Version >= 2
AND I.flags & 256 = 0
				END
				ELSE
				BEGIN
					INSERT INTO @tblStorePrimingStores
			                SELECT SIDBStoreId
			                FROM IdxSIDBStore WITH (READUNCOMMITTED)
			                WHERE Status <> 1 and SealedTime > 0 and SIDBStoreId in (SELECT SIDBStoreId from archCopySidbStore WITH (READUNCOMMITTED) where CopyId = @copyId )
and Version >= 2
			                and SIDBSiloStatus <> 3 -- DDB_ARCHIVED_OFFDISK
and flags & 256 = 0
				END
				FETCH CopyCursor INTO @copyId, @dedupeFlags, @silosInCache
			END
		END
		DELETE FROM #tmpUnusedSIDBs WHERE SIDBStoreId IN (SELECT SIDBStoreId FROM @tblStorePrimingStores)
DELETE FROM #tmpUnusedSIDBs WHERE SIDBStoreId IN (SELECT SIDBStoreId FROM IdxSIDBStore I where I.flags & 1024 > 0)
DELETE FROM #tmpUnusedSIDBs WHERE SIDBStoreId IN (SELECT SIDBStoreId FROM IdxSIDBSubStore I where I.flags & 1024 > 0)
	END
	SELECT	STORE.SIDBStoreId,
			STORE.SIDBStoreName,
			STORE.SIDBStoreAliasName,
			STORE.CommCellId,
			ISNULL((SELECT TOP 1 CopyId FROM archCopySIDBStore WITH (NOLOCK) WHERE SIDBStoreId = STORE.SIDBStoreId), 0),
			STORE.IdxCacheId,
			STORE.IdxAccessPathId,
			STORE.ClientId,
			STORE.FirstBackupTime,
			STORE.MinObjSizeKB,
			STORE.oldestEligibleObjArchiveTime,
			STORE.SignatureType,
			STORE.flags,
			STORE.TotalDataSizeBytes,
			STORE.InstancedDataSizeBytes,
			STORE.Status,
			STORE.LastAccessTime
	FROM 	IdxSIDBStore STORE WITH (READUNCOMMITTED), #tmpUnusedSIDBs T
	WHERE	STORE.SIDBStoreId = T.SIDBStoreId
		AND STORE.SIDBStoreId NOT IN (
								SELECT 	DISTINCT SIDBStoreId
								FROM 	IdxSIDBSubStore Sub WITH (NOLOCK), APP_Client AC WITH (NOLOCK)
           						WHERE 	Sub.ClientId = AC.id
									AND AC.releaseId < 13
AND AC.id <> 1
								)
	drop table #tmpUnusedSIDBs
GO

IF EXISTS (select * from GxQscripts where name = 'MMGetUnusedSIDBStores')
	delete from GxQscripts where name = 'MMGetUnusedSIDBStores'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetUnusedSIDBStores')
	delete from GXDBVersions where aliasname = 'MMGetUnusedSIDBStores'
GO

insert into GXDBVersions values(2, 'MMGetUnusedSIDBStores',  '00010022001200050000', 'MMGetUnusedSIDBStores', '00010022001200050000')
GO

