

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMGetTapeDriveUsage.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMGetTapeDriveUsage.sp,v $ $Id: MMGetTapeDriveUsage.sp,v 1.1.2.4 2018/03/20 19:47:16 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMGetTapeDriveUsage <<<'

IF EXISTS (select * from sysobjects where name='MMGetTapeDriveUsage')
	drop procedure MMGetTapeDriveUsage
IF EXISTS (select * from GxQscripts where name='MMGetTapeDriveUsage')
	delete from GxQscripts where name = 'MMGetTapeDriveUsage'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetTapeDriveUsage')
	delete from GXDBVersions where aliasname = 'MMGetTapeDriveUsage'
GO
print '... Creating Procedure: MMGetTapeDriveUsage'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MMGetTapeDriveUsage
  @libraryName varchar(MAX) ='',
  @driveName varchar(MAX) = ''
AS
SET NOCOUNT ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE #DailyUsage  (DriveId INT, ReadSec INT, ReadMB BIGINT, WriteSec INT, WriteMB BIGINT,  Errors INT)
CREATE TABLE #WeeklyUsage (DriveId INT, ReadSec INT, ReadMB BIGINT, WriteSec INT, WriteMB BIGINT,  Errors INT)
DECLARE @24HoursAgo DATETIME = DATEADD(HOUR, -24, GETUTCDATE())
DECLARE @7DaysAgo   DATETIME = DATEADD(DAY, -7, GETUTCDATE())
INSERT  INTO #DailyUsage
SELECT  H.DriveId, SUM(DataReadDurationSec), SUM(DataRead), SUM(DataWriteDurationSec), SUM(DataWritten), SUM(NumberOfSoftErrors + NumberOfHardErrors)
FROM    MMDriveHistory H WITH (NOLOCK)
    INNER JOIN MMDrive D WITH (NOLOCK) ON H.DriveId = D.DriveId AND D.DriveTypeId < 10001
WHERE   HistoryType = 2 AND TimeStart >= @24HoursAgo
GROUP BY H.DriveId
INSERT  INTO #WeeklyUsage
SELECT  H.DriveId, SUM(DataReadDurationSec), SUM(DataRead), SUM(DataWriteDurationSec), SUM(DataWritten), SUM(NumberOfSoftErrors + NumberOfHardErrors)
FROM    MMDriveHistory H WITH (NOLOCK)
    INNER JOIN MMDrive D WITH (NOLOCK) ON H.DriveId = D.DriveId AND D.DriveTypeId < 10001
WHERE   HistoryType = 2 AND TimeStart >= @7DaysAgo
GROUP BY H.DriveId
SELECT  L.AliasName AS Library,
        D.AliasName AS Drive,
        CAST (RatedThroughputInMBPerSec*3600/1024 AS DECIMAL(20,2)) AS 'Manufacturer Rated (GB/Hr)',
        CAST(ISNULL(WU.WriteSec, 0)/3600.0 AS DECIMAL(20,2)) AS 'Weekly Write Time (Hr)',
        CAST(ISNULL(WU.WriteMB, 0)/1024.0 AS DECIMAL(20,2)) AS 'Weekly Write Size (GB)',
        CASE WHEN ISNULL(WU.WriteSec, 0) > 0 THEN CAST(WU.WriteMB/1024.0/(WU.WriteSec/3600.0) AS DECIMAL(20,2)) ELSE 0 END AS 'Weekly Write (GB/Hr)',
        CAST(ISNULL(WU.ReadSec, 0)/3600.0 AS DECIMAL(20,2)) AS 'Weekly Read Time (Hr)',
        CAST(ISNULL(WU.ReadMB, 0)/1024.0 AS DECIMAL(20,2)) AS 'Weekly Read Size (GB)',
        CASE WHEN ISNULL(WU.ReadSec, 0) > 0 THEN CAST(WU.ReadMB/1024.0/(WU.ReadSec/3600.0) AS DECIMAL(20,2)) ELSE 0 END AS 'Weekly Read (GB/Hr)',
        ISNULL(WU.Errors, 0) AS 'Weekly Errors',
        CAST(ISNULL(DU.WriteSec, 0)/3600.0 AS DECIMAL(20,2)) AS 'Daily Write Time (Hr)',
        CAST(ISNULL(DU.WriteMB, 0)/1024.0 AS DECIMAL(20,2)) AS 'Daily Write Size (GB)',
        CASE WHEN ISNULL(DU.WriteSec, 0) > 0 THEN CAST(DU.WriteMB/1024.0/(DU.WriteSec/3600.0) AS DECIMAL(20,2)) ELSE 0 END AS 'Daily Write (GB/Hr)',
        CAST(ISNULL(DU.ReadSec, 0)/3600.0 AS DECIMAL(20,2)) AS 'Daily Read Time (Hr)',
        CAST(ISNULL(DU.ReadMB, 0)/1024.0 AS DECIMAL(20,2)) AS 'Daily Read Size (GB)',
        CASE WHEN ISNULL(DU.ReadSec, 0) > 0 THEN CAST(DU.ReadMB/1024.0/(DU.ReadSec/3600.0) AS DECIMAL(20,2)) ELSE 0 END AS 'Daily Read (GB/Hr)',
        ISNULL(DU.Errors, 0) AS 'Daily Errors'
FROM    MMDrive D WITH (NOLOCK)
        INNER JOIN MMDriveType DT WITH (NOLOCK) ON D.DriveTypeId = DT.DriveTypeId
        INNER JOIN MMMasterPool MP WITH (NOLOCK) ON D.MasterPoolId = MP.MasterPoolId
        INNER JOIN MMLibrary L WITH (NOLOCK) ON MP.Libraryid = L.LibraryId
        LEFT OUTER JOIN #WeeklyUsage WU ON D.DriveId = WU.DriveId
        LEFT OUTER JOIN #DailyUsage DU ON WU.DriveId = DU.DriveId
WHERE   D.DriveId > 0 AND D.DriveTypeId < 10001
		AND (D.AliasName = @driveName OR @driveName = '' or @driveName IS NULL)
		AND (L.AliasName = @libraryName OR @libraryName = '' or @libraryName IS NULL)
ORDER BY 'Weekly Write (GB/Hr)', 'Weekly Read (GB/Hr)', Library, Drive
DROP TABLE #DailyUsage
DROP TABLE #WeeklyUsage

IF EXISTS (select * from GxQscripts where name = 'MMGetTapeDriveUsage')
	delete from GxQscripts where name = 'MMGetTapeDriveUsage'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetTapeDriveUsage')
	delete from GXDBVersions where aliasname = 'MMGetTapeDriveUsage'
GO

insert into GXDBVersions values(2, 'MMGetTapeDriveUsage',  '00010001000200040000', 'MMGetTapeDriveUsage', '00010001000200040000')
GO

