

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMGetStoragePools.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2011  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMGetStoragePools.sp,v $ $Id: MMGetStoragePools.sp,v 1.1.2.23 2020/12/12 21:19:08 aselvanayagam Exp $";
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='MMGetStoragePools')
BEGIN
	print '>>> Drop Stored Procedure: MMGetStoragePools <<<'
	drop procedure MMGetStoragePools
END
IF EXISTS (select * from GxQscripts where name='MMGetStoragePools')
	delete from GxQscripts where name = 'MMGetStoragePools'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetStoragePools')
	delete from GXDBVersions where aliasname = 'MMGetStoragePools'
GO
print '... Creating Procedure: MMGetStoragePools'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure MMGetStoragePools
  @i_userId integer = 0,
  @i_storagePoolName nvarchar(255) = '',
  @i_storagePoolType integer = 0,
  @i_storageType integer = 0,
  @i_storageSubType integer = 0,
  @i_libraryId integer = 0
AS
-- Following are the "columns" returned, in the order in which they are returned
  DECLARE @o_StoragePoolId integer
  DECLARE @o_StoragePoolName nvarchar(255)
  DECLARE @o_StoragePoolType integer
  DECLARE @o_SIDBStoreId integer
  DECLARE @o_ClientGroupName nvarchar(512)
  DECLARE @o_Libraries varchar(1024)
  DECLARE @o_LibraryType integer
  DECLARE @o_NumMediaAgents integer
  DECLARE @o_TotalControllers integer
  DECLARE @o_ActiveControllers integer
  DECLARE @o_LibOfflineReason integer
  DECLARE @o_MPOfflineReason integer
  DECLARE @o_MAOfflineReason integer
  DECLARE @o_MountPathType integer
  DECLARE @o_StatusCode integer
  DECLARE @o_deviceTypeId integer
  DECLARE @o_LibrarySubType integer
IF OBJECT_ID('tempdb..#lt_StoragePool') IS NOT NULL DROP TABLE #lt_StoragePool
CREATE TABLE #lt_StoragePool (id INT, name nvarchar(512), type INT, SIDBStoreId INT, clientGroupName nvarchar(512),status INT)
DECLARE @archGroupFlags INT = 0;
SET @archGroupFlags = 	CASE
WHEN @i_storagePoolType = 1 THEN 256   		--Api::StoragePoolType_DEDUPLICATION
WHEN @i_storagePoolType = 2 THEN 16384 	--Api::StoragePoolType_SECONDARY_COPY
WHEN @i_storagePoolType = 3 THEN 8388608     		--Api::StoragePoolType_NON_DEDUPLICATION
WHEN @i_storagePoolType = 4 THEN 33554432   	--Api::StoragePoolType_SCALE_OUT
ELSE 256 | 16384 | 8388608 | 33554432
						END
IF(@i_storageType = 3) --Api::StorageType_HYPERSCALE
BEGIN
SET @archGroupFlags = @archGroupFlags & 33554432
END
IF @i_libraryId = 0
BEGIN
	SET @i_libraryId = NULL
END
DECLARE @showHiddenSPConfig INT = 0
SELECT  @showHiddenSPConfig = value FROM MMConfigs (READUNCOMMITTED) WHERE name = 'MMCONFIG_SHOW_HIDDEN_STORAGE_POLICIES'
IF OBJECT_ID('tempdb.dbo.#lt_StoragePool_UserObjects') IS NOT NULL DROP TABLE #lt_StoragePool_UserObjects
CREATE TABLE #lt_StoragePool_UserObjects (StoragePolicyId INT)
--Filter out storage pools based on user permissions
IF @i_userId > 0
BEGIN
EXEC sec_getNonIdaObjectsForThisUser @i_userId, 17, 0, '#lt_StoragePool_UserObjects'
END
INSERT 	INTO #lt_StoragePool
SELECT	AG.id,
		AG.name,
		CASE
WHEN AG.flags & 33554432 = 33554432  			THEN 4 	--Api::StoragePoolType_SCALE_OUT -- Scale out storagepool
WHEN AG.flags & 256 = 256  					THEN 1 	--Api::StoragePoolType_DEDUPLICATION -- GDSP
WHEN AG.flags & 16384 = 16384 	THEN 2 	--Api::StoragePoolType_SECONDARY_COPY -- GACP
			ELSE 3 																									--Api::StoragePoolType_NON_DEDUPLICATION
		END,
		ISNULL(CS.SIDBStoreId, 0),
		ISNULL(SDS.StoragePoolName,''),
		ISNULL(SDS.StoragePoolStatus,0)
FROM    archGroup AG WITH(READUNCOMMITTED)
LEFT OUTER JOIN archCopySIDBStore CS WITH (READUNCOMMITTED) ON AG.defaultCopy = CS.copyId AND ((CS.Flags & (2|4)) = (2|4))
        LEFT OUTER JOIN MMSDSStoragePool SDS WITH (READUNCOMMITTED) ON  AG.id = SDS.GDSPId
WHERE   (
			AG.name = @i_storagePoolName
			OR ( @i_storagePoolName = '' AND (AG.flags & @archGroupFlags) > 0)
		)
AND (AG.flags & 64 = 0 OR @showHiddenSPConfig > 0)
		AND (@i_userId = 0 OR EXISTS(SELECT 1 FROM #lt_StoragePool_UserObjects SEC WHERE SEC.StoragePolicyId = AG.id))
IF OBJECT_ID('tempdb..#lt_Library') IS NOT NULL DROP TABLE #lt_Library
CREATE TABLE #lt_Library (StoragePoolId INT, LibraryId INT, LibraryType INT, LibrarySubType INT, TotalControllers INT, OnlineControllers INT, LibOfflineReason INT, MPOfflineReason INT, MAOfflineReason INT, MountPathType INT, DeviceTypeId INT)
INSERT 	INTO #lt_Library
SELECT	SP.id,
		LIB.LibraryId,
		MAX(LIB.LibraryTypeId),
MAX(CASE WHEN LIB.VTLType = 4 THEN 1 /*Api::StorageSubType_IBMi_VTL*/
			 WHEN MPDS.MountPathId IS NOT NULL THEN 3 /*APP::StorageSubStore_HEDVIG*/ ELSE 0 END),
		/*TotalControllers*/
		0,
		/*OnlineControllers*/
		0,
		/*Library Offline Reason*/
		MAX(
				CASE
				WHEN (LIB.LibrarySoftState = 0 OR LIB.LibraryEnabled = 0 OR LIB.LibraryBroken = 1 OR LC.LibraryControllerSoftState = 0 OR LC.LibraryControllerEnabled = 0)
				THEN LIB.LibraryStatusReason
				ELSE 0
				END
			),
		/*MountPath or Drive Offline Reason*/
		MAX(
				CASE
WHEN (LIB.LibraryTypeId = 3 AND (MP.IsEnabled = 0 OR MP.IsOffline = 1))
				THEN MP.OfflineReason
WHEN (LIB.LibraryTypeId <> 3 AND (DRV.DriveSoftState = 0 OR DRV.DriveEnabled = 0 OR DRV.DriveBroken = 1))
				THEN DRV.OfflineReason
				ELSE 0
				END
			),
		/*MA Offline Reason*/
		MAX(
				CASE
				WHEN (MA.MmHostEnabled = 0 OR MA.MmHostSoftState = 0)
				THEN MA.OfflineReason
				ELSE 0
				END
			),
		/*Mount Path Type*/
		MAX(
				CASE
WHEN (LIB.LibraryTypeId = 3)
				THEN MP.MountPathTypeId
				ELSE 0
				END
			),
		/*deviceTypeId*/
		MAX(
				CASE
WHEN (LIB.LibraryTypeId = 3)
				THEN D.DisplayDeviceTypeId
				ELSE 0
				END
			)
FROM	#lt_StoragePool SP
		INNER JOIN ArchGroupCopy AGC WITH(READUNCOMMITTED) ON SP.id = AGC.archGroupId
		INNER JOIN MMDataPath DPath WITH(READUNCOMMITTED) ON AGC.id = DPath.CopyId
		INNER JOIN MMDrivePool DPool WITH(READUNCOMMITTED) ON DPath.DrivePoolId = DPool.DrivePoolId
		INNER JOIN MMMasterPool MPool  WITH(READUNCOMMITTED) ON DPool.MasterPoolId = MPool.MasterPoolId
		INNER JOIN MMLibrary LIB WITH(READUNCOMMITTED) ON MPool.LibraryId = LIB.LibraryId
		INNER JOIN MMLibraryController LC WITH(READUNCOMMITTED) ON LIB.LibraryId = LC.LibraryId AND DPool.ClientId = LC.ClientId
		INNER JOIN MMHost MA WITH(READUNCOMMITTED) ON DPool.ClientId = MA.ClientId
		LEFT OUTER JOIN MMMountPath MP WITH (READUNCOMMITTED) ON MP.LibraryId = LIB.LibraryId
		LEFT OUTER JOIN MMMountPathToStorageDevice MPSD WITH (READUNCOMMITTED) ON MPSD.MountPathId = MP.MountPathId
		LEFT OUTER JOIN MMDevice D WITH (READUNCOMMITTED) ON D.DeviceId = MPSD.DeviceId
		LEFT OUTER JOIN MMDrive DRV WITH (READUNCOMMITTED) ON MPool.MasterPoolId = DRV.MasterPoolId
		LEFT OUTER JOIN MMMountPathToDistributedStorage MPDS WITH (READUNCOMMITTED) ON MPDS.MountPathId = MP.MountPathId
WHERE 	LIB.LibraryId = ISNULL(@i_libraryId, LIB.LibraryId)
AND (DPath.flag & 1) > 0
		AND (
			@i_storageType = 0
			OR @i_storageType = 3 --Api::StorageType_HYPERSCALE, already filtered in storage -pool table
OR (@i_storageType = 1 AND LIB.LibraryTypeId = 3 AND MP.MountPathTypeId <> 7 AND SP.type <> 4)--Api::StorageType_DISK-- filteroutHyperscalePool
OR (@i_storageType = 2 AND LIB.LibraryTypeId = 3 AND MP.MountPathTypeId = 7)--Api::StorageType_CLOUD
OR (@i_storageType = 4 AND LIB.LibraryTypeId <> 3)--Api::StorageType_TAPE
		)
		AND
		(
			@i_storageSubType = 0
OR (@i_storageSubType = 1 /*App::StorageSubType_IBMi_VTL*/  AND LIB.VTLType = 4)
OR (@i_storageSubType = 2 /*App::StorageSubType_ALL_EXCEPT_IBMi_VTL*/ AND LIB.VTLType <> 4)
OR (@i_storageSubType = 4 /*App::StorageSubType_METALLIC*/ AND D.DisplayDeviceTypeId = 400)
		)
GROUP BY SP.id, LIB.LibraryId
DECLARE @tblOnlineMediaAgent table (mediaAgentId int, libraryId int)
INSERT INTO @tblOnlineMediaAgent
SELECT DISTINCT MH.ClientId, STRG.LibraryId
FROM MMLibrary STRG
	INNER JOIN MMLibraryController LC WITH(READUNCOMMITTED) ON STRG.LibraryId = LC.LibraryId
	INNER JOIN MMMasterPool AS MPool WITH(READUNCOMMITTED) ON MPool.LibraryId = STRG.LibraryId
	INNER JOIN MMDrivePool AS DPool WITH(READUNCOMMITTED) ON DPool.MasterPoolId = MPool.MasterPoolId
	INNER JOIN MMHost AS MH WITH (READUNCOMMITTED) ON MH.ClientId = DPool.ClientId
	LEFT OUTER JOIN MMDrive DRV WITH (READUNCOMMITTED) ON MPool.MasterPoolId = DRV.MasterPoolId
	LEFT OUTER JOIN MMMountPath AS MP WITH (READUNCOMMITTED) ON MP.LibraryId = STRG.LibraryId
	LEFT OUTER JOIN MMMountPathToStorageDevice AS MP2SD WITH (READUNCOMMITTED) ON MP.MountPathId = MP2SD.MountPathId
	LEFT OUTER JOIN MMDevice AS MD WITH (READUNCOMMITTED) ON MP2SD.DeviceId = MD.DeviceId
	LEFT OUTER JOIN MMDeviceController AS DC WITH (READUNCOMMITTED) ON MD.DeviceId = DC.DeviceId
WHERE STRG.LibrarySoftState = 1 AND STRG.LibraryEnabled = 1 AND STRG.LibraryBroken = 0 AND LC.LibraryControllerSoftState = 1 AND LC.LibraryControllerEnabled = 1
	AND MH.MmHostEnabled = 1 AND MH.MmHostSoftState = 1
	AND
	(
(STRG.LibraryTypeId = 3 AND MP.IsEnabled = 1 AND MP.IsOffline = 0 AND MD.DeviceEnabled > 0 AND MD.DeviceBroken = 0 AND DC.DeviceControllerEnabled > 0 AND DC.DeviceAccessible > 0 )
		OR
(STRG.LibraryTypeId <> 3 AND DRV.DriveSoftState = 1 AND DRV.DriveEnabled = 1 AND DRV.DriveBroken = 0)
	)
--For magnetic get numer of controllers
--Set the number of active controllers
--Set the total number of controllers
UPDATE STRG
SET STRG.TotalControllers= ISNULL(TLC.TotalControllers, 0), STRG.OnlineControllers = ISNULL(OLC.OnlineControllers, 0)
FROM #lt_Library STRG
LEFT JOIN
(SELECT COUNT(1) as OnlineControllers, libraryId FROM @tblOnlineMediaAgent OMA GROUP BY libraryId) OLC ON OLC.libraryId=STRG.LibraryId
LEFT JOIN
(SELECT COUNT(1) as TotalControllers, LibraryId FROM MMLibraryController LC WITH (READUNCOMMITTED) GROUP BY LibraryId ) TLC ON TLC.LibraryId=STRG.LibraryId
WHERE STRG.LibraryType = 3
-- For tape get number of drives
UPDATE STRG
SET STRG.TotalControllers= ISNULL(OD.TotalDrives, 0), STRG.OnlineControllers = ISNULL(OD.OnlineDrives, 0)
FROM #lt_Library STRG
inner join
(SELECT COUNT(1) as TotalDrives, sum( case when MD.DriveSoftState = 1 AND MD.DriveEnabled = 1 AND MD.DriveBroken = 0 then 1 else 0 end) as OnlineDrives, MP.libraryId
FROM MMDrive MD WITH (READUNCOMMITTED)
inner join MMMasterpool MP WITH (READUNCOMMITTED) ON MP.MasterPoolId = MD.MasterPoolId
inner join #lt_Library STRG1 ON MP.LibraryId = STRG1.LibraryId AND STRG1.LibraryType <> 3 GROUP BY MP.libraryId, STRG1.StoragePoolId) OD ON OD.libraryId=STRG.LibraryId
AND STRG.LibraryType <> 3
SELECT	SP.id AS StoragePoolId,
		SP.name AS StoragePoolName,
		SP.type AS StoragePoolType,
		SP.SIDBStoreId AS SIDBStoreId,
		SP.clientGroupName AS ClientGroupName,
		STUFF ((SELECT ',' + CONVERT(varchar(20), T.LibraryId) FROM #lt_Library T WHERE T.StoragePoolId = SP.Id FOR XML PATH ('')), 1, 1, '')  AS Libraries,
		MAX(LIB.LibraryType) AS LibraryType,
		COUNT(DISTINCT LC.ClientId) AS NumOfMediaAgents,
		SUM(DISTINCT LIB.TotalControllers) AS TotalControllers,
		SUM(DISTINCT LIB.OnlineControllers) AS OnlineControllers,
		MAX(LIB.LibOfflineReason) AS LibraryOfflineReason,
		MAX(LIB.MPOfflineReason) AS MountPathOfflineReason,
		MAX(LIB.MAOfflineReason) AS MediaAgentOfflineReason,
		MAX(LIB.MountPathType) AS MountPathType,
		SP.status AS StatusCode,
		MAX(LIB.DeviceTypeId) AS DeviceTypeId,
		MAX(LIB.LibrarySubType) AS LibrarySubType
FROM	#lt_StoragePool SP
		INNER JOIN #lt_Library LIB ON SP.id = LIB.StoragePoolId
		INNER JOIN MMLibraryController LC WITH(READUNCOMMITTED) ON LIB.LibraryId = LC.LibraryId
GROUP BY SP.id, SP.name, SP.type, SP.SIDBStoreId, SP.clientGroupName,SP.status
ORDER BY SP.name
IF OBJECT_ID('tempdb..#lt_Library') IS NOT NULL DROP TABLE #lt_Library
IF OBJECT_ID('tempdb..#lt_StoragePool') IS NOT NULL DROP TABLE #lt_StoragePool
GO

IF EXISTS (select * from GxQscripts where name = 'MMGetStoragePools')
	delete from GxQscripts where name = 'MMGetStoragePools'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetStoragePools')
	delete from GXDBVersions where aliasname = 'MMGetStoragePools'
GO

insert into GXDBVersions values(2, 'MMGetStoragePools',  '00010001000200230000', 'MMGetStoragePools', '00010001000200230000')
GO

