

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMGetStoragePoolSpaceInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMGetStoragePoolSpaceInfo.sp,v $ $Id: MMGetStoragePoolSpaceInfo.sp,v 1.1.4.9 2020/11/06 21:51:05 pnara Exp $";
-- =============================================
-- Author       :       Leny
-- Create date  :       20-July-2017
-- Description  :	Will fetch the space info for a storage pool
-- =============================================
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='MMGetStoragePoolSpaceInfo')
BEGIN
	print '>>> Drop Stored Procedure: MMGetStoragePoolSpaceInfo <<<'
	drop procedure MMGetStoragePoolSpaceInfo
END
IF EXISTS (select * from GxQscripts where name='MMGetStoragePoolSpaceInfo')
	delete from GxQscripts where name = 'MMGetStoragePoolSpaceInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetStoragePoolSpaceInfo')
	delete from GXDBVersions where aliasname = 'MMGetStoragePoolSpaceInfo'
GO
print '... Creating Procedure: MMGetStoragePoolSpaceInfo'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure MMGetStoragePoolSpaceInfo
  @i_storagePoolId integer,
  @i_getSizeOnDisk integer = 0
AS
  DECLARE @o_capacity BIGINT
  DECLARE @o_freeSpace BIGINT
  DECLARE @o_sizeOnDisk BIGINT
SET @o_sizeOnDisk = 0
IF object_id('tempdb.dbo.#tmpLib') IS NOT NULL DROP TABLE #tmpLib
CREATE TABLE #tmpLib
(
	libraryId	INT
        PRIMARY KEY (libraryId)
)
INSERT INTO #tmpLib
        SELECT  DISTINCT ML.LibraryId
        FROM    MMLibrary ML WITH (READUNCOMMITTED)
                INNER JOIN MMMasterPool MP WITH (READUNCOMMITTED) ON ML.LibraryId = MP.LibraryId
                INNER JOIN MMDrivePool DRP WITH (READUNCOMMITTED) ON DRP.MasterPoolId = MP.MasterPoolId
                INNER JOIN MMDataPath DAP WITH (READUNCOMMITTED) ON DAP.DrivePoolId = DRP.DrivePoolId
                INNER JOIN archGroup AG WITH (READUNCOMMITTED) ON DAP.CopyId = AG.defaultCopy
        WHERE   AG.id = @i_storagePoolId
AND ML.LibraryTypeId = 3
SELECT  @o_capacity  = CAST( SUM(CASE WHEN (MP.MountPathTypeId = 7 AND MS.TotalSpaceMB = 1048576) THEN -1 ELSE MS.TotalSpaceMB  END) AS BIGINT)  ,
@o_freeSpace = CAST( SUM(CASE WHEN (MP.MountPathTypeId = 7 AND MS.FreeBytesMB = 1048576) THEN -1 ELSE MS.FreeBytesMB END) AS BIGINT)
        FROM    MMMediaSide MS WITH (READUNCOMMITTED)
        INNER JOIN MMMountPath MP WITH (READUNCOMMITTED) ON MS.MediaSideId = MP.mediaSideId
		INNER JOIN #tmpLib TL ON MP.LibraryId = TL.libraryId
IF @i_getSizeOnDisk > 0
BEGIN
	SELECT 	@o_sizeOnDisk = ISNULL(SUM(M.UsedSpaceInBytes), 0)
	FROM	#tmpLib L,
			MMMountPath MP WITH(READUNCOMMITTED),
			MMMetallicStorage M WITH(READUNCOMMITTED)
	WHERE	L.LibraryId = MP.LibraryId
			AND MP.MountPathId = M.MountPathId
	IF @o_sizeOnDisk = 0
	BEGIN
		SELECT 	@o_sizeOnDisk = ISNULL(SUM(CAST(PhysicalBytesMB AS BIGINT)),0)*1024*1024
		FROM  	MMVolume MV WITH (READUNCOMMITTED)
				INNER JOIN MMMedia  MM  WITH (READUNCOMMITTED) ON MM.mediaId = MV.mediaId
				INNER JOIN #tmpLib  TL ON MM.libraryId = TL.libraryId
		WHERE SiloStatus <> 3
	END
END
IF object_id('tempdb.dbo.#tmpLib') IS NOT NULL DROP TABLE #tmpLib
IF object_id('tempdb.dbo.#tmpMedia') IS NOT NULL DROP TABLE #tmpMedia
SELECT ISNULL(@o_capacity, 0), ISNULL(@o_freeSpace, 0) ,(@o_sizeOnDisk)

IF EXISTS (select * from GxQscripts where name = 'MMGetStoragePoolSpaceInfo')
	delete from GxQscripts where name = 'MMGetStoragePoolSpaceInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetStoragePoolSpaceInfo')
	delete from GXDBVersions where aliasname = 'MMGetStoragePoolSpaceInfo'
GO

insert into GXDBVersions values(2, 'MMGetStoragePoolSpaceInfo',  '00010001000400090000', 'MMGetStoragePoolSpaceInfo', '00010001000400090000')
GO

