

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMGetStoragePoolList.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2011  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMGetStoragePoolList.sp,v $ $Id: MMGetStoragePoolList.sp,v 1.1.2.5 2018/03/19 23:56:51 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMGetStoragePoolList <<<'

IF EXISTS (select * from sysobjects where name='MMGetStoragePoolList')
	drop procedure MMGetStoragePoolList
IF EXISTS (select * from GxQscripts where name='MMGetStoragePoolList')
	delete from GxQscripts where name = 'MMGetStoragePoolList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetStoragePoolList')
	delete from GXDBVersions where aliasname = 'MMGetStoragePoolList'
GO
print '... Creating Procedure: MMGetStoragePoolList'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMGetStoragePoolList
  @i_userId integer = 0
AS
-- Following are the "columns" returned, in the order in which they are returned
  DECLARE @o_StoragePoolId integer
  DECLARE @o_StoragePoolName nvarchar(512)
  DECLARE @o_LibraryId integer
  DECLARE @o_DeviceId integer
  DECLARE @o_DevicePath varchar(1024)
  DECLARE @o_ActiveControllers integer
  DECLARE @o_TotalControllers integer
  DECLARE @o_LibOfflineReason integer
  DECLARE @o_MPOfflineReason integer
  DECLARE @o_MAOfflineReason integer
--Link between APP_AdvanceSettings and APP_ClientGroup
DECLARE @tblStoragePool TABLE (id INT, name nvarchar(512), libraryId INT, deviceId INT, devicePath varchar(1024), numOfControllersOnline INT, totalNumOfControllers INT, libOfflineReason INT, mpOfflineReason INT, maOfflineReason INT)
INSERT INTO @tblStoragePool
select CG.id, CG.Name, 0, 0, '', 0, 0, 0, 0, 0 from APP_ClientGroup CG WITH (READUNCOMMITTED)
INNER JOIN APP_AdvanceSettings ADV WITH (READUNCOMMITTED) ON ADV.entityType = 28 AND ADV.entityId = CG.Id AND ADV.enabled=1
WHERE ADV.keyName= 'StoragePool' AND ADV.relativePath='CommServDB.MediaAgent' AND cast (ADV.value as nvarchar) = 'true'
--Get the device id from MMEntityProp based on the client group id
--Get the library id from the device id
UPDATE STRG SET STRG.libraryId = MP.LibraryId, STRG.deviceId = EP.EntityId, STRG.devicePath = (SELECT TOP 1 Folder FROM MMDeviceController WITH (READUNCOMMITTED) WHERE DeviceId = EP.EntityId)
FROM @tblStoragePool STRG
	INNER JOIN MMEntityProp EP WITH (READUNCOMMITTED) ON STRG.id=EP.intVal
	INNER JOIN MMMountPathToStorageDevice MSD WITH (READUNCOMMITTED) ON MSD.DeviceId=EP.EntityId
	INNER JOIN MMMountPath MP WITH (READUNCOMMITTED) ON MP.MountPathId = MSD.MountPathId
WHERE EP.propertyName = 'DeviceClientGroup'
AND EP.EntityType = 8
DECLARE @tblOnlineMediaAgent table (mediaAgentId int, libraryId int)
INSERT INTO @tblOnlineMediaAgent
SELECT DISTINCT MH.ClientId, ML.LibraryId
FROM MMLibrary ML WITH (READUNCOMMITTED)
	INNER JOIN @tblStoragePool STRG ON ML.LibraryId = STRG.LibraryId
	INNER JOIN MMMountPath AS MP WITH (READUNCOMMITTED) ON MP.LibraryId = ML.LibraryId
	INNER JOIN MMMountPathToStorageDevice AS MP2SD WITH (READUNCOMMITTED) ON MP.MountPathId = MP2SD.MountPathId
	INNER JOIN MMDevice AS MD WITH (READUNCOMMITTED) ON MP2SD.DeviceId = MD.DeviceId
	INNER JOIN MMDeviceController AS DC WITH (READUNCOMMITTED) ON MD.DeviceId = DC.DeviceId
	INNER JOIN MMHost AS MH WITH (READUNCOMMITTED) ON MH.ClientId = DC.ClientId
WHERE ML.LibrarySoftState > 0 AND ML.LibraryEnabled > 0 AND ML.LibraryBroken = 0
	AND MD.DeviceEnabled > 0 AND MD.DeviceBroken = 0
	AND DC.DeviceControllerEnabled > 0 AND DC.DeviceAccessible > 0
	AND MP.IsEnabled > 0 AND MP.IsOffline = 0
AND ML.LibraryTypeId = 3
	AND MH.MmHostEnabled = 1 AND MH.MmHostSoftState = 1 AND MH.OfflineReason = 0
--Set the number of active controllers
--Set the total number of controllers
UPDATE STRG
SET STRG.numOfControllersOnline = ISNULL(OLC.OnlineControllers, 0), STRG.totalNumOfControllers= ISNULL(TLC.TotalControllers, 0)
FROM @tblStoragePool STRG
LEFT JOIN
(SELECT COUNT(*) as OnlineControllers, libraryId FROM @tblOnlineMediaAgent OMA GROUP BY libraryId) OLC ON OLC.libraryId=STRG.libraryId
LEFT JOIN
(SELECT COUNT(*) as TotalControllers, LibraryId FROM MMLibraryController LC GROUP BY LibraryId ) TLC ON TLC.LibraryId=STRG.libraryId
--Set the offline reason if there are no active controllers
--From MMMountPath
UPDATE STRG
SET STRG.libOfflineReason = (CASE
								WHEN (ML.LibrarySoftState <= 0 OR ML.LibraryEnabled <= 0 OR ML.LibraryBroken <> 0 OR LC.LibraryControllerSoftState <= 0 OR LC.LibraryControllerEnabled <= 0) THEN ML.LibraryStatusReason
								ELSE 0
							END),
	STRG.mpOfflineReason =  (CASE
								WHEN (MP.IsEnabled <= 0 OR MP.IsOffline <> 0) THEN MP.OfflineReason
								ELSE 0
							END),
	STRG.maOfflineReason =  (CASE
								WHEN (MH.MmHostEnabled <= 0 OR MH.MmHostSoftState <= 0) THEN MH.OfflineReason
								ELSE 0
							END)
FROM @tblStoragePool STRG
INNER JOIN MMLibrary AS ML WITH (READUNCOMMITTED) ON ML.LibraryId = STRG.LibraryId
INNER JOIN MMLibraryController AS LC WITH (READUNCOMMITTED) ON LC.LibraryId = ML.LibraryId
INNER JOIN MMMountPath AS MP WITH (READUNCOMMITTED) ON MP.LibraryId = STRG.LibraryId
INNER JOIN MMMountPathToStorageDevice AS MP2SD WITH (READUNCOMMITTED) ON MP.MountPathId = MP2SD.MountPathId
INNER JOIN MMDevice AS MD WITH (READUNCOMMITTED) ON MP2SD.DeviceId = MD.DeviceId
INNER JOIN MMDeviceController AS DC WITH (READUNCOMMITTED) ON MD.DeviceId = DC.DeviceId
INNER JOIN MMHost AS MH WITH (READUNCOMMITTED) ON MH.ClientId = DC.ClientId
WHERE STRG.numOfControllersOnline = 0
SELECT id, name, libraryId, deviceId, devicePath, numOfControllersOnline, totalNumOfControllers, libOfflineReason, mpOfflineReason, maOfflineReason FROM @tblStoragePool
GO

IF EXISTS (select * from GxQscripts where name = 'MMGetStoragePoolList')
	delete from GxQscripts where name = 'MMGetStoragePoolList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetStoragePoolList')
	delete from GXDBVersions where aliasname = 'MMGetStoragePoolList'
GO

insert into GXDBVersions values(2, 'MMGetStoragePoolList',  '00010001000200050000', 'MMGetStoragePoolList', '00010001000200050000')
GO

