

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMGetStoragePoolDetails.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2011  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMGetStoragePoolDetails.sp,v $ $Id: MMGetStoragePoolDetails.sp,v 1.1.2.17 2020/12/17 01:27:08 aselvanayagam Exp $";
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='MMGetStoragePoolDetails')
BEGIN
	print '>>> Drop Stored Procedure: MMGetStoragePoolDetails <<<'
	drop procedure MMGetStoragePoolDetails
END
IF EXISTS (select * from GxQscripts where name='MMGetStoragePoolDetails')
	delete from GxQscripts where name = 'MMGetStoragePoolDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetStoragePoolDetails')
	delete from GXDBVersions where aliasname = 'MMGetStoragePoolDetails'
GO
print '... Creating Procedure: MMGetStoragePoolDetails'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure MMGetStoragePoolDetails
  @i_localeId INT,
  @i_StoragePoolName nvarchar(512)
AS
-- Following are the "columns" returned, in the order in which they are returned
  DECLARE @o_MediaAgentId integer
  DECLARE @o_MediaAgentName nvarchar(255)
  DECLARE @o_DevicePathOnNode varchar(1024)
  DECLARE @o_Capacity bigint
  DECLARE @o_FreeSpace bigint
  DECLARE @o_IsDDB integer
  DECLARE @o_DDBStoreList varchar(255)
  DECLARE @o_Status integer
  DECLARE @o_LibOfflineReason integer
  DECLARE @o_MPOfflineReason integer
  DECLARE @o_MAOfflineReason integer
  DECLARE @o_MAConfiguredInStoragePool integer
  DECLARE @o_SharedDevicePath varchar(1024)
  DECLARE @o_LibraryId integer
  DECLARE @o_MountPathId integer
  DECLARE @o_DisperseFactor integer
  DECLARE @o_RedundancyFactor integer
  DECLARE @o_ReplicationFactor integer
  DECLARE @o_TotalControllers integer
  DECLARE @o_OnlineControllers integer
  DECLARE @o_RetentionDays integer
  DECLARE @o_RetentionCycles integer
  DECLARE @o_nodesPerBlock integer
  DECLARE @o_statusCode integer
  DECLARE @o_blockNum integer
  DECLARE @o_MAHostName nvarchar(255)
  DECLARE @o_DeviceId integer
  DECLARE @o_MAAttribute integer
DECLARE	@libraryId int = 0
DECLARE @replicationFactor int = 0
DECLARE @spCopyUsingGlobalDDB int = 0
DECLARE @retentionDays int = 0
DECLARE @retentionCycles int = 0
IF OBJECT_ID ('temp.dbo.#archGroupForLibraryId') IS NOT NULL
	DROP TABLE #archGroupForLibraryId
CREATE TABLE #archGroupForLibraryId (archGroupId integer, archGroupName NVARCHAR(255), archCopyId integer,  archCopyName NVARCHAR(255) ,globalPolicyName NVARCHAR(MAX))
IF OBJECT_ID ('temp.dbo.#DDBStoreForMAWithCopyInformation') IS NOT NULL
	DROP TABLE #DDBStoreForMAWithCopyInformation
CREATE TABLE #DDBStoreForMAWithCopyInformation (ddbStoreId integer, clientId integer, archCopyId integer, useGlobalDDB integer)
IF OBJECT_ID ('temp.dbo.#tblStoragePoolDetails') IS NOT NULL
	DROP TABLE #tblStoragePoolDetails
CREATE TABLE #tblStoragePoolDetails
	(mediaAgentId int,
mediaAgentName nvarchar(255),
deviceNodePath varchar(1024),
	diskCapacity bigint,
	diskFreeSpace bigint,
	isDDB int,
ddbStoreList varchar(255),
	status int,
	libOfflineReason INT,
	mpOfflineReason INT,
	maOfflineReason INT,
	hostConfiguredInStoragePool INT,
sharedDevicePath varchar(1024),
	libraryId INT ,
	mountPathId INT,
	disperseFactor INT,
	redundancyFactor INT,
	nodesPerBlock INT,
	blockNum INT,
	storagepoolStatus INT,
maHostName nvarchar(255),
	deviceId INT,
	maAttribute INT)
SELECT @libraryId = LibraryId
FROM MMSDSStoragePool
WHERE StoragePoolName = @i_StoragePoolName
INSERT INTO #archGroupForLibraryId
exec MMS2getArchGrpNCopyListByLibId @libraryId
INSERT INTO #DDBStoreForMAWithCopyInformation
SELECT DISTINCT CS.SIDBStoreId, ISS.ClientId, AGC.id,
(CASE WHEN (AGC.dedupeFlags & 134217728 > 0) THEN 1 ELSE 0 END)
FROM archGroupCopy AGC  WITH (READUNCOMMITTED)
	INNER JOIN #archGroupForLibraryId AGL ON AGC.id = AGL.archCopyId
	INNER JOIN archCopySIDBStore CS WITH (READUNCOMMITTED) ON AGC.id = CS.copyId
	INNER JOIN IdxSIDBSubStore ISS  WITH (READUNCOMMITTED) ON ISS.SIDBStoreId = AGC.SIDBStoreId
	INNER JOIN IdxSIDBStore S  WITH (READUNCOMMITTED) ON S.SIDBStoreId = CS.SIDBStoreId
WHERE CS.SIDBStoreId <> 0 AND S.SealedTime = 0
INSERT INTO #tblStoragePoolDetails
SELECT CL.id as mediaAgentId,
	CL.name as mediaAgentName,
	DHW.deviceOSPath as deviceNodePath,
	DHW.diskCapacityMB*1024*1024 AS diskCapacity,
	DHW.freeSpaceMB*1024*1024 AS diskFreeSpace,
	CASE WHEN (ISS.ClientId IS NULL) THEN 0 ELSE 1 END AS isDDB,
	'' AS [ddbStoreList],
	(CASE --This is to get the status
		WHEN (ML.LibrarySoftState <= 0 OR ML.LibraryEnabled <= 0 OR ML.LibraryBroken <> 0 OR LC.LibraryControllerSoftState <= 0 OR LC.LibraryControllerEnabled <= 0) THEN 0
		WHEN (MP.IsEnabled <= 0 OR MP.IsOffline <> 0) THEN 0
		WHEN (MH.MmHostEnabled <= 0 OR MH.MmHostSoftState <= 0) THEN 0
		ELSE 1
	 END) AS [status],
	(CASE --This is to get the library offline reason
		WHEN (ML.LibrarySoftState <= 0 OR ML.LibraryEnabled <= 0 OR ML.LibraryBroken <> 0 OR LC.LibraryControllerSoftState <= 0 OR LC.LibraryControllerEnabled <= 0) THEN ML.LibraryStatusReason
		ELSE 0
	 END) AS libOfflineReason,
	(CASE --This is to get the mountpath offline reason
		WHEN (MP.IsEnabled <= 0 OR MP.IsOffline <> 0) THEN MP.OfflineReason
		ELSE 0
	 END) AS mpOfflineReason,
	 (CASE --This is to get the mediaagent offline reason
		WHEN (MH.MmHostEnabled <= 0 OR MH.MmHostSoftState <= 0) THEN MH.OfflineReason
		ELSE 0
	 END) AS maOfflineReason,
	 (CASE --This is to check if this host is configured in the storage pool
		WHEN (DHW.flags & 1) > 0 THEN 1
		ELSE 0
	 END) AS hostConfigureInStoragePool,
	 MDC.Folder AS sharedDevicePath,
	 ML.LibraryId AS libraryId,
	 MP.MountPathId AS mountPathId,
	 SDS.DisperseFactor AS disperseFactor,
	 SDS.RedundancyFactor AS redundancyFactor,
	 SDS.NodesPerBlock AS nodesPerBlock,
	 DHW.blockNumber AS blockNum,
	 SDS.StoragePoolStatus AS storagePoolStatus,
	 CL.net_hostname AS maHostName,
	 DEV.deviceId as deviceId,
	 MH.Attribute
FROM
	MMDiskHWInfo DHW WITH (READUNCOMMITTED)
	INNER JOIN APP_Client CL WITH (READUNCOMMITTED) ON DHW.hostId = CL.id
	INNER JOIN MMDevice DEV WITH (READUNCOMMITTED) ON DEV.DeviceId = DHW.deviceId
	INNER JOIN MMDeviceController MDC WITH (READUNCOMMITTED) ON DEV.DeviceId = MDC.DeviceId
	INNER JOIN MMMountPathToStorageDevice MSD WITH (READUNCOMMITTED) ON DEV.DeviceId = MSD.DeviceId
	INNER JOIN MMMountPath MP WITH (READUNCOMMITTED) ON MP.MountPathId = MSD.MountPathId
	INNER JOIN MMLibrary ML WITH (READUNCOMMITTED) ON ML.LibraryId = MP.LibraryId
	INNER JOIN MMLibraryController LC WITH (READUNCOMMITTED) ON ML.LibraryId = LC.LibraryId
	INNER JOIN MMHost MH WITH (READUNCOMMITTED) ON MH.ClientId = CL.id
	INNER JOIN MMSDSStoragePool SDS WITH (READUNCOMMITTED) ON SDS.LibraryId = ML.LibraryId
	LEFT JOIN IdxSIDBSubStore ISS WITH (READUNCOMMITTED) ON CL.id = ISS.ClientId
WHERE
	SDS.StoragePoolName = @i_StoragePoolName
AND DHW.mountPathUsageType = 2
AND MDC.DeviceAccessType & (6 | 8) = (6 | 8)
GROUP BY CL.id,
	CL.name,
	DHW.deviceOSPath,
	DHW.freeSpaceMB,
	DHW.diskCapacityMB,
	MDC.Folder,
	ML.LibraryId,
	MP.MountPathId,
	DHW.blockNumber,
	CL.net_hostname,
	ISS.ClientId,
	ML.LibrarySoftState,
	ML.LibraryEnabled,
	ML.LibraryBroken,
	LC.LibraryControllerSoftState,
	LC.LibraryControllerEnabled,
	MP.IsEnabled,
	MP.IsOffline,
	MH.MmHostEnabled,
	MH.MmHostSoftState,
	ML.LibraryStatusReason,
	MP.OfflineReason,
	MH.OfflineReason,
	DHW.flags,
	SDS.DisperseFactor,
	SDS.RedundancyFactor,
	SDS.NodesPerBlock,
	SDS.StoragePoolStatus,
	DEV.deviceId,
	MDC.DeviceAccessType,
	MH.Attribute
--Update Substore Id
UPDATE SPD SET SPD.ddbStoreList =
ISNULL( (SELECT DISTINCT CONVERT(VARCHAR(20), ddbStoreId) + ','
        FROM #DDBStoreForMAWithCopyInformation DMA
        WHERE DMA.clientId = SPD.mediaAgentId
        FOR XML PATH('')), '' )
FROM #tblStoragePoolDetails SPD
UPDATE #tblStoragePoolDetails
SET ddbStoreList = (CASE WHEN LEN(ddbStoreList) > 0 THEN SUBSTRING(ddbStoreList, 1, LEN(ddbStoreList)-1) ELSE ddbStoreList END)
DECLARE	@totalControllers int
DECLARE	@onlineControllers int
SELECT @totalControllers = COUNT(DISTINCT mediaAgentId) FROM #tblStoragePoolDetails
SELECT @onlineControllers = COUNT(DISTINCT mediaAgentId)
FROM #tblStoragePoolDetails
WHERE status = 1
IF @replicationFactor IS NULL
BEGIN
SELECT @replicationFactor = ISNULL(value, 0)
    FROM MMConfigs WITH (READUNCOMMITTED) WHERE name = 'MMCONFIG_WEBSCALE_STORAGE_REPLICATION_FACTOR'
END
--Get retention
SET @spCopyUsingGlobalDDB = (SELECT TOP 1 archCopyId FROM #DDBStoreForMAWithCopyInformation WHERE useGlobalDDB = 1)
IF @spCopyUsingGlobalDDB IS NOT NULL
BEGIN
SELECT @retentionDays = retentionDays, @retentionCycles = fullCycles FROM archAgingRule WITH (READUNCOMMITTED) where copyId = @spCopyUsingGlobalDDB
END
SELECT mediaAgentId, mediaAgentName, deviceNodePath, diskCapacity, diskFreeSpace,
	   isDDB, ddbStoreList, status, libOfflineReason, mpOfflineReason, maOfflineReason, hostConfiguredInStoragePool,
	   sharedDevicePath, libraryId, mountpathId, disperseFactor, redundancyFactor, @replicationFactor as replicationFactor,
	   @totalControllers as totalControllers, @onlineControllers as onlineControllers, @retentionDays as retentionDays, @retentionCycles as retentionCycles,
	   nodesPerBlock, storagepoolStatus, blockNum, maHostName, deviceId, maAttribute
FROM #tblStoragePoolDetails
GO

IF EXISTS (select * from GxQscripts where name = 'MMGetStoragePoolDetails')
	delete from GxQscripts where name = 'MMGetStoragePoolDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetStoragePoolDetails')
	delete from GXDBVersions where aliasname = 'MMGetStoragePoolDetails'
GO

insert into GXDBVersions values(2, 'MMGetStoragePoolDetails',  '00010001000200170000', 'MMGetStoragePoolDetails', '00010001000200170000')
GO

