

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMGetStoragePolicyCopyDetails.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2008  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMGetStoragePolicyCopyDetails.sp,v $ $Id: MMGetStoragePolicyCopyDetails.sp,v 1.1.4.11 2020/12/19 05:10:22 kjaiswal Exp $";
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='MMGetStoragePolicyCopyDetails')
BEGIN
	print '>>> Drop Stored Procedure: MMGetStoragePolicyCopyDetails <<<'
	drop procedure MMGetStoragePolicyCopyDetails
END
IF EXISTS (select * from GxQscripts where name='MMGetStoragePolicyCopyDetails')
	delete from GxQscripts where name = 'MMGetStoragePolicyCopyDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetStoragePolicyCopyDetails')
	delete from GXDBVersions where aliasname = 'MMGetStoragePolicyCopyDetails'
GO
print '... Creating Procedure: MMGetStoragePolicyCopyDetails'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure MMGetStoragePolicyCopyDetails
  @i_xmlString XML
AS
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
  DECLARE @o_xml XML
-- XML Input Parameters
DECLARE @userId					INTEGER = 0
DECLARE @storagePolicyId		INTEGER = 0
DECLARE @storagePolicyCopyId	INTEGER = 0
DECLARE @propertyLevel			INTEGER = 1
DECLARE @errorCode      		INTEGER = 0
DECLARE @errorString    		NVARCHAR(1024) = N''
DECLARE @associationsXML XML
BEGIN TRY
-- Get the input parameters from the XML input str
SELECT 	@userId = ISNULL(ref.value('(processinginstructioninfo/user/@userId)[1]', 'int'), 0),
		@storagePolicyCopyId = ISNULL(ref.value('(storagePolicyCopy/@copyId)[1]', 'int'), 0),
		@storagePolicyId = ISNULL(ref.value('(storagePolicyCopy/@storagePolicyId)[1]', 'int'), 0),
		@propertyLevel = ISNULL(ref.value('@propertyLevel', 'int'), 0)
FROM 	@i_xmlString.nodes('App_GetStoragePolicyCopyReq') R(ref)
if object_id('tempdb.dbo.#tempAssocOutput') is not null DROP TABLE #tempAssocOutput
CREATE TABLE #tempAssocOutput (clientGroupID  integer, clientGroupName nvarchar(255), clientId  integer, clientName nvarchar(255), appTypeId  integer, appTypename nvarchar(255), Instanceid  integer, instanceName		nvarchar(255), backupsetId integer, backupSetName		nvarchar(255), subclientId integer, subclientName		nvarchar(255), include 	integer, exclude 	integer, entityType integer, isHidden integer)
IF @propertyLevel = 5 /*App::ListPropertyLevels_EssententialProperties*/
BEGIN
	SET @o_xml =
	(
		SELECT	AGC.id AS 'StoragePolicyCopy/@copyId',
				AGC.name AS 'StoragePolicyCopy/@copyName',
				AG.id AS 'StoragePolicyCopy/@storagePolicyId',
				AG.name AS 'StoragePolicyCopy/@storagePolicyName',
				/*flags*/
(case AGC.flags & 1048576 when 0 then 0 else 1 end) AS 'copyFlags/@preserveEncryptionModeAsInSource',
(case AGC.flags & 8388608 when 0 then 0 else 1 end) AS 'copyFlags/@auxCopyReencryptData',
(case AGC.flags & 2097152 when 0 then 0 else 1 end) AS 'copyFlags/@storePlainText',
(case AGC.flags & 4194304 when 0 then 0 else 1 end) AS 'copyFlags/@encryptOnNetworkUsingSelectedCipher',
(case AGC.flags & 131072 when 0 then 0 else 1 end) AS 'copyFlags/@storeKeyOnMedia',
				/*extendedFlags*/
(case AGC.extendedFlags & 262144 when 0 then 0 else 1 end) AS 'extendedFlags/@encryptOnDependentPrimary',
				/*dataEncryption*/
				AGC.encType AS 'dataEncryption/@encryptionType',
				AGC.encKeyLen AS 'dataEncryption/@encryptionKeyLength',
				ISNULL(KP.keyProviderId, 0) AS 'dataEncryption/keyProvider/@keyProviderId',
				ISNULL(KP.keyProviderName, N'') AS 'dataEncryption/keyProvider/@keyProviderName'
		FROM	ArchGroupCopy AGC WITH(READUNCOMMITTED)
				INNER JOIN ArchGroup AG WITH(READUNCOMMITTED) ON AG.id = AGC.archGroupId
				LEFT OUTER JOIN ArchCopyEncProperties EP WITH(READUNCOMMITTED) ON AGC.id = EP.copyId
				LEFT OUTER JOIN ArchEncKeyProvider KP WITH(READUNCOMMITTED) ON EP.keyProviderId = KP.keyProviderId
		WHERE 	AGC.id = @storagePolicyCopyId
		FOR XML PATH ('copy'), ROOT('App_GetStoragePolicyCopyResp'), TYPE
	)
END
ELSE
BEGIN
	IF OBJECT_ID('tempdb.dbo.#tmpStoragePolicyCopyInfo') IS NOT NULL DROP TABLE #tmpStoragePolicyCopyInfo
	CREATE TABLE  #tmpStoragePolicyCopyInfo (
					spId 						integer,
					spName						nvarchar(255),
					copyId						integer,
					copyName					nvarchar(255),
					copyPrecedence					integer,
					type						integer,
					copyFlags					integer,
					isDefaultCopy					integer,
					isActive					integer,
					isMirrorCopy					integer,
					isSnapCopy					integer,
					throttleNWBandwidth				integer,
					maId						integer,
					maName						nvarchar(510),
					startTime					integer,
					libraryId					integer,
					libraryName					nvarchar(255),
					storagePoolId					integer,
					storagePoolName					nvarchar(288),
					drivePoolId					integer,
					drivePoolName					nvarchar(128),
					spareGroupId					integer,
					spareGroupName					nvarchar(384),
					sourceCopyId 					integer,
					sourceCopyName					nvarchar(255))
	INSERT INTO	#tmpStoragePolicyCopyInfo
	SELECT 	AG.id, AG.name, AGC.id, AGC.name, AGC.copy, AGC.type, AGC.flags,
			(CASE WHEN AG.defaultCopy = AGC.id THEN 1 ELSE 0 END),
			AGC.isActive, AGC.isMirrorCopy, AGC.isSnapCopy, AGC.NWWriteSpeed,
			ISNULL(DP.HostClientId, 0), ISNULL(C.name, ''),
			(CASE WHEN AGC.startTime < 0 THEN -1 ELSE AGC.startTime END),
			ISNULL(LIB.LibraryId, 0), ISNULL(LIB.AliasName, ''),
			ISNULL(SPOOL.id, 0), ISNULL(SPOOL.name, ''),
			ISNULL(DPool.DrivePoolId, 0), ISNULL(DPool.DrivePoolName, ''), ISNULL(SG.SpareGroupId, 0), ISNULL(SG.SpareGroupName, ''),
			SCOPY.id, (CASE WHEN SCOPY.id = 0 THEN '' ELSE SCOPY.name END)
	FROM 	archGroupCopy AGC WITH(READUNCOMMITTED)
			INNER JOIN 	archGroup AG WITH(READUNCOMMITTED) ON AG.id = AGC.archGroupId
			INNER JOIN 	archGroupCopy SCOPY WITH(READUNCOMMITTED) ON SCOPY.id = AGC.sourceCopyId
			LEFT JOIN 	MMDataPath DP WITH(READUNCOMMITTED) ON AGC.id = DP.CopyId AND (DP.Flag & 1 > 0)
			LEFT JOIN 	MMDrivePool DPool WITH(READUNCOMMITTED) ON DP.DrivePoolId = DPool.DrivePoolId
			LEFT JOIN 	MMMasterPool MPool WITH(READUNCOMMITTED) ON DPool.MasterPoolId = MPool.MasterPoolId
			LEFT JOIN 	MMLibrary LIB WITH(READUNCOMMITTED) ON MPool.LibraryId = LIB.LibraryId
			LEFT JOIN 	MMSpareGroup SG WITH(READUNCOMMITTED) ON (DP.SpareGroupId <> 0 AND SG.SpareGroupId = DP.SpareGroupId)
OR (DP.SpareGroupId = 0 AND SG.LibraryId = LIB.LibraryId AND SG.SpareGroupName = 'Default Scratch')
			LEFT JOIN 	APP_Client C WITH(READUNCOMMITTED) ON DP.hostClientId = C.id
			--Following to fetch StoragePool name
			LEFT JOIN archCopyToGlobalPolicy GP WITH (READUNCOMMITTED) ON AGC.id = GP.copyId --this table is populated for GDSP and GSP dependent copies
			LEFT JOIN archGroup SPOOL WITH (READUNCOMMITTED) ON GP.globalPolicyId = SPOOL.id
	WHERE AGC.id = @storagePolicyCopyId
	IF OBJECT_ID('tempdb.dbo.#tmpStoragePolicyCopyAndFlags') IS NOT NULL DROP TABLE #tmpStoragePolicyCopyAndFlags
	CREATE TABLE  #tmpStoragePolicyCopyAndFlags (
					copyId 							integer,
					copyFlags						XML,
					extendedFlags					XML,
					dedupeFlags						XML)
	INSERT INTO #tmpStoragePolicyCopyAndFlags
	SELECT id,
		(SELECT
(CASE WHEN flags&2 > 0 THEN (SELECT 1 FOR XML PATH ('multiplexSourceStreams'), TYPE) END),
(CASE WHEN flags&4 > 0 THEN (SELECT 1  FOR XML PATH ('combineStreams'), TYPE) END),
(CASE WHEN flags&8 > 0 THEN (SELECT 1 FOR XML PATH ('switchIfOffline'), TYPE) END),
(CASE WHEN flags&16 > 0 THEN (SELECT 1 FOR XML PATH ('switchIfBusy'), TYPE) END),
(CASE WHEN flags&32 > 0 THEN (SELECT 1 FOR XML PATH ('demultiplexOnCopy'), TYPE) END),
(CASE WHEN flags&64 > 0 THEN (SELECT 1 FOR XML PATH ('markMediaToBeErasedAfterRecycling'), TYPE) END),
(CASE WHEN flags&(128 + 256) > 0 THEN (SELECT 1 FOR XML PATH ('archiveCheckBitmap'), TYPE) END),
(CASE WHEN flags&512 > 0 THEN (SELECT 1 FOR XML PATH ('roundRobbinDataPath'), TYPE) END),
(CASE WHEN flags&1024 > 0 THEN (SELECT 1 FOR XML PATH ('inlineAuxCopy'), TYPE) END),
(CASE WHEN flags&2048 > 0 THEN (SELECT 1 FOR XML PATH ('enableParallelCopy'), TYPE) END),
(CASE WHEN flags&4096 > 0 THEN (SELECT 1 FOR XML PATH ('lastFull'), TYPE) END),
(CASE WHEN flags&8192 > 0 THEN (SELECT 1 FOR XML PATH ('lastFullWait'), TYPE) END),
(CASE WHEN flags&16384 > 0 THEN (SELECT 1 FOR XML PATH ('autoAddDataPaths'), TYPE) END),
(CASE WHEN flags&32768 > 0 THEN (SELECT 1 FOR XML PATH ('noInlineCopyToSameLibrary'), TYPE) END),
(CASE WHEN flags&65536 > 0 THEN (SELECT 1 FOR XML PATH ('noAuxCopyToSameLibrary'), TYPE) END),
(CASE WHEN flags&131072 > 0 THEN (SELECT 1 FOR XML PATH ('storeKeyOnMedia'), TYPE) END),
(CASE WHEN flags&262144 > 0 THEN (SELECT 1 FOR XML PATH ('sourceCopyForSnapToTape'), TYPE) END),
(CASE WHEN flags&524288 > 0 THEN (SELECT 1 FOR XML PATH ('siloCopy'), TYPE) END),
(CASE WHEN flags&1048576 > 0 THEN (SELECT 1 FOR XML PATH ('preserveEncryptionModeAsInSource'), TYPE) END),
(CASE WHEN flags&8388608 > 0 THEN (SELECT 1 FOR XML PATH ('auxCopyReencryptData'), TYPE) END),
(CASE WHEN flags&2097152 > 0 THEN (SELECT 1 FOR XML PATH ('storePlainText'), TYPE) END),
(CASE WHEN flags&4194304 > 0 THEN (SELECT 1 FOR XML PATH ('encryptOnNetworkUsingSelectedCipher'), TYPE) END),
(CASE WHEN flags&16777216 > 0 THEN (SELECT 1 FOR XML PATH ('wormCopy'), TYPE) END),
(CASE WHEN flags&33554432 > 0 THEN (SELECT 1 FOR XML PATH ('enableMediaRefresh'), TYPE) END),
(CASE WHEN flags&67108864 > 0 THEN (SELECT 1 FOR XML PATH ('useHardwareSnapshot'), TYPE) END),
(CASE WHEN flags&134217728 > 0 THEN (SELECT 1 FOR XML PATH ('enableLanFreeReservationOnly'), TYPE) END),
(CASE WHEN flags&268435456 > 0 THEN (SELECT 1 FOR XML PATH ('useStreamsOverMultiplexing'), TYPE) END),
(CASE WHEN flags&536870912 > 0 THEN (SELECT 1 FOR XML PATH ('useDirectAttachedNASDrivePool'), TYPE) END),
(CASE WHEN flags&1073741824 > 0 THEN (SELECT 1 FOR XML PATH ('deleteCopyAfterJobsAreDeleted'), TYPE) END)
		FOR XML PATH('copyFlags')),
		(SELECT
(CASE WHEN extendedFlags&1 > 0 THEN (SELECT 1 FOR XML PATH ('globalAuxCopyPolicy'), TYPE) END),
(CASE WHEN extendedFlags&2 > 0 THEN (SELECT 1 FOR XML PATH ('useGlobalAuxCopyPolicy'), TYPE) END),
(CASE WHEN extendedFlags&4 > 0 THEN (SELECT 1 FOR XML PATH ('dynamicStreamAllocation'), TYPE) END),
(CASE WHEN extendedFlags&8 > 0 THEN (SELECT 1 FOR XML PATH ('secondarySiloCopy'), TYPE) END),
(CASE WHEN extendedFlags&16 > 0 THEN (SELECT 1 FOR XML PATH ('compressionOnClients'), TYPE) END),
(CASE WHEN extendedFlags&256 > 0 THEN (SELECT 1 FOR XML PATH ('arrayReplicaCopy'), TYPE) END),
(CASE WHEN extendedFlags&512 > 0 THEN (SELECT 1 FOR XML PATH ('useOfflineArrayReplication'), TYPE) END),
(CASE WHEN extendedFlags&32768 > 0 THEN (SELECT 1 FOR XML PATH ('chunkLevelAuxCopy'), TYPE) END),
(CASE WHEN extendedFlags&2048 > 0 THEN (SELECT 1 FOR XML PATH ('overRideGACPRetention'), TYPE) END),
(CASE WHEN extendedFlags&65536 > 0 THEN (SELECT 1 FOR XML PATH ('overRideGACPEncryption'), TYPE) END),
(CASE WHEN extendedFlags&131072 > 0 THEN (SELECT 1 FOR XML PATH ('spaceOptimizedAuxCopy'), TYPE) END),
(CASE WHEN extendedFlags&524288 > 0 THEN (SELECT 1 FOR XML PATH ('defaultReplicaCopy'), TYPE) END)
			FOR XML PATH('extendedFlags')),
		(SELECT
(CASE WHEN dedupeFlags&2 > 0 THEN (SELECT 1 FOR XML PATH ('useDDBPrimingOption'), TYPE) END),
(CASE WHEN dedupeFlags&4 > 0 THEN (SELECT 1 FOR XML PATH ('optimizeHighLatencyNetwork'), TYPE) END),
(CASE WHEN dedupeFlags&8 > 0 THEN (SELECT 1 FOR XML PATH ('minimumPartitionsToBeAvailableForJobsToRun'), TYPE) END),
(CASE WHEN dedupeFlags&131072 > 0 THEN (SELECT 1 FOR XML PATH ('enableSIDBArchive'), TYPE) END),
(CASE WHEN dedupeFlags&262144 > 0 THEN (SELECT 1 FOR XML PATH ('enableDeduplication'), TYPE) END),
(CASE WHEN dedupeFlags&524288 > 0 THEN (SELECT 1 FOR XML PATH ('enableClientSideDedup'), TYPE) END),
(CASE WHEN dedupeFlags&1048576 > 0 THEN (SELECT 1 FOR XML PATH ('temporarilyDisableDeduplication'), TYPE) END),
(CASE WHEN dedupeFlags&2097152 > 0 THEN (SELECT 1 FOR XML PATH ('backupSiloEnabled'), TYPE) END),
(CASE WHEN dedupeFlags&4194304 > 0 THEN (SELECT 1 FOR XML PATH ('isSilosToBeKeptInCache'), TYPE) END),
(CASE WHEN dedupeFlags&8388608 > 0 THEN (SELECT 1 FOR XML PATH ('enableDASHFull'), TYPE) END),
(CASE WHEN dedupeFlags&16777216 > 0 THEN (SELECT 1 FOR XML PATH ('enableSiloDiskSpaceManagement'), TYPE) END),
(CASE WHEN dedupeFlags&33554432 > 0 THEN (SELECT 1 FOR XML PATH ('pauseAndRecoverCurrentDDB'), TYPE) END),
(CASE WHEN dedupeFlags&67108864 > 0 THEN (SELECT 1 FOR XML PATH ('automaticallyPauseAndRecoverDDB'), TYPE) END),
(CASE WHEN dedupeFlags&134217728 > 0 THEN (SELECT 1 FOR XML PATH ('useGlobalDedupStore'), TYPE) END),
(CASE WHEN dedupeFlags&268435456 > 0 THEN (SELECT 1 FOR XML PATH ('hostGlobalDedupStore'), TYPE) END),
(CASE WHEN dedupeFlags&536870912 > 0 THEN (SELECT 1 FOR XML PATH ('markClientCacheDbDirty'), TYPE) END),
(CASE WHEN dedupeFlags&1073741824 > 0 THEN (SELECT 1 FOR XML PATH ('enableSourceSideDiskCache'), TYPE) END)
			FOR XML PATH('dedupeFlags'))
		FROM archGroupCopy where id = @storagePolicyCopyId
	DECLARE @copyRetentionXML TABLE(copyId int, retentionXML XML)
	DECLARE @EXT_RET_RULE_ALL INT = 2;
	DECLARE @EXT_RET_RULE_HOUR INT = 262144;
	DECLARE @EXT_RET_RULE_DAY INT =524288;
	DECLARE @EXT_RET_RULE_WEEK INT = 4;
	DECLARE @EXT_RET_RULE_MONTH INT = 8;
	DECLARE @EXT_RET_RULE_QUARTER INT = 16;
	DECLARE @EXT_RET_RULE_SIXMONTHS INT = 32;
	DECLARE @EXT_RET_RULE_YEAR INT = 64;
	INSERT INTO @copyRetentionXML
	SELECT AR.copyId,
		(SELECT AR.retentionDays as '@retainBackupDataForDays', AR.fullCycles as '@retainBackupDataForCycles',
			   AR.archiverRetDays as '@retainArchiverDataForDays',
			   AR.retentionJobs as '@jobs',
			   (SELECT
(CASE WHEN (AR.flags & 1 > 0) THEN (SELECT 1  FOR XML PATH ('extendedRetentionFirst'), TYPE) END),
(CASE WHEN (AR.flags & 2 > 0) THEN (SELECT 1  FOR XML PATH ('dirtyExtendedRetention'), TYPE) END),
(CASE WHEN (AR.flags & 4 > 0) THEN (SELECT 0  FOR XML PATH ('enableDataAging'), TYPE) ELSE (SELECT 1 FOR XML PATH ('enableDataAging'), TYPE)END),
(CASE WHEN (AR.flags & 8 > 0) THEN (SELECT 1  FOR XML PATH ('enableManagedDiskSpace'), TYPE) END),
(CASE WHEN (AR.flags & 16 > 0) THEN (SELECT 1  FOR XML PATH ('ignoreJobDependencyCheck'), TYPE) END),
(CASE WHEN (AR.flags & 32 > 0) THEN (SELECT 1  FOR XML PATH ('selectJobsFromPreviousTier'), TYPE) END),
(CASE WHEN (AR.flags & 64 > 0) THEN (SELECT 1  FOR XML PATH ('retainFullAndLastDifferential'), TYPE) END),
(CASE WHEN (AR.flags & 128 > 0) THEN (SELECT 1  FOR XML PATH ('jobBasedRetention'), TYPE) END),
(CASE WHEN (AR.flags & 256 > 0) THEN (SELECT 1  FOR XML PATH ('grcRemoteCopy'), TYPE) END)
				   FOR XML PATH ('retentionFlags'), TYPE),
			   (SELECT 1 as '@isEnabled', EveryXHours as '@everyXHours' , GraceDays as '@graceDays',
					   retentionDays as '@endDays', retentionRule as '@rule'
						FROM  (SELECT EveryXHours , GraceDays, retentionDays, retentionRule,
								ROW_NUMBER() OVER (ORDER BY
													 (CASE WHEN retentionRule = @EXT_RET_RULE_ALL THEN 0
														   WHEN retentionRule = @EXT_RET_RULE_HOUR THEN 1
														   WHEN retentionRule = @EXT_RET_RULE_DAY THEN 2
														   WHEN retentionRule = @EXT_RET_RULE_WEEK THEN 3
														   WHEN retentionRule = @EXT_RET_RULE_MONTH THEN 4
														   WHEN retentionRule = @EXT_RET_RULE_QUARTER THEN 5
														   WHEN retentionRule = @EXT_RET_RULE_SIXMONTHS THEN 6
														   WHEN retentionRule = @EXT_RET_RULE_YEAR THEN 7
													  END) ) as RowNumber
								FROM archAgingRuleExtended where copyId = AR.copyId) AS ARE
						WHERE RowNumber=1 FOR XML PATH ('extendedRetentionRuleOne'), TYPE),
				(SELECT 1 as '@isEnabled', EveryXHours as '@everyXHours' , GraceDays as '@graceDays',
					   retentionDays as '@endDays', retentionRule as '@rule'
						FROM  (SELECT EveryXHours , GraceDays, retentionDays, retentionRule,
								ROW_NUMBER() OVER (ORDER BY
													 (CASE WHEN retentionRule = @EXT_RET_RULE_ALL THEN 0
														   WHEN retentionRule = @EXT_RET_RULE_HOUR THEN 1
														   WHEN retentionRule = @EXT_RET_RULE_DAY THEN 2
														   WHEN retentionRule = @EXT_RET_RULE_WEEK THEN 3
														   WHEN retentionRule = @EXT_RET_RULE_MONTH THEN 4
														   WHEN retentionRule = @EXT_RET_RULE_QUARTER THEN 5
														   WHEN retentionRule = @EXT_RET_RULE_SIXMONTHS THEN 6
														   WHEN retentionRule = @EXT_RET_RULE_YEAR THEN 7
													  END) ) as RowNumber
								FROM archAgingRuleExtended where copyId = AR.copyId) AS ARE
						WHERE RowNumber=2 FOR XML PATH ('extendedRetentionRuleTwo'), TYPE),
				(SELECT 1 as '@isEnabled', EveryXHours as '@everyXHours' , GraceDays as '@graceDays',
					   retentionDays as '@endDays', retentionRule as '@rule'
						FROM  (SELECT EveryXHours , GraceDays, retentionDays, retentionRule,
								ROW_NUMBER() OVER (ORDER BY
													 (CASE WHEN retentionRule = @EXT_RET_RULE_ALL THEN 0
														   WHEN retentionRule = @EXT_RET_RULE_HOUR THEN 1
														   WHEN retentionRule = @EXT_RET_RULE_DAY THEN 2
														   WHEN retentionRule = @EXT_RET_RULE_WEEK THEN 3
														   WHEN retentionRule = @EXT_RET_RULE_MONTH THEN 4
														   WHEN retentionRule = @EXT_RET_RULE_QUARTER THEN 5
														   WHEN retentionRule = @EXT_RET_RULE_SIXMONTHS THEN 6
														   WHEN retentionRule = @EXT_RET_RULE_YEAR THEN 7
													  END) ) as RowNumber
								FROM archAgingRuleExtended where copyId = AR.copyId) AS ARE
						WHERE RowNumber=3 FOR XML PATH ('extendedRetentionRuleThree'), TYPE)
		FOR XML PATH ('retentionRules'), TYPE)
	FROM ArchAgingRule AR
	WHERE AR.copyId=@storagePolicyCopyId
	DECLARE @hours INT = 0
	DECLARE @mins INT = 0
	DECLARE @ampm INT = 0
	DECLARE @dayNumber INT = 0
	DECLARE @type	INT = 0
	DECLARE @numPeriod	INT = 0
	SELECT @dayNumber = dayNumber, @type = type, @numPeriod = numPeriod from archSelectiveCopy WHERE copyId = @storagePolicyCopyId;
	IF (@type=10 OR @type=3)
	BEGIN
		SET @hours = @dayNumber / 60
		SET @mins = @dayNumber % 60
		IF @hours >= 12
		BEGIN
			SET @ampm = 1
			IF @hours > 12
				SET @hours = @hours - 12
		END
		ELSE
			SET @ampm = 0
	END
	DECLARE @copySelectiveXML TABLE(copyId int, selectiveXML XML)
	INSERT INTO @copySelectiveXML
	SELECT @storagePolicyCopyId,
		(SELECT
(CASE WHEN (AGC.flags & 4096 = 0)  --CVA_LAST_FULL_FLAG 4096
				  THEN (SELECT 1 FOR XML PATH('firstFullBackup'), TYPE)
				  ELSE (SELECT 0 FOR XML PATH('firstFullBackup'), TYPE)
			 END),
(CASE WHEN (AGC.flags & 8192 = 0)  --CVA_LAST_FULL_WAIT_FLAG 8192
				  THEN (SELECT 1 FOR XML PATH('selectMostRecentJob'), TYPE)
				  ELSE (SELECT 0 FOR XML PATH('selectMostRecentJob'), TYPE)
			 END),
(CASE WHEN (SEL.type= 8) --CVA_SELECT_LASTFULL 8
				  THEN (SELECT 1 FOR XML PATH('doNotAutomaticallySelectJobs'), TYPE)
			 END),
(CASE WHEN ((SEL.type <> 8) AND (SEL.type <> 4) AND (SEL.numPeriod <> 1))
				  THEN (SELECT 16777216 FOR XML PATH ('selectiveRule'), TYPE) --SELECTIVE_ADVANCED 16777216
			 END),
			 --CYCLES
(CASE WHEN ((SEL.numPeriod=1) AND (SEL.type=1)) --CVA_SELECT_BY_CYCLE
					THEN (SELECT 2 FOR XML PATH('selectiveRule'), TYPE) --SELECTIVE_ALLFULL
WHEN ((SEL.numPeriod <> 1) AND (SEL.type=1)) --SEL.type = CVA_SELECT_BY_CYCLE 1
					THEN (SELECT @numPeriod FOR XML PATH ('everyXCycles'), TYPE)
			 END),
			 --HOURS
(CASE WHEN ((SEL.type=10) AND (SEL.numPeriod=1)) --CVA_SELECT_BY_HOURS 10 (SEL.type)
					THEN (SELECT 262144 FOR XML PATH ('selectiveRule'), TYPE) --SELECTIVE_HOUR = 262144
WHEN ((SEL.type=10) AND (SEL.numPeriod <> 1))
					THEN (SELECT @numPeriod FOR XML PATH ('everyXHours'), TYPE)
			 END),
			(SELECT @ampm as '@amOrPm',
				(SELECT @hours as '@hours', @mins as '@min' FOR XML PATH('dayStartsHoursMinutes'), TYPE)
WHERE SEL.type=10 FOR XML PATH ('dayStartsAt'), TYPE),
			 --DAYS
(CASE WHEN ((SEL.type=3) AND (SEL.numPeriod=1)) --CVA_SELECT_BY_DAYS 3 (SEL.type)
					THEN (SELECT 524288 FOR XML PATH ('selectiveRule'), TYPE) --SELECTIVE_DAY = 524288
WHEN ((SEL.type=3) AND (SEL.numPeriod <> 1))
					THEN (SELECT @numPeriod FOR XML PATH ('everyXDays'), TYPE)
			 END),
			(SELECT @ampm as '@amOrPm',
				(SELECT @hours as '@hours', @mins as '@min' FOR XML PATH('dayStartsHoursMinutes'), TYPE)
WHERE SEL.type=3 FOR XML PATH ('dayStartsAt'), TYPE),
			--WEEK
(CASE WHEN (SEL.numPeriod=1) AND (SEL.type = 2)			--CVA_SELECT_BY_WEEKDAY 2 (SEL.type)
					THEN (SELECT 4 FOR XML PATH ('selectiveRule'), TYPE) --SELECTIVE_WEEK = 4
WHEN (SEL.numPeriod <> 1) AND (SEL.type = 2)--CVA_SELECT_BY_WEEKDAY 2 (SEL.type)
					THEN (SELECT @numPeriod FOR XML PATH ('everyXWeeks'), TYPE)
				END),
(CASE WHEN (SEL.type=2)--CVA_SELECT_BY_WEEKDAY 2 (SEL.type)
					THEN (SELECT @dayNumber FOR XML PATH ('weekDayStartsOn'), TYPE)
				END),
			--MONTH
(CASE WHEN (SEL.numPeriod=1) AND (SEL.type = 4) THEN (SELECT 8 FOR XML PATH ('selectiveRule'), TYPE) --SELECTIVE_MONTH = 8
WHEN (SEL.numPeriod=3) AND (SEL.type = 4) THEN (SELECT 16 FOR XML PATH ('selectiveRule'), TYPE) --SELECTIVE_QUARTER = 16,
WHEN (SEL.numPeriod=6) AND (SEL.type = 4) THEN (SELECT 32 FOR XML PATH ('selectiveRule'), TYPE) --SELECTIVE_HALFYEAR = 32,
WHEN (SEL.numPeriod=12) AND (SEL.type = 4) THEN (SELECT 64 FOR XML PATH ('selectiveRule'), TYPE) --SELECTIVE_YEAR = 64,
WHEN (SEL.type = 4) THEN (SELECT 16777216 FOR XML PATH ('selectiveRule'), TYPE)					--SELECTIVE_ADVANCED 16777216
				END),
(CASE WHEN (SEL.numPeriod <> 1)  AND (SEL.type = 4)
					THEN (SELECT @numPeriod FOR XML PATH ('everyXMonths'), TYPE)
				END),
(CASE WHEN (SEL.type=4)		--CVA_SELECT_BY_MONTHDAY          4 (SEL.type)
					THEN (SELECT @dayNumber FOR XML PATH ('monthStartsOn'), TYPE)
				END)
		  FOR XML PATH ('selectiveCopyRules'),TYPE)
	FROM archSelectiveCopy SEL JOIN archGroupCopy AGC ON SEL.copyId= AGC.id
	WHERE copyId= @storagePolicyCopyId
	exec ArchCopyAppSubsetForGUI @storagePolicyCopyId,@storagePolicyId,0,0, @userId
	UPDATE #tempAssocOutput
	SET entityType = CASE WHEN subClientId > 0 THEN 7 WHEN backupSetId > 0 THEN 6 WHEN InstanceId > 0 THEN 5 WHEN AppTypeId > 0 THEN 4 WHEN clientId > 0 THEN 3 WHEN clientGroupID > 0 THEN 28 ELSE entityType END
	WHERE entityType = 0
	SET @associationsXML =(
	select entityType as '@_type_', appTypename '@appName', appTypeId '@applicationId', backupsetId '@backupsetId', backupSetName '@backupsetName', clientGroupID '@clientGroupId', clientGroupName '@clientGroupName', clientId '@clientId', clientName  '@clientName',  instanceId '@instanceId', instanceName '@instanceName', subclientId '@subclientId', subclientName '@subclientName' ,
	t.ishidden 'flags/@disabled', t.exclude 'flags/@exclude', t.include  'flags/@include'
	from #tempAssocOutput t
	FOR XML PATH ('entities'), ROOT('associations')
	)
	SET @o_xml =
		(	SELECT
				(SELECT SPC.copyPrecedence as '@copyPrecedence', SPC.type as '@copyType',
				  SPC.isActive as '@active', SPC.isMirrorCopy as '@isMirrorCopy', SPC.isSnapCopy as '@isSnapCopy',
				  SPC.isDefaultCopy as '@isDefault',
				  SPC.throttleNWBandwidth as '@throttleNetworkBandWidthMBHR',
				 (SELECT SPC.copyId as '@copyId', SPC.copyName as '@copyName' FOR XML PATH ('StoragePolicyCopy'), TYPE),
				 (SELECT SPC.sourceCopyId as '@copyId', SPC.sourceCopyName as '@copyName' FOR XML PATH ('sourceCopy'), TYPE),
				 (SELECT SPC.startTime as '@time' FOR XML PATH ('startTime'), TYPE),
				 (SELECT SPC.maId as '@mediaAgentId', SPC.maName as '@mediaAgentName' FOR XML PATH ('mediaAgent'), TYPE),
				  CAST(CR.retentionXML AS XML),
				  CAST(CS.selectiveXML AS XML),
				  CAST(CF.copyFlags AS XML),
				  CAST(CF.extendedFlags AS XML),
				  CAST(CF.dedupeFlags AS XML),
				  @associationsXML,
				 (SELECT SPC.libraryId as '@libraryId', SPC.libraryName as '@libraryName' FOR XML PATH ('library'), TYPE),
				 (SELECT SPC.drivePoolId as '@drivePoolId', SPC.drivePoolName as '@drivePoolName' FOR XML PATH ('drivePool'), TYPE),
				 (SELECT SPC.spareGroupId as '@spareMediaGroupId', SPC.spareGroupName as '@spareMediaGroupName' FOR XML PATH('spareMediaGroup'), TYPE),
				 (SELECT SPC.storagePoolId as '@storagePoolId', SPC.storagePoolName as '@storagePoolName' FOR XML PATH('storagePool'), TYPE)
				 FROM #tmpStoragePolicyCopyInfo SPC
					JOIN #tmpStoragePolicyCopyAndFlags CF ON SPC.copyId = CF.copyId
					LEFT JOIN @copyRetentionXML CR ON SPC.copyId = CR.copyId
					LEFT JOIN @copySelectiveXML CS ON SPC.copyId = CS.copyId
				 FOR XML PATH ('copy'), TYPE),
				(SELECT @errorCode AS '@errorCode', @errorString AS '@errorMessage' FOR XML PATH('error'), TYPE)
			FOR XML PATH ('App_GetStoragePolicyCopyResp')
		)
END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
     set @errorCode = ERROR_NUMBER()
     set @errorString = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
END CATCH
IF @errorCode <> 0
    SET @o_xml = (SELECT @errorCode AS '@errorCode', @errorString AS '@errorMessage' FOR XML PATH('error'), ROOT('App_GetStoragePolicyCopyResp') )
SELECT @o_xml
IF OBJECT_ID('tempdb.dbo.#tmpStoragePolicyCopyInfo') IS NOT NULL DROP TABLE #tmpStoragePolicyCopyInfo
IF OBJECT_ID('tempdb.dbo.#tmpStoragePolicyCopyAndFlags') IS NOT NULL DROP TABLE #tmpStoragePolicyCopyAndFlags
IF OBJECT_ID('tempdb.dbo.#tempAssocOutput') IS NOT NULL DROP TABLE #tempAssocOutput
SET NOCOUNT OFF
GO


IF EXISTS (select * from GxQscripts where name = 'MMGetStoragePolicyCopyDetails')
	delete from GxQscripts where name = 'MMGetStoragePolicyCopyDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetStoragePolicyCopyDetails')
	delete from GXDBVersions where aliasname = 'MMGetStoragePolicyCopyDetails'
GO

insert into GXDBVersions values(2, 'MMGetStoragePolicyCopyDetails',  '00010001000400110000', 'MMGetStoragePolicyCopyDetails', '00010001000400110000')
GO

