

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMGetStoragePolicies.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2008  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMGetStoragePolicies.sp,v $ $Id: MMGetStoragePolicies.sp,v 1.1.4.14 2020/05/10 01:16:35 pveeravalli Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MMGetStoragePolicies')
BEGIN
	print '>>> Drop Stored Procedure: MMGetStoragePolicies <<<'
	drop procedure MMGetStoragePolicies
END
IF EXISTS (select * from GxQscripts where name='MMGetStoragePolicies')
	delete from GxQscripts where name = 'MMGetStoragePolicies'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetStoragePolicies')
	delete from GXDBVersions where aliasname = 'MMGetStoragePolicies'
GO
print '... Creating Procedure: MMGetStoragePolicies'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MMGetStoragePolicies
  @i_xmlString XML OUTPUT
AS
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
  DECLARE @o_xml XML
-- XML Input Parameters
DECLARE @userId					INTEGER = 0
DECLARE @storagePolicyId		INTEGER = 0
DECLARE @filterGlobalPolicies	INTEGER = 1
DECLARE @propertyLevel			INTEGER = 1
DECLARE @errorCode      		INTEGER = 0
DECLARE @errorString    		NVARCHAR(1024) = N''
BEGIN TRY
if object_id('tempdb.dbo.#tmpStoragePolicies') is not null DROP TABLE #tmpStoragePolicies
CREATE TABLE  #tmpStoragePolicies (
				AGid 							integer,
				name							nvarchar(255),
				maxStreams						integer,
				type							integer,
				flags							integer,
				incrSP							integer,
				incrSPName						nvarchar(255),
				defaultCopy						integer,
				defaultSnapCopy					integer,
				defCopyName						nvarchar(255),
				numCopies						integer,
				numDeDupCopies					integer,
				numSiloedCopies					integer,
				drivePoolId						integer,
				drivePoolType					integer,
				drivePoolClientId				integer,
				drivePoolClientsimSystemOSId	integer,
				isNRSInstalledOndrivePoolClient	integer,
				isCenteraPartOfDefCopy			integer,
				numApps							integer,
				visibleToUser					integer,
				isCIEnabled						integer,
				primaryCopyMultiplexFactor 		integer,
				isSnapToMediaEnabled			integer,
				isAuxcopyEncEnabled				integer,
				SIBlockSizeKB					integer,
				AuxCopyAlertGB					integer,
				AuxCopyAlertDays				integer,
				archGroupDescription			nvarchar(max),
				clientCount						integer,
				numNonGDSPDedupeCopies      	integer,
				isIBMiVTL						integer,
				timeZoneType					integer,
				logSP							integer,
				logSPName						nvarchar(255),
				fullSPCountIsLogSpFor			integer)
-- Get the input parameters from the XML input str
SET @userId = ISNULL( ( SELECT ref.value('@userId', 'int') FROM @i_xmlString.nodes('App_GetStoragePoliciesReq/processinginstructioninfo/user') R(ref) ), 0)
SET @storagePolicyId = ISNULL ( ( SELECT ref.value('@storagePolicyId', 'int') FROM @i_xmlString.nodes ( 'App_GetStoragePoliciesReq/storagePolicy' ) R(ref) ), 0 )
SET @propertyLevel = ISNULL ( (SELECT ref.value('@propertyLevel', 'int') FROM @i_xmlString.nodes('App_GetStoragePoliciesReq') R(ref) ), 1)
SET @filterGlobalPolicies = CASE WHEN (@storagePolicyId > 0) THEN 0 ELSE 1 END -- To get GDSP properties if user supplies storagepolicyID
EXEC archGroupList @userId, @storagePolicyId, @filterGlobalPolicies
IF OBJECT_ID('tempdb.dbo.#tmpStoragePoliciesAndFlags') IS NOT NULL DROP TABLE #tmpStoragePoliciesAndFlags
CREATE TABLE  #tmpStoragePoliciesAndFlags (
				AGid 							integer,
				flags                             XML)
INSERT INTO #tmpStoragePoliciesAndFlags
SELECT AGid,
	(SELECT
(CASE WHEN flags&1 > 0 THEN 1 END ) AS 'flag/@legalHold',
(CASE WHEN flags&2 > 0 THEN 1 END ) AS 'flag/@allowEraseData' ,
(CASE WHEN flags&4 > 0 THEN 1 END ) AS 'flag/@randomizeStream',
(CASE WHEN flags&8 > 0 THEN 1 END ) AS'flag/@enableAuxCopyAlert',
(CASE WHEN flags&16 > 0 THEN 1 END ) AS'flag/@storagePolicyLevelMediaPassword',
(CASE WHEN flags&32 > 0 THEN 1 END )AS 'flag/@blockLevelDedup' ,
(CASE WHEN flags&64 > 0 THEN 1 END ) AS'flag/@hideStoragePolicy',
(CASE WHEN flags&128 > 0 THEN 1 END ) AS'flag/@ezStoragePolicy',
(CASE WHEN flags&256 > 0 THEN 1 END ) AS'flag/@enableGlobalDeduplication',
(CASE WHEN flags&512 > 0 THEN 1 END ) AS'flag/@cdrStoragePolicy',
(CASE WHEN flags&1024 > 0 THEN 1 END ) AS'flag/@ddrSnapshot',
(CASE WHEN flags&2048 > 0 THEN 1 END ) AS'flag/@enableSnapshot',
(CASE WHEN flags&4096 > 0 THEN 1 END ) AS'flag/@deleteAfterJobsAreDeleted',
(CASE WHEN flags&8192 > 0 THEN 1 END ) AS 'flag/@clonedStoragePolicy',
(CASE WHEN flags&16384 > 0 THEN 1 END ) AS 'flag/@globalAuxCopyPolicy',
(CASE WHEN flags&32768 > 0 THEN 1 END ) AS 'flag/@considerIncrSnapsAsFull',
(CASE WHEN flags&65536 > 0 THEN 1 END ) AS 'flag/@stopNewSubclientAssociationDueToStoreLimit',
(CASE WHEN flags&131072 > 0 THEN 1 END )'flag/@distributeDataEvenlyAmongStreams' ,
(CASE WHEN flags&1048576 > 0 THEN 1 END ) AS 'flag/@cacheResourceReservationForJobs',
(CASE WHEN flags&33554432 > 0 THEN 1 END ) AS 'flag/@scaleOutStoragePolicy'
	FOR XML PATH (''))
FROM #tmpStoragePolicies
WHERE ((@storagePolicyId <> 0 AND AGid = @storagePolicyId) OR
	   (@storagePolicyId = 0 AND AGid > 1))
IF OBJECT_ID('tempdb.dbo.#tmpStoragePoliciesAndPlan') IS NOT NULL DROP TABLE #tmpStoragePoliciesAndPlan
CREATE TABLE  #tmpStoragePoliciesAndPlan (
				AGid 							integer,
				planId							integer,
				planName						nvarchar(255))
DECLARE		@searchEngineId 	integer = 0
DECLARE		@searchEngineName	nvarchar(1024) = ''
IF @propertyLevel > 1
BEGIN
	INSERT INTO #tmpStoragePoliciesAndPlan
	SELECT AG.AGid, P.id ,P.name FROM APP_PLAN P
			JOIN APP_PlanProp PP ON P.id = PP.componentNameId
			JOIN #tmpStoragePolicies AG ON PP.attrVal=AG.AGid
WHERE PP.attrVal = CAST(AG.AGid as varchar(10)) AND PP.attrName IN('Storage policy', 'Log storage policy')
	IF @storagePolicyId > 0
	BEGIN
		DECLARE @searchEngineTbl TABLE
		(
			searchEngineId 	integer,
			searchEngineName NVARCHAR(1024)
		)
		INSERT INTO @searchEngineTbl (searchEngineId,searchEngineName)
			SELECT CP.id,CP.stringVal
			FROM APP_ComponentProp CP with(nolock) INNER JOIN APP_ClientProp CLP with(nolock)
			ON CP.id = CONVERT(INT,CLP.attrVal)
WHERE CP.componentType = 1 AND CP.componentId = 2 AND CP.propertyTypeId = 1 AND CP.modified = 0 AND CLP.modified = 0 AND CLP.attrName = 'CLOUD_ID'
		--analytics engine
		INSERT INTO @searchEngineTbl (searchEngineId,searchEngineName)
		SELECT C.cloudid, C.name
		FROM DM2Cloud C WITH (NOLOCK)
			INNER JOIN DM2SearchServerCoreInfo S WITH (NOLOCK) ON C.cloudId=S.CloudId
			INNER JOIN DM2CloudCoreRole CR WITH (NOLOCK) ON CR.CloudId=S.CloudId
		DELETE T
			FROM @searchEngineTbl T
			 INNER JOIN DM2SearchEngineCloudMapping M  WITH (NOLOCK) ON T.searchEngineId = M.DestCloudId AND  M.Flags=0
INNER JOIN archContentIndexingRules R  WITH (NOLOCK) ON R.cloudId = M.SrcCloudId AND R.enabled=1 AND R.archGroupId = @storagePolicyId AND R.operationType = 1
		--There will only one search engine for a storage policy. But incase there are more will use TOP 1
		SELECT TOP 1 @searchEngineId = searchEngineId, @searchEngineName = searchEngineName FROM @searchEngineTbl
	END
END
IF (@propertyLevel > 5) AND (@storagePolicyId > 0)
BEGIN
	IF OBJECT_ID('tempdb.dbo.#tmpStoragePoliciesAndCopyInfo') IS NOT NULL DROP TABLE #tmpStoragePoliciesAndCopyInfo
	CREATE TABLE  #tmpStoragePoliciesAndCopyInfo (
					AGid 							integer,
					copyId							integer,
					copyName						nvarchar(255),
					isDefaultCopy					integer,
					copyType 						tinyint,
					copyPrecedence					integer,
					copyFlags						integer,
					maId							integer,
					maName							nvarchar(510),
					retainBackupDataForDays			integer,
					retainBackupDataForCycles		integer,
					libraryId						integer,
					libraryName						nvarchar(255),
					storagePoolId					integer,
					storagePoolName					nvarchar(288),
					destMediaCopyId				integer,
					isSnapCopy					integer,
					isMirrorCopy				integer)
	INSERT INTO	#tmpStoragePoliciesAndCopyInfo
	SELECT DISTINCT AG.AGid, AGC.id, AGC.name,
					(CASE WHEN AG.defaultCopy = AGC.id THEN 1 ELSE 0 END),
					AGC.type, AGC.copy, AGC.flags,
					ISNULL(DP.HostClientId, 0), ISNULL(C.name, ''),
					ISNULL(AR.retentionDays, 0), ISNULL(AR.fullCycles, 0),
					ISNULL(LIB.LibraryId, 0), ISNULL(LIB.AliasName, ''),
					ISNULL(SPOOL.Id, 0), ISNULL(SPOOL.name, ''), AGC.destMediaCopyId, AGC.isSnapCopy, AGC.isMirrorCopy
		FROM #tmpStoragePolicies AG
INNER JOIN ArchGroupCopy AGC WITH(READUNCOMMITTED)  ON AG.AGid = AGC.archGroupId AND AGC.type <> 5
		LEFT JOIN MMDataPath DP WITH(READUNCOMMITTED) ON AGC.id = DP.CopyId AND (DP.Flag & 1 > 0)
		LEFT JOIN MMDrivePool DPool WITH(READUNCOMMITTED) ON DP.DrivePoolId = DPool.DrivePoolId
		LEFT JOIN MMMasterPool MPool WITH(READUNCOMMITTED) ON DPool.MasterPoolId = MPool.MasterPoolId
		LEFT JOIN MMLibrary LIB WITH(READUNCOMMITTED) ON MPool.LibraryId = LIB.LibraryId
		LEFT JOIN APP_Client C ON DP.hostClientId = C.id
		LEFT JOIN ArchAgingRule AR ON AR.copyId = AGC.id
		--Following to fetch StoragePool name
		LEFT JOIN archCopyToGlobalPolicy GP WITH (READUNCOMMITTED) ON AGC.id = GP.copyId
        LEFT JOIN archGroup SPOOL WITH (READUNCOMMITTED) ON GP.globalPolicyId = SPOOL.id
	WHERE AG.AGid = @storagePolicyId
END
IF (@propertyLevel = 1) AND (@storagePolicyId <= 0) --@propertyLevel = 1 is List Only from App.x
BEGIN
SET @o_xml =
	(	SELECT S.maxStreams as '@numberOfStreams',
		(SELECT S.AGid as '@storagePolicyId', S.name as '@storagePolicyName' FOR XML PATH ('storagePolicy'), TYPE),
		(SELECT @errorCode AS '@errorCode', @errorString AS '@errorMessage' FOR XML PATH('error'), TYPE)
		FROM #tmpStoragePolicies S
		FOR XML PATH ('policies'), ROOT ('App_GetStoragePoliciesResp')
	)
END
ELSE
BEGIN
	IF (@propertyLevel > 1) AND (@storagePolicyId <= 0) --Essential Properties
	BEGIN
		SET @o_xml =
			(	SELECT
					(SELECT S.maxStreams as '@numberOfStreams',
							S.type as '@type',
							S.numCopies as '@numberOfCopies',
(CASE WHEN S.flags&2048 = 0 THEN 0 ELSE ISNULL(ACH.SMReplicationProtocolType,0) END) as '@smReplicationProtocolType',
							CAST(SPF.flags as XML),
							(SELECT S.AGid as '@storagePolicyId', S.name as '@storagePolicyName' FOR XML PATH ('storagePolicy'), TYPE),
							(SELECT S.incrSP as '@storagePolicyId', S.incrSPName as '@storagePolicyName' FOR XML PATH ('incrementalStoragePolicy'), TYPE),
							(SELECT P.planId as '@planId', P.planName as '@planName' FROM #tmpStoragePoliciesAndPlan P  WHERE P.AGid = S.AGid FOR XML PATH ('plans'), TYPE)
						FROM #tmpStoragePolicies S JOIN #tmpStoragePoliciesAndFlags SPF ON S.AGid = SPF.AGid
						LEFT JOIN ArchGroupControlHost ACH WITH(READUNCOMMITTED)ON S.AGid = ACH.ArchGroupId
						FOR XML PATH ('policies'), TYPE),
					(SELECT @errorCode AS '@errorCode', @errorString AS '@errorMessage' FOR XML PATH('error'), TYPE)
				FOR XML PATH ('App_GetStoragePoliciesResp'), TYPE
			)
	END
	ELSE --This fetches properties of a given storage policy
	BEGIN
		IF (@propertyLevel <= 5) AND (@storagePolicyId > 0) --Basic Properties
		BEGIN
			SET @o_xml =
				(	SELECT
						(SELECT S.maxStreams as '@numberOfStreams',
								S.type as '@type',
								S.numCopies as '@numberOfCopies',
								S.archGroupDescription as '@description',
								S.SIBlockSizeKB as '@sidbBlockSizeKB',
								(CASE WHEN S.AuxCopyAlertGB < 0 THEN 0 ELSE S.AuxCopyAlertGB END) as '@auxCopyAlertGB',
								(CASE WHEN S.AuxCopyAlertDays < 0 THEN 0 ELSE S.AuxCopyAlertDays END) as '@auxCopyAlertDays',
								S.timeZoneType as '@timeZoneType',
								@searchEngineId as '@searchEngineId',
								@searchEngineName as '@searchEngineName',
(CASE WHEN S.flags&2048 = 0 THEN 0 ELSE ISNULL(ACH.SMReplicationProtocolType,0) END) as '@smReplicationProtocolType',
								CAST(SPF.flags as XML),
								(SELECT S.AGid as '@storagePolicyId', S.name as '@storagePolicyName' FOR XML PATH ('storagePolicy'), TYPE),
								(SELECT S.incrSP as '@storagePolicyId', S.incrSPName as '@storagePolicyName' FOR XML PATH ('incrementalStoragePolicy'), TYPE),
								(SELECT P.planId as '@planId', P.planName as '@planName' FROM #tmpStoragePoliciesAndPlan P WHERE P.AGid = S.AGid FOR XML PATH ('plans'), TYPE)
							FROM #tmpStoragePolicies S JOIN #tmpStoragePoliciesAndFlags SPF ON S.AGid = SPF.AGid
						    LEFT JOIN ArchGroupControlHost ACH WITH(READUNCOMMITTED)ON S.AGid = ACH.ArchGroupId
							FOR XML PATH ('policies'), TYPE),
						(SELECT @errorCode AS '@errorCode', @errorString AS '@errorMessage' FOR XML PATH('error'), TYPE)
					FOR XML PATH ('App_GetStoragePoliciesResp'), TYPE
				)
		END
		ELSE --IF (@propertyLevel > 5) AND (@storagePolicyId > 0) --Extended Properties
		BEGIN
			DECLARE @copyExtendedRetentionXML TABLE(copyId int, retentionNumber int, retentionXML XML, PRIMARY KEY(copyId, retentionNumber))
			IF (@propertyLevel >= 30)
			BEGIN
				DECLARE @EXT_RET_RULE_ALL INT = 2;
				DECLARE @EXT_RET_RULE_HOUR INT = 262144;
				DECLARE @EXT_RET_RULE_DAY INT =524288;
				DECLARE @EXT_RET_RULE_WEEK INT = 4;
				DECLARE @EXT_RET_RULE_MONTH INT = 8;
				DECLARE @EXT_RET_RULE_QUARTER INT = 16;
				DECLARE @EXT_RET_RULE_SIXMONTHS INT = 32;
				DECLARE @EXT_RET_RULE_YEAR INT = 64;
				INSERT INTO @copyExtendedRetentionXML
				SELECT 	SPC.copyId,
						ROW_NUMBER() OVER ( PARTITION BY SPC.copyId
											ORDER BY (CASE
														WHEN retentionRule = @EXT_RET_RULE_ALL THEN 0
														WHEN retentionRule = @EXT_RET_RULE_HOUR THEN 1
														WHEN retentionRule = @EXT_RET_RULE_DAY THEN 2
														WHEN retentionRule = @EXT_RET_RULE_WEEK THEN 3
														WHEN retentionRule = @EXT_RET_RULE_MONTH THEN 4
														WHEN retentionRule = @EXT_RET_RULE_QUARTER THEN 5
														WHEN retentionRule = @EXT_RET_RULE_SIXMONTHS THEN 6
														WHEN retentionRule = @EXT_RET_RULE_YEAR THEN 7
													END)) AS retentionNumber,
						(SELECT 1 as '@isEnabled', EveryXHours as '@everyXHours' , GraceDays as '@graceDays', retentionDays as '@endDays', retentionRule as '@rule'FOR XML PATH('ExtendedRetentionRule'), TYPE)
				FROM 	archAgingRuleExtended  ARE
						INNER JOIN #tmpStoragePoliciesAndCopyInfo SPC ON ARE.copyId = SPC.copyId
				UPDATE 	@copyExtendedRetentionXML
				SET 	retentionXML = 	CASE
											WHEN retentionNumber = 1 THEN retentionXML.query('element extendedRetentionRuleOne {ExtendedRetentionRule/@*, /ExtendedRetentionRule/*}')
											WHEN retentionNumber = 2 THEN retentionXML.query('element extendedRetentionRuleTwo {ExtendedRetentionRule/@*, /ExtendedRetentionRule/*}')
											WHEN retentionNumber = 3 THEN retentionXML.query('element extendedRetentionRuleThree {ExtendedRetentionRule/@*, /ExtendedRetentionRule/*}')
											ELSE retentionXML
										END
			END
			SET @o_xml =
				(	SELECT
						(SELECT S.maxStreams as '@numberOfStreams',
								S.type as '@type',
								S.numCopies as '@numberOfCopies',
								s.archGroupDescription as '@description',
								S.SIBlockSizeKB as '@sidbBlockSizeKB',
								(CASE WHEN S.AuxCopyAlertGB < 0 THEN 0 ELSE S.AuxCopyAlertGB END) as '@auxCopyAlertGB',
								(CASE WHEN S.AuxCopyAlertDays < 0 THEN 0 ELSE S.AuxCopyAlertDays END) as '@auxCopyAlertDays',
								S.timeZoneType as '@timeZoneType',
								@searchEngineId as '@searchEngineId',
								@searchEngineName as '@searchEngineName',
(CASE WHEN S.flags&2048 = 0 THEN 0 ELSE ISNULL(ACH.SMReplicationProtocolType,0) END) as '@smReplicationProtocolType',
								CAST(SPF.flags as XML),
								(SELECT S.AGid as '@storagePolicyId', S.name as '@storagePolicyName' FOR XML PATH ('storagePolicy'), TYPE),
								(SELECT S.incrSP as '@storagePolicyId', S.incrSPName as '@storagePolicyName' FOR XML PATH ('incrementalStoragePolicy'), TYPE),
								(SELECT S.logSP as '@storagePolicyId', S.logSPName as '@storagePolicyName' FOR XML PATH ('logStoragePolicy'), TYPE),
								(SELECT P.planId as '@planId', P.planName as '@planName' FROM #tmpStoragePoliciesAndPlan P WHERE P.AGid = S.AGid FOR XML PATH ('plans'), TYPE),
								(	SELECT 	SPC.copyPrecedence as '@copyPrecedence', SPC.isDefaultCopy as '@isDefault', SPC.isSnapCopy as '@isSnapCopy', SPC.copyType as '@copyType', SPC.isMirrorCopy as '@isMirrorCopy',
											(SELECT SPC.copyId as '@copyId', SPC.copyName as '@copyName' FOR XML PATH ('StoragePolicyCopy'), TYPE),
											(SELECT SPC.maId as '@mediaAgentId', SPC.maName as '@mediaAgentName' FOR XML PATH ('mediaAgent'), TYPE),
											(	SELECT 	SPC.retainBackupDataForDays as '@retainBackupDataForDays', SPC.retainBackupDataForCycles as '@retainBackupDataForCycles',
														(SELECT ER.retentionXML FROM @copyExtendedRetentionXML ER WHERE ER.retentionNumber = 1 AND ER.copyId = SPC.copyId),
														(SELECT ER.retentionXML FROM @copyExtendedRetentionXML ER WHERE ER.retentionNumber = 2 AND ER.copyId = SPC.copyId),
														(SELECT ER.retentionXML FROM @copyExtendedRetentionXML ER WHERE ER.retentionNumber = 3 AND ER.copyId = SPC.copyId)
												FOR XML PATH ('retentionRules'), TYPE
											),
											(SELECT SPC.libraryId as '@libraryId', SPC.libraryName as '@libraryName' FOR XML PATH ('library'), TYPE),
											(SELECT SPC.storagePoolId as '@storagePoolId', SPC.storagePoolName as '@storagePoolName' FOR XML PATH('storagePool'), TYPE)
									FROM #tmpStoragePoliciesAndCopyInfo SPC WHERE SPC.AGid = S.AGid
									FOR XML PATH ('copies'), TYPE
								)
							FROM #tmpStoragePolicies S JOIN #tmpStoragePoliciesAndFlags SPF ON S.AGid = SPF.AGid
							LEFT JOIN ArchGroupControlHost ACH WITH(READUNCOMMITTED)ON S.AGid = ACH.ArchGroupId
							FOR XML PATH ('policies'), TYPE),
						(SELECT @errorCode AS '@errorCode', @errorString AS '@errorMessage' FOR XML PATH('error'), TYPE)
					 FOR XML PATH ('App_GetStoragePoliciesResp'), TYPE
				)
		END
	END
END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
     set @errorCode = ERROR_NUMBER()
     set @errorString = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
END CATCH
IF @errorCode <> 0
    SET @o_xml = (SELECT @errorCode AS '@errorCode', @errorString AS '@errorMessage' FOR XML PATH('error'), ROOT('App_GetStoragePoliciesResp') )
set @i_xmlString = @o_xml
SELECT @o_xml
IF OBJECT_ID('tempdb.dbo.#tmpStoragePolicies') IS NOT NULL DROP TABLE #tmpStoragePolicies
IF OBJECT_ID('tempdb.dbo.#tmpStoragePoliciesAndFlags') IS NOT NULL DROP TABLE #tmpStoragePoliciesAndFlags
IF OBJECT_ID('tempdb.dbo.#tmpStoragePoliciesAndPlan') IS NOT NULL DROP TABLE #tmpStoragePoliciesAndPlan
IF OBJECT_ID('tempdb.dbo.#tmpStoragePoliciesAndCopyInfo') IS NOT NULL DROP TABLE #tmpStoragePoliciesAndCopyInfo
SET NOCOUNT OFF
GO


IF EXISTS (select * from GxQscripts where name = 'MMGetStoragePolicies')
	delete from GxQscripts where name = 'MMGetStoragePolicies'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetStoragePolicies')
	delete from GXDBVersions where aliasname = 'MMGetStoragePolicies'
GO

insert into GXDBVersions values(2, 'MMGetStoragePolicies',  '00010001000400140000', 'MMGetStoragePolicies', '00010001000400140000')
GO

