

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMGetStorageAndClientAccessListfor3dfs.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET NOCOUNT ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='MMGetStorageAndClientAccessListfor3dfs')
BEGIN
	print '>>> Drop Stored Procedure: MMGetStorageAndClientAccessListfor3dfs <<<'
	drop procedure MMGetStorageAndClientAccessListfor3dfs
END
IF EXISTS (select * from GxQscripts where name='MMGetStorageAndClientAccessListfor3dfs')
	delete from GxQscripts where name = 'MMGetStorageAndClientAccessListfor3dfs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetStorageAndClientAccessListfor3dfs')
	delete from GXDBVersions where aliasname = 'MMGetStorageAndClientAccessListfor3dfs'
GO
print '... Creating Procedure: MMGetStorageAndClientAccessListfor3dfs'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure MMGetStorageAndClientAccessListfor3dfs
  @inputGUID VARCHAR(256),
  @path VARCHAR(256)
AS
  DECLARE @o_clientId INTEGER
  DECLARE @o_clientName NVARCHAR(510)
  DECLARE @o_netHostName NVARCHAR(510)
  DECLARE @o_clientGUID VARCHAR(255)
  DECLARE @o_mountPathId INTEGER
  DECLARE @o_Folder VARCHAR(1024)
IF OBJECT_ID('tempdb.dbo.#pseudoClientApps') IS NOT NULL DROP TABLE #pseudoClientApps
CREATE TABLE #pseudoClientApps
(
    appId    INT,
    copyId   INT,
    appTypeId   INT,
    instanceId  INT,
    pseudoClientId  INT,
    pseudoClientstatus INT,
    minReleaseId INT,
    minServicePack INT
)
-- 1. Get list of mount paths with direct access from the 3dfs server media agent or input media agent.
DECLARE @locallyAttachedStorage TABLE (MountPathId int, Folder varchar(1024), deviceId INT, clientId INT, bWindows bit)
INSERT INTO @locallyAttachedStorage
SELECT  DISTINCT MPSD.MountPathId, DC.Folder, DC.deviceId, DC.ClientId, IIF(PKG.simPackageId IS NULL, 0, 1)
FROM    MMMountPathToStorageDevice MPSD (NOLOCK)
          INNER JOIN MMDevicecontroller DC (NOLOCK) ON MPSD.DeviceId = DC.DeviceId
          INNER JOIN APP_Client C (NOLOCK) ON C.id = DC.ClientId
          LEFT JOIN SimInstalledPackages (NOLOCK) PKG ON C.id = PKG.ClientId AND PKG.simPackageID = 51 --N_WIN_PACKAGE_MEDIAAGENT
WHERE   C.GUID = @inputGUID and DC.DeviceAccessType & (16|32|128) = 0
--2. Get all clients using the above mount paths for 1 min RPO log dumping.
DECLARE @logDumpingClientsToStorage TABLE (MountPathId INT, Folder varchar(1024), subClientId INT, clientId INT, bWindows bit)
INSERT INTO @logDumpingClientsToStorage
SELECT  DISTINCT ASM.MountPathId, L.Folder, ASM.subClientId, C.id, L.bWindows
   FROM    APP_SubclientToMountPathMapping ASM (NOLOCK)
        INNER JOIN APP_Application A(NOLOCK) ON ASM.subClientId = A.id
        INNER JOIN APP_Client C (NOLOCK) ON A.clientId = C.id
        INNER JOIN @locallyAttachedStorage L ON ASM.MountPathId = L.MountPathId
-- populate this temp table for the below spb to use.
INSERT INTO #pseudoClientApps
SELECT DISTINCT C.subClientId,0,0,0,0,0,0,0 from @logDumpingClientsToStorage C
--
-- BEGIN: Get all physical clients for pseudo clients
--
--
-- BEGIN: archGetMinVersionOfAccessNodesForSC.spb
--
if object_id('tempdb.dbo.#pseudoClientApps') is  null
BEGIN
	GOTO CX_EXIT;
END
DECLARE @ProxyTable TABLE
(
	pseudoClientId int,
	proxyClientId int
)
DECLARE @instanceId int
DECLARE @actualInstance int
DEClARE @clientId int
declare @appTypeId int
declare @appId int
DECLARE @inputxml XML
DECLARE @outputXML XML
UPDATE t
SET pseudoClientId = c.id, pseudoClientstatus = status , appTypeId = aa.appTypeId, instanceId = aa.instance
FROM app_client c WITH(READUNCOMMITTED), app_Application aa WITH(READUNCOMMITTED), #pseudoClientApps t
WHERE c.id = aa.clientID AND aa.id = t.appId
--
-- Exchange DAG
--
IF EXISTS (SELECT 1 FROM  #pseudoClientApps WHERE pseudoClientstatus & 0x200000 = 0x200000)
BEGIN
	INSERT 	INTO @ProxyTable
	SELECT  PC.pseudoClientId, EP.id
	FROM   	#pseudoClientApps PC
			INNER JOIN app_clientprop prop WITH(READUNCOMMITTED)
				on PC.pseudoClientId = prop.componentNameId
				and prop.attrType = 125 /*PROPERTY_DAG_MEMBERSERVER*/
				and prop.modified = 0
			INNER JOIN app_client EP WITH(READUNCOMMITTED)
				on EP.net_hostname = prop.attrName
WHERE 	PC.pseudoClientstatus & 0x200000 = 0x200000
			AND NOT EXISTS(SELECT 1 FROM @ProxyTable P WHERE P.pseudoClientId = PC.pseudoClientId AND P.proxyClientId = EP.id)
	GROUP BY PC.pseudoClientId, EP.id
END
--
-- Oracle RAC
--
IF EXISTS (SELECT 1 FROM  #pseudoClientApps WHERE pseudoClientstatus & 0x0040 = 0x0040)
BEGIN
IF EXISTS (SELECT 1 FROM APP_InstanceName I WITH (READUNCOMMITTED), #pseudoClientApps PC WHERE PC.instanceId = I.Id AND I.status & 0x0800 = 0x0800)
	BEGIN
		INSERT 	INTO @ProxyTable
		SELECT  PC.pseudoClientId, EP.id
FROM   	#pseudoClientApps PC INNER JOIN APP_InstanceName I WITH (READUNCOMMITTED) ON I.Id = PC.instanceId AND I.status & 0x0800 = 0x0800 INNER JOIN App_Application A WITH (READUNCOMMITTED) ON A.clientId = PC.pseudoClientId
				INNER JOIN APP_OracleRacInstance R WITH(READUNCOMMITTED)
					ON A.instance = R.instaceId
AND PC.appTypeId = 80
				INNER JOIN app_client EP WITH(READUNCOMMITTED)
					ON EP.id = R.clientid
WHERE 	PC.pseudoClientstatus & 0x0040 = 0x0040
				AND NOT EXISTS(SELECT 1 FROM @ProxyTable P WHERE P.pseudoClientId = PC.pseudoClientId AND P.proxyClientId = EP.id)
		GROUP BY PC.pseudoClientId, EP.id
	END
	INSERT 	INTO @ProxyTable
	SELECT  PC.pseudoClientId, EP.id
	FROM   	#pseudoClientApps PC
			INNER JOIN APP_OracleRacInstance R WITH(READUNCOMMITTED)
				ON PC.instanceId = R.instaceId
AND PC.appTypeId = 80
			INNER JOIN app_client EP WITH(READUNCOMMITTED)
				ON EP.id = R.clientid
WHERE 	PC.pseudoClientstatus & 0x0040 = 0x0040
			AND NOT EXISTS(SELECT 1 FROM @ProxyTable P WHERE P.pseudoClientId = PC.pseudoClientId AND P.proxyClientId = EP.id)
	GROUP BY PC.pseudoClientId, EP.id
END
--
-- MS SQL
--
IF EXISTS (SELECT 1 FROM  #pseudoClientApps WHERE appTypeId = 81)
BEGIN
	INSERT 	INTO @ProxyTable
	SELECT  T.pseudoClientId, EP.id
	FROM   	(
				select 	PC.pseudoClientId, cast(prop.attrval as xml) as replicas
				from  	#pseudoClientApps PC,
						APP_InstanceProp prop WITH(READUNCOMMITTED)
				where 	prop.attrName ='Availability Replicas'
						and prop.modified = 0
						and PC.instanceId = prop.componentNameId
and PC.appTypeId = 81
and PC.pseudoClientstatus & 0x20000000 = 0x20000000
			) T, app_client EP WITH(READUNCOMMITTED)
	WHERE	NOT EXISTS(SELECT 1 FROM @ProxyTable P WHERE P.pseudoClientId = T.pseudoClientId AND P.proxyClientId = EP.id)
	AND    EP.id IN  (SELECT N.value('(replicaClient/@clientId)[1]','int') FROM T.replicas.nodes('App_SQLAvailabilityReplicas/SQLAvailabilityReplicasList') AS T(N) )
	GROUP BY T.pseudoClientId, EP.id
	INSERT 	INTO @ProxyTable
	SELECT  T.pseudoClientId, EP.id
	FROM   	(
				SELECT 	PC.pseudoClientId, cast(AIP.attrval as xml) memberServers
				FROM	#pseudoClientApps PC
						INNER JOIN APP_IDAName AID WITH(READUNCOMMITTED) ON PC.pseudoClientId = AID.clientId  AND PC.appTypeId = AID.appTypeId
						INNER JOIN APP_IDAProp AIP WITH(READUNCOMMITTED)
							ON AID.id = AIP.componentNameId
							AND AIP.attrName = N'Cloud Proxy Servers'
							AND AIP.modified = 0
WHERE	PC.appTypeId = 81
AND PC.pseudoClientstatus & 0x20000000 = 0
			) T
			inner join app_client EP WITH(READUNCOMMITTED)
				on
				(
					EP.id IN (SELECT N.value('(client/@clientId)[1]','int') FROM T.memberServers.nodes('App_MemberServers/memberServers') AS T(N)  )
					OR
					EP.id IN
					(
						SELECT 	clientId
						FROM 	APP_ClientGroupAssoc WITH(READUNCOMMITTED)
						WHERE 	clientGroupId IN ( SELECT   N.value('(client/@clientGroupId)[1]','int') FROM T.memberServers.nodes('App_MemberServers/memberServers') AS T(N)  )
					)
				)
	WHERE 	NOT EXISTS(SELECT 1 FROM @ProxyTable P WHERE P.pseudoClientId = T.pseudoClientId AND P.proxyClientId = EP.id)
	GROUP BY T.pseudoClientId, EP.id
END
--
-- Oracle Agentless
--
IF EXISTS (SELECT 1 FROM  #pseudoClientApps WHERE appTypeId = 22)
BEGIN
	INSERT 	INTO @ProxyTable
	SELECT  T.pseudoClientId, EP.id
	FROM   	(
				select 	pseudoClientId, prop.componentNameId, cast(prop.attrval as xml) as bkpConfigNodes
				from  	#pseudoClientApps PC,
						APP_InstanceProp prop WITH(READUNCOMMITTED)
				where 	prop.attrName = 'DB Thin Client Proxy Client List'
						and prop.modified = 0
						and PC.instanceId = prop.componentNameId
and PC.appTypeId = 22
			) T
			inner join app_client EP WITH(READUNCOMMITTED)
				on
				(
					EP.id IN (SELECT  N.value('(@clientId)[1]','int') FROM T.bkpConfigNodes.nodes('App_BackupConfigurationNodes/backupDataAccessNodes') AS T(N) )
					OR
					EP.id IN
					(
						SELECT 	clientId
						FROM 	APP_ClientGroupAssoc WITH(READUNCOMMITTED)
						WHERE 	clientGroupId IN ( SELECT   N.value('(@clientGroupId)[1]','int') FROM T.bkpConfigNodes.nodes('App_BackupConfigurationNodes/backupDataAccessNodes') AS T(N))
					)
				)
	WHERE 	NOT EXISTS(SELECT 1 FROM @ProxyTable P WHERE P.pseudoClientId = T.pseudoClientId AND P.proxyClientId = EP.id)
	GROUP BY T.pseudoClientId, EP.id
END
--
-- Cloud Apps
--
--IF EXISTS (SELECT 1 FROM  #pseudoClientApps WHERE appTypeId IN (134, 33, 104))
BEGIN
	INSERT 	INTO @ProxyTable
	SELECT  T.pseudoClientId, EP.id
	FROM   	(
				select 	pseudoClientId, prop.componentNameId, cast(prop.attrval as xml) as bkpConfigNodes
				from  	#pseudoClientApps PC,
						APP_InstanceProp prop WITH(READUNCOMMITTED)
				where 	prop.attrName in ( 'Proxy Clients','Amazon S3 Proxy Clients','Azure Proxy Clients', 'Oracle Cloud Proxy Clients',
					'Openstack Proxy Clients', 'Google Cloud Proxy Clients', 'Azure DL Proxy Clients')
						and prop.modified = 0
						and PC.instanceId = prop.componentNameId
and PC.appTypeId IN (134, 33)
			) T
			inner join app_client EP WITH(READUNCOMMITTED)
				on
				(
					EP.id IN
					(
						SELECT  N.value('(@clientId)[1]','int') FROM T.bkpConfigNodes.nodes('App_GeneralCloudProperties/proxyServers') AS T(N)
						UNION
						SELECT  N.value('(client/@clientId)[1]','int') FROM T.bkpConfigNodes.nodes('App_GeneralCloudProperties/memberServers') AS T(N)
						UNION
						SELECT 	clientId
						FROM 	APP_ClientGroupAssoc WITH(READUNCOMMITTED)
						WHERE 	clientGroupId IN ( SELECT   N.value('(client/@clientGroupId)[1]','int') FROM T.bkpConfigNodes.nodes('App_GeneralCloudProperties/memberServers') AS T(N)  )
					)
				)
	WHERE 	NOT EXISTS(SELECT 1 FROM @ProxyTable P WHERE P.pseudoClientId = T.pseudoClientId AND P.proxyClientId = EP.id)
	GROUP BY T.pseudoClientId, EP.id
	UNION
	SELECT  PC.pseudoClientId, EP.id
	FROM   	#pseudoClientApps PC
			inner join APP_InstanceProp I WITH(READUNCOMMITTED)
				on PC.instanceId = I.componentNameId
				and I.attrname  = 'Salesforce backup client'
				and I.modified =0
			inner join app_client EP WITH(READUNCOMMITTED)
				on cast(EP.id as nvarchar) = I.attrval
WHERE 	PC.appTypeId IN (134, 33)
			AND NOT EXISTS(SELECT 1 FROM @ProxyTable P WHERE P.pseudoClientId = PC.pseudoClientId AND P.proxyClientId = EP.id)
	GROUP BY PC.pseudoClientId, EP.id
	UNION
	SELECT  T.pseudoClientId, EP.id
	FROM   	(
				SELECT 	PC.pseudoClientId, cast(prop.attrval as xml) dataNodes
				FROM #pseudoClientApps PC
					INNER JOIN APP_IDAName I WITH(READUNCOMMITTED) on PC.pseudoClientId = I.clientId AND PC.appTypeId = I.appTypeId
					INNER JOIN App_IDAProp prop WITH(READUNCOMMITTED)
					on prop.componentNameId = I.id
					AND prop.attrname  = 'Cloud DB Config'
					and prop.modified =0
			) T
			inner join app_client EP WITH(READUNCOMMITTED)
				on EP.id IN
				(
					SELECT N.value('(client/@clientId)[1]','int') FROM T.dataNodes.nodes('App_CloudDBConfig/dbProxyClientList') AS T(N)
					UNION
					SELECT 	clientId
					FROM 	APP_ClientGroupAssoc WITH(READUNCOMMITTED)
					WHERE 	clientGroupId IN ( SELECT   N.value('(client/@clientGroupId)[1]','int') FROM T.dataNodes.nodes('App_CloudDBConfig/dbProxyClientList') AS T(N)  )
				)
	WHERE 	NOT EXISTS(SELECT 1 FROM @ProxyTable P WHERE P.pseudoClientId = T.pseudoClientId AND P.proxyClientId = EP.id)
	GROUP BY T.pseudoClientId, EP.id
END
--
-- Distributed iDA
--
IF EXISTS (SELECT 1 FROM  #pseudoClientApps WHERE appTypeId = 64)
BEGIN
	INSERT 	INTO @ProxyTable
	SELECT  PC.pseudoClientId, EP.id
	FROM   	#pseudoClientApps PC
			INNER JOIN APP_InstanceProp prop WITH(READUNCOMMITTED)
				on PC.instanceId = prop.componentNameId
				and prop.attrName IN ('Greenplum Master Client Id','Coordinator Node')
				and prop.modified = 0
			inner join app_client EP WITH(READUNCOMMITTED)
				on EP.id = prop.attrVal
WHERE 	PC.appTypeId = 64
			AND NOT EXISTS(SELECT 1 FROM @ProxyTable P WHERE P.pseudoClientId = PC.pseudoClientId AND P.proxyClientId = EP.id)
	GROUP BY PC.pseudoClientId, EP.id
	INSERT 	INTO @ProxyTable
	SELECT  T.pseudoClientId, EP.id
	FROM   	(
				select 	pseudoClientId, prop.componentNameId, cast(REPLACE(prop.attrval, '<?xml version="1.0" encoding="UTF-8" standalone="no" ?>','') as xml) as dataNodes
				from  	#pseudoClientApps PC,
						APP_SubClientProp prop WITH(READUNCOMMITTED)
				where 	prop.attrName = 'Data Access Nodes'
						and prop.modified = 0
						and PC.appId = prop.componentNameId
and PC.appTypeId = 64
			) T
			inner join app_client EP WITH(READUNCOMMITTED)
				on EP.id IN (SELECT N.value('(@clientId)[1]','int') FROM T.dataNodes.nodes('App_DataAccessNodes/dataAccessNodes') AS T(N))
	WHERE 	NOT EXISTS(SELECT 1 FROM @ProxyTable P WHERE P.pseudoClientId = T.pseudoClientId AND P.proxyClientId = EP.id)
	GROUP BY T.pseudoClientId, EP.id
	--For CTree Index Server, MediaAgent acts as a proxy
	INSERT 	INTO @ProxyTable
	SELECT 	PC.pseudoClientId, dp.clientId
	FROM   	#pseudoClientApps PC
			INNER JOIN App_ClientProp CP WITH(READUNCOMMITTED)
				ON PC.pseudoClientId = CP.componentNameId
AND CP.attrName = 'Index Server Type'
				AND CP.modified = 0
AND CP.attrVal = N'15'
			INNER JOIN APP_InstanceProp IP WITH(READUNCOMMITTED)
				ON PC.instanceId = IP.componentNameId
AND IP.attrName = 'Distributed Cluster Type'
				AND IP.modified = 0
AND IP.attrVal = N'7'
			INNER JOIN MMDataPath dPath WITH(READUNCOMMITTED) ON dPath.copyId = PC.copyId
			INNER JOIN MMDrivePool dp WITH(READUNCOMMITTED) ON dPath.DrivePoolId = dp.DrivePoolId
WHERE	PC.appTypeId = 64
			AND NOT EXISTS(SELECT 1 FROM @ProxyTable P WHERE P.pseudoClientId = PC.pseudoClientId AND P.proxyClientId = dp.clientId)
	--For Solr Index Server, find nodes
	IF OBJECT_ID('tempdb.dbo.#getIndexServers') IS NOT NULL     DROP TABLE #getIndexServers
    CREATE TABLE #getIndexServers
                        (     serverURL NVARCHAR(512),
                                clientId INT,
                                clientName NVARCHAR(256),
                                cloudId INT,
                                hostName NVARCHAR(256),
                                basePort INT,
                                engineName  NVARCHAR(256),
                                serverType INT,
                                indexServerClientId INT,
                                internalCloudName NVARCHAR(256)
                        )
    EXEC DM2GetIndexServers
	INSERT 	INTO @ProxyTable
	SELECT 	PC.pseudoClientId, ISrvr.clientId
	FROM   	#pseudoClientApps PC
			INNER JOIN #getIndexServers ISrvr ON PC.pseudoClientId = ISrvr.indexServerClientId
WHERE	PC.appTypeId = 64
			AND NOT EXISTS(SELECT 1 FROM @ProxyTable P WHERE P.pseudoClientId = PC.pseudoClientId AND P.proxyClientId = ISrvr.clientId)
	IF OBJECT_ID('tempdb.dbo.#getIndexServers') IS NOT NULL     DROP TABLE #getIndexServers
END
--
-- Exchange OnePass
--
IF EXISTS (SELECT 1 FROM  #pseudoClientApps WHERE appTypeId = 137)
BEGIN
	INSERT 	INTO @ProxyTable
	SELECT  T.pseudoClientId, EP.id
	FROM   	(
				select 	PC.pseudoClientId, cast(replace(prop.attrval,'encoding="UTF-8"', '') as xml) as dataNodes
				from  	#pseudoClientApps PC
						INNER JOIN APP_IDAName I WITH(READUNCOMMITTED) on PC.pseudoClientId = I.clientId AND PC.appTypeId = I.appTypeId
						INNER JOIN App_IDAProp prop WITH(READUNCOMMITTED)
							ON prop.attrName ='OnePass Member Servers'
							and prop.modified = 0
							and prop.componentNameId  = I.id
where 	PC.appTypeId = 137
			) T
			inner join app_client EP
				on
				(
					EP.id IN (SELECT N.value('(client/@clientId)[1]','int') FROM T.dataNodes.nodes('App_MemberServers/memberServers') AS T(N))
					OR
					EP.id IN
					(
						SELECT 	clientID
						FROM 	APP_ClientGroupAssoc WITH(READUNCOMMITTED)
						WHERE	clientGroupID IN (SELECT N.value('(client/@clientGroupId)[1]','int') FROM T.dataNodes.nodes('App_MemberServers/memberServers') AS T(N))
					)
				)
	WHERE 	NOT EXISTS(SELECT 1 FROM @ProxyTable P WHERE P.pseudoClientId = T.pseudoClientId AND P.proxyClientId = EP.id)
	GROUP BY T.pseudoClientId, EP.id
	--For Case Manager, MediaAgent acts as a proxy
	INSERT 	INTO @ProxyTable
	SELECT 	PC.pseudoClientId, dp.clientId
	FROM   	#pseudoClientApps PC
			INNER JOIN App_ClientProp CP WITH(READUNCOMMITTED)
				ON PC.pseudoClientId = CP.componentNameId
				AND CP.attrName = N'Case Manager Pseudo Client'
				AND CP.modified = 0
				AND CP.attrVal = N'1'
			INNER JOIN MMDataPath dPath WITH(READUNCOMMITTED) ON dPath.copyId = PC.copyId
			INNER JOIN MMDrivePool dp WITH(READUNCOMMITTED) ON dPath.DrivePoolId = dp.DrivePoolId
WHERE	PC.appTypeId = 137
			AND NOT EXISTS(SELECT 1 FROM @ProxyTable P WHERE P.pseudoClientId = PC.pseudoClientId AND P.proxyClientId = dp.clientId)
END
--
-- VSA
--
IF EXISTS (SELECT 1 FROM  #pseudoClientApps WHERE appTypeId = 106)
BEGIN
	declare cur CURSOR LOCAL for
		select DISTINCT pseudoClientId, Prop.componentNameId, PC.instanceId
		FROM #pseudoClientApps PC INNER JOIN APP_InstanceProp Prop ON
							(PC.instanceID = Prop.componentNameId OR
							 prop.componentNameId IN (SELECT attrVal FROM APP_ClientProp cp WHERE cp.componentNameId = PC.pseudoClientId AND cp.attrName = 'Virtual Machine Instance ID'))
							AND Prop.attrName LIKE 'Virtual Server Instance Type'
							AND Prop.modified = 0
	open cur
	fetch next from cur into @clientId, @instanceId, @actualInstance
	while @@FETCH_STATUS = 0
	BEGIN
		SET @inputxml = '<App_GetVSMemberServersRequest expandClientGroup="1"><entity _type_="5" instanceId="' + convert(varchar(10),@instanceId) + '"/></App_GetVSMemberServersRequest>'
		IF OBJECT_ID('tempdb..#lt_AppGetVSMemberServersOutput') IS NOT NULL DROP TABLE #lt_AppGetVSMemberServersOutput
		CREATE TABLE #lt_AppGetVSMemberServersOutput (xmlOutput XML)
		exec AppGetVSMemberServers @inputxml
		SELECT	@outputXML = xmlOutput
		FROM 	#lt_AppGetVSMemberServersOutput
		IF OBJECT_ID('tempdb..#lt_AppGetVSMemberServersOutput') IS NOT NULL DROP TABLE #lt_AppGetVSMemberServersOutput
		insert into @ProxyTable
		select 	@clientId, c.value('@clientId','int')
		from 	@outputXML.nodes('App_GetVSMemberServersResponse/associatedClients/memberServers/client') C ( c )
		where 	NOT EXISTS(SELECT 1 FROM @ProxyTable P WHERE P.pseudoClientId = @clientId AND P.proxyClientId = c.value('@clientId','int'))
		fetch next from cur into @clientId, @instanceId, @actualInstance
	END
	close cur
	deallocate cur
END
--
-- NAS, non NDMP
--
IF EXISTS( SELECT 1 FROM #pseudoClientApps PC WHERE pseudoClientstatus & (CAST(0x0080 AS BIGINT)|CAST(0x8000000 AS BIGINT)) > 0 )
BEGIN
	declare cur CURSOR LOCAL for
		select Pc.pseudoClientId, PC.InstanceId, PC.ApptypeId, PC.appId
		from #pseudoClientApps  PC
WHERE pseudoClientstatus & (CAST(0x0080 AS BIGINT)|CAST(0x8000000 AS BIGINT) ) > 0
	open cur
	fetch next from cur into @clientId, @instanceId, @appTypeId, @appId
	while @@FETCH_STATUS = 0
	BEGIN
		IF OBJECT_ID('tempdb..#lt_AppGetBackupConfigNodesOutput') IS NOT NULL DROP TABLE #lt_AppGetBackupConfigNodesOutput
		CREATE TABLE #lt_AppGetBackupConfigNodesOutput (xmlOutput XML)
		exec AppGetBackupConfigNodes @clientId, @appTypeId, @appId, 0, 2, 0,0, 0
		SELECT	@outputXML = xmlOutput
		FROM 	#lt_AppGetBackupConfigNodesOutput
		IF OBJECT_ID('tempdb..#lt_AppGetBackupConfigNodesOutput') IS NOT NULL DROP TABLE #lt_AppGetBackupConfigNodesOutput
		insert into @ProxyTable
		select 	@clientId, c.value('@clientId','int')
		from 	@outputXML.nodes('App_BackupConfigurationNodes/backupDataAccessNodes') C ( c )
		where 	NOT EXISTS(SELECT 1 FROM @ProxyTable P WHERE P.pseudoClientId = @clientId AND P.proxyClientId = c.value('@clientId','int'))
		fetch next from cur into @clientId, @instanceId, @appTypeId, @appId
	END
	close cur
	deallocate cur
	--For NAS, the proxies are optional and MediaAgent acts as a proxy if there are no proxies returned by AppGetBackupConfigNodes
	INSERT 	INTO @ProxyTable
	SELECT 	PC.pseudoClientId, dp.ClientId
	FROM   	#pseudoClientApps PC
			INNER JOIN MMDataPath dPath WITH(READUNCOMMITTED) ON dPath.copyId = PC.copyId
			INNER JOIN MMDrivePool dp WITH(READUNCOMMITTED) ON dPath.DrivePoolId = dp.DrivePoolId
WHERE	PC.pseudoClientstatus & (CAST(0x0080 AS BIGINT)|CAST(0x8000000 AS BIGINT)) > 0
			AND NOT EXISTS(SELECT 1 FROM @ProxyTable P WHERE P.pseudoClientId = PC.pseudoClientId)
END
--
-- Open VMS
--
IF EXISTS  (SELECT 1 FROM  #pseudoClientApps WHERE appTypeId = 38)
BEGIN
	INSERT 	INTO @ProxyTable
	SELECT  T.pseudoClientId, EP.id
	FROM   	(
				select 	PC.pseudoClientId, cast(prop.attrval as xml) as bkpConfigNodes
				from	#pseudoClientApps PC,
						APP_ClientProp prop WITH(READUNCOMMITTED)
				where 	PC.pseudoClientId = prop.componentNameId
						and prop.attrName = 'Open VMS proxy client list'
						and prop.modified = 0
and PC.appTypeId = 38
			) T
			inner join app_client EP WITH(READUNCOMMITTED)
				on
				(
					EP.id IN (SELECT N.value('(@clientId)[1]','int') FROM T.bkpConfigNodes.nodes('App_BackupConfigurationNodes/backupDataAccessNodes') AS T(N))
					OR
					EP.id IN (SELECT clientID FROM APP_ClientGroupAssoc WITH(READUNCOMMITTED) where clientGroupID IN (SELECT N.value('(@clientGroupId)[1]','int') FROM T.bkpConfigNodes.nodes('App_BackupConfigurationNodes/backupDataAccessNodes') AS T(N)))
				)
	WHERE 	NOT EXISTS(SELECT 1 FROM @ProxyTable P WHERE P.pseudoClientId = T.pseudoClientId AND P.proxyClientId = EP.id)
	GROUP BY T.pseudoClientId, EP.id
END
--
-- Cluster Clients
--
INSERT 	INTO @ProxyTable
SELECT	PC.pseudoClientId, VC.PMClientId
FROM	#pseudoClientApps PC
		INNER JOIN APP_VMToPMMap VC WITH(READUNCOMMITTED) ON VC.VMClientId = PC.pseudoClientId
WHERE 	NOT EXISTS(SELECT 1 FROM @ProxyTable P WHERE P.pseudoClientId = PC.pseudoClientId AND P.proxyClientId = VC.PMClientId)
GROUP BY PC.pseudoClientId, VC.PMClientId
--
-- SAP HANA
--
IF EXISTS (SELECT 1 FROM  #pseudoClientApps WHERE appTypeId = 135)
BEGIN
	INSERT 	INTO @ProxyTable
	SELECT  PC.pseudoClientId, EP.id
	FROM   	#pseudoClientApps PC
			INNER JOIN app_InstanceProp ip WITH(READUNCOMMITTED)
				on PC.instanceID = ip.componentNameId
				and ip.attrName = 'Database Clients'
				and ip.modified = 0
			CROSS APPLY dbo.SplitIDString(replace(ip.attrVal,'+',',')) T
			INNER JOIN app_client EP WITH(READUNCOMMITTED)
				on EP.id =  T._ID
WHERE 	PC.appTypeId = 135
			AND NOT EXISTS(SELECT 1 FROM @ProxyTable P WHERE P.pseudoClientId = PC.pseudoClientId AND P.proxyClientId = EP.id)
	GROUP BY PC.pseudoClientId, EP.id
END
--
-- DB2
--
IF EXISTS (SELECT 1 FROM  #pseudoClientApps WHERE appTypeId = 103)
BEGIN
	INSERT 	INTO @ProxyTable
	SELECT  PC.pseudoClientId, EP.id
	FROM   	#pseudoClientApps PC
			INNER JOIN app_InstanceProp ip WITH(READUNCOMMITTED)
				on PC.instanceID = ip.componentNameId
				and ip.attrName = 'DB2 Partition Clients'
				and ip.modified = 0
			CROSS APPLY dbo.SplitString(IP.attrVal, ' ') T
			INNER JOIN app_client EP WITH(READUNCOMMITTED)
				on EP.id =  substring(T.Data, CHARINDEX(',', T.Data)+1, LEN(T.Data))
WHERE 	PC.appTypeId = 103
			AND NOT EXISTS(SELECT 1 FROM @ProxyTable P WHERE P.pseudoClientId = PC.pseudoClientId AND P.proxyClientId = EP.id)
	GROUP BY PC.pseudoClientId, EP.id
END
--
-- 3dfs
--
IF EXISTS (SELECT 1 FROM  #pseudoClientApps t, APP_SubClientProp sp
WHERE appTypeId = 29 AND sp.componentNameId = t.appID AND sp.attrname='3dfs Is NFS Share Enabled' AND attrVal = 1)
BEGIN
	INSERT 	INTO @ProxyTable
	SELECT  PC.pseudoClientId, EP.id
	FROM   	#pseudoClientApps PC
			INNER JOIN APP_SubClientProp sp1 WITH(READUNCOMMITTED)
				ON sp1.attrName = 'Associated subclient Policy'
				AND sp1.modified = 0
				AND sp1.componentNameId = PC.appId
			INNER JOIN APP_SubClientProp sp2 WITH(READUNCOMMITTED)
				ON sp1.attrVal = sp2.componentNameId AND sp2.attrName = '3dfs NFS Servers'
			inner join app_client EP WITH(READUNCOMMITTED)
				on EP.name = sp2.attrVal
WHERE 	PC.appTypeId = 29
			AND EXISTS (SELECT 1 FROM APP_SubClientProp WHERE componentNameId = PC.appID AND attrname='3dfs Is NFS Share Enabled' AND attrVal = 1)
			AND NOT EXISTS(SELECT 1 FROM @ProxyTable P WHERE P.pseudoClientId = PC.pseudoClientId AND P.proxyClientId = EP.id)
	GROUP BY PC.pseudoClientId, EP.id
END
--
-- Edge Drive
--
IF EXISTS (SELECT 1 FROM  #pseudoClientApps WHERE pseudoClientstatus & 0x10000000 = 0x10000000)
BEGIN
	--Get all webservers
	INSERT 	INTO @ProxyTable
	SELECT  PC.pseudoClientId, PKG.clientId
	FROM   	#pseudoClientApps PC,
			simInstalledPackages PKG WITH(READUNCOMMITTED)
WHERE 	PC.pseudoClientstatus & 0x10000000 = 0x10000000
AND PKG.simPackageID = 252
	GROUP BY PC.pseudoClientId, PKG.clientId
	--Get connected laptop clients configured for offline backup
	INSERT 	INTO @ProxyTable
	SELECT  PC.pseudoClientId, SC.clientId
	FROM   	#pseudoClientApps PC
			INNER JOIN App_SyncCloudConfig SC WITH(READUNCOMMITTED) ON PC.appId = SC.subclientId
			INNER JOIN App_SyncCloudFolder SF WITH(READUNCOMMITTED)
ON SF.syncWebFolderId = SC.syncWebFolderId AND SF.flag & 0x10 = 0x10
WHERE 	PC.pseudoClientstatus & 0x10000000 = 0x10000000
			AND SC.syncType  = 3 -- Edge offline linked laptops
	GROUP BY PC.pseudoClientId, SC.clientId
END
IF EXISTS(SELECT 1 FROM  #pseudoClientApps WHERE pseudoClientstatus & 0x1000 = 0x1000)
BEGIN
	INSERT 	INTO @ProxyTable
	SELECT  PC.pseudoClientId, ACP.attrval
	FROM   	#pseudoClientApps PC, APP_ClientProp ACP WITH (READUNCOMMITTED)
	WHERE	PC.pseudoClientId = ACP.componentNameId AND ACP.attrname = 'Physical Client Id' AND ACP.modified = 0
AND PC.pseudoClientstatus & 0x1000 = 0x1000
	GROUP BY PC.pseudoClientId, ACP.attrval
END
--
-- O365
--
IF EXISTS (SELECT 1 FROM  #pseudoClientApps WHERE appTypeId = 78)
BEGIN
	INSERT 	INTO @ProxyTable
	SELECT  T.pseudoClientId, EP.id
	FROM   	(
				select 	PC.pseudoClientId, cast(replace(prop.attrval,'encoding="UTF-8"', '') as xml) as dataNodes
				from  	#pseudoClientApps PC
						INNER JOIN APP_IDAName I WITH(READUNCOMMITTED) on PC.pseudoClientId = I.clientId AND PC.appTypeId = I.appTypeId
						INNER JOIN App_IDAProp prop WITH(READUNCOMMITTED)
							ON prop.attrName ='Sharepoint Member Servers'
							and prop.modified = 0
							and prop.componentNameId  = I.id
where 	PC.appTypeId = 78
				UNION ALL
				select 	PC.pseudoClientId, cast(replace(prop.stringVal,'encoding="UTF-8"', '') as xml) as dataNodes
				from  	#pseudoClientApps PC
						INNER JOIN APP_ComponentProp prop WITH(READUNCOMMITTED)
on PC.pseudoClientId = prop.componentId AND prop.propertyTypeId = 1046
							and prop.modified = 0
where 	PC.appTypeId = 78
			) T
			inner join app_client EP
				on
				(
					EP.id IN (SELECT N.value('(client/@clientId)[1]','int') FROM T.dataNodes.nodes('App_MemberServers/memberServers') AS T(N))
					OR
					EP.id IN
					(
						SELECT 	clientID
						FROM 	APP_ClientGroupAssoc WITH(READUNCOMMITTED)
						WHERE	clientGroupID  IN (SELECT N.value('(client/@clientGroupId)[1]','int') FROM T.dataNodes.nodes('App_MemberServers/memberServers') AS T(N))
					)
				)
	WHERE 	NOT EXISTS(SELECT 1 FROM @ProxyTable P WHERE P.pseudoClientId = T.pseudoClientId AND P.proxyClientId = EP.id)
	GROUP BY T.pseudoClientId, EP.id
	UNION
	SELECT  PC.pseudoClientId, EP.id
	FROM   	#pseudoClientApps PC
INNER JOIN app_clientProp prop WITH(READUNCOMMITTED) ON PC.pseudoClientId = componentNameId AND attrName = 'SharePoint Primary Member Server' AND PC.appTypeId = 78 AND prop.modified = 0
			inner join app_client EP WITH(READUNCOMMITTED) ON EP.Id = prop.attrVal
	WHERE 	NOT EXISTS(SELECT 1 FROM @ProxyTable P WHERE P.pseudoClientId = PC.pseudoClientId AND P.proxyClientId = EP.id)
	GROUP BY PC.pseudoClientId, EP.id
END
--
-- Azure AD
--
IF EXISTS (SELECT 1 FROM  #pseudoClientApps WHERE appTypeId = 139)
BEGIN
	INSERT 	INTO @ProxyTable
	SELECT  T.pseudoClientId, EP.id
	FROM   	(
				select 	PC.pseudoClientId, cast(replace(prop.attrval,'encoding="UTF-8"', '') as xml) as dataNodes
				from  	#pseudoClientApps PC
						INNER JOIN APP_IDAName I WITH(READUNCOMMITTED) on PC.pseudoClientId = I.clientId AND PC.appTypeId = I.appTypeId
						INNER JOIN App_IDAProp prop WITH(READUNCOMMITTED)
							ON prop.attrName ='Azure AD Member Servers'
							and prop.modified = 0
							and prop.componentNameId  = I.id
where 	PC.appTypeId = 139
			) T
			inner join app_client EP
				on
				(
					EP.id IN (SELECT N.value('(client/@clientId)[1]','int') FROM T.dataNodes.nodes('App_MemberServers/memberServers') AS T(N))
					OR
					EP.id IN
					(
						SELECT 	clientID
						FROM 	APP_ClientGroupAssoc WITH(READUNCOMMITTED)
						WHERE	clientGroupID  IN (SELECT N.value('(client/@clientGroupId)[1]','int') FROM T.dataNodes.nodes('App_MemberServers/memberServers') AS T(N))
					)
				)
	WHERE 	NOT EXISTS(SELECT 1 FROM @ProxyTable P WHERE P.pseudoClientId = T.pseudoClientId AND P.proxyClientId = EP.id)
	GROUP BY T.pseudoClientId, EP.id
END
---
--- Case Manager
---
IF EXISTS (SELECT 1 FROM   	#pseudoClientApps PC
			INNER JOIN App_ClientProp CP WITH(READUNCOMMITTED)
				ON PC.pseudoClientId = CP.componentNameId
				AND CP.attrName = 'Case Manager Pseudo Client' AND CP.attrVal = 1
				AND CP.modified = 0)
BEGIN
	--For CTree Index Server, MediaAgent acts as a proxy
	INSERT 	INTO @ProxyTable
	SELECT 	PC.pseudoClientId, dp.clientId
	FROM   	#pseudoClientApps PC
			INNER JOIN App_ClientProp CP WITH(READUNCOMMITTED)
				ON PC.pseudoClientId = CP.componentNameId
				AND CP.attrName = 'Case Manager Pseudo Client' AND CP.attrVal = 1
				AND CP.modified = 0
			INNER JOIN MMDataPath dPath WITH(READUNCOMMITTED) ON dPath.copyId = PC.copyId
			INNER JOIN MMDrivePool dp WITH(READUNCOMMITTED) ON dPath.DrivePoolId = dp.DrivePoolId
	WHERE	NOT EXISTS(SELECT 1 FROM @ProxyTable P WHERE P.pseudoClientId = PC.pseudoClientId AND P.proxyClientId = dp.clientId)
END
--
-- Final Step:
-- Get min Version for each pseudo client
--
;WITH ClientVersion AS
(
	SELECT  T.pseudoClientId, MIN(CN.ReleaseId) minReleaseId, MIN(PKG.HighestSP) minServicePack
	FROM    (
				SELECT 	PC.pseudoClientId, ISNULL(VC.PMClientId, PC.proxyClientId) proxyClientId
				FROM 	@ProxyTable PC
						LEFT OUTER JOIN APP_VMToPMMap VC WITH(READUNCOMMITTED) ON VC.VMClientId = PC.proxyClientId
			) T
			INNER JOIN App_Client CN WITH(READUNCOMMITTED) ON CN.id = T.proxyClientId
			INNER JOIN simInstalledPackages PKG WITH(READUNCOMMITTED) ON CN.id = PKG.ClientId
	GROUP BY T.pseudoClientId
)
UPDATE 	PC
SET		minReleaseId = V.minReleaseId,
		minServicePack = V.minServicePack
FROM	#pseudoClientApps PC,
		ClientVersion V
WHERE	PC.pseudoClientId = V.pseudoClientId
UPDATE 	PC
SET		minReleaseId = 16,
		minServicePack = CASE WHEN  AI.attrVal = 3 THEN  22 ELSE 17 END
FROM	#pseudoClientApps PC, APP_InstanceProp AI WITH (READUNCOMMITTED)
WHERE	appTypeId = 134 AND AI.componentNameId = PC.instanceId AND AI.attrName = 'Cloud Apps Instance Type' AND AI.attrVal IN (3, 22, 23, 24, 25) --SALESFORCE , AMAZON_DYNAMODB, COSMOSDB, ALICLOUD, IBM_COS
UPDATE 	PC
SET		minReleaseId = 16,
		minServicePack = 18
FROM	#pseudoClientApps PC
WHERE 	ISNULL(minReleaseId ,0) = 0 AND ISNULL(minServicePack, 0) = 0
AND appTypeId IN (125,104)
CX_EXIT:
--
-- END: archGetMinVersionOfAccessNodesForSC.spb
--
--
-- END: Get all physical clients pseudo clients
--
--3. Insert direct clients from log dumping table into the proxy table.
INSERT INTO @ProxyTable
SELECT DISTINCT C.clientId,C.clientId FROM @logDumpingClientsToStorage C
--4. Get all out of place restore clients from ClientAccessControl table.
IF NOT EXISTS (SELECT 1 FROM gxglobalparam (NOLOCK) WHERE name = 'bEnableAppMgrSecurityCheck' AND value = '0')
BEGIN
    INSERT INTO @ProxyTable
    SELECT DISTINCT C.clientId, AC.PrivilegedClientId
    FROM @logDumpingClientsToStorage C, App_ClientAccessControl AC (NOLOCK)
    WHERE C.clientId = AC.AccessedClientId
END
-- 5. Get physical client for cluster scenarios
INSERT INTO @ProxyTable
SELECT P.PseudoClientId, V.PMClientId
FROM @ProxyTable P, App_VMToPMMap V (NOLOCK)
WHERE P.ProxyclientId = V.VMClientId
-- 6. Final result of all clients with expanded export path based on iDA and OS type(to support nfs exports to log dumping jobs)
SELECT  DISTINCT C.id, C.name, C.net_hostname, C.GUID, LC.mountPathId,
             CASE
                WHEN PKG.HighestSP < 22 THEN LC.Folder
                WHEN APP.appTypeId IN (3, 22, 80 ,135) --  CV_APPTYPE_INFORMIX, CV_APPTYPE_ORACLE8, CV_APPTYPE_ORACLE_RAC, CV_APPTYPE_SAP_HANA
                THEN
                    CASE
                        WHEN LC.bWindows = 1
                            THEN IIF(RIGHT(LC.Folder, 1) IN ('/', '\'), LEFT(LC.Folder, LEN(LC.Folder)-1), LC.Folder) + '\' + MP.MountPathName + '\CV_MAGNETIC\CV_APP_DUMPS\' + CAST(BKP.GUID AS varchar(512))
                        ELSE
                            IIF(RIGHT(LC.Folder, 1) IN ('/', '\'), LEFT(LC.Folder, LEN(LC.Folder)-1), LC.Folder ) + '/' + MP.MountPathName + '/CV_MAGNETIC/CV_APP_DUMPS/' + CAST(BKP.GUID AS varchar(512))
                    END
                 ELSE
                    CASE
                        WHEN LC.bWindows = 1
                            THEN IIF(RIGHT(LC.Folder, 1) IN ('/', '\'), LEFT(LC.Folder, LEN(LC.Folder)-1), LC.Folder ) + '\' + MP.MountPathName + '\CV_MAGNETIC\CV_APP_DUMPS\' + CAST(APP.GUID AS varchar(512))
                        ELSE
                            IIF(RIGHT(LC.Folder, 1) IN ('/', '\'), LEFT(LC.Folder, LEN(LC.Folder)-1), LC.Folder ) + '/' + MP.MountPathName + '/CV_MAGNETIC/CV_APP_DUMPS/' + CAST(APP.GUID AS varchar(512))
                    END
                END
    FROM @logDumpingClientsToStorage LC, @ProxyTable PC, App_Client C (NOLOCK), SimInstalledPackages PKG (NOLOCK), App_Application APP (NOLOCK), App_BackupsetName BKP (NOLOCK), MMMountPath MP (NOLOCK)
    WHERE   LC.ClientId = PC.pseudoClientId
            AND PC.ProxyClientId = C.id
            AND PC.ProxyClientId = PKG.clientId                 -- the SIM table join should eliminate all virtual clients as they do not have package information.
            AND C.ReleaseId >= 16
            AND LC.MountPathId = MP.MountPathId
            AND LC.subClientId = APP.id
            AND APP.backupSet = BKP.id
UNION
-- 7. Add the media agents that access the local storage via DataServer IP
SELECT  C.id, C.name, C.net_hostname, C.GUID, L.MountPathId,L.folder
FROM    MMDevicecontroller DC (NOLOCK)
        INNER JOIN @locallyAttachedStorage L ON L.deviceid = DC.deviceid
        LEFT JOIN  APP_VMToPMMap MAP (NOLOCK) ON MAP.VMClientId = DC.clientId
        INNER JOIN APP_Client C (NOLOCK) ON C.id = ISNULL(MAP.PMClientId, DC.clientId)
DROP TABLE #pseudoClientApps

IF EXISTS (select * from GxQscripts where name = 'MMGetStorageAndClientAccessListfor3dfs')
	delete from GxQscripts where name = 'MMGetStorageAndClientAccessListfor3dfs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetStorageAndClientAccessListfor3dfs')
	delete from GXDBVersions where aliasname = 'MMGetStorageAndClientAccessListfor3dfs'
GO

insert into GXDBVersions values(2, 'MMGetStorageAndClientAccessListfor3dfs',  '00000000000000000000', 'MMGetStorageAndClientAccessListfor3dfs', '00000000000000000000')
GO

