

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMGetStorageAcceleratorCredentials.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2017  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMGetStorageAcceleratorCredentials.sp,v $ $Id: MMGetStorageAcceleratorCredentials.sp,v 1.1.2.1.4.1 2021/02/12 02:51:08 pveeravalli Exp $";
--
--  +=================================================================================================================================================+
--  |   Procedure:  MMGetStorageAcceleratorCredentials
--  |
--  |   Description:  Creates/Updates an association between credential and mountpathId
--  |
--  |   Input:  mountpathId
--  |
--  |   Output:  username and password
--  |
--  |   Notes:   Generate username and password based on storage accelartor credentials
--  |
--  |   Revisions  Author			Description
--  |   ---------  -----------		-------------------------------------------------------------------------------------------------
--  |   1.1        pveeravalli	 	Stored procedure to generate username and password based on storage accelartor credentials
--  +====================================================================================================================================================+
--
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='MMGetStorageAcceleratorCredentials')
BEGIN
	print '>>> Drop Stored Procedure: MMGetStorageAcceleratorCredentials <<<'
	drop procedure MMGetStorageAcceleratorCredentials
END
IF EXISTS (select * from GxQscripts where name='MMGetStorageAcceleratorCredentials')
	delete from GxQscripts where name = 'MMGetStorageAcceleratorCredentials'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetStorageAcceleratorCredentials')
	delete from GXDBVersions where aliasname = 'MMGetStorageAcceleratorCredentials'
GO
print '... Creating Procedure: MMGetStorageAcceleratorCredentials'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure MMGetStorageAcceleratorCredentials
  @i_mountpathId INTEGER
AS
  DECLARE @o_userName VARCHAR(1024)
  DECLARE @o_password VARCHAR(2048)
  DECLARE @o_deviceCtrlID INT
  DECLARE @o_isSecCredSet INT
SET NOCOUNT ON
DECLARE @secCredentialType INTEGER = 0
DECLARE @secCredId INTEGER = 0
DECLARE @secCredUserName     VARCHAR(1024)
DECLARE @deviceCtrlId INTEGER = 0
DECLARE @deviceCtrlCredentialAssocId INTEGER = 0
DECLARE @deviceId INTEGER = 0
DECLARE @primaryCredentialUsername	     VARCHAR(1024)
DECLARE @primaryUsername	     VARCHAR(1024)
DECLARE @primaryPassword         VARCHAR(2048)
SELECT @deviceId = deviceID  FROM MMMountPathToStorageDevice M WITH (READUNCOMMITTED)
WHERE M.MountpathId = @i_mountpathId
IF OBJECT_ID('tempdb.dbo.#deviceControllerTable') IS NOT NULL
    DROP TABLE #deviceControllerTable
CREATE TABLE #deviceControllerTable
(
    deviceControllerId INT,
    clientId INT,
    deviceId INT,
    deviceControllerActive INT,
    deviceControllerEnabled INT,
    SNRVolumeId INT,
    useCount INT,
userName VARCHAR(1024),
userPassword VARCHAR(2048),
folder VARCHAR(1024),
	deviceMounted INT,
	deviceAccessible INT,
	volumeRecoveryStatus INT,
	volumeRecoveryTime INT,
	volumeScsiReserved INT,
	DeviceAccessType INT,
	RMStatus INT,
	RMStatusUpdateTime INT,
	credentialAssocId INT
)
BEGIN
	INSERT INTO #deviceControllerTable ( deviceControllerId, clientId, deviceId, deviceControllerActive, deviceControllerEnabled, SNRVolumeId, useCount, userName, userPassword, folder, deviceMounted, deviceAccessible, volumeRecoveryStatus,	volumeRecoveryTime,	volumeScsiReserved,	DeviceAccessType, RMStatus,	RMStatusUpdateTime,	credentialAssocId)
        SELECT
                       TOP 1
           DC.DeviceControllerId,
		   DC.ClientId,
		   DC.DeviceId,
		   DC.DeviceControllerActive,
		   DC.DeviceControllerEnabled,
		   DC.SNRVolumeId,
		   DC.UseCount,
		   DC.UserName,
		   DC.UserPassword,
		   DC.Folder,
		   DC.DeviceMounted,
		   DC.DeviceAccessible,
		   DC.VolumeRecoveryStatus,
		   DC.VolumeRecoveryTime,
		   DC.VolumeScsiReserved,
		   DC.DeviceAccessType,
		   DC.RMStatus,
		   DC.RMStatusUpdateTime,
		   DC.CredentialAssocId
	FROM   MMDeviceController DC WITH(READUNCOMMITTED)
	        INNER JOIN MMHost H WITH(READUNCOMMITTED) ON DC.ClientId = H.ClientId
        	AND DC.DeviceAccessible = 1
			AND DC.DeviceId = @deviceId
	        AND DC.DeviceControllerEnabled = 1
        	AND H.MmHostEnabled = 1
ORDER BY case when ( DC.DeviceAccessType & 2 ) = 2 then 0 else 1 end
	BEGIN
		EXEC MMS2GetDeviceControllerCredentials
	END
	     SELECT  @deviceCtrlId = deviceControllerId,
		         @deviceCtrlCredentialAssocId = credentialAssocId ,
				 @primaryUsername = userName,
				 @primaryPassword = userPassword
		 FROM #deviceControllerTable
	IF OBJECT_ID('tempdb.dbo.#deviceControllerTable') IS NOT NULL
		DROP TABLE #deviceControllerTable
END
SELECT @secCredId = AC.credentialid, @secCredentialType = A.recordtype,
	   @secCredUserName = A.userName,
	   @o_password = dbo.pswConvertV5ToV3(A.password)
       FROM APP_CredentialAssoc AC WITH (READUNCOMMITTED)
	   INNER JOIN APP_Credentials  A WITH (READUNCOMMITTED) ON A.credentialId = AC.credentialId
WHERE AC.entityType = 185 AND AC.entityId = @deviceId
--If secondary credentials are not set then send username/Password like old way
IF @secCredId  =  0
 BEGIN
    --These values are set in SPB
    SELECT   @primaryUsername, @primaryPassword,@deviceCtrlId,0
 END
ELSE
 BEGIN
   DECLARE  @primaryCredentialType INTEGER = 0
DECLARE  @tempStr  VARCHAR(1024)
DECLARE  @proxyStr VARCHAR(255) = ''
   DECLARE  @index   INTEGER
   --@o_userName will have original username from devicecontroller
   SELECT @o_userName = LTRIM(RTRIM(username)) FROM MMDeviceController M WITH (READUNCOMMITTED)
   WHERE M.DeviceControllerId = @deviceCtrlId AND M.DeviceId = @deviceId
   SELECT @primaryCredentialType = A.recordType,
		  @primaryCredentialUsername = A.userName
	  FROM  APP_CredentialAssoc AC WITH (READUNCOMMITTED)
      INNER JOIN APP_Credentials A WITH (READUNCOMMITTED) ON AC.credentialId = A.credentialId
	  WHERE AC.assocId =  @deviceCtrlCredentialAssocId
	--This logic is to get proxy information
	SELECT @index = CHARINDEX('!!', reverse(@o_userName))
	DECLARE @len int = LEN(@o_userName)
	IF @index>0
	 BEGIN
       SELECT @proxyStr = SUBSTRING(@o_userName, @len - @index, @index)
	   SELECT @o_userName = SUBSTRING(@o_userName, 0, @len - @index)
	 END
    --Do this only for Azure if no credential set @ devicecontroller
IF (@primaryCredentialType = 0 AND (@secCredentialType = 4 OR @secCredentialType = 103))
	 BEGIN
		IF CHARINDEX('|-|IAM', @o_userName) > 0
			BEGIN
SELECT @primaryCredentialType = 18
			END
		ELSE IF CHARINDEX('|-|', @o_userName) > 0
		    BEGIN
SELECT @primaryCredentialType = -999
			END
		ELSE
		    BEGIN
SELECT @primaryCredentialType = 103
			END
	 END
	--     Azure                                                    Format                                                             Credential Manager
	--	 -----------------------------------------------------------------------------------------------------------------------------------------------------------
	--     Access key                                      <serviceHost>--<accountName>                                                  AccountName
	--     AD App 			                               <serviceHost>--<accountName>|-|<CMId>                                         CMId
	--     VM Role					                       <serviceHost>--<accountName>|-|IAM                                            Nothing
	--     AD App (Non CM)                                 <serviceHost>--<accountName>|-|<tenantId>|-|<appId>
IF (@secCredentialType = 4 OR @secCredentialType = 103)
          BEGIN
            IF (@primaryCredentialType = @secCredentialType)
                   BEGIN
SELECT  @o_userName = (CASE  WHEN (CHARINDEX('__CVCRED__', @o_userName) > 0
OR CHARINDEX('__CVCREDID__', @o_userName) > 0)
THEN REPLACE(REPLACE(@o_userName , '__CVCRED__', @secCredUserName), '__CVCREDID__', cast(@secCredId as varchar(10)))
                                ELSE @o_userName END)
                   END
            ELSE
                   BEGIN
IF (@primaryCredentialType = 103 AND @secCredentialType = 4)
                           BEGIN
                               SELECT @o_userName = CONCAT(@primaryUsername, '|-|',cast(@secCredId AS VARCHAR(10)))
						   END
ELSE IF (@primaryCredentialType = 4 AND @secCredentialType = 103)
                           BEGIN
                               SELECT @o_userName = REPLACE(@o_userName,'|-|__CVCREDID__','')
                           END
ELSE IF (@primaryCredentialType = 18)
                           BEGIN
IF (@secCredentialType = 103)
                               BEGIN
                                  SELECT @o_userName = REPLACE(@o_userName,'|-|IAM','')
                               END
ELSE IF (@secCredentialType = 4)
                               BEGIN
                                  SELECT @tempStr = CONCAT('|-|',CAST(@secCredId AS VARCHAR(10)))
								  SELECT @o_userName = REPLACE(@o_userName,'|-|IAM',@tempStr)
                               END
						   END
ELSE IF ( @primaryCredentialType = -999 )
						   BEGIN
IF (@secCredentialType = 103)
								  BEGIN
								     SELECT @o_userName = LEFT(@o_userName,CHARINDEX('|-|', @o_userName)-1)
								  END
ELSE IF (@secCredentialType = 4)
								  BEGIN
						   		     SELECT  @o_userName = LEFT(@o_userName,CHARINDEX('|-|', @o_userName)-1)
									 SELECT  @o_userName = CONCAT(@o_userName, '|-|',CAST(@secCredId AS VARCHAR(10)))
								  END
						   END
					END
		END
		ELSE
		    BEGIN
			  -- USERNAME
			  ---------------------------
			  --'blob.core.windows.net@2--dssl1qke2us00|-|__CVCREDID__'
			  --'https:--mmtest-tenant.hitachivm1.commvault.com--__CVCRED__'
			  DECLARE @lastIdx  INT
			  DECLARE @idx INT = CHARINDEX('://',@o_userName)
			  WHILE ( @idx > 0)
				BEGIN
					SELECT @lastIdx = @idx+3
					SELECT @idx = CHARINDEX('://',@o_userName,@lastIdx)
				END
              IF @lastIdx > 0
			    BEGIN
				   SELECT @idx = (CHARINDEX('//', @o_userName, @lastIdx))+1
				   SELECT @o_userName = LEFT(@o_userName,@idx)
				END
			  ELSE
  			    BEGIN
				   SELECT @o_userName = SUBSTRING(@o_userName,1,CHARINDEX('//',@o_userName)+1)
				END
IF ( @primaryCredentialType = 102 OR  @primaryCredentialType = 16 )
                BEGIN
						--Access key                                <serviceHost>--<accesskey>                                access key
						--IAM Role                                  <serviceHost>--IAM                                           N/A
						--STS Assume Role                           <serviceHost>--<ARN Role>|-|<accessKey>                      N/A
						--STS Assume Role with IAM                  <serviceHost>--<ARN Role>|-|IAM                            ARN Role
					    --C2S Access                                <serviceHost>--<URL>|-|<CertFileName>                        N/A
IF (@secCredentialType = 102)
                          BEGIN
                                SELECT  @o_userName = CONCAT(@o_userName, @secCredUserName)
                          END
ELSE IF (@secCredentialType = 16)
                          BEGIN
   							    SELECT  @o_userName = CONCAT(@o_userName, @secCredUserName ,'|-|IAM')
                          END
				END
ELSE IF (@primaryCredentialType = 119)
		        BEGIN
				   --Google                                              Format                                                             Credential Manager
				   ------------------------------------------------------------------------------------------------------------------------------------------------------
	               --Access key                                     <serviceHost>--<accesskey>                                                  access key
	               --Service account                                <serviceHost>--<project>|-|<email>|-|<certFileName>                         N/A
			       SELECT  @o_userName = CONCAT(@o_userName, @secCredUserName)
			     END
			  ELSE
			     -- Format for rest of cloud vendors which supports credential manager
			     BEGIN
			        SELECT  @o_userName = CONCAT(@o_userName,@secCredUserName)
			     END
		END
    --Append proxy information
    SELECT  @o_userName = CONCAT(@o_userName,@proxyStr)
	SELECT @o_userName,@o_password,@deviceCtrlId,1
 END
SET NOCOUNT OFF;
GO

IF EXISTS (select * from GxQscripts where name = 'MMGetStorageAcceleratorCredentials')
	delete from GxQscripts where name = 'MMGetStorageAcceleratorCredentials'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetStorageAcceleratorCredentials')
	delete from GXDBVersions where aliasname = 'MMGetStorageAcceleratorCredentials'
GO

insert into GXDBVersions values(2, 'MMGetStorageAcceleratorCredentials',  'v1.1.2.1.4.1', 'MMGetStorageAcceleratorCredentials', 'v1.1.2.1.4.1')
GO

