

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMGetSiloVolRecallInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMGetSiloVolRecallInfo.sp,v $ $Id: MMGetSiloVolRecallInfo.sp,v 1.18.194.2 2018/03/20 00:18:27 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMGetSiloVolRecallInfo <<<'

IF EXISTS (select * from sysobjects where name='MMGetSiloVolRecallInfo')
	drop procedure MMGetSiloVolRecallInfo
IF EXISTS (select * from GxQscripts where name='MMGetSiloVolRecallInfo')
	delete from GxQscripts where name = 'MMGetSiloVolRecallInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetSiloVolRecallInfo')
	delete from GXDBVersions where aliasname = 'MMGetSiloVolRecallInfo'
GO
print '... Creating Procedure: MMGetSiloVolRecallInfo'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMGetSiloVolRecallInfo
  @i_siloVolumeId INTEGER,
  @i_commCellId INTEGER,
  @i_mountPathId INTEGER,
  @i_copyPrecedence INTEGER,
  @i_includeAgedData INTEGER,
  @i_preferMagnetic INTEGER,
  @i_preferAccessible INTEGER
AS
  DECLARE @o_errorCode INTEGER
  DECLARE @o_clientId INTEGER
  DECLARE @o_clientName VARCHAR(255)
  DECLARE @o_appTypeId INTEGER
  DECLARE @o_appTypeName VARCHAR(255)
  DECLARE @o_instanceId INTEGER
  DECLARE @o_instanceName VARCHAR(255)
  DECLARE @o_backupSetId INTEGER
  DECLARE @o_backupSetName VARCHAR(255)
  DECLARE @o_migrateStartTime INTEGER
  DECLARE @o_migrateEndTime INTEGER
  DECLARE @o_srcArchFileId INTEGER
  DECLARE @o_srcCommCellId INTEGER
  DECLARE @o_srcCopyId INTEGER
  DECLARE @o_galaxyUserName VARCHAR(255)
  DECLARE @o_galaxyUserPassword VARCHAR(255)
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
SET	@o_errorCode		= 0
SET	@o_migrateStartTime	= 0
SET	@o_migrateEndTime	= 0
SET	@o_srcArchFileId	= 0
SET	@o_srcCommCellId	= 0
SET	@o_srcCopyId		= 0
DECLARE	@l_SIDBStoreId	INT
DECLARE	@l_MountPathTypeId	INT
DECLARE	@l_LibraryId	INT
DECLARE	@l_siloCopyId	INT
DECLARE	@l_archGroupId	INT
DECLARE	@l_siloAppId	INT
DECLARE	@l_clientId		INT
SET	@l_SIDBStoreId		= -1
SET	@l_MountPathTypeId	= -1
SET	@l_LibraryId		= -1
SET	@l_siloCopyId		= -1
SET	@l_archGroupId		= -1
SET	@l_siloAppId		= -1
SET	@l_clientId			= -1
IF @i_commCellId = 2
	SELECT	@l_SIDBStoreId = V.SIDBStoreId, @l_MountPathTypeId = MP.MountPathTypeId, @l_LibraryId = MP.LibraryId
	FROM	MMVolume V WITH (NOLOCK), MMMountPath MP WITH (NOLOCK)
	WHERE	V.VolumeId = @i_siloVolumeId
		AND V.MediaSideId = MP.MediaSideId AND (@i_mountPathId = 0 OR MP.MountPathId = @i_mountPathId)
ELSE
IF @i_commCellId > 2
	SELECT	@i_siloVolumeId = V.VolumeId, @l_SIDBStoreId = V.SIDBStoreId, @l_MountPathTypeId = MP.MountPathTypeId, @l_LibraryId = MP.LibraryId
	FROM	MMVolume V WITH (NOLOCK), MMMountPath MP WITH (NOLOCK)
	WHERE	V.origCCvolumeId = @i_siloVolumeId AND V.origCCcommCellID = @i_commCellId AND V.origCCcommCellID > 2
		AND V.MediaSideId = MP.MediaSideId AND (@i_mountPathId = 0 OR MP.MountPathId = @i_mountPathId)
IF @l_SIDBStoreId = -1
BEGIN
SET @o_errorCode = 56000
	goto FINISH
END
SELECT	TOP 1 @l_siloCopyId = CopyId
FROM	archCopySIDBStore WITH (NOLOCK)
WHERE	SIDBStoreId = @l_SIDBStoreId
IF 	@l_siloCopyId = -1
BEGIN
SET @o_errorCode = 56001
	goto FINISH
END
SELECT	@l_archGroupId = archGroupId, @l_siloAppId = siloAppId, @l_clientId = siloRestoreClientId
FROM	archGroupCopy WITH (NOLOCK)
WHERE	id = @l_siloCopyId
IF 	@l_clientId <= 0
BEGIN
	IF @l_MountPathTypeId = 0/*MOUNT_PATH_MAGNETIC*/
		SELECT	TOP 1 @l_clientId = H.ClientId
		FROM	MMLibraryController LC WITH (NOLOCK), MMHost as H WITH (NOLOCK)
		WHERE	LC.LibraryId = @l_LibraryId
			AND LC.LibraryControllerActive = 1 AND LC.LibraryControllerEnabled = 1
			AND	H.ClientId = LC.ClientId AND H.MmHostEnabled = 1 and H.MmHostSoftState = 1
	ELSE
		SELECT	TOP 1 @l_clientId = H.ClientId
		FROM	MMMountPathToStorageDevice MPSD WITH (NOLOCK), MMDevice D WITH (NOLOCK),
				MMDeviceController DC WITH (NOLOCK), MMHost as H WITH (NOLOCK)
		WHERE	MPSD.MountPathId = @i_mountPathId
			AND D.DeviceId = MPSD.DeviceId AND D.DeviceEnabled = 1 AND D.DeviceBroken = 0
			AND DC.DeviceId = D.DeviceId AND DC.DeviceControllerEnabled = 1 AND DC.DeviceAccessible = 1 AND (DC.DeviceAccessType & 2) = 2
			AND H.ClientId = DC.ClientId AND H.MmHostEnabled = 1 and H.MmHostSoftState = 1
	IF 	@l_clientId <= 0
	BEGIN
SET @o_errorCode = 56002
		goto FINISH
	END
END
DECLARE	@tblAF	TABLE (archFileId INT, commCellId INT, jobId INT)
DECLARE	@l_firstJobId	INT
DECLARE	@l_lastJobId	INT
INSERT	INTO @tblAF
SELECT	AF.id, AF.commCellId, AF.jobId
FROM	archFileSiloVolume AFS WITH (NOLOCK), archFile AF WITH (NOLOCK)
WHERE	AFS.siloVolumeId = @i_siloVolumeId
	AND AFS.archFileId = AF.id AND AFS.commCellId = AF.commCellId AND AF.isValid = 1
SELECT	TOP 1 @o_srcArchFileId = archFileId, @o_srcCommCellId = commCellId, @l_firstJobId = jobId
FROM	@tblAF
ORDER BY archFileId ASC
SELECT	TOP 1 @l_lastJobId = jobId
FROM	@tblAF
ORDER BY archFileId DESC
SELECT	TOP 1 @o_migrateStartTime = cTime
FROM	archFile WITH (NOLOCK)
WHERE	jobId = @l_firstJobId AND commCellId = @o_srcCommCellId AND isValid = 1
ORDER BY cTime
SELECT	@o_migrateEndTime = cTime
FROM	archFile WITH (NOLOCK)
WHERE	jobId = @l_lastJobId AND commCellId = @o_srcCommCellId
	AND fileType = 2 AND isValid = 1
IF @o_srcArchFileId = 0
BEGIN
SET @o_errorCode = 56003
	goto FINISH
END
IF @i_copyPrecedence = 0 AND (@i_preferMagnetic <> 0 OR @i_preferAccessible <> 0)
BEGIN
	DECLARE @l_error		INT
	DECLARE @l_AFC_isValid	INT
	DECLARE @l_AFC_flags	INT
	EXEC	@o_errorCode = archFileCopyPreferred @o_srcArchFileId, @o_srcCommCellId, @i_includeAgedData, @i_preferMagnetic, @i_preferAccessible,
			@o_srcCopyId OUTPUT, @l_AFC_isValid OUTPUT, @l_AFC_flags OUTPUT
	SELECT @l_error = @@ERROR
	IF @l_error <> 0
		SET @o_errorCode = @l_error
END
ELSE
BEGIN
	SELECT	TOP 1 @o_srcCopyId = AFC.archCopyId
	FROM	archFile AF WITH (NOLOCK), archFileCopy AFC WITH (NOLOCK), archGroupCopy AGC WITH (NOLOCK)
	WHERE	AFC.archFileId = @o_srcArchFileId AND AFC.commCellId = @o_srcCommCellId AND AFC.archCopyId = AGC.id AND AFC.isValid > 0
AND (@i_includeAgedData <> 0 OR (AFC.flags & 256) = 0)
		AND AGC.type <> 5 -- SELECT only none transitive copy files/chunks for restore, CVA_AGCOPYTYPE_TRANSITIVE = 5
AND ( (@i_copyPrecedence = -1 AND AGC.id IN (SELECT defaultCopy FROM archGroup WITH (NOLOCK)))
OR @i_copyPrecedence = 0
			OR @i_copyPrecedence = AGC.copy )
		AND AF.id = @o_srcArchFileId AND AF.commCellId = @o_srcCommCellId
	ORDER BY AGC.copy ASC
	SELECT @o_errorCode = @@ERROR
END
IF @o_srcCopyId = 0 AND @o_errorCode = 0
BEGIN
	IF NOT EXISTS (SELECT * FROM archFileCopy WITH (NOLOCK), archGroupCopy AGC WITH (NOLOCK)
					WHERE archFileId = @o_srcArchFileId AND commCellId = @o_srcCommCellId AND isValid > 0
						  AND archCopyId = AGC.id
						  AND AGC.type <> 5 -- SELECT only none transitive copy files/chunks for restore, CVA_AGCOPYTYPE_TRANSITIVE = 5
						  )
SET @o_errorCode = 56004
	ELSE
	IF @i_copyPrecedence = 0 AND @i_includeAgedData = 0
SET @o_errorCode = 56005
	ELSE
	IF @i_copyPrecedence <> 0 AND @i_includeAgedData <> 0
SET @o_errorCode = 56006
	ELSE
	IF @i_copyPrecedence <> 0 AND @i_includeAgedData = 0
SET @o_errorCode = 56007
END
FINISH:
IF @o_srcCopyId > 0
	SELECT	@o_errorCode,
			@l_clientId,	(SELECT name FROM APP_Client WITH (NOLOCK) WHERE id = @l_clientId),
			APP.appTypeId,	(SELECT name FROM APP_iDAType WITH (NOLOCK) WHERE type = APP.appTypeId),
			APP.instance,	(SELECT name FROM APP_instanceName WITH (NOLOCK) WHERE id = APP.instance),
			APP.backupset,	(SELECT name FROM APP_BackupsetName WITH (NOLOCK) WHERE id = APP.backupset),
			@o_migrateStartTime,
			@o_migrateEndTime,
			@o_srcArchFileId,
			@o_srcCommCellId,
			@o_srcCopyId,
			U.login,
			U.password
	FROM	APP_Application APP WITH (NOLOCK), (SELECT TOP 1 login, password FROM UMUsers WITH (NOLOCK) WHERE id > 0) U
	WHERE	id = @l_siloAppId
ELSE
	SELECT	@o_errorCode, 0, '', 0, '', 0, '', 0, '', 0, 0, 0, 0, 0, 0, 0
RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'MMGetSiloVolRecallInfo')
	delete from GxQscripts where name = 'MMGetSiloVolRecallInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetSiloVolRecallInfo')
	delete from GXDBVersions where aliasname = 'MMGetSiloVolRecallInfo'
GO

insert into GXDBVersions values(2, 'MMGetSiloVolRecallInfo',  '00010018019400020000', 'MMGetSiloVolRecallInfo', '00010018019400020000')
GO

