

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMGetSiloVolInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMGetSiloVolInfo.sp,v $ $Id: MMGetSiloVolInfo.sp,v 1.14.34.1 2018/03/20 00:12:25 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMGetSiloVolInfo <<<'

IF EXISTS (select * from sysobjects where name='MMGetSiloVolInfo')
	drop procedure MMGetSiloVolInfo
IF EXISTS (select * from GxQscripts where name='MMGetSiloVolInfo')
	delete from GxQscripts where name = 'MMGetSiloVolInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetSiloVolInfo')
	delete from GXDBVersions where aliasname = 'MMGetSiloVolInfo'
GO
print '... Creating Procedure: MMGetSiloVolInfo'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMGetSiloVolInfo
  @i_siloVolumeId INTEGER,
  @i_mountPathId INTEGER,
  @i_commCellId INTEGER
AS
  DECLARE @o_volumeId INTEGER
  DECLARE @o_siloStoreId INTEGER
  DECLARE @o_volumeSiloStatus INTEGER
  DECLARE @o_mountPathId INTEGER
  DECLARE @o_transformedMPID INTEGER
  DECLARE @o_transformedMPCCId INTEGER
  DECLARE @o_copyId INTEGER
  DECLARE @o_copyFlags INTEGER
  DECLARE @o_dedupeFlags INTEGER
  DECLARE @o_CommCellNumber INTEGER
  DECLARE @o_ccGUID NVARCHAR(256)
  DECLARE @o_storeFlags INTEGER
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE	@l_MediaSideId		INT
DECLARE	@l_MediaGroupId		INT
DECLARE	@l_SIDBStoreId		INT
DECLARE	@l_SiloStatus		INT
DECLARE	@l_CurrMountPathId	INT
DECLARE	@l_CopyId		INT
DECLARE @l_storeFlags		INT
SET @l_CopyId = 0
IF	@i_commCellId = 2
	SELECT	@l_MediaSideId = MediaSideId, @l_MediaGroupId = MediaGroupId,
			@l_SIDBStoreId = SIDBStoreId, @l_SiloStatus = SiloStatus, @l_CurrMountPathId = CurrMountPathId
	FROM	MMVolume WITH (NOLOCK)
	WHERE	VolumeId = @i_siloVolumeId
ELSE
IF	@i_commCellId > 2
	SELECT	@l_MediaSideId = MediaSideId, @l_MediaGroupId = MediaGroupId,
			@l_SIDBStoreId = SIDBStoreId, @l_SiloStatus = SiloStatus, @l_CurrMountPathId = CurrMountPathId
	FROM	MMVolume WITH (NOLOCK)
	WHERE	origCCvolumeId = @i_siloVolumeId
IF	@l_MediaGroupId > 0
	SELECT	@l_CopyId = archGroupCopyId FROM archStream WITH (NOLOCK) WHERE mediaGroupId = @l_MediaGroupId
ELSE
IF	@l_SIDBStoreId > 0
BEGIN
	SELECT	@l_CopyId = CopyId FROM archCopySIDBStore WITH (NOLOCK) WHERE SIDBStoreId = @l_SIDBStoreId
	IF @@ROWCOUNT <> 1
		SET @l_CopyId = 0
END
--If volume with this storeId exists, then Store entry must also exist.
SELECT @l_storeFlags = flags FROM IdxSIDBStore WITH (NOLOCK) WHERE SIDBStoreId = @l_SIDBStoreId
IF @l_CopyId = 0
	SELECT	TOP 1 @l_CopyId = ACM.archCopyId FROM archChunk AC WITH (NOLOCK), archChunkMapping ACM WITH (NOLOCK)
	WHERE	AC.volumeId = @i_siloVolumeId
		AND ACM.archChunkId = AC.id AND ACM.chunkCommCellId = AC.commCellId
SELECT	@i_siloVolumeId, @l_SIDBStoreId, @l_SiloStatus, MP.MountPathId,
		@l_CurrMountPathId, (SELECT origCCcommCellID FROM MMMountPath WITH (NOLOCK) WHERE MountPathId = @l_CurrMountPathId),
		@l_CopyId, AGC.flags, AGC.dedupeFlags,
		CC.number, CC.csGUID, @l_storeFlags
FROM	MMMountPath MP WITH (NOLOCK), archGroupCopy AGC WITH (NOLOCK), APP_CommCell CC WITH (NOLOCK)
WHERE	MP.MediaSideId = @l_MediaSideId AND (@i_mountPathId = 0 OR MP.MountPathId = @i_mountPathId)
	AND AGC.id = @l_CopyId
	AND CC.id = @i_commCellId
RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'MMGetSiloVolInfo')
	delete from GxQscripts where name = 'MMGetSiloVolInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetSiloVolInfo')
	delete from GXDBVersions where aliasname = 'MMGetSiloVolInfo'
GO

insert into GXDBVersions values(2, 'MMGetSiloVolInfo',  '00010014003400010000', 'MMGetSiloVolInfo', '00010014003400010000')
GO

