

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMGetSiloVolForCleanup.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
--	Author: Jun Lu
--	Date:   04/26/2003
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMGetSiloVolForCleanup.sp,v $ $Id: MMGetSiloVolForCleanup.sp,v 1.31.12.7 2019/04/18 21:31:04 chandru Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MMGetSiloVolForCleanup')
BEGIN
	print '>>> Drop Stored Procedure: MMGetSiloVolForCleanup <<<'
	drop procedure MMGetSiloVolForCleanup
END
IF EXISTS (select * from GxQscripts where name='MMGetSiloVolForCleanup')
	delete from GxQscripts where name = 'MMGetSiloVolForCleanup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetSiloVolForCleanup')
	delete from GXDBVersions where aliasname = 'MMGetSiloVolForCleanup'
GO
print '... Creating Procedure: MMGetSiloVolForCleanup'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMGetSiloVolForCleanup
  @i_dummy int
AS
  DECLARE @o_HostClientId integer
  DECLARE @o_MountPathId integer
  DECLARE @o_MountPathName NVARCHAR(1024)
  DECLARE @o_UserName varchar(1024)
  DECLARE @o_UserPassword varchar(2048)
  DECLARE @o_SIDBStoreId integer
  DECLARE @o_VolumeId integer
  DECLARE @o_CommCellId integer
  DECLARE @o_LastRestoreTime integer
  DECLARE @o_SpaceToFreeMB integer
  DECLARE @o_transformedMPID integer
  DECLARE @o_transformedMPCCId integer
  DECLARE @o_MountPathTotalSpaceMB integer
  DECLARE @o_MountPathFreeSpaceMB integer
  DECLARE @o_LibraryThresholdPerc integer
  DECLARE @o_LibraryThresholdVariation integer
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE	@HrsKeepRestoredVol	INT
DECLARE	@MaxRestoredTime	INT
SET		@HrsKeepRestoredVol = 6
SELECT	@HrsKeepRestoredVol = value
FROM	MMConfigs
WHERE	name = 'MMCONFIG_SILO_KEEP_RESTORED_VOLUMES_HOURS'
SET		@MaxRestoredTime	= (dbo.GetUnixTime(GETUTCDATE()) - 3600*@HrsKeepRestoredVol)
DECLARE @t_CopyId			integer = 0
DECLARE @t_silosInCache		integer = 0
DECLARE @t_SIDBStoreId		integer = 0
DECLARE @t_LibraryId		integer = 0
DECLARE @l_LibraryId		integer = 0
DECLARE @t_MountPathId		integer = 0
DECLARE @l_MountPathId		integer = 0
DECLARE @l_VolumeId			integer = 0
DECLARE @l_PhysicalBytesMB	bigint  = 0
DECLARE @l_MPTotalSpaceMB	bigint  = 0
DECLARE @l_MPFreeSpaceMB	bigint  = 0
DECLARE @l_SpaceToFreeMB	bigint  = 0
DECLARE @l_TotalBytesMB		bigint  = 0
CREATE	TABLE #SiloStore (SIDBStoreId INT, CopyId INT)
CREATE	TABLE #SiloMountPath (ClientId INT, MountPathId INT, MPAttribute INT,
		MountPathName nvarchar(1024), UserName varchar(1024), UserPassword varchar(2048),
		MountPathTypeId INT, MediaSideId INT, LibraryId INT, MPTotalSpaceMB BIGINT, MPFreeSpaceMB BIGINT)
CREATE	TABLE #SiloLibrary (LibraryId INT, LibThreshPerc INT, LibVariation INT,
		LibTotalSpaceMB BIGINT, LibFreeSpaceMB BIGINT)
CREATE	TABLE #SiloVolume (MountPathId INT, SIDBStoreId INT, VolumeId INT, CommCellId INT, PhysicalBytesMB BIGINT,
		LastBackupTime INT, LastRestoreTime INT, TransformedMPId INT, TransformedCCId INT)
CREATE	TABLE #JobsInSiloVolume (VolumeId INT, jobId INT, commCellId INT, fileType INT, CIFlags INT,
		archGroupId INT, archCopyId INT, DVFlags INT)
CREATE	TABLE #DelVolume (VolumeId INT, SpaceToFreeMB INT)
CREATE	TABLE #MountPathHost (ClientId INT, MountPathId INT,
		MountPathName nvarchar(1024), UserName varchar(1024), UserPassword varchar(2048), CredentialAssocId INT)
INSERT	INTO #SiloStore
SELECT	DISTINCT S.SIDBStoreId, S.CopyId
FROM	archCopySIDBStore S WITH (NOLOCK), archGroupCopy C WITH (NOLOCK), IdxSIDBStore I WITH (NOLOCK)
WHERE	C.id = S.CopyId
	AND S.SIDBStoreId = I.SIDBStoreId
AND (C.dedupeFlags & 16777216) <> 0
	--AND (C.dedupeFlags & CVA_BACKUP_SILO_ENABLED_FLAG) <> 0
AND (I.flags & 2097152) <> 0
DECLARE	GetCopyCur CURSOR FOR
SELECT	C.id, C.silosInCache, S.SIDBStoreId
FROM	archGroupCopy C WITH (NOLOCK), archCopySIDBStore S WITH (NOLOCK), #SiloStore T
WHERE	C.id = S.copyId
AND (dedupeFlags & 16777216) <> 0
	--AND (dedupeFlags & CVA_BACKUP_SILO_ENABLED_FLAG) <> 0
AND (dedupeFlags & 4194304) <> 0
AND (S.Flags & 4) > 0
	AND S.copyId = T.copyId
OPEN	GetCopyCur
	FETCH NEXT FROM GetCopyCur INTO @t_CopyId, @t_silosInCache, @t_SIDBStoreId
WHILE @@FETCH_STATUS = 0
BEGIN
	DELETE	#SiloStore
	FROM	(SELECT	TOP (@t_silosInCache) SIDBStoreId
			FROM	archCopySIDBStore S WITH (NOLOCK)
			WHERE	CopyId = @t_CopyId
			ORDER BY SIDBStoreId DESC) T
	WHERE	#SiloStore.SIDBStoreId = T.SIDBStoreId
	DELETE	#SiloStore
	WHERE	#SiloStore.SIDBStoreId = @t_SIDBStoreId
	FETCH NEXT FROM GetCopyCur INTO @t_CopyId, @t_silosInCache, @t_SIDBStoreId
END
CLOSE	GetCopyCur
DEALLOCATE	GetCopyCur
-- MR 53156: SILO disc celanup should be disabled on the store which is getting recontructed.
DELETE #SiloStore
FROM	#SiloStore STORES, JMJobInfo JMINFO WITH (READUNCOMMITTED), TM_JobOptions TMINFO WITH (READUNCOMMITTED)
WHERE JMINFO.OpType = 80 /* DEDUPDBSYNC */
	AND TMINFO.jobid = JMINFO.JobId
	AND TMINFO.optionid = 1777365717 /* DEDUPDBSYNCOPTION__SIDBSTORE_ID */
	AND TMINFO.value = STORES.SIDBStoreId
INSERT	INTO #SiloMountPath
SELECT	0, MP.MountPathId, MP.Attribute, MP.MountPathName, MP.UserName, MP.UserPassword, MP.MountPathTypeId, MP.MediaSideId, MP.LibraryId,
		MS.TotalSpaceMB, MS.FreeBytesMB
FROM	MMMountPath MP WITH (NOLOCK), MMMediaSide MS WITH (NOLOCK)
WHERE	MP.MediaSideId = MS.MediaSideId
	AND MP.isEnabled = 1 AND MP.isOffline = 0
AND (MP.Attribute & 8) = 8
INSERT	INTO #SiloLibrary
SELECT	L.LibraryId, L.ThresholdPercentage, L.ThresholdVariation, SUM(MP.MPTotalSpaceMB), SUM(MP.MPFreeSpaceMB)
FROM	#SiloMountPath MP, MMLibrary L WITH (NOLOCK)
WHERE	MP.LibraryId = L.LibraryId
GROUP BY L.LibraryId, L.ThresholdPercentage, L.ThresholdVariation
INSERT	INTO #SiloVolume
SELECT	MP.MountPathId, V.SIDBStoreId, V.VolumeId, V.PhysicalBytesMB, V.OrigCcCommCellId, V.LastBackupTime, V.LastRestoreTime, V.CurrMountPathId, 0
FROM	#SiloMountPath MP, #SiloLibrary L, MMVolume V WITH (NOLOCK), #SiloStore S
WHERE	MP.LibraryId = L.LibraryId
AND (MP.MPAttribute & 2) = 0
 	AND L.LibFreeSpaceMB < L.libTotalSpaceMB*(100 - L.LibThreshPerc)/100
	AND V.MediaSideId = MP.MediaSideId
	AND V.VolumeFlags IN (2, 6)/*VOL_FULL, VOL_RECYCLE*/
	AND V.SiloStatus  = 2/*SILO_VOLUME_MIGRATED*/
	AND V.SIDBStoreId = S.SIDBStoreId AND V.SIDBStoreId > 0
	AND V.LastRestoreTime < @MaxRestoredTime
INSERT	INTO #SiloVolume
SELECT	MP.MountPathId, V.SIDBStoreId, V.VolumeId, V.PhysicalBytesMB, V.OrigCcCommCellId, V.LastBackupTime, V.LastRestoreTime, V.CurrMountPathId, 0
FROM	#SiloMountPath MP, #SiloLibrary L, MMVolume V WITH (NOLOCK), #SiloStore S
WHERE	MP.LibraryId = L.LibraryId
AND (MP.MPAttribute & 2) <> 0
	AND MP.MPFreeSpaceMB*100 < MP.MPTotalSpaceMB*(100 - L.LibThreshPerc)
	AND V.CurrMountPathId = MP.MountPathId
	AND V.VolumeFlags IN (2, 6)/*VOL_FULL, VOL_RECYCLE*/
	AND V.SiloStatus  = 2/*SILO_VOLUME_MIGRATED*/
	AND V.SIDBStoreId = S.SIDBStoreId AND V.SIDBStoreId > 0
	AND V.LastRestoreTime < @MaxRestoredTime
-- Update the Transformed MP CCId in the temp table.
UPDATE	#SiloVolume
SET		TransformedCCId = MP.origCCcommCellID
FROM	MMMountPath MP WITH (READUNCOMMITTED)
WHERE	TransformedMPId = MP.MountPathId
-- Exclude source volumes for Auxiliary Copy, Content Indexing and Data Verification
INSERT	INTO #JobsInSiloVolume
SELECT	V.VolumeId, AF.jobId, AF.commCellId, AF.fileType, MAX(AF.flags & (16 | 32)),
AF.archGroupId, ACM.archCopyId, MAX(ACM.flags & 1)
FROM	#SiloVolume V, archChunk AC, archChunkMapping ACM, archFile AF
WHERE	ACM.archChunkId = AC.id AND ACM.chunkCommCellId = AC.commCellId
	AND AC.volumeId = V.VolumeId
	AND AF.id = ACM.archFileId AND AF.commCellId = ACM.commCellId AND AF.isValid = 1
GROUP BY V.VolumeId, AF.jobId, AF.commCellId, AF.fileType, AF.archGroupId, ACM.archCopyId
UPDATE	#JobsInSiloVolume
SET		CIFlags = 0
FROM	#JobsInSiloVolume J LEFT JOIN archContentIndexingRules R
		ON J.archGroupId = R.archGroupId AND R.enabled > 0 AND (R.sourceCopyId = 0 OR R.sourceCopyId = J.archCopyId)
WHERE	J.CIFlags > 0 AND R.archGroupId IS NULL AND R.operationType = 1
DELETE	#SiloVolume
WHERE	VolumeId IN (SELECT DISTINCT VolumeId FROM #JobsInSiloVolume WHERE (CIFlags > 0 OR DVFlags > 0))
DELETE	#SiloVolume
WHERE	VolumeId IN (
		SELECT	DISTINCT JSV.VolumeId
		FROM	#JobsInSiloVolume JSV, JMJobDataStats JDS WITH (NOLOCK), archGroupCopy AGC WITH (NOLOCK), archGroup AG WITH (NOLOCK)
		WHERE	JDS.jobId = JSV.jobId AND JDS.commCellId = JSV.commCellId AND JDS.dataType = JSV.fileType
			AND JDS.archGrpId = JSV.archGroupId AND JDS.archGrpCopyId <> JSV.archCopyId
			AND JDS.status IN (101, 102, 103) AND (JDS.disabled & (1+256)) = 0
			AND AG.id = JDS.archGrpId
			AND AGC.id = JDS.archGrpCopyId
			AND (AGC.sourceCopyId = JSV.archCopyId OR AGC.sourceCopyId = 0 AND AG.defaultCopy = JSV.archCopyId))
-- Exclude volumes migrated by active backup SILO jobs
DELETE	#SiloVolume
WHERE	VolumeId IN (
		SELECT	DISTINCT SV.VolumeId
		FROM	#SiloVolume SV, archFileSiloVolume AFSV WITH (NOLOCK), archFile AF WITH (NOLOCK), JMJobInfo J WITH (NOLOCK)
		WHERE	AFSV.siloVolumeId = SV.VolumeId
			AND AFSV.archFileId = AF.id AND AFSV.commCellId = AF.commCellId
			AND AF.jobId = J.jobId AND AF.commCellId = J.commCellId)
-- If SILO-Backup-End-Time(VolId) > Most-recent-DR-Backup-Start-Time,
-- exclude that volume. This is to ensure that we have atleast one
-- DR backup that has the media details for the SILO-ed data.
-- This is our best case effort to make sure the SILO data on tape isnt orphaned.
IF EXISTS (SELECT value FROM MMConfigs WHERE name = 'MMS2_STALL_SILO_CLEANUP_UNTIL_DRBACKUP' AND value = 1)
BEGIN
	DECLARE @LastDRBackupTime INT
	SELECT TOP 1 @LastDRBackupTime = JOB.ServStart
		FROM JMAdminJobStatsTable JOB
		-- Successful full DR backup job from this CS.
		WHERE JOB.OpType = 11 AND Job.ER_BkpLevel = 1 AND
		JOB.CommcellId = 2 AND
		JOB.status = 1
		ORDER BY JOB.JobId DESC
	DELETE	#SiloVolume
	WHERE	VolumeId IN (
				SELECT DISTINCT SV.VolumeId
				FROM #SiloVolume SV, ArchFileSiloVolume AFSV WITH (NOLOCK), ArchFile AF WITH (NOLOCK), JMBkpStats BKP
				WHERE	SV.VolumeId = AFSV.SiloVolumeId AND
						AFSV.ArchFileId = AF.Id AND AFSV.CommcellId = AF.CommcellId AND
						AF.JobId = BKP.JobId AND AF.CommcellId = BKP.CommcellId AND
						BKP.servEndDate > ISNULL (@LastDRBackupTime, 0))
END
DECLARE	GetVolCur CURSOR FOR
SELECT	V.VolumeId, V.PhysicalBytesMB, MP.LibraryId
FROM	#SiloVolume V, #SiloMountPath MP
WHERE	V.MountPathId = MP.MountPathId
AND (MP.MPAttribute & 2) = 0
ORDER BY MP.LibraryId, V.LastRestoreTime, V.LastBackupTime
OPEN	GetVolCur
	FETCH NEXT FROM GetVolCur INTO @l_VolumeId, @l_PhysicalBytesMB, @l_LibraryId
WHILE @@FETCH_STATUS = 0
BEGIN
	IF	@t_LibraryId <> @l_LibraryId
	BEGIN
		SET @t_LibraryId  = @l_LibraryId
		SET @l_TotalBytesMB = 0
		SELECT	@l_SpaceToFreeMB = LibTotalSpaceMB*(100 - LibThreshPerc + LibVariation)/100 - LibFreeSpaceMB
		FROM	#SiloLibrary
		WHERE	LibraryId = @l_LibraryId
	END
	SET @l_TotalBytesMB = @l_TotalBytesMB + @l_PhysicalBytesMB
	IF (@l_TotalBytesMB < @l_SpaceToFreeMB)
		INSERT	INTO #DelVolume
		SELECT	@l_VolumeId, @l_TotalBytesMB
	FETCH NEXT FROM GetVolCur INTO @l_VolumeId, @l_PhysicalBytesMB, @l_LibraryId
END
CLOSE	GetVolCur
DEALLOCATE	GetVolCur
-- Handle Restore Only Mount Paths
DECLARE	GetVolCur2 CURSOR FOR
SELECT	V.VolumeId, V.PhysicalBytesMB, MP.LibraryId, MP.MountPathId, MP.MPTotalSpaceMB, MP.MPFreeSpaceMB
FROM	#SiloVolume V, #SiloMountPath MP
WHERE	V.MountPathId = MP.MountPathId
AND (MP.MPAttribute & 2) <> 0
ORDER BY MP.LibraryId, MP.MountPathId, V.LastRestoreTime, V.LastBackupTime
OPEN	GetVolCur2
	FETCH NEXT FROM GetVolCur2 INTO @l_VolumeId, @l_PhysicalBytesMB, @l_LibraryId, @l_MountPathId, @l_MPTotalSpaceMB, @l_MPFreeSpaceMB
WHILE @@FETCH_STATUS = 0
BEGIN
	IF	@t_MountPathId <> @l_MountPathId
	BEGIN
		SET @t_MountPathId= @l_MountPathId
		SET @l_TotalBytesMB = 0
		SELECT	@l_SpaceToFreeMB = @l_MPTotalSpaceMB*(100 - LibThreshPerc + LibVariation)/100 - @l_MPFreeSpaceMB
		FROM	#SiloLibrary
		WHERE	LibraryId = @l_LibraryId
	END
	SET @l_TotalBytesMB = @l_TotalBytesMB + @l_PhysicalBytesMB
	IF (@l_TotalBytesMB < @l_SpaceToFreeMB)
		INSERT	INTO #DelVolume
		SELECT	@l_VolumeId, @l_TotalBytesMB
	FETCH NEXT FROM GetVolCur2 INTO @l_VolumeId, @l_PhysicalBytesMB, @l_LibraryId, @l_MountPathId, @l_MPTotalSpaceMB, @l_MPFreeSpaceMB
END
CLOSE	GetVolCur2
DEALLOCATE	GetVolCur2
IF EXISTS (SELECT * FROM #SiloMountPath WHERE MountPathTypeId = 0/*MOUNT_PATH_MAGNETIC*/)
BEGIN
	INSERT	INTO #MountPathHost
	SELECT	DISTINCT H.ClientId, MP.MountPathId, '', '', ''
	FROM	(SELECT DISTINCT MountPathId, LibraryId FROM #SiloMountPath WHERE MountPathTypeId = 0) MP,
			MMLibraryController LC WITH (NOLOCK), MMHost as H WITH (NOLOCK)
	WHERE	LC.LibraryId = MP.LibraryId
		AND LC.LibraryControllerActive = 1 AND LC.LibraryControllerEnabled = 1
AND	H.ClientId = LC.ClientId AND H.MmHostEnabled = 1 and H.MmHostSoftState = 1 AND ((H.Attribute & 16) = 0)
	UPDATE	#SiloMountPath
	SET		ClientId = #MountPathHost.ClientId
	FROM	#MountPathHost
	WHERE	#SiloMountPath.MountPathId = #MountPathHost.MountPathId
	TRUNCATE TABLE #MountPathHost
END
IF EXISTS (SELECT * FROM #SiloMountPath WHERE MountPathTypeId <> 0)
BEGIN
	INSERT	INTO #MountPathHost
	SELECT	DISTINCT H.ClientId, MP.MountPathId,
			CASE
				WHEN RIGHT(DC.Folder, 1) IN ('/', '\') THEN (DC.Folder + MP.MountPathName)
				ELSE (DC.Folder + (CASE WHEN LEFT(DC.Folder, 1) = '/' THEN '/' ELSE '\' END) + MP.MountPathName)
			END,
			DC.UserName, DC.UserPassword, DC.CredentialAssocId
	FROM	(SELECT DISTINCT MountPathId, MountPathName FROM #SiloMountPath WHERE MountPathTypeId <> 0) MP
			INNER JOIN MMMountPathToStorageDevice MPSD WITH (NOLOCK) ON MPSD.MountPathId = MP.MountPathId
			INNER JOIN MMDevice D WITH (NOLOCK) ON D.DeviceId = MPSD.DeviceId AND D.DeviceEnabled = 1 AND D.DeviceBroken = 0
			INNER JOIN MMDeviceController DC WITH (NOLOCK) ON DC.DeviceId = D.DeviceId
						AND DC.DeviceControllerEnabled = 1 AND DC.DeviceAccessible = 1 AND (DC.DeviceAccessType & 2) = 2
INNER JOIN MMHost as H WITH (NOLOCK) ON H.ClientId = DC.ClientId AND H.MmHostEnabled = 1 and H.MmHostSoftState = 1 AND ((H.Attribute & 16) = 0)
	-- Update user name and password for entries that use credentials
	EXEC MMS2GetDeviceControllerCredentials '#MountPathHost', 'CredentialAssocId', 'UserName', 'UserPassword'
	UPDATE	#SiloMountPath
	SET		ClientId = #MountPathHost.ClientId, MountPathName = #MountPathHost.MountPathName,
			UserName = #MountPathHost.UserName, UserPassword  = #MountPathHost.UserPassword
	FROM	#MountPathHost
	WHERE	#SiloMountPath.MountPathId = #MountPathHost.MountPathId
END
SELECT	MP.ClientId, MP.MountPathId, MP.MountPathName, MP.UserName, MP.UserPassword, V.SIDBStoreId, V.VolumeId,
		case when V.CommCellId > 0 then V.CommCellId else 2 end, V.LastRestoreTime, DV.SpaceToFreeMB, V.TransformedMPId, V.TransformedCCId,
		MP.MPTotalSpaceMB, MP.MPFreeSpaceMB, L.LibThreshPerc, L.LibVariation
FROM	#SiloVolume V, #DelVolume DV, #SiloMountPath MP, #SiloLibrary L
WHERE	V.VolumeId = DV.VolumeId AND V.MountPathId = MP.MountPathId AND MP.ClientId > 0 AND MP.LibraryId = L.LibraryId
ORDER BY MP.ClientId, MP.MountPathId, V.SIDBStoreId, V.VolumeId
DROP TABLE	#SiloStore
DROP TABLE	#SiloMountPath
DROP TABLE	#SiloLibrary
DROP TABLE	#JobsInSiloVolume
DROP TABLE	#SiloVolume
DROP TABLE	#DelVolume
DROP TABLE	#MountPathHost
RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'MMGetSiloVolForCleanup')
	delete from GxQscripts where name = 'MMGetSiloVolForCleanup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetSiloVolForCleanup')
	delete from GXDBVersions where aliasname = 'MMGetSiloVolForCleanup'
GO

insert into GXDBVersions values(2, 'MMGetSiloVolForCleanup',  '00010031001200070000', 'MMGetSiloVolForCleanup', '00010031001200070000')
GO

