

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMGetSetMMTask.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MMGetSetMMTask')
BEGIN
	print '>>> Drop Stored Procedure: MMGetSetMMTask <<<'
	drop procedure MMGetSetMMTask
END
IF EXISTS (select * from GxQscripts where name='MMGetSetMMTask')
	delete from GxQscripts where name = 'MMGetSetMMTask'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetSetMMTask')
	delete from GXDBVersions where aliasname = 'MMGetSetMMTask'
GO
print '... Creating Procedure: MMGetSetMMTask'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MMGetSetMMTask
  @i_spOpType INTEGER,			
  @i_taskId INTEGER,
  @i_taskType INTEGER,				
  @i_metadata XML,			
  @i_pauseTillTime integer = 0
AS
  DECLARE @taskId integer
  DECLARE @taskType integer
  DECLARE @metadata XML
  DECLARE @retryCount integer
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE @currentTime  INTEGER = dbo.GetUnixTime(GETUTCDATE())
IF(@i_spOpType = 0)
BEGIN
	INSERT INTO MMTask(TaskType, MetaData, CreateTime)
		VALUES(@i_taskType, @i_metadata, @currentTime)
END
ELSE IF(@i_spOpType = 1)
BEGIN
	UPDATE MMTask
SET Status =  0
WHERE Status = 3 AND PauseTillTime < @currentTime
	SELECT T.TaskId, T.TaskType, T.MetaData, T.RetryCount
	FROM MMTask T WITH(READUNCOMMITTED)
		INNER JOIN MMTaskType TT WITH (READUNCOMMITTED) ON TT.TaskType = T.TaskType
	WHERE (T.RetryCount < TT.MaxRetryCount OR TT.MaxRetryCount < 0)
		AND @currentTime - T.LastExecutionTime > TT.IntervalMins * 60
AND T.Status = 0
END
ELSE IF(@i_spOpType = 2)
BEGIN
	UPDATE MMTask
	SET MetaData = @i_metaData
	WHERE TaskId = @i_taskId
END
ELSE IF(@i_spOpType = 3)
BEGIN
	UPDATE MMTask
SET Status =  3, PauseTillTime = @i_pauseTillTime
	WHERE TaskId = @i_taskId
AND Status NOT IN (1, 2)
END
ELSE IF(@i_spOpType = 4)
BEGIN
	UPDATE MMTask
SET Status =  0
	WHERE TaskId = @i_taskId
AND Status NOT IN (1, 2)
END

IF EXISTS (select * from GxQscripts where name = 'MMGetSetMMTask')
	delete from GxQscripts where name = 'MMGetSetMMTask'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetSetMMTask')
	delete from GXDBVersions where aliasname = 'MMGetSetMMTask'
GO

insert into GXDBVersions values(2, 'MMGetSetMMTask',  '00000000000000000000', 'MMGetSetMMTask', '00000000000000000000')
GO

