

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMGetScaleOutHwInfoForHwEntity.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET NOCOUNT ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='MMGetScaleOutHwInfoForHwEntity')
BEGIN
	print '>>> Drop Stored Procedure: MMGetScaleOutHwInfoForHwEntity <<<'
	drop procedure MMGetScaleOutHwInfoForHwEntity
END
IF EXISTS (select * from GxQscripts where name='MMGetScaleOutHwInfoForHwEntity')
	delete from GxQscripts where name = 'MMGetScaleOutHwInfoForHwEntity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetScaleOutHwInfoForHwEntity')
	delete from GXDBVersions where aliasname = 'MMGetScaleOutHwInfoForHwEntity'
GO
print '... Creating Procedure: MMGetScaleOutHwInfoForHwEntity'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure MMGetScaleOutHwInfoForHwEntity
  @userId integer,
  @entityType integer,
  @showAllDetail integer,
  @storagePoolId integer = 0,
  @mediaAgentId integer = 0,
  @filterRANodes integer = 1
AS
  DECLARE @o_NodeId integer
  DECLARE @o_NodeName nvarchar(510)
  DECLARE @o_EntityType integer
  DECLARE @o_EntityId integer
  DECLARE @o_EntityName varchar(256)
  DECLARE @o_EntityInfo varchar(256)
  DECLARE @o_EntityStatus integer
  DECLARE @o_EntityStatusStr varchar(16)
  DECLARE @o_StoragePoolId int
  DECLARE @o_StoragePoolName NVARCHAR(256)
declare @DISK_ENTITY int = 1
declare @CACHE_ENTITY int = 2
declare @FAN_ENTITY	 int = 4
declare @POWERSUPPLY_ENTITY int = 8
declare @NIC_ENTITY int	= 16
IF @mediaAgentId <= 0
    SET @mediaAgentId = NULL
IF @storagePoolId <= 0
    SET @storagePoolId = NULL
if(@showAllDetail = 1)
begin
	set @entityType = (@DISK_ENTITY | @CACHE_ENTITY | @FAN_ENTITY | @POWERSUPPLY_ENTITY | @NIC_ENTITY)
end
if object_id('tempdb.dbo.#tbl_applianceMA') IS NOT NULL DROP TABLE #tbl_applianceMA
create table #tbl_applianceMA(hostId int, storagePoolId int, storagePoolName NVARCHAR(256))
INSERT INTO #tbl_applianceMA
	SELECT DISTINCT(HW.hostId), SDS.GDSPId, ag.name
	FROM MMSDSStoragePool SDS(nolock)
		INNER JOIN MMMountPath MP WITH (READUNCOMMITTED) ON MP.LibraryId = SDS.LibraryId
		INNER JOIN MMMountPathToStorageDevice MSD WITH (READUNCOMMITTED) ON MSD.MountPathId = MP.MountPathId
		INNER JOIN MMDiskHwInfo HW(nolock) ON HW.DeviceId = MSD.DeviceID
		INNER JOIN MMScaleOutMAInfo MA(nolock) ON HW.hostId = MA.ClientId
		INNER JOIN archGroup ag(nolock) ON ag.id = SDS.GDSPId
	WHERE HW.flags & 1 = 1
		AND SDS.GDSPId = ISNULL(@storagePoolId, SDS.GDSPId)
		AND HW.hostId = ISNULL(@mediaAgentId, HW.hostId)
		AND CASE
				WHEN @filterRANodes = 1
					THEN CASE
WHEN  EXISTS(SELECT 1 FROM MMEntityProp ME(nolock) WHERE ME.EntityId = HW.hostId AND ME.EntityType = 10 AND ME.CommCellId = 2 AND ME.propertyName = 'MediaAgentApplianceType' AND ME.intVal = 1)
								THEN 1
							ELSE 0
						END
				ELSE IIF(MA.HardwareInformation.value('/MediaManager_WSPlatformHwInfo[1]/@isHwCollectionSupported', 'int') = 1, 1, 0)
			END = 1
--security check
if(@userId > 0)
begin
	if object_id('tempdb.dbo.#tblMMS2GetMediaAgentsForUserResult') IS NOT NULL drop table #tblMMS2GetMediaAgentsForUserResult
	create table #tblMMS2GetMediaAgentsForUserResult (clientId integer)
	exec MMS2GetMediaAgentsForUser @userId
	--remove the hosts not visible to the user
	delete from #tbl_applianceMA
	where hostId not in (select clientId from #tblMMS2GetMediaAgentsForUserResult)
	if object_id('tempdb.dbo.#tblMMS2GetMediaAgentsForUserResult') is not null drop table #tblMMS2GetMediaAgentsForUserResult
end
if object_id('tempdb.dbo.#tbl_HardwareDetails') IS NOT NULL DROP TABLE #tbl_HardwareDetails
create table #tbl_HardwareDetails(
	NodeId			int,
	NodeName		nvarchar(510),
	EntityType		int,
	EntityId		int,
	EntityName		varchar(256),
	EntityInfo		varchar(256),
	EntityStatus	int,
	EntityStatusStr	varchar(16),
	StoragePoolId	int,
	StoragePoolName NVARCHAR(256),
)
-- Disk Information
if (@entityType & @DISK_ENTITY = @DISK_ENTITY)
begin
	insert into #tbl_HardwareDetails
	select  C.id, C.displayName, @DISK_ENTITY, HW.diskId, HW.deviceOSPath, cast (cast(HW.diskCapacityMB/1024.0 as decimal(10,2)) as varchar(256)),
	case when (	HW.BrickHealth & 7 = 0				-- IO Test Failed
				OR HW.BlockDeviceHealth &  15 = 0	-- SMART Params failure
				OR HW.BrickHealth & 32 = 32         -- Daemon offline
				OR HW.flags & 16 = 16               -- Disk missing from last update
			   )
				then 0
		  else 1
		  end,
		  '',
		  T.storagePoolId,
		  T.storagePoolName
	from #tbl_applianceMA T (nolock), APP_client C(nolock), MMDiskHWInfo HW(nolock)
	where T.hostId = C.id and T.hostId = Hw.hostId
	and HW.mountPathUsageType = 2 and HW.flags & 1 = 1
	order by HW.hostId
	update #tbl_HardwareDetails
	set EntityStatusStr = (case when EntityStatus = 1 then 'Ready' else 'Offline' end)
	where EntityType = @DISK_ENTITY
end
-- Cache Information
if (@entityType & @CACHE_ENTITY = @CACHE_ENTITY)
begin
	insert into #tbl_HardwareDetails
	select  C.id, C.displayName, @CACHE_ENTITY, HW.diskId, HW.deviceOSPath, HW.blockDeviceUUID, 1,'', T.storagePoolId, T.storagePoolName
	from #tbl_applianceMA T (nolock), APP_client C(nolock), MMDiskHWInfo HW(nolock)
	where T.hostId = C.id and T.hostId = Hw.hostId
	and HW.mountPathUsageType = 1 and HW.flags & 1 = 1
	order by HW.hostId
	update #tbl_HardwareDetails
	set EntityStatusStr = (case when EntityStatus = 1 then 'Ready' else 'Offline' end)
	where EntityType = @CACHE_ENTITY
end
--Fan Information
if (@entityType & @FAN_ENTITY = @FAN_ENTITY)
begin
	if object_id('tempdb.dbo.#tbl_Fan') IS NOT NULL DROP TABLE #tbl_Fan
	create table #tbl_Fan(hostId int, name varchar(64), val varchar(64), pStatus bit)
	insert into #tbl_Fan
	select a.ClientId, R.ref.value('@fanName', 'varchar(64)'), R.ref.value('@value', 'varchar(64)'),  R.ref.value('@status', 'bit')
	from MMScaleOutMAInfo a cross apply a.HardwareInformation.nodes('MediaManager_WSPlatformHwInfo/fanList') as R (ref)
	insert into #tbl_HardwareDetails
	select C.id,C.displayName,@FAN_ENTITY, -1/*No Id for fan*/, F.name, F.val, F.pStatus, '', MA.storagePoolId, MA.storagePoolName
	from #tbl_Fan F(nolock), #tbl_applianceMA MA(nolock), APP_Client C(nolock)
	where F.hostId = MA.hostId and MA.hostId = C.id and F.val NOT IN ('Disabled','No reading','Absent')
	update #tbl_HardwareDetails
	set EntityStatusStr = (case when EntityStatus = 1 then 'On' else 'Off' end)
	where EntityType = @FAN_ENTITY
	drop table #tbl_Fan
end
-- Power Supply Information
if (@entityType & @POWERSUPPLY_ENTITY = @POWERSUPPLY_ENTITY)
begin
	if object_id('tempdb.dbo.#tbl_powerSupply') IS NOT NULL DROP TABLE #tbl_powerSupply
	create table #tbl_powerSupply(hostId int, name varchar(64), redund varchar(64), pStatus bit)
	insert into #tbl_powerSupply
	select a.ClientId, R.ref.value('@supplyName', 'varchar(64)'), R.ref.value('@redundancy', 'varchar(64)'),  R.ref.value('@status', 'bit')
	from MMScaleOutMAInfo a cross apply a.HardwareInformation.nodes('MediaManager_WSPlatformHwInfo/powerSupplyList') as R (ref)
	insert into #tbl_HardwareDetails
	select C.id, C.displayName, @POWERSUPPLY_ENTITY, -1, PS.name, PS.redund, PS.pStatus, '', MA.storagePoolId, MA.storagePoolName
	from #tbl_powerSupply PS(nolock), #tbl_applianceMA MA(nolock), APP_client C(nolock)
	where PS.hostId = MA.hostId and MA.hostId = C.id
	update #tbl_HardwareDetails
	set EntityStatusStr = (case when EntityStatus = 1 then 'Connected' else 'Disconnected' end)
	where EntityType = @POWERSUPPLY_ENTITY
	drop table #tbl_powerSupply
end
-- NIC Information
if (@entityType & @NIC_ENTITY = @NIC_ENTITY)
begin
	if object_id('tempdb.dbo.#tbl_NIC') IS NOT NULL DROP TABLE #tbl_NIC
	create table #tbl_NIC(hostId int, name varchar(64), linkStatus varchar(16), linkSpeed varchar(32))
	insert into #tbl_NIC
	select a.ClientId, R.ref.value('@deviceName', 'varchar(64)'), R.ref.value('@linkStatus', 'varchar(16)'),  R.ref.value('@linkSpeed', 'varchar(32)')
	from MMScaleOutMAInfo a cross apply a.HardwareInformation.nodes('MediaManager_WSPlatformHwInfo/nicInfoList') as R (ref)
	insert into #tbl_HardwareDetails
	select C.id, C.displayName, @NIC_ENTITY, -1, N.name, N.linkSpeed, (case when N.linkStatus = 'yes' then 1 else 0 end), '', MA.storagePoolId, MA.storagePoolName
	from #tbl_NIC N(nolock), #tbl_applianceMA MA(nolock), APP_Client C(nolock)
	where N.hostId = MA.hostId and MA.hostId = C.id and N.name like 'en[op]%'
	update #tbl_HardwareDetails
	set EntityStatusStr = (case when EntityStatus = 1 then 'Connected' else 'Disconnected' end)
	where EntityType = @NIC_ENTITY
	drop table #tbl_NIC
end
select * from #tbl_HardwareDetails
drop table #tbl_applianceMA
drop table #tbl_HardwareDetails

IF EXISTS (select * from GxQscripts where name = 'MMGetScaleOutHwInfoForHwEntity')
	delete from GxQscripts where name = 'MMGetScaleOutHwInfoForHwEntity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetScaleOutHwInfoForHwEntity')
	delete from GXDBVersions where aliasname = 'MMGetScaleOutHwInfoForHwEntity'
GO

insert into GXDBVersions values(2, 'MMGetScaleOutHwInfoForHwEntity',  '00000000000000000000', 'MMGetScaleOutHwInfoForHwEntity', '00000000000000000000')
GO

