

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMGetScaleOutDiskHealthAlertInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MMGetScaleOutDiskHealthAlertInfo')
BEGIN
	print '>>> Drop Stored Procedure: MMGetScaleOutDiskHealthAlertInfo <<<'
	drop procedure MMGetScaleOutDiskHealthAlertInfo
END
IF EXISTS (select * from GxQscripts where name='MMGetScaleOutDiskHealthAlertInfo')
	delete from GxQscripts where name = 'MMGetScaleOutDiskHealthAlertInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetScaleOutDiskHealthAlertInfo')
	delete from GXDBVersions where aliasname = 'MMGetScaleOutDiskHealthAlertInfo'
GO
print '... Creating Procedure: MMGetScaleOutDiskHealthAlertInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MMGetScaleOutDiskHealthAlertInfo
AS
  DECLARE @SDSStoragePoolId INT
  DECLARE @StoragePoolName nvarchar(1024)
  DECLARE @StorageLibrary nvarchar(256)
  DECLARE @clientId INT
  DECLARE @hostName nvarchar(510)
  DECLARE @diskId int
  DECLARE @blockDevPath varchar(1024)
  DECLARE @brickPath varchar(1024)	
  DECLARE @issueType INT
  DECLARE @issue nvarchar(256)
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
--Brick level issueTypes
DECLARE @BRICK_HEALTH_ISSUE INT = 1
DECLARE @SMART_HEALTH_ISSUE INT = 2
DECLARE @BRICK_DAEMON_ISSUE INT = 3
DECLARE @BRICK_MISSING_ISSUE INT = 4
--Node level issueTypes
DECLARE @NODE_VOLUME_NOT_MOUNTED INT = 100
--Storage Pool level issueTypes
DECLARE @STORAGE_POOL_SIZE_DECREASE INT = 1000
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
IF OBJECT_ID('tempdb..#BricksToAlert') IS NOT NULL DROP TABLE #BricksToAlert
CREATE TABLE #BricksToAlert(
	SDSStoragePoolId	INT,
	StoragePoolName		nvarchar(1024)  DEFAULT '',
	clientId			INT				DEFAULT 0,
	hostName			nvarchar(510)	DEFAULT '',
	diskId				int				DEFAULT 0,
	StorageLibrary		nvarchar(256)	DEFAULT '',
	blockDevPath		varchar(1024)	DEFAULT '',
	brickPath			varchar(1024)	DEFAULT '',
	issueType			INT,
	issue				nvarchar(256)
)
/*
	Brick Level Alerts
*/
INSERT INTO #BricksToAlert
    SELECT S.StoragePoolId, '', C.id, c.displayName, HW.diskId, L.AliasName, HW.backingDevice,HW.deviceOSPath,@BRICK_HEALTH_ISSUE, N'I/O Test Failure'
    FROM MMSDSStoragePool S
        INNER JOIN MMMountPath MP  ON MP.LibraryId = S.LibraryId
        INNER JOIN MMMountPathToStorageDevice MSD  ON MSD.MountPathId = MP.MountPathId
        INNER JOIN MMDiskHwInfo HW  ON  MSD.DeviceId = HW.deviceId
        INNER JOIN MMLibrary L  on S.LibraryId = L.LibraryId
        INNER JOIN APP_Client C  on HW.hostId = C.id
WHERE   HW.flags & 1 > 0 AND HW.mountPathUsageType = 2
    AND HW.BrickHealth & 7 = 0 -- 7 = I/O Read Write io.txt test success
INSERT INTO #BricksToAlert
    SELECT S.StoragePoolId, '', C.id, c.displayName, HW.diskId, L.AliasName, HW.backingDevice, HW.deviceOSPath, @SMART_HEALTH_ISSUE, N'S.M.A.R.T Health Faulty'
    FROM MMSDSStoragePool S
        INNER JOIN MMMountPath MP  ON MP.LibraryId = S.LibraryId
        INNER JOIN MMMountPathToStorageDevice MSD  ON MSD.MountPathId = MP.MountPathId
        INNER JOIN MMDiskHwInfo HW  ON  MSD.DeviceId = HW.deviceId
        INNER JOIN MMLibrary L  on S.LibraryId = L.LibraryId
        INNER JOIN APP_Client C  on HW.hostId = C.id
WHERE   HW.flags & 1 > 0 AND HW.mountPathUsageType = 2
    AND HW.BlockDeviceHealth &  15 = 0 -- 15 = Block Dev Read Good, Smart Extract Good, SMART Overall Health Good, SMART Params Good
INSERT INTO #BricksToAlert
    SELECT S.StoragePoolId, '', C.id, c.displayName, HW.diskId, L.AliasName, HW.backingDevice, HW.deviceOSPath, @BRICK_DAEMON_ISSUE, N'Disk Daemon Offline'
    FROM MMSDSStoragePool S
        INNER JOIN MMMountPath MP  ON MP.LibraryId = S.LibraryId
        INNER JOIN MMMountPathToStorageDevice MSD  ON MSD.MountPathId = MP.MountPathId
        INNER JOIN MMDiskHwInfo HW  ON  MSD.DeviceId = HW.deviceId
        INNER JOIN MMLibrary L  on S.LibraryId = L.LibraryId
        INNER JOIN APP_Client C  on HW.hostId = C.id
WHERE   HW.flags & 1 > 0 AND HW.mountPathUsageType = 2
AND HW.BrickHealth & 0x020 > 0
INSERT INTO #BricksToAlert
    SELECT S.StoragePoolId, '', C.id, c.displayName, HW.diskId, L.AliasName, HW.backingDevice, HW.deviceOSPath, @BRICK_MISSING_ISSUE, N'Disk not detected in last health check cycle'
    FROM MMSDSStoragePool S
        INNER JOIN MMMountPath MP  ON MP.LibraryId = S.LibraryId
        INNER JOIN MMMountPathToStorageDevice MSD  ON MSD.MountPathId = MP.MountPathId
        INNER JOIN MMDiskHwInfo HW  ON  MSD.DeviceId = HW.deviceId
        INNER JOIN MMLibrary L  on S.LibraryId = L.LibraryId
        INNER JOIN APP_Client C  on HW.hostId = C.id
WHERE   HW.flags & 1 > 0 AND HW.mountPathUsageType = 2
AND HW.flags & 16 > 0
/*
	Node level alerts
*/
INSERT INTO #BricksToAlert(SDSStoragePoolId, StorageLibrary, clientId, hostName, issueType, issue)
	SELECT DISTINCT S.StoragePoolId, L.AliasName, C.id, c.displayName, @NODE_VOLUME_NOT_MOUNTED, N'Storage Pool Device Path not accessible on node'
    FROM 	MMSDSStoragePool S
			INNER JOIN MMMountPath MP  ON MP.LibraryId = S.LibraryId
			INNER JOIN MMMountPathToStorageDevice MSD ON MSD.MountPathId = MP.MountPathId
			INNER JOIN MMDiskHwInfo HW  ON  MSD.DeviceId = HW.deviceId
			INNER JOIN MMLibrary L on S.LibraryId = L.LibraryId
			INNER JOIN APP_Client C on HW.hostId = C.id
WHERE   HW.flags & 1 > 0 AND HW.mountPathUsageType = 2
AND HW.BrickHealth & 0x00020000 > 0
/*
Storage Pool Level Alerts
*/
INSERT INTO #BricksToAlert(SDSStoragePoolId, StorageLibrary, issueType, issue)
	SELECT 	S.StoragePoolId, L.AliasName, @STORAGE_POOL_SIZE_DECREASE, N'Reduced storage pool capacity detected'
    FROM 	MMSDSStoragePool S
			INNER JOIN MMLibrary L ON L.LibraryId = S.LibraryId
	WHERE	EXISTS (
			SELECT 1
			FROM	MMDiskHWInfo D
					INNER JOIN MMMountPathToStorageDevice MPSD ON MPSD.DeviceId = D.deviceId
					INNER JOIN MMMountPath MP ON MP.MountPathId = MPSD.MountPathId
			WHERE	MP.LibraryId = S.LibraryId
AND D.flags & 1 > 0 AND D.mountPathUsageType = 2
AND D.BrickHealth & 0x00010000 > 0
			)
UPDATE B
SET StoragePoolName = ag.name
FROM #BricksToAlert B
	INNER JOIN MMSDSStoragePool S ON S.StoragePoolId = B.SDSStoragePoolId
	INNER JOIN archGroup ag ON ag.id = S.GDSPId
SELECT *
FROM #BricksToAlert
ORDER BY SDSStoragePoolId, ClientId, DiskId
IF OBJECT_ID('tempdb..#BricksToAlert') IS NOT NULL DROP TABLE #BricksToAlert

IF EXISTS (select * from GxQscripts where name = 'MMGetScaleOutDiskHealthAlertInfo')
	delete from GxQscripts where name = 'MMGetScaleOutDiskHealthAlertInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetScaleOutDiskHealthAlertInfo')
	delete from GXDBVersions where aliasname = 'MMGetScaleOutDiskHealthAlertInfo'
GO

insert into GXDBVersions values(2, 'MMGetScaleOutDiskHealthAlertInfo',  '00000000000000000000', 'MMGetScaleOutDiskHealthAlertInfo', '00000000000000000000')
GO

