

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMGetScaleOutApplianceHwInfoForDash.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET NOCOUNT ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='MMGetScaleOutApplianceHwInfoForDash')
BEGIN
	print '>>> Drop Stored Procedure: MMGetScaleOutApplianceHwInfoForDash <<<'
	drop procedure MMGetScaleOutApplianceHwInfoForDash
END
IF EXISTS (select * from GxQscripts where name='MMGetScaleOutApplianceHwInfoForDash')
	delete from GxQscripts where name = 'MMGetScaleOutApplianceHwInfoForDash'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetScaleOutApplianceHwInfoForDash')
	delete from GXDBVersions where aliasname = 'MMGetScaleOutApplianceHwInfoForDash'
GO
print '... Creating Procedure: MMGetScaleOutApplianceHwInfoForDash'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure MMGetScaleOutApplianceHwInfoForDash
  @userId INTEGER,
  @storagePoolId INTEGER = 0
AS
  DECLARE @o_HWEntity INTEGER
  DECLARE @o_HWEntityName varchar(16)
  DECLARE @o_EntityCount INTEGER
  DECLARE @o_OfflineCount INTEGER
--Stored Procedure to return the list of disks, cache, fan, power supply, NIC ----
--Output expected
-------------------------------------------------
--Type                      Total      Offline
-------------------------------------------------
--Disks                       100          10
--Cache                        90           5
--Fan                         100          10
--PowerSupply                 200          20
--NIC                         150          30
-------------------------------------------------
IF @storagePoolId <= 0
	SET @storagePoolId = NULL
declare @DISK_ENTITY int = 1
declare @CACHE_ENTITY int = 2
declare @FAN_ENTITY	 int = 4
declare @POWERSUPPLY_ENTITY int = 8
declare @NIC_ENTITY int	= 16
if object_id('tempdb.dbo.#tbl_ApplianceHwStatus') IS NOT NULL DROP TABLE #tbl_ApplianceHwStatus
create table #tbl_ApplianceHwStatus(HWEntityType int, HWEntityName varchar(16), EntityCount int, OfflineCount int)
if object_id('tempdb.dbo.#tbl_applianceMA') IS NOT NULL DROP TABLE #tbl_applianceMA
create table #tbl_applianceMA(hostId int, hwInfo xml)
insert into #tbl_applianceMA
	select distinct(HW.hostId), ''
	from MMSDSStoragePool SDS(nolock), MMDiskHwInfo HW(nolock),MMScaleOutMAInfo MA(nolock), MMEntityProp ME(nolock), MMMountPath MP(nolock), MMMountPathToStorageDevice MSD(nolock)
	where sds.LibraryId = MP.LibraryId and MP.MountPathId = MSD.MountPathId
and MSD.DeviceId = HW.deviceId and HW.hostId = MA.ClientId and Hw.flags & 1 = 1
		AND SDS.GDSPId = ISNULL(@storagePoolId, SDS.GDSPId)
		AND MA.HardwareInformation.value('/MediaManager_WSPlatformHwInfo[1]/@isHwCollectionSupported', 'int') = 1
--security check
if(@userId > 0)
begin
	if object_id('tempdb.dbo.#tblMMS2GetMediaAgentsForUserResult') IS NOT NULL drop table #tblMMS2GetMediaAgentsForUserResult
	create table #tblMMS2GetMediaAgentsForUserResult (clientId integer)
	exec MMS2GetMediaAgentsForUser @userId
	--remove the hosts not visible to the user
	delete from #tbl_applianceMA
	where hostId not in (select clientId from #tblMMS2GetMediaAgentsForUserResult)
	if object_id('tempdb.dbo.#tblMMS2GetMediaAgentsForUserResult') is not null drop table #tblMMS2GetMediaAgentsForUserResult
end
update T
set hwInfo = ISNULL(M.HardwareInformation,'')
from MMScaleOutMAInfo M, #tbl_applianceMA T
where M.ClientId = T.hostId
insert into #tbl_ApplianceHwStatus
values(@DISK_ENTITY,'Disk', 0, 0 )
insert into #tbl_ApplianceHwStatus
values(@CACHE_ENTITY,'Cache', 0, 0 )
insert into #tbl_ApplianceHwStatus
values(@FAN_ENTITY,'Fan', 0, 0 )
insert into #tbl_ApplianceHwStatus
values(@POWERSUPPLY_ENTITY,'Power Supply', 0, 0 )
insert into #tbl_ApplianceHwStatus
values(@NIC_ENTITY,'NIC', 0, 0 )
-- Total configured disk count on the CS
update  #tbl_ApplianceHwStatus
set EntityCount = T.DiskCount
from (	select count(distinct HW.diskId) as DiskCount from MMSDSStoragePool SDS(nolock), MMDiskHwInfo HW(nolock), #tbl_applianceMA MA, MMMountPath MP(nolock), MMMountPathToStorageDevice MSD(nolock)
		where sds.LibraryId = MP.LibraryId and MP.MountPathId = MSD.MountPathId
		and MSD.DeviceId = HW.deviceId and HW.hostId = MA.hostId
and HW.flags & 1 = 1 and HW.mountPathUsageType = 2) as T
where hwEntityType = @DISK_ENTITY
update  #tbl_ApplianceHwStatus
set OfflineCount = T.DiskCount
from (	select count(distinct HW.diskId) as DiskCount from MMSDSStoragePool SDS(nolock), MMDiskHwInfo HW(nolock), #tbl_applianceMA MA, MMMountPath MP(nolock), MMMountPathToStorageDevice MSD(nolock)
		where sds.LibraryId = MP.LibraryId and MP.MountPathId = MSD.MountPathId
		and MSD.DeviceId = HW.deviceId and HW.hostId = MA.hostId
		and HW.flags & 1 = 1 and HW.mountPathUsageType = 2
		and (	HW.BrickHealth <> 23				-- Read,Write,IO, Daemon Online(1 | 2 | 4 | 16)
				OR HW.BlockDeviceHealth <>  15 		-- SMART Params failure
				OR HW.flags & 16 = 16               -- Disk missing from last update
			)
) as T
where hwEntityType = @DISK_ENTITY
-- Total Cache
update  #tbl_ApplianceHwStatus
set EntityCount = T.CacheCount
from (	select count(distinct HW.diskId) as CacheCount from MMSDSStoragePool SDS(nolock), MMDiskHwInfo HW(nolock), #tbl_applianceMA MA, MMMountPath MP(nolock), MMMountPathToStorageDevice MSD(nolock)
		where sds.LibraryId = MP.LibraryId and MP.MountPathId = MSD.MountPathId
		and MSD.DeviceId = HW.deviceId and HW.hostId = MA.hostId
		and HW.flags & 1 = 1 and HW.mountPathUsageType = 1) as T
where hwEntityType = @CACHE_ENTITY
-- Fan Info
if object_id('tempdb.dbo.#tbl_Fan') IS NOT NULL DROP TABLE #tbl_Fan
create table #tbl_Fan(hostId int, name varchar(64), val varchar(64), pStatus bit)
insert into #tbl_Fan
select a.ClientId, R.ref.value('@fanName', 'varchar(64)'), R.ref.value('@value', 'varchar(64)'),  R.ref.value('@status', 'bit')
from MMScaleOutMAInfo a cross apply a.HardwareInformation.nodes('MediaManager_WSPlatformHwInfo/fanList') as R (ref)
--Total Fan
update  #tbl_ApplianceHwStatus
set EntityCount = T.FanCount
from (	select count(*) as FanCount from #tbl_Fan F,#tbl_applianceMA MA where F.hostId = MA.hostId and F.val not in ('Disabled','No reading','Absent') ) as T
where hwEntityType = @FAN_ENTITY
-- Offline Fan
update  #tbl_ApplianceHwStatus
set OfflineCount = T.OfflineFanCount
from (	select count(*) as OfflineFanCount from #tbl_Fan F,#tbl_applianceMA MA where F.hostId = MA.hostId and F.pStatus = 0 and F.val not in ('Disabled','No reading','Absent')) as T
where hwEntityType = @FAN_ENTITY
--Power Supply Info
if object_id('tempdb.dbo.#tbl_powerSupply') IS NOT NULL DROP TABLE #tbl_powerSupply
create table #tbl_powerSupply(hostId int, name varchar(64), redund varchar(64), pStatus bit)
insert into #tbl_powerSupply
select a.ClientId, R.ref.value('@supplyName', 'varchar(64)'), R.ref.value('@redundancy', 'varchar(6)'),  R.ref.value('@status', 'bit')
from MMScaleOutMAInfo a cross apply a.HardwareInformation.nodes('MediaManager_WSPlatformHwInfo/powerSupplyList') as R (ref)
--Total PS
update  #tbl_ApplianceHwStatus
set EntityCount = T.PSCount
from (	select count(*) as PSCount from #tbl_powerSupply P,#tbl_applianceMA MA where P.hostId = MA.hostId) as T
where hwEntityType = @POWERSUPPLY_ENTITY
update  #tbl_ApplianceHwStatus
set OfflineCount = T.PSCount
from (	select count(*) as PSCount from #tbl_powerSupply P,#tbl_applianceMA MA where P.hostId = MA.hostId and P.pStatus = 0) as T
where hwEntityType = @POWERSUPPLY_ENTITY
--NIC Info
if object_id('tempdb.dbo.#tbl_NIC') IS NOT NULL DROP TABLE #tbl_NIC
create table #tbl_NIC(hostId int, name varchar(64), linkStatus varchar(16))
insert into #tbl_NIC
select a.ClientId, R.ref.value('@deviceName', 'varchar(64)'), R.ref.value('@linkStatus', 'varchar(16)')
from MMScaleOutMAInfo a cross apply a.HardwareInformation.nodes('MediaManager_WSPlatformHwInfo/nicInfoList') as R (ref)
--Total NIC
update  #tbl_ApplianceHwStatus
set EntityCount = T.NICCount
from (	select count(*) as NICCount from #tbl_NIC N,#tbl_applianceMA MA where N.hostId = MA.hostId and N.name like 'en[op]%' ) as T
where hwEntityType = @NIC_ENTITY
-- Offline NIC
update  #tbl_ApplianceHwStatus
set OfflineCount = T.OfflineNic
from (	select count(*) as OfflineNic from #tbl_NIC N,#tbl_applianceMA MA where N.hostId = MA.hostId and linkStatus <> 'yes' and N.name like 'en[op]%' ) as T
where hwEntityType = @NIC_ENTITY
select * from #tbl_ApplianceHwStatus
drop table #tbl_applianceMA
drop table #tbl_ApplianceHwStatus

IF EXISTS (select * from GxQscripts where name = 'MMGetScaleOutApplianceHwInfoForDash')
	delete from GxQscripts where name = 'MMGetScaleOutApplianceHwInfoForDash'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetScaleOutApplianceHwInfoForDash')
	delete from GXDBVersions where aliasname = 'MMGetScaleOutApplianceHwInfoForDash'
GO

insert into GXDBVersions values(2, 'MMGetScaleOutApplianceHwInfoForDash',  '00000000000000000000', 'MMGetScaleOutApplianceHwInfoForDash', '00000000000000000000')
GO

