

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMGetSIDBStoreByCopySum.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMGetSIDBStoreByCopySum.sp,v $ $Id: MMGetSIDBStoreByCopySum.sp,v 1.28.66.8 2018/12/05 07:19:23 pnara Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 						SP: "MMGetSIDBStoreByCopySum"
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MMGetSIDBStoreByCopySum')
BEGIN
	print '>>> Drop Stored Procedure: MMGetSIDBStoreByCopySum <<<'
	drop procedure MMGetSIDBStoreByCopySum
END
IF EXISTS (select * from GxQscripts where name='MMGetSIDBStoreByCopySum')
	delete from GxQscripts where name = 'MMGetSIDBStoreByCopySum'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetSIDBStoreByCopySum')
	delete from GXDBVersions where aliasname = 'MMGetSIDBStoreByCopySum'
GO
print '... Creating Procedure: MMGetSIDBStoreByCopySum'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMGetSIDBStoreByCopySum
-- ---------------------------------------------------------------
-- Function is used to lookup the client list using specified condition
-- ---------------------------------------------------------------
  @i_copyId integer,
  @i_returnBaseLine integer = 0
AS
  DECLARE @o_numSIDBStore integer
  DECLARE @o_SizeOfStoreMB bigint
  DECLARE @o_SizeOffDiskMB bigint
  DECLARE @o_SizeInSiloMB bigint
  DECLARE @o_SizeToBeInSiloMB bigint
  DECLARE @o_SizeOfApplication bigint
  DECLARE @o_SizeOfBackup bigint
  DECLARE @o_allTotalSizeToBeFreedBytes bigint
  DECLARE @o_SizeForBaseline bigint
  DECLARE @o_SizeForApplicationBaseline bigint
  DECLARE @o_DeDupSavingsPercent varchar(20)
  DECLARE @o_diskFreeSpaceMB bigint
SET NOCOUNT ON
DECLARE	@l_DedupeFlags			INT = 0
DECLARE	@l_archGroupId			INT = 0
DECLARE	@l_SizeOfStoreMB		BIGINT = 0
DECLARE	@l_SizeOffDiskMB		BIGINT = 0
DECLARE	@l_SizeInSiloMB			BIGINT = 0
DECLARE	@l_SizeToBeInSiloMB		BIGINT = 0
DECLARE	@l_SizeOfBackup			BIGINT = 0
DECLARE	@l_SizeOfApplication	BIGINT = 0
DECLARE @l_SizeToBeFreed		BIGINT = 0
DECLARE @l_SizeForBaseline		BIGINT = 0
DECLARE @l_SizeForApplicationBaseline	BIGINT = 0
DECLARE	@l_DeDupSavingsPercent		VARCHAR(20)	= '0'
DECLARE @l_diskFreeSpaceMB		BIGINT = 0
SELECT	@l_DedupeFlags	= dedupeFlags,
		@l_archGroupId	= archGroupId
FROM	archGroupCopy WITH (NOLOCK)
WHERE	id = @i_copyId
--
--Get Size Info from MMGetDDBEngies
--
DECLARE @Propfilters INT = 	8	|
16 |
512
IF @i_returnBaseLine > 0
SET @Propfilters |= (32 | 64)
IF OBJECT_ID('tempdb..#lt_MMGetDDBEnginesOutput') IS NOT NULL DROP TABLE #lt_MMGetDDBEnginesOutput CREATE TABLE #lt_MMGetDDBEnginesOutput ( CommCellId 				int, SIDBStoreId 			int, SIDBStoreName 			nvarchar(256), SIDBStoreAliasName 		nvarchar(256), archGroupId 			integer, archGroupName 			nvarchar(256), copyId 					int, copyName  				nvarchar(64), totalDataSize 			bigint, sizeOnMedia 			bigint, totalAppSize 			BIGINT, deDupSavingSize 		BIGINT, deletedAFCount 			INT, MaintenanceReason 		INT, jobCount 				INT, baseLineSize 			BIGINT, freeSpaceOnLibrary 		BIGINT, retentionDaysForCopy 	INT, retentionCyclesForCopy 	INT, copyMediaAgentId 		INT, sealedTime    			INT, CreatedTime 			INT, SubstoreCount 			INT, AvgQITime 				INT, UniqueBlocks 			BIGINT, dedupeFlags  			integer, PrimaryRecPercent		INT, Version					INT, MaxAvgQITime 			INT, Flags 					INT, LimitFlag				INT, AvgQITime14Days 		INT, MaxAllowedConnections	INT, LastVerifiedOn			BIGINT, JobsLastVerifiedOn		BIGINT, AppBaselineSize			BIGINT, SizeOfFragmentedSpace 	BIGINT, ActiveStreams			INT, EnableAfterDelayTimeZone INT, EnableAfterDelayTime	INT, SizeOffDiskMB			BIGINT, SizeToBeInSiloMB		BIGINT, SizeInSiloMB			BIGINT, SizeOfBackup			BIGINT, deDupSavingPercent		VARCHAR(20), extendedFlags 			BIGINT , TotalSizeOfUniqueBlocks       BIGINT			)
EXEC MMGetDDBEngines 0 /*userId*/, 30 /*propertyLevel*/, @l_archGroupId, @i_copyId, 0 /*SIDBStoreId*/, @Propfilters
SELECT	@l_SizeOfStoreMB 				= totalDataSize / (1024.0 * 1024.0),
		@l_SizeOffDiskMB 				= SizeOffDiskMB,
		@l_SizeToBeInSiloMB				= SizeToBeInSiloMB,
		@l_SizeInSiloMB					= SizeInSiloMB,
		@l_SizeOfBackup 				= SizeOfBackup,
		@l_SizeOfApplication 			= totalAppSize,
		@l_SizeForBaseline 				= baseLineSize,
		@l_SizeForApplicationBaseline 	= AppBaselineSize,
		@l_DeDupSavingsPercent			= deDupSavingPercent,
		@l_diskFreeSpaceMB 				= freeSpaceOnLibrary
FROM	#lt_MMGetDDBEnginesOutput
WHERE	SIDBStoreId = 0 --We return copy level summary with storeId 0
-- If this is the primary copy of a Global Deduplication Policy, show size for all copies using this policy
IF	(@l_DedupeFlags & 268435456) <> 0
BEGIN
	SET	@l_SizeToBeFreed = (	SELECT 	SUM(appSizeFreedBytes)
					FROM 	MMDeletedAF WITH (NOLOCK)
					WHERE 	SIDBStoreId IN (SELECT SIDBStoreId FROM archCopySIDBStore WITH (NOLOCK) WHERE copyId = @i_copyId))
END
ELSE
BEGIN
	SET	@l_SizeToBeFreed = (	SELECT 	SUM(appSizeFreedBytes)
					FROM 	MMDeletedAF WITH (NOLOCK)
					WHERE 	SIDBStoreId IN (SELECT SIDBStoreId FROM archCopySIDBStore WITH (NOLOCK) WHERE copyId = @i_copyId)
						AND copyId = @i_copyId)
END
SELECT	(SELECT COUNT(1) FROM archCopySIDBStore WITH (NOLOCK) WHERE CopyId = @i_copyId) AS NumberOfStores,
		@l_SizeOfStoreMB	AS SizeOfStoreMB,
		@l_SizeOffDiskMB	AS SizeOffDiskMB,
		(@l_SizeInSiloMB + @l_SizeOffDiskMB) AS SizeInSiloMB,
		@l_SizeToBeInSiloMB AS SizeToBeInSiloMB,
		@l_SizeOfApplication AS SizeOfApplication,
		@l_SizeOfBackup		AS SizeOfBackup,
		@l_SizeToBeFreed	AS SizeToBeFreed,
		@l_SizeForBaseline AS SizeForBaseline,
		@l_SizeForApplicationBaseline AS SizeForApplicationBaseline,
		@l_DeDupSavingsPercent		  AS deDupSavingPercent,
		@l_diskFreeSpaceMB			AS diskFreeSpaceMB
GO

IF EXISTS (select * from GxQscripts where name = 'MMGetSIDBStoreByCopySum')
	delete from GxQscripts where name = 'MMGetSIDBStoreByCopySum'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetSIDBStoreByCopySum')
	delete from GXDBVersions where aliasname = 'MMGetSIDBStoreByCopySum'
GO

insert into GXDBVersions values(2, 'MMGetSIDBStoreByCopySum',  '00010028006600080000', 'MMGetSIDBStoreByCopySum', '00010028006600080000')
GO

