

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMGetSIDBStoreByCopy.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMGetSIDBStoreByCopy.sp,v $ $Id: MMGetSIDBStoreByCopy.sp,v 1.51.66.13 2020/02/12 20:33:06 pnara Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 						SP: "MMGetSIDBStoreByCopy"
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MMGetSIDBStoreByCopy')
BEGIN
	print '>>> Drop Stored Procedure: MMGetSIDBStoreByCopy <<<'
	drop procedure MMGetSIDBStoreByCopy
END
IF EXISTS (select * from GxQscripts where name='MMGetSIDBStoreByCopy')
	delete from GxQscripts where name = 'MMGetSIDBStoreByCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetSIDBStoreByCopy')
	delete from GXDBVersions where aliasname = 'MMGetSIDBStoreByCopy'
GO
print '... Creating Procedure: MMGetSIDBStoreByCopy'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMGetSIDBStoreByCopy
-- ---------------------------------------------------------------
-- Function is used to lookup the client list using specified condition
-- ---------------------------------------------------------------
  @i_copyId integer,
  @i_SIDBStoreId integer = 0,
  @i_ReturnSizeInfo integer = 0
AS
  DECLARE @o_SIDBStoreId integer
  DECLARE @o_SIDBStoreName NVARCHAR(255)
  DECLARE @o_SIDBStoreAliasName NVARCHAR(255)
  DECLARE @o_commCellId integer
  DECLARE @o_commCellAliasName varchar(255)
  DECLARE @o_copyId integer
  DECLARE @o_copyName NVARCHAR(255)
  DECLARE @o_siloCopyId integer
  DECLARE @o_siloCopyName NVARCHAR(255)
  DECLARE @o_nDataInstance integer
  DECLARE @o_nSiloStreams integer
  DECLARE @o_silosInCache integer
  DECLARE @o_siloRestoreMAId integer
  DECLARE @o_siloRestoreMAName varchar(255)
  DECLARE @o_siloRestoreClientId integer
  DECLARE @o_siloRestoreClientName varchar(255)
  DECLARE @o_blockCacheValidDays integer
  DECLARE @o_SIDBSnapIntervalHours integer
  DECLARE @o_idxCacheId integer
  DECLARE @o_idxAccessPathId integer
  DECLARE @o_clientId integer
  DECLARE @o_clientName varchar(255)
  DECLARE @o_firstBackupTime integer
  DECLARE @o_minObjSizeKB bigint
  DECLARE @o_oldestEligibleObjArchiveTime integer
  DECLARE @o_signatureType integer
  DECLARE @o_flags integer
  DECLARE @o_CreatedTime integer
  DECLARE @o_LastSnapTime integer
  DECLARE @o_LastRecoveryTime integer
  DECLARE @o_diskFreeThresholdMB integer
  DECLARE @o_diskFreeWarningThreshholdMB integer
  DECLARE @o_SizeOfStoreMB bigint
  DECLARE @o_SizeOffDiskMB bigint
  DECLARE @o_SizeOfBackup bigint
  DECLARE @o_SizeOfApplication bigint
  DECLARE @o_SizeForBaseline bigint
  DECLARE @o_diskFreeSpaceMB bigint
  DECLARE @o_numberOfRetries integer
  DECLARE @o_DDBLimitExtensionTimeStamp integer
  DECLARE @o_DDBLimitFlag integer
  DECLARE @o_SizeForApplicationBaseline bigint
  DECLARE @o_SizeOfFragmentedSpace bigint
  DECLARE @o_SubStoreCount integer
  DECLARE @o_DeDupSavingsPercent varchar(20)
  DECLARE @o_SealedTime integer
  DECLARE @o_Version integer
  DECLARE @o_EnableAfterDelayTimeZone integer
  DECLARE @o_EnableAfterDelayTime integer
  DECLARE @o_ExtendedFlags bigint
SET NOCOUNT ON
DECLARE	@l_archGroupId			INT = 0
DECLARE	@l_SIDBStoreId			INT = @i_SIDBStoreId
DECLARE	@l_DedupeFlags			INT = 0
DECLARE	@l_nDataInstance		INT = 0
DECLARE	@l_nSiloStreams			INT = 0
DECLARE	@l_SiloAppId			INT = 0
DECLARE	@l_SiloCopyId			INT = 0
DECLARE	@l_SilosInCache			INT = 0
DECLARE	@l_SiloRestoreMAClientId INT = 0
DECLARE	@l_SiloRestoreClientId	 INT = 0
DECLARE	@l_BlockCacheValidDays	 INT = 0
DECLARE	@l_SIDBSnapIntervalHours INT = 0
DECLARE	@l_SizeOfStoreMB		BIGINT = 0
DECLARE	@l_SizeOffDiskMB		BIGINT = 0
DECLARE	@l_SizeOfBackup			BIGINT = 0
DECLARE	@l_SizeOfApplication	BIGINT = 0
DECLARE	@l_Size1				BIGINT = 0
DECLARE	@l_Size2				BIGINT = 0
DECLARE	@l_SizeForBaseline		BIGINT = 0
DECLARE	@l_SizeForApplicationBaseline		BIGINT = 0
DECLARE	@l_SubStoreCount			INT	= 0
DECLARE	@l_DeDupSavingsPercent		VARCHAR(20)	= '0'
DECLARE	@l_Version					INT	= 0
DECLARE	@l_EnableAfterDelayTimeZone	INT	= 0
DECLARE	@l_EnableAfterDelayTime		INT	= 0
DECLARE @l_diskFreeThresholdMB			integer
DECLARE @l_diskFreeWarningThreshholdMB	integer
DECLARE @l_diskFreeSpaceMB				bigint
DECLARE @l_TotalDataSizeBytes		BIGINT = 0
DECLARE @l_SizeOfFragmentedSpace	BIGINT = 0
DECLARE @l_SiloEnabled				integer	= 0
DECLARE @l_retValue				INT = 0
DECLARE	@l_oneConstReal			REAL = 1.0
SELECT	@l_archGroupId			= archGroupId,
		@l_DedupeFlags			= dedupeFlags,
		@l_nDataInstance		= nDataInstance,
		@l_nSiloStreams			= nSiloStreams,
		@l_SiloAppId			= siloAppId,
		@l_SilosInCache			= silosInCache,
		@l_SiloRestoreMAClientId= siloRestoreMAClientId,
		@l_SiloRestoreClientId	= siloRestoreClientId,
		@l_BlockCacheValidDays	= blockCacheValidDays,
		@l_SIDBSnapIntervalHours= SIDBSnapIntervalHours
FROM	archGroupCopy WITH (NOLOCK)
WHERE	id = @i_copyId
IF @l_SIDBStoreId = 0
BEGIN
	SELECT 	TOP 1 @l_SIDBStoreId = SIDBStoreId
	FROM	archCopySIDBStore WITH(READUNCOMMITTED)
	WHERE	copyId = @i_copyId
AND flags & 4 = 4
ORDER BY IIF(flags & 2 > 0, 0, 1)
END
IF	@l_siloAppId > 0
	SELECT	@l_SiloCopyId = id
	FROM	ArchGroupCopy WITH (NOLOCK)
WHERE	archGroupId = @l_archGroupId AND sourceCopyId = @i_copyId AND (flags & 524288) > 0
IF @i_ReturnSizeInfo > 0
BEGIN
	--
	--Get Size Info from MMGetDDBEngies
	--
DECLARE @Propfilters INT = 	8	|
16 |
32 |
64
	IF	@i_SIDBStoreId = 0
SET @Propfilters |=	512
	ELSE
SET @Propfilters |=	8192
IF OBJECT_ID('tempdb..#lt_MMGetDDBEnginesOutput') IS NOT NULL DROP TABLE #lt_MMGetDDBEnginesOutput CREATE TABLE #lt_MMGetDDBEnginesOutput ( CommCellId 				int, SIDBStoreId 			int, SIDBStoreName 			nvarchar(256), SIDBStoreAliasName 		nvarchar(256), archGroupId 			integer, archGroupName 			nvarchar(256), copyId 					int, copyName  				nvarchar(64), totalDataSize 			bigint, sizeOnMedia 			bigint, totalAppSize 			BIGINT, deDupSavingSize 		BIGINT, deletedAFCount 			INT, MaintenanceReason 		INT, jobCount 				INT, baseLineSize 			BIGINT, freeSpaceOnLibrary 		BIGINT, retentionDaysForCopy 	INT, retentionCyclesForCopy 	INT, copyMediaAgentId 		INT, sealedTime    			INT, CreatedTime 			INT, SubstoreCount 			INT, AvgQITime 				INT, UniqueBlocks 			BIGINT, dedupeFlags  			integer, PrimaryRecPercent		INT, Version					INT, MaxAvgQITime 			INT, Flags 					INT, LimitFlag				INT, AvgQITime14Days 		INT, MaxAllowedConnections	INT, LastVerifiedOn			BIGINT, JobsLastVerifiedOn		BIGINT, AppBaselineSize			BIGINT, SizeOfFragmentedSpace 	BIGINT, ActiveStreams			INT, EnableAfterDelayTimeZone INT, EnableAfterDelayTime	INT, SizeOffDiskMB			BIGINT, SizeToBeInSiloMB		BIGINT, SizeInSiloMB			BIGINT, SizeOfBackup			BIGINT, deDupSavingPercent		VARCHAR(20), extendedFlags 			BIGINT , TotalSizeOfUniqueBlocks       BIGINT			)
	EXEC MMGetDDBEngines 0 /*userId*/, 30 /*propertyLevel*/, 0 /*storagePolicyId*/, @i_copyId, @i_SIDBStoreId, @Propfilters
	SELECT	@l_SizeOfStoreMB 				= totalDataSize / (1024.0 * 1024.0),
			@l_SizeOffDiskMB 				= SizeOffDiskMB,
			@l_SizeOfBackup 				= SizeOfBackup,
			@l_SizeOfApplication 			= totalAppSize,
			@l_SizeForBaseline 				= baseLineSize,
			@l_diskFreeSpaceMB 				= freeSpaceOnLibrary,
			@l_SizeForApplicationBaseline 	= AppBaselineSize,
			@l_SizeOfFragmentedSpace 		= SizeOfFragmentedSpace,
			@l_SubStoreCount				= SubstoreCount,
			@l_DeDupSavingsPercent			= deDupSavingPercent,
			@l_Version						= Version,
			@l_EnableAfterDelayTimeZone		= EnableAfterDelayTimeZone,
			@l_EnableAfterDelayTime			= EnableAfterDelayTime
	FROM	#lt_MMGetDDBEnginesOutput
	WHERE	SIDBStoreId = @i_SIDBStoreId
END
SELECT	@l_diskFreeThresholdMB = DiskFreeThresholdMB,
		@l_diskFreeWarningThreshholdMB = diskFreeWarningThreshholdMB
FROM	IdxSIDBStore I WITH (NOLOCK), IdxCache IC WITH (NOLOCK)
WHERE	I.SIDBStoreId = @l_SIDBStoreId
		AND I.IdxCacheId = IC.IdxCacheId
SELECT @o_numberOfRetries = 0
SELECT 	@o_DDBLimitFlag = extendedFlags, @o_DDBLimitExtensionTimeStamp = DDBLimitExtensionTimeStamp
FROM  	archGroupCopy WITH(READUNCOMMITTED)
WHERE 	id = @i_copyId
SELECT	I.SIDBStoreId,
		SIDBStoreName,
		SIDBStoreAliasName,
		CommCellId,
		(SELECT AliasName FROM App_CommCell WITH (NOLOCK) WHERE id = CommCellid) AS CommCellName,
		@i_copyId AS CopyId,
		(SELECT Name FROM ArchGroupCopy WITH (NOLOCK) WHERE id = @i_copyId) AS CopyName,
		@l_SiloCopyId AS SiloCopyId,
		(SELECT Name FROM ArchGroupCopy WITH (NOLOCK) WHERE id = @l_SiloCopyId) AS SiloCopyName,
		@l_nDataInstance AS nDataInstance,
		@l_nSiloStreams AS nSiloStreams,
		@l_SilosInCache AS SilosInCache,
		@l_SiloRestoreMAClientId AS SiloRestoreMAClientId,
		CASE WHEN @l_SiloRestoreMAClientId = 0 THEN ''
			ELSE (SELECT Name FROM App_Client WITH (NOLOCK) WHERE id = @l_SiloRestoreMAClientId) END AS SiloRestoreMAName,
		@l_SiloRestoreClientId AS SiloRestoreClientId,
		CASE WHEN @l_SiloRestoreClientId = 0 THEN ''
			ELSE (SELECT Name FROM App_Client WITH (NOLOCK) WHERE id = @l_SiloRestoreClientId) END AS SiloRestoreClientName,
		@l_BlockCacheValidDays AS BlockCacheValidDays,
		@l_SIDBSnapIntervalHours AS SIDBSnapIntervalHours,
		IdxCacheId,
		IdxAccessPathId,
		ClientId,
		(SELECT Name FROM App_Client WITH (NOLOCK) WHERE id = ClientId) AS ClientName,
		FirstBackupTime,
		MinObjSizeKB,
		oldestEligibleObjArchiveTime,
		SignatureType,
		flags,
		CreatedTime,
		LastSnapTime,
		LastRecoveryTime,
		@l_diskFreeThresholdMB AS DiskFreeThresholdMB,
		@l_diskFreeWarningThreshholdMB AS DiskFreeWarningThreshholdMB,
		@l_SizeOfStoreMB AS SizeOfStoreMB,
		@l_SizeOffDiskMB AS SizeOffDiskMB,
		@l_SizeOfBackup AS SizeOfBackup,
		@l_SizeOfApplication AS SizeOfApplication,
		@l_SizeForBaseline AS SizeForBaseline,
		@l_diskFreeSpaceMB AS DiskFreeSpaceMB,
		@o_numberOfRetries as numberOfRetries,
		@o_DDBLimitExtensionTimeStamp as DDBLimitExtensionTimeStamp,
		@o_DDBLimitFlag as DDBLimitFlag,
		@l_SizeForApplicationBaseline AS SizeForApplicationBaseline,
		@l_SizeOfFragmentedSpace AS SizeOfFragmentedSpace,
		@l_SubStoreCount				SubstoreCount,
		@l_DeDupSavingsPercent			deDupSavingPercent,
		SealedTime,
		@l_Version						Version,
		@l_EnableAfterDelayTimeZone		EnableAfterDelayTimeZone,
		@l_EnableAfterDelayTime			EnableAfterDelayTime,
		ExtendedFlags
FROM	IdxSIDBStore I WITH (NOLOCK)
WHERE	I.SIDBStoreId = @l_SIDBStoreId
IF OBJECT_ID('tempdb.dbo.#SIJob') IS NOT NULL DROP TABLE #SIJob
IF OBJECT_ID('tempdb.dbo.#tmpJobSizeInfo') IS NOT NULL DROP TABLE #tmpJobSizeInfo
GO

IF EXISTS (select * from GxQscripts where name = 'MMGetSIDBStoreByCopy')
	delete from GxQscripts where name = 'MMGetSIDBStoreByCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetSIDBStoreByCopy')
	delete from GXDBVersions where aliasname = 'MMGetSIDBStoreByCopy'
GO

insert into GXDBVersions values(2, 'MMGetSIDBStoreByCopy',  '00010051006600130000', 'MMGetSIDBStoreByCopy', '00010051006600130000')
GO

