

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMGetSIDBStoreAndSubStoreInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2006  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMGetSIDBStoreAndSubStoreInfo.sp,v $ $Id: MMGetSIDBStoreAndSubStoreInfo.sp,v 1.28.2.7 2019/02/15 23:32:19 aselvanayagam Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 	SP: "MMGetSIDBStoreAndSubStoreInfo"
--	|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MMGetSIDBStoreAndSubStoreInfo')
BEGIN
	print '>>> Drop Stored Procedure: MMGetSIDBStoreAndSubStoreInfo <<<'
	drop procedure MMGetSIDBStoreAndSubStoreInfo
END
IF EXISTS (select * from GxQscripts where name='MMGetSIDBStoreAndSubStoreInfo')
	delete from GxQscripts where name = 'MMGetSIDBStoreAndSubStoreInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetSIDBStoreAndSubStoreInfo')
	delete from GXDBVersions where aliasname = 'MMGetSIDBStoreAndSubStoreInfo'
GO
print '... Creating Procedure: MMGetSIDBStoreAndSubStoreInfo'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMGetSIDBStoreAndSubStoreInfo
-- ------------------------------------------------------------------------------------------
-- Function is used to lookup the SIDB and substore information given SiDBStoreId and subStoreId
-- ------------------------------------------------------------------------------------------
  @i_SIDBStoreId integer,
  @i_SubStoreId integer,
  @i_CommcellId integer
AS
  DECLARE @o_SIDBStoreId integer
  DECLARE @o_SIDBStoreName varchar(256)
  DECLARE @o_commCellId integer
  DECLARE @o_copyId integer
  DECLARE @o_nDataInstance integer
  DECLARE @o_blockCacheValidDays integer
  DECLARE @o_SIDBSnapIntervalHours integer
  DECLARE @o_dedupeFlags integer
  DECLARE @o_idxCacheId integer
  DECLARE @o_idxAccessPathId integer
  DECLARE @o_clientId integer
  DECLARE @o_firstBackupTime integer
  DECLARE @o_minObjSizeKB bigint
  DECLARE @o_oldestEligibleObjArchiveTime integer
  DECLARE @o_signatureType integer
  DECLARE @o_flags integer
  DECLARE @o_TotalDataSizeBytes bigint
  DECLARE @o_InstancedDataSizeBytes bigint
  DECLARE @o_Status integer
  DECLARE @o_LastAccessTime integer
  DECLARE @o_SIDBVersion integer
  DECLARE @o_SIDBSnapPath varchar(1024)
  DECLARE @o_IdxPoolId integer
  DECLARE @o_CacheEnabled integer
  DECLARE @o_CacheCreationTime integer
  DECLARE @o_CacheSoftState integer
  DECLARE @o_CacheOfflineReason integer
  DECLARE @o_FillUpOrder integer
  DECLARE @o_CacheAgingPercent integer
  DECLARE @o_LastUpdateTime integer
  DECLARE @o_FreeDiskSpaceMB integer
  DECLARE @o_TotalCapacityMB integer
  DECLARE @o_DiskUsageMB integer
  DECLARE @o_OtherDataMB integer
  DECLARE @o_Description NVARCHAR(128)
  DECLARE @o_DiskFreeThresholdMB integer
  DECLARE @o_PathEnabled integer
  DECLARE @o_PathSoftState integer
  DECLARE @o_PathOfflineReason integer
  DECLARE @o_PathPriority integer
  DECLARE @o_Path varchar(1024)
  DECLARE @o_PathUserName varchar(1024)
  DECLARE @o_PathPassword varchar(2048)
  DECLARE @o_ClientName nvarchar(255)
  DECLARE @o_ClientHostName nvarchar(255)
  DECLARE @o_ClientEnabled integer
  DECLARE @o_ClientSoftState integer
  DECLARE @o_ClientOfflineReason integer
  DECLARE @o_ClientSimOSId integer
  DECLARE @o_CopyHasSiloToCloud integer
  DECLARE @o_SealedSIDBStoreId integer
  DECLARE @o_DiskFreeWarningThreshholdMB integer
  DECLARE @o_SubStoreId integer
  DECLARE @o_GroupNumber integer
  DECLARE @o_subStoreIdxCacheId integer
  DECLARE @o_subStoreIdxAccessPathId integer
  DECLARE @o_subStoreClientId integer
  DECLARE @o_subStoreFirstBackupTime integer
  DECLARE @o_subStoreFlags integer
  DECLARE @o_subStoreTotalDataSizeBytes bigint
  DECLARE @o_subStoreInstancedDataSizeBytes bigint
  DECLARE @o_subStoreStatus integer
  DECLARE @o_subStoreLastAccessTime integer
  DECLARE @o_subStoreSIDBVersion integer
  DECLARE @o_subStoreSIDBSnapPath varchar(1024)
  DECLARE @o_subStoreDiskFreeThresholdMB integer
  DECLARE @o_subStoreDiskFreeWarningThresholdMB integer
  DECLARE @o_subStoreLastSnapTime integer
  DECLARE @o_subStoreLastSnapJobId integer
  DECLARE @o_subStoreCorruptError integer
  DECLARE @o_subStoreClientVersion integer
-- IdxSIDBUsageHistory
  DECLARE @o_HistoryType integer
  DECLARE @o_PrimaryEntries bigint
  DECLARE @o_SecondaryEntries bigint
  DECLARE @o_AvgQITime bigint
  DECLARE @o_AvgQITimeSampleCount integer
  DECLARE @o_NumOfConnections integer
  DECLARE @o_ZeroRefCount bigint
  DECLARE @o_ReserveField1 integer
  DECLARE @o_ReserveField2 bigint
  DECLARE @o_ReserveField3 bigint
  DECLARE @o_ReserveFieldstr NVARCHAR(255)
  DECLARE @o_DataSizeToPrune bigint
  DECLARE @o_SizeOccupied bigint
  DECLARE @o_DDBManagedSize bigint
  DECLARE @o_recoveryStartTime integer
  DECLARE @o_recoveryEndTime integer
  DECLARE @o_timeTakenForRecovery integer
  DECLARE @o_maxSIDBPrimaryRecords BIGINT
  DECLARE @o_maxSIDBAverageQITime INT
  DECLARE @o_maxValuesSubStoreStats XML
  DECLARE @o_minValuesSubStoreStats XML
  DECLARE @o_maxNumOfAFsInSecFile INT
SET NOCOUNT ON
	declare @tblUsage table (SIDBStoreId int, SubStoreId int, CommCellId int, ModifiedTime int, AvgQITime bigint)
	declare @tblRecov table (SIDBStoreId int, SubStoreId int, CommCellId int, StartTime int)
	IF object_id('tempdb.dbo.#tempRecov') is not null DROP TABLE #tempRecov
	IF object_id('tempdb.dbo.#tempUsage') is not null DROP TABLE #tempUsage
	insert into @tblRecov
	select SIDBStoreId, SubStoreId, CommCellId, max(StartTime)
	from IdxSIDBRecoveryHistory
	where SIDBStoreId = @i_SIDBStoreId
	and CommCellId = @i_CommCellId
	and (@i_SubStoreId = 0 or @i_SubStoreId = SubStoreId)
	group by SIDBStoreId, SubStoreId, CommCellId
	insert into @tblUsage
	select SIDBStoreId, SubStoreId, CommCellId, max(ModifiedTime), dbo.GetCurrentAvgQITimeMedian(SIDBStoreId, SubStoreId, CommCellId, 3) AS AvgQITimeMedian --Hardcode since in GUI we show for 3 days
	from IdxSIDBUsageHistory WITH (READUNCOMMITTED)
	where SIDBStoreId = @i_SIDBStoreId
	and CommCellId = @i_CommCellId
	and (@i_SubStoreId = 0 or @i_SubStoreId = SubStoreId)
	group by SIDBStoreId, SubStoreId, CommCellId
	select b.* into #tempRecov
	from @tblRecov a, IdxSIDBRecoveryHistory b
	where a.SIDBStoreId = b.SIDBStoreId
	and a.SubStoreId = b.SubStoreId
	and a.CommCellId = b.CommCellId
	and a.StartTime = b.StartTime
	select 	b.SIDBStoreId,
			b.SubStoreId,
			b.CommCellId,
			b.HistoryType,
			b.ModifiedTime,
			b.PrimaryEntries,
			b.SecondaryEntries,
			a.AvgQITime,
			b.AvgQITimeSampleCount,
			b.NumOfConnections,
			b.ZeroRefCount,
			b.ReserveField1,
			b.PrimaryDataSize,
			b.ReserveField3,
			b.ReserveFieldStr,
			b.DataSizeToPrune,
			b.SizeOccupied,
			b.DDBManagedSize,
			b.DeleteChunkCount
	into #tempUsage
	from @tblUsage a, IdxSIDBUsageHistory b WITH (READUNCOMMITTED)
	where a.SIDBStoreId = b.SIDBStoreId
	and a.SubStoreId = b.SubStoreId
	and a.CommCellId = b.CommCellId
	and a.ModifiedTime = b.ModifiedTime
/* We are using funciton GetCurrentAvgQITimeMedian to get the avgQITime, so commenting out below code.
-- update AvgQITime with the last Avg QI time in case if it zero
-- get Last AvgQI for all substore
  declare @tblLastAvgQIUsage table (SubStoreId int, ModifiedTime int, AvgQITime BIGINT )
  INSERT INTO @tblLastAvgQIUsage
		SELECT A.SubStoreId ,	A.ModifiedTime ,A.AvgQITime
		FROM (
			SELECT
			a.AvgQITime AS AvgQITime ,
			a.SubStoreId AS SubStoreId,
			a.ModifiedTime AS ModifiedTime
			FROM IdxSIDBUsageHistory a WITH (NOLOCK)
			inner join #tempUsage b
			on a.SubStoreId = b.SubStoreId
			 and a.AvgQITime>0
		 ) AS A
	INNER JOIN
		(
		SELECT
		 a.SubStoreId  AS SubStoreId,MAX(a.ModifiedTime) AS ModifiedTime from IdxSIDBUsageHistory a WITH (NOLOCK)
		inner join #tempUsage b
		on a.SubStoreId = b.SubStoreId
		 and a.AvgQITime>0
		 and b.AvgQITime=0
		 group by a.SubStoreId
		) AS B
	ON
	B.SubStoreId =A.SubStoreId
	AND B.ModifiedTime =A.ModifiedTime
	UPDATE #tempUsage
	SET AvgQITime =B.AvgQITime
	FROM #tempUsage A, @tblLastAvgQIUsage B
	WHERE
	A.SubStoreId =B.SubStoreId
*/
	DECLARE @nLastdays INT =1
	DECLARE @filterdate BIGINT = dbo.GetUnixTime(GETUTCDATE()-@nLastdays)
	declare @curAccessPathId	integer
	declare @curIdxCacheId		integer
	declare @CopyIdForSIDBStore 	integer
	declare @lookupMediaGroupId		integer
	declare @lookupSIDBStoreId		integer
	declare @lookupCommcellId		integer
	declare @lookupSubStoreId		integer
	declare @l_nDataInstance	 	integer
	declare @l_blockCacheValidDays 	integer
	declare @l_SIDBSnapIntervalHrs	integer
	declare @l_dedupeFlags			integer
	declare @l_numDaysSIDBBkwdRef		integer
	declare @l_SealedSIDBStoreId		integer
	-- Temporary table to hold the online accesspath for the given idxcacheId.
	declare @OnlineAccessPaths	TABLE (idxaccesspathid int, clientId int)
	declare @numAccessPaths		integer
	declare @unsealedStoreCreateTime int
declare @l_StoreAliasName nvarchar(256)
	declare @MOUNT_PATH_EXTERNAL_REMOTE_HOST integer
	declare @CopyHasSiloToCloud  integer
	declare @l_subStoreDiskFreeThresholdMB	integer
	declare @l_subStoreDiskFreeWarningThresholdMB	integer
	declare @l_subStoreCorruptError integer
	set @MOUNT_PATH_EXTERNAL_REMOTE_HOST = 7
	set @CopyHasSiloToCloud = 0
	set @CopyIdForSIDBStore		=	0
	set @lookupMediaGroupId		=	0
	set @lookupSIDBStoreId		=	0
	set @lookupSubStoreId		=	0
	set @lookupCommCellId		=	0
	set @l_nDataInstance		=	0
	set @l_blockCacheValidDays	=	0
	set @l_SIDBSnapIntervalHrs	=	0
	set @l_dedupeFlags		=	0
	set @l_numDaysSIDBBkwdRef	=	0
	set @l_SealedSIDBStoreId	=	0
	set @unsealedStoreCreateTime=	0
	set @l_subStoreCorruptError =   0
	IF (@i_SIDBStoreId > 0 AND @i_CommcellId > 0)
	BEGIN
		set @lookupSIDBStoreId	= @i_SIDBStoreId
		set @lookupSubStoreId	= @i_SubStoreId
		set @lookupCommCellId	= @i_CommCellId
		set @CopyIdForSIDBStore	=
			(
				SELECT TOP 1 CopyId
				FROM archCopySIDBStore WITH (NOLOCK)
				WHERE (SIDBStoreId = @lookupSIDBStoreId AND CommCellId = @lookupCommCellId)
			)
		SELECT	@l_dedupeFlags = dedupeFlags, @l_nDataInstance = nDataInstance,
				@l_blockCacheValidDays = blockCacheValidDays, @l_SIDBSnapIntervalHrs = SIDBSnapIntervalHours
		FROM	archGroupCopy  WITH (NOLOCK)
		WHERE	id = @CopyIdForSIDBStore
	END
	SELECT 	@unsealedStoreCreateTime = CreatedTime,
			@l_StoreAliasName = SIDBStoreAliasName
	FROM IdxSIDBStore WITH (NOLOCK)
	WHERE (SIDBStoreId = @lookupSIDBStoreId AND CommCellId = @lookupCommCellId)
IF ((@l_dedupeFlags & 2) > 0)
	BEGIN
		SELECT	TOP 1 @l_numDaysSIDBBkwdRef = value
     	FROM	MMConfigs WITH (NOLOCK)
     	WHERE	name = 'MMS2_CONFIG_SIDB_BACKWARD_REF_FROM_SEALEDSTORES_MAX_DAYS'
		-- Check if the time for backward referencing has elapsed
		declare @curTime int
		set @curTime = dbo.GetUnixTime(GETDATE())
		if ((@curTime - @unsealedStoreCreateTime) < (60*60*24*@l_numDaysSIDBBkwdRef))
		BEGIN
			SELECT TOP 1 @l_SealedSIDBStoreId = SIDBStoreId
			FROM IdxSIDBStore WITH (NOLOCK)
			WHERE Status <> 1 and SealedTime > 0 and SIDBStoreAliasName = @l_StoreAliasName
			ORDER BY SIDBStoreId DESC
		END
	END
	-- Get the diskfreethresholdMB and diskfreeWarningThresholdMB values for a given substore
	SELECT @l_blockCacheValidDays = retentionDays
	FROM archAgingRule WITH (NOLOCK)
	WHERE copyId = @CopyIdForSIDBStore
--- Get the maxSIDBPrimaryRecords & maxSIDBAverageQITime values from MMConfigs
	DECLARE	@maxSIDBPrimaryRecords	BIGINT
	DECLARE	@maxSIDBAverageQITime	INT
	SELECT	@maxSIDBPrimaryRecords = CAST(value AS BIGINT)*1000000
	FROM	MMConfigs
	WHERE	name = 'MMCONFIG_MAX_PRIMARYRECS_IN_SIDB_MIL'
	IF	@maxSIDBPrimaryRecords IS NULL
	SET @maxSIDBPrimaryRecords = 1000000000
	SELECT	@maxSIDBAverageQITime = CAST(value AS INT)
	FROM	MMConfigs
	WHERE	name = 'MMCONFIG_MAX_AVGQITIME_FOR_SIDB'
	IF	@maxSIDBAverageQITime IS NULL
	SET @maxSIDBAverageQITime = 1000
	--Get the error code based on dedupeFlags. But only output it, if status is corrupt.
IF ((@l_dedupeFlags & 67108864) > 0)
	BEGIN
SET @l_subStoreCorruptError = 20066
	END
ELSE IF ((@l_dedupeFlags & 33554432) > 0)
	BEGIN
SET @l_subStoreCorruptError = 20067
	END
	ELSE
	BEGIN
SET @l_subStoreCorruptError = 20082
	END
	SELECT
		-- First, the SIDB information
		ST.SIDBStoreId,
		ST.SIDBStoreName,
		ST.CommCellId,
		@CopyIdForSIDBStore AS CopyIdForSIDBStore,
		@l_nDataInstance AS l_nDataInstance,
		@l_blockCacheValidDays AS l_blockCacheValidDays,
		@l_SIDBSnapIntervalHrs AS l_SIDBSnapIntervalHrs,
		@l_dedupeFlags AS l_dedupeFlags,
		ST.IdxCacheId,
		ST.IdxAccessPathId,
		SST.ClientId,
		ST.FirstBackupTime,
		ST.MinObjSizeKB,
		ST.oldestEligibleObjArchiveTime,
		ST.SignatureType,
CASE WHEN ST.SealedTime > 0 THEN ST.flags | 32768 ELSE ST.flags END,
		ST.TotalDataSizeBytes,
		ST.InstancedDataSizeBytes,
		ST.Status,
		ST.LastAccessTime,
		ST.Version,
		ST.SIDBSnapPath,
		-- Second, the index cache info
		IC.IdxPoolId,
		IC.Enabled,
		IC.CreationTime,
		IC.SoftState,
		IC.OfflineReason,
		IC.FillUpOrder,
		IC.AgeingPercentDiskspace,
		IC.LastUpdateTime,
		IC.FreeDiskSpaceMB,
		IC.TotalCapacityMB,
		IC.DiskUsageMB,
		IC.TotalCapacityMB - IC.FreeDiskSpaceMB - IC.DiskUsageMB,
		IC.Description,
		IC.DiskFreeThresholdMB,
		-- Then the access path info
		-- (id, cacheId, and clientId are those that are set on the sidbStoreTable, so no need to
		-- retreive these again)
		AP.Enabled,
		AP.SoftState,
		AP.OfflineReason,
		AP.Priority,
		AP.Path,
		AP.UserName,
		AP.Password,
		-- Lastly, the client information
		CL.name,
		CL.net_hostname,
		H.MmHostEnabled,
		H.MmHostSoftState,
		H.OfflineReason,
		CL.simOperatingSystemId,
		@CopyHasSiloToCloud AS CopyHasSiloToCloud,
		@l_SealedSIDBStoreId AS l_SealedSIDBStoreId,
		IC.DiskFreeWarningThreshholdMB,
		SST.SubStoreId,
		SST.GroupNumber,
		SST.IdxCacheId,
		SST.IdxAccessPathId,
		SST.ClientId,
		SST.FirstBackupTime,
CASE WHEN SST.SealedTime > 0 THEN SST.flags | 32768 ELSE SST.flags END,
		SST.TotalDataSizeBytes,
		SST.InstancedDataSizeBytes,
		SST.Status,
		SST.LastAccessTime,
		SST.Version,
		SST.SIDBSnapPath,
			IC.DiskFreeThresholdMB,
			IC.DiskFreeWarningThreshholdMB,
		SST.LastSnapTime,
		SST.LastSnapJobId,
CASE WHEN SST.Status = 1
			THEN @l_subStoreCorruptError
			ELSE 0
			END,
		CL.releaseId,
		-- IdxSIDBUsageHistory
		ISNULL(UH.HistoryType, 0) as HistoryType,
		ISNULL(UH.PrimaryEntries, 0) as PrimaryEntries,
		ISNULL(UH.SecondaryEntries, 0) as SecondaryEntries,
		ISNULL(UH.AvgQITime, 0) as AvgQITime,
		ISNULL(UH.AvgQITimeSampleCount, 0) as AvgQITimeSampleCount,
		ISNULL(UH.NumOfConnections, 0) as NumOfConnections,
		ISNULL(UH.ZeroRefCount, 0) as ZeroRefCount,
		ISNULL(UH.ReserveField1, 0) as ReserveField1,
		ISNULL(UH.PrimaryDataSize, 0) as PrimaryDataSize,
		ISNULL(UH.ReserveField3, 0) as ReserveField3,
		ISNULL(UH.ReserveFieldStr, N'') as ReserveFieldStr,
		ISNULL(UH.DataSizeToPrune, 0) as DataSizeToPrune,
		ISNULL(UH.SizeOccupied, 0) as SizeOccupied,
		ISNULL(UH.DDBManagedSize, 0) as DDBManagedSize,
		-- IdxSIDBRecoveryHistory
		ISNULL(RH.StartTime, 0) AS StartTime,
		ISNULL(RH.EndTime, 0) AS EndTime,
		ISNULL((EndTime - StartTime), 0) AS timeTakenForRecovery,
		@maxSIDBPrimaryRecords AS maxSIDBPrimaryRecords,
		@maxSIDBAverageQITime  AS maxSIDBAverageQITime
		, (
		SELECT MAX(PrimaryEntries) AS '@uniqueBlocks',
		   MAX(SecondaryEntries) AS '@secondaryBlocks',
		   MAX(ZeroRefCount) AS '@pendingDelRecords',
		   MAX(NumOfConnections) AS '@connections',
		   MAX(AvgQITime) AS '@avgQITime'
		FROM IdxSIDBUsageHistory AS sdh
		WHERE ModifiedTime>=@filterdate
		AND HistoryType = 0
		AND sdh.SubStoreId = SST.SubStoreId
		AND CommCellId  = @i_CommcellId
		AND  ST.SIDBStoreId = sdh.SIDBStoreId
		FOR XML PATH ('maxValuesSubStoreStats'),TYPE)  AS maxValuesSubStoreStats
		,(SELECT MIN(PrimaryEntries) AS '@uniqueBlocks',
		   MIN(SecondaryEntries) AS '@secondaryBlocks',
		   MIN(ZeroRefCount) AS '@pendingDelRecords',
		   MIN(NumOfConnections) AS '@connections',
		   MIN(AvgQITime) AS '@avgQITime'
		FROM IdxSIDBUsageHistory AS sdh
		WHERE ModifiedTime>=@filterdate
		AND HistoryType = 0
		AND sdh.SubStoreId = SST.SubStoreId
		AND CommCellId  = @i_CommcellId
		AND  ST.SIDBStoreId = sdh.SIDBStoreId
		FOR XML PATH ('minValuesSubStoreStats'),TYPE)  AS minValuesSubStoreStats,
		SST.MaxNumOfAFsInSecFile
	FROM	IdxSIDBSubStore AS SST WITH (NOLOCK)
	inner join IdxSIDBStore ST WITH (NOLOCK) on ST.SIDBStoreId = SST.SIDBStoreId
	inner join IdxAccessPath AP WITH (NOLOCK) on AP.IdxAccessPathId = SST.IdxAccessPathId
	inner join IdxCache IC WITH (NOLOCK) on SST.IdxCacheId = IC.IdxCacheId
	inner join APP_Client as CL WITH (NOLOCK) on CL.Id = SST.ClientId
	inner join MMHost as H WITH (NOLOCK) on H.ClientId = CL.Id
	left outer join #tempUsage as UH on UH.SIDBStoreId = SST.SIDBStoreId AND UH.SubStoreId = SST.SubStoreId AND SST.commCellId = UH.CommCellId
	left outer join #tempRecov as RH on RH.SIDBStoreId = SST.SIDBStoreId AND RH.SubStoreId = SST.SubStoreId AND SST.commCellId = RH.CommCellId
	WHERE	ST.SIDBStoreId = @i_SIDBStoreId AND ST.SIDBStoreId > 0
	AND ST.CommCellId = @i_CommCellId
	AND (@i_SubStoreId = 0 OR SST.SubStoreId = @i_SubStoreId)
CX_EXIT:
	IF object_id('tempdb.dbo.#tempRecov') is not null DROP TABLE #tempRecov
	IF object_id('tempdb.dbo.#tempUsage') is not null DROP TABLE #tempUsage
GO

IF EXISTS (select * from GxQscripts where name = 'MMGetSIDBStoreAndSubStoreInfo')
	delete from GxQscripts where name = 'MMGetSIDBStoreAndSubStoreInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetSIDBStoreAndSubStoreInfo')
	delete from GXDBVersions where aliasname = 'MMGetSIDBStoreAndSubStoreInfo'
GO

insert into GXDBVersions values(2, 'MMGetSIDBStoreAndSubStoreInfo',  '00010028000200070000', 'MMGetSIDBStoreAndSubStoreInfo', '00010028000200070000')
GO

