

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMGetSIDBInfoAndFailoverOfflineAccessPath.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2006  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMGetSIDBInfoAndFailoverOfflineAccessPath.sp,v $ $Id: MMGetSIDBInfoAndFailoverOfflineAccessPath.sp,v 1.52.14.8 2020/06/23 04:59:05 lviswambharan Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 	SP: "MMGetSIDBInfoAndFailoverOfflineAccessPath"
--	|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MMGetSIDBInfoAndFailoverOfflineAccessPath')
BEGIN
	print '>>> Drop Stored Procedure: MMGetSIDBInfoAndFailoverOfflineAccessPath <<<'
	drop procedure MMGetSIDBInfoAndFailoverOfflineAccessPath
END
IF EXISTS (select * from GxQscripts where name='MMGetSIDBInfoAndFailoverOfflineAccessPath')
	delete from GxQscripts where name = 'MMGetSIDBInfoAndFailoverOfflineAccessPath'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetSIDBInfoAndFailoverOfflineAccessPath')
	delete from GXDBVersions where aliasname = 'MMGetSIDBInfoAndFailoverOfflineAccessPath'
GO
print '... Creating Procedure: MMGetSIDBInfoAndFailoverOfflineAccessPath'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMGetSIDBInfoAndFailoverOfflineAccessPath
-- ------------------------------------------------------------------------------------------
-- Function is used to lookup the SIDB information given commCellId and SiDBStoreId OR copyId
-- -- if the current accesspath is offline, then failover to an available accesspath.
-- ------------------------------------------------------------------------------------------
  @i_SIDBStoreId integer,
  @i_CommCellId integer,
  @i_CopyId integer,
  @i_VolumeId integer,
  @i_appId integer
AS
  DECLARE @o_SIDBStoreId integer
  DECLARE @o_SIDBStoreName varchar(256)
  DECLARE @o_commCellId integer
  DECLARE @o_copyId integer
  DECLARE @o_nDataInstance integer
  DECLARE @o_blockCacheValidDays integer
  DECLARE @o_SIDBSnapIntervalHours integer
  DECLARE @o_dedupeFlags integer
  DECLARE @o_idxCacheId integer
  DECLARE @o_idxAccessPathId integer
  DECLARE @o_clientId integer
  DECLARE @o_firstBackupTime integer
  DECLARE @o_minObjSizeKB bigint
  DECLARE @o_oldestEligibleObjArchiveTime integer
  DECLARE @o_signatureType integer
  DECLARE @o_flags integer
  DECLARE @o_TotalDataSizeBytes bigint
  DECLARE @o_InstancedDataSizeBytes bigint
  DECLARE @o_Status integer
  DECLARE @o_LastAccessTime integer
  DECLARE @o_SIDBVersion integer
  DECLARE @o_SIDBSnapPath varchar(1024)
  DECLARE @o_LastSnapTime integer
  DECLARE @o_IdxPoolId integer
  DECLARE @o_CacheEnabled integer
  DECLARE @o_CacheCreationTime integer
  DECLARE @o_CacheSoftState integer
  DECLARE @o_CacheOfflineReason integer
  DECLARE @o_FillUpOrder integer
  DECLARE @o_CacheAgingPercent integer
  DECLARE @o_LastUpdateTime integer
  DECLARE @o_FreeDiskSpaceMB integer
  DECLARE @o_Description NVARCHAR(128)
  DECLARE @o_DiskFreeThresholdMB integer
  DECLARE @o_PathEnabled integer
  DECLARE @o_PathSoftState integer
  DECLARE @o_PathOfflineReason integer
  DECLARE @o_PathPriority integer
  DECLARE @o_Path varchar(1024)
  DECLARE @o_PathUserName varchar(1024)
  DECLARE @o_PathPassword varchar(2048)
  DECLARE @o_ClientName nvarchar(255)
  DECLARE @o_ClientHostName nvarchar(255)
  DECLARE @o_ClientSimOSId integer
  DECLARE @o_CopyHasSiloToCloud integer
  DECLARE @o_SealedSIDBStoreId integer
  DECLARE @o_DiskFreeWarningThreshholdMB integer
  DECLARE @o_NumAFsForSecondaryFile integer
SET NOCOUNT ON
	declare @curAccessPathId	integer
	declare @curIdxCacheId		integer
	declare @CopyIdForSIDBStore 	integer
	declare @lookupMediaGroupId		integer
	declare @lookupSIDBStoreId		integer
	declare @lookupCommCellId		integer
	declare @l_nDataInstance	 	integer
	declare @l_blockCacheValidDays 	integer
	declare @l_SIDBSnapIntervalHrs	integer
	declare @l_dedupeFlags			integer
	declare @l_numDaysSIDBBkwdRef		integer
	declare @l_SealedSIDBStoreId		integer
	declare @l_CurStoreSealedTime		integer
	declare @l_isCopySiloBackupEnabled	integer
	declare @l_silosInCache			integer
	-- Temporary table to hold the online accesspath for the given idxcacheId.
	declare @OnlineAccessPaths	TABLE (idxaccesspathid int, clientId int)
	declare @sealedStoreIds		TABLE (SIDBStoreId int)
	declare @numAccessPaths		integer
	declare @unsealedStoreCreateTime int
	declare @MOUNT_PATH_EXTERNAL_REMOTE_HOST integer
	declare @CopyHasSiloToCloud  integer
	set @MOUNT_PATH_EXTERNAL_REMOTE_HOST = 7
	set @CopyHasSiloToCloud = 0
	set @CopyIdForSIDBStore		=	0
	set @lookupMediaGroupId		=	0
	set @lookupSIDBStoreId		=	0
	set @lookupCommCellId		=	0
	set @l_nDataInstance		=	0
	set @l_blockCacheValidDays	=	0
	set @l_SIDBSnapIntervalHrs	=	0
	set @l_dedupeFlags			=	0
	set @l_numDaysSIDBBkwdRef	=	0
	set @l_SealedSIDBStoreId	=	0
	set @unsealedStoreCreateTime=	0
	set @l_CurStoreSealedTime	=	0
	set @l_isCopySiloBackupEnabled	=	0
	set @l_silosInCache		=	0
	DECLARE @tblSourceCopy AS TABLE ( copyId integer, sourceCopyId integer, defaultCopyId integer, archGroupId integer, copyFlags integer,
  dedupeFlags integer, 		maxMultiplex integer, isSnapCopy integer, isMirrorCopy integer, SIBlockSize integer)
	IF (@i_VolumeId > 0)
	BEGIN
		SELECT	@lookupMediaGroupId = MediaGroupId, @lookupSIDBStoreId = SIDBStoreId,
				@lookupCommCellId = CASE WHEN origCCcommCellId > 0 THEN origCCcommCellId ELSE 2 END
		FROM	MMVolume
		WHERE	VolumeId = @i_VolumeId
		SELECT	@CopyIdForSIDBStore = archGroupCopyId
		FROM	archStream
		WHERE	MediaGroupId = @lookupMediaGroupId
		SELECT	@lookupCommCellId = (CASE WHEN @lookupSIDBStoreId > 0 THEN @lookupCommCellId ELSE 2 END),
				@lookupSIDBStoreId = (CASE WHEN @lookupSIDBStoreId > 0 THEN @lookupSIDBStoreId ELSE SIDBStoreId END),
				@l_dedupeFlags = dedupeFlags, @l_nDataInstance = nDataInstance,
				@l_blockCacheValidDays = blockCacheValidDays, @l_SIDBSnapIntervalHrs = SIDBSnapIntervalHours, @l_silosInCache = silosInCache
		FROM	archGroupCopy
		WHERE	id = @CopyIdForSIDBStore
	END
	ELSE
	IF (@i_SIDBStoreId > 0 AND @i_CommCellId > 0)
	BEGIN
		set @lookupSIDBStoreId	= @i_SIDBStoreId
		set @lookupCommCellId	= @i_CommCellId
		IF (@i_CopyId > 0)
			set @CopyIdForSIDBStore	= @i_CopyId
		ELSE
			set @CopyIdForSIDBStore	=
				(
					SELECT TOP 1 CopyId
					FROM archCopySIDBStore
					WHERE (SIDBStoreId = @lookupSIDBStoreId AND CommCellId = @lookupCommCellId)
				)
		SELECT	@l_dedupeFlags = dedupeFlags, @l_nDataInstance = nDataInstance,
				@l_blockCacheValidDays = blockCacheValidDays, @l_SIDBSnapIntervalHrs = SIDBSnapIntervalHours, @l_silosInCache = silosInCache
		FROM	archGroupCopy
		WHERE	id = @CopyIdForSIDBStore
	END
	ELSE
	BEGIN
		SELECT	@CopyIdForSIDBStore	= @i_CopyId, --@lookupSIDBStoreId = SIDBStoreId, @lookupCommCellId = 2,
				@l_dedupeFlags = dedupeFlags, @l_nDataInstance = nDataInstance,
				@l_blockCacheValidDays = blockCacheValidDays, @l_SIDBSnapIntervalHrs = SIDBSnapIntervalHours, @l_silosInCache = silosInCache
		FROM	archGroupCopy
		WHERE	id = @i_CopyId
		IF (@i_appId > 0)
		BEGIN
			SELECT	@lookupSIDBStoreId = SIDBStoreId, @lookupCommCellId = 2
			FROM	archSubClientCopyDDBMap SCD
			WHERE	SCD.appId = @i_appId
					AND SCD.copyId = @i_CopyId
		END
		ELSE
		BEGIN
			SELECT	@lookupSIDBStoreId = SIDBStoreId, @lookupCommCellId = 2
			FROM	archCopySIDBStore CS
			WHERE	CS.copyId = @i_CopyId
AND (CS.flags & (2|4)) = (2|4)
		END
	END
	INSERT INTO @tblSourceCopy
	EXEC archSourceCopyList @CopyIdForSIDBStore
	IF EXISTS (SELECT 1 FROM @tblSourceCopy C, @tblSourceCopy S WHERE C.copyId = @CopyIdForSIDBStore AND C.sourceCopyId = S.copyId
			AND C.SIBlockSize <> S.SIBlockSize)
	BEGIN
SET @l_dedupeFlags = @l_dedupeFlags & ~8388608
	END
	SELECT @curAccessPathId = IdxAccessPathId, @curIdxCacheId = IdxCacheId, @unsealedStoreCreateTime = CreatedTime, @l_CurStoreSealedTime = SealedTime
	FROM IdxSIDBStore WITH (NOLOCK)
	WHERE (SIDBStoreId = @lookupSIDBStoreId AND CommCellId = @lookupCommCellId)
IF ((@l_dedupeFlags & 2097152) > 0)
	BEGIN
		SET @l_isCopySiloBackupEnabled = 1
	END
IF ((@l_dedupeFlags & 2) > 0)
	BEGIN
		SELECT	TOP 1 @l_numDaysSIDBBkwdRef = value
		FROM	MMConfigs WITH (NOLOCK)
		WHERE	name = 'MMS2_CONFIG_SIDB_BACKWARD_REF_FROM_SEALEDSTORES_MAX_DAYS'
		-- Check if the time for backward referencing has elapsed
		declare @curTime int
		set @curTime = dbo.GetUnixTime(GETDATE())
		if (((@curTime - @unsealedStoreCreateTime) < (60*60*24*@l_numDaysSIDBBkwdRef)) AND (@l_CurStoreSealedTime = 0))
		BEGIN
			if (@l_isCopySiloBackupEnabled > 0)
			BEGIN
				INSERT INTO @sealedStoreIds
				SELECT I.SIDBStoreId
				FROM IdxSIDBStore as I with (NOLOCK), MMVolume as MMV with (NOLOCK)
				WHERE I.Status <> 1 and I.SealedTime > 0 and I.SIDBStoreId in (SELECT top(@l_silosInCache + 1) SIDBStoreId from archCopySidbStore with (NOLOCK) where CopyId = @CopyIdForSIDBStore)
				and I.SIDBStoreId = MMV.SIDBStoreId
				--and MMV.SiloStatus <> 3 -- SILO_VOLUME_MIGRATED_OFFDISK is value 3
				-- remove the SIDB store if any of the volume associated has SiloStatus set to SILO_VOLUME_MIGRATED_OFFDISK MR 56519
				and NOT EXISTS
		                     (select VolumeId from MMVolume WITH (NOLOCK) where SiloStatus = 3 /* SILO_VOLUME_MIGRATED_OFFDISK is value 3*/ and SIDBStoreId = I.SIDBStoreId)
				and I.SIDBSiloStatus <> 3 -- DDB_ARCHIVED_OFFDISK
and I.Version >= 2
and I.flags & 256 = 0
				ORDER BY I.SIDBStoreId DESC
				SELECT TOP 1 @l_SealedSIDBStoreId = SIDBStoreId FROM @sealedStoreIds ORDER BY SIDBStoreId DESC
			END
			ELSE
			BEGIN
				INSERT INTO @sealedStoreIds
				SELECT SIDBStoreId
				FROM IdxSIDBStore with (NOLOCK)
				WHERE Status <> 1 and SealedTime > 0 and SIDBStoreId in (SELECT SIDBStoreId from archCopySidbStore with (NOLOCK) where CopyId = @CopyIdForSIDBStore)
and Version >= 2
				and SIDBSiloStatus <> 3 -- DDB_ARCHIVED_OFFDISK
and flags & 256 = 0
				ORDER BY SIDBStoreId DESC
				SELECT TOP 1 @l_SealedSIDBStoreId = SIDBStoreId FROM @sealedStoreIds ORDER BY SIDBStoreId DESC
			END
		END
	END
	-- Commenting for parallel dedup since the accessPathId is now not stored on store level but on substore level.
	--INSERT INTO @OnlineAccessPaths
	--SELECT AP.IdxAccessPathId, AP.ClientId
	--FROM IdxAccessPath AP, MMHost Host
	--WHERE @curIdxCacheId = AP.IdxCacheId AND AP.ClientId = Host.ClientId
	--AND AP.Enabled = 1 AND AP.SoftState = 1
	--AND Host.MmHostSoftState = 1 AND Host.MmHostEnabled = 1
	--set @numAccessPaths = (SELECT COUNT (IdxAccessPathId) FROM @OnlineAccessPaths)
	--IF (@numAccessPaths > 0) AND NOT EXISTS
	--	(SELECT IdxAccessPathId FROM @OnlineAccessPaths WHERE IdxAccessPathId = @curAccessPathId)
	--BEGIN
	--	-- Oh oh, The current active accesspath for this SIDBStore is offline,
	--	-- need to update it with a new accesspath that's online.
	--	UPDATE IdxSIDBStore
	--	SET IdxAccessPathId = (SELECT TOP 1 IdxAccessPathId FROM @OnlineAccessPaths),
	--		ClientId = (SELECT TOP 1 ClientId FROM @OnlineAccessPaths)
	--	WHERE SIDBStoreId = @lookupSIDBStoreId AND CommCellId = @lookupCommCellId
	--END
	-- Check if Copy is a SILO enabled copy first. CopyHasSiloToCloud will be set to 1 for SILO. 2 for SILO to cloud.
IF (@l_dedupeFlags & 2097152 > 0 )
		SET @CopyHasSiloToCloud = 1
	-- Get the silo CopyId first
	DECLARE @siloCopyId INT = 0
SET @siloCopyId = ISNULL((SELECT id FROM archGroupCopy AGC WITH (READUNCOMMITTED) WHERE sourceCopyId = @CopyIdForSIDBStore AND (flags & 524288) > 0 ),0)
	-- Check if SIDB Store's copy has SILO enabled to Cloud Library.Check it for the SILO copy.
	IF EXISTS ( Select * FROM MMMountPath as MP with (readuncommitted), MMDrivePool as DP with (readuncommitted),
							  MMMasterPool as MSP with (readuncommitted), MMDataPath as DTP with (readuncommitted)
				WHERE DTP.CopyId = @siloCopyId and DTP.DrivePoolId = DP.DrivePoolId and
				DP.MasterPoolId = MSP.MasterPoolId and MSP.MasterPoolId = MP.MasterPoolId and
				MP.MountPathTypeId = @MOUNT_PATH_EXTERNAL_REMOTE_HOST )
		SET @CopyHasSiloToCloud = 2
	SELECT @l_blockCacheValidDays = retentionDays
	FROM archAgingRule
	WHERE copyId = @CopyIdForSIDBStore
	-- If reconstruct is off then send SIDBSnapIntervalHrs as 0.
IF ((@l_dedupeFlags & 33554432) = 0)
	BEGIN
		SET @l_SIDBSnapIntervalHrs = 0
	END
	IF ((select COUNT(*) from IdxSIDBSubStore WITH (NOLOCK) where SIDBStoreId = @lookupSIDBStoreId) = 1)
	BEGIN
	-- Now return all the information.
		SELECT
			-- First, the SIDB information
			ST.SIDBStoreId,
			ST.SIDBStoreName,
			ST.CommCellId,
			@CopyIdForSIDBStore,
			@l_nDataInstance,
			@l_blockCacheValidDays,
			@l_SIDBSnapIntervalHrs,
			@l_dedupeFlags,
			Sub.IdxCacheId,
			Sub.IdxAccessPathId,
			Sub.ClientId,
			Sub.FirstBackupTime,
			ST.MinObjSizeKB,
			ST.oldestEligibleObjArchiveTime,
			ST.SignatureType,
			-- SIDB expects store flags. Return store flags.
CASE WHEN ST.SealedTime > 0 THEN ST.flags | 32768 ELSE ST.flags END,
			Sub.TotalDataSizeBytes,
			Sub.InstancedDataSizeBytes,
			Sub.Status,
			Sub.LastAccessTime,
			Sub.Version,
			Sub.SIDBSnapPath,
			Sub.LastSnapTime,
			-- Second, the index cache info
			IC.IdxPoolId,
			IC.Enabled,
			IC.CreationTime,
			IC.SoftState,
			IC.OfflineReason,
			IC.FillUpOrder,
			IC.AgeingPercentDiskspace,
			IC.LastUpdateTime,
			IC.FreeDiskSpaceMB,
			IC.Description,
			IC.DiskFreeThresholdMB,
			-- Then the access path info
			-- (id, cacheId, and clientId are those that are set on the sidbStoreTable, so no need to
			-- retreive these again)
			AP.Enabled,
			AP.SoftState,
			AP.OfflineReason,
			AP.Priority,
			AP.Path,
			AP.UserName,
			AP.Password,
			-- Lastly, the client information
			CL.name,
			CL.net_hostname,
			CL.simOperatingSystemId,
			@CopyHasSiloToCloud,
			@l_SealedSIDBStoreId,
			IC.DiskFreeWarningThreshholdMB,
			ST.MaxNumOfAFsInSecFile
		FROM	IdxSIDBStore AS ST WITH (NOLOCK), IdxCache IC WITH (NOLOCK), IdxAccessPath AP WITH (NOLOCK), APP_Client as CL WITH (NOLOCK), IdxSIDBSubStore AS Sub WITH (NOLOCK)
		WHERE	ST.SIDBStoreId = @lookupSIDBStoreId AND ST.CommCellId = @lookupCommCellId AND
			Sub.IdxCacheId = IC.IdxCacheId AND
			AP.IdxAccessPathId = Sub.IdxAccessPathId AND
			CL.Id = Sub.ClientId AND
                        ST.SIDBStoreId = Sub.SIDBStoreId
	END
	ELSE
	BEGIN
		SELECT
			-- First, the SIDB information
			ST.SIDBStoreId,
			ST.SIDBStoreName,
			ST.CommCellId,
			@CopyIdForSIDBStore,
			@l_nDataInstance,
			@l_blockCacheValidDays,
			@l_SIDBSnapIntervalHrs,
			@l_dedupeFlags,
			0, --ST.IdxCacheId,
			0, --ST.IdxAccessPathId,
			0, --ST.ClientId,
			ST.FirstBackupTime,
			ST.MinObjSizeKB,
			ST.oldestEligibleObjArchiveTime,
			ST.SignatureType,
CASE WHEN ST.SealedTime > 0 THEN ST.flags | 32768 ELSE ST.flags END,
			ST.TotalDataSizeBytes,
			ST.InstancedDataSizeBytes,
			ST.Status,
			ST.LastAccessTime,
			ST.Version,
			ST.SIDBSnapPath,
			ST.LastSnapTime,
			-- Second, the index cache info
			0, --IC.IdxPoolId,
			0, --IC.Enabled,
			0, --IC.CreationTime,
			0, --IC.SoftState,
			0, --IC.OfflineReason,
			0, --IC.FillUpOrder,
			0, --IC.AgeingPercentDiskspace,
			0, --IC.LastUpdateTime,
			0, --IC.FreeDiskSpaceMB,
			'', --IC.Description,
			0, --IC.DiskFreeThresholdMB,
			-- Then the access path info
			-- (id, cacheId, and clientId are those that are set on the sidbStoreTable, so no need to
			-- retreive these again)
			0, --AP.Enabled,
			0, --AP.SoftState,
			0, --AP.OfflineReason,
			0, --AP.Priority,
			'', --AP.Path,
			'', --AP.UserName,
			'', --AP.Password,
			-- Lastly, the client information
			'', --CL.name,
			'', --CL.net_hostname,
			0, --CL.simOperatingSystemId,
			@CopyHasSiloToCloud,
			@l_SealedSIDBStoreId,
			0, --IC.DiskFreeWarningThreshholdMB
			ST.MaxNumOfAFsInSecFile
		FROM	IdxSIDBStore AS ST WITH (NOLOCK)--, IdxCache IC, IdxAccessPath AP, APP_Client as CL
		WHERE	ST.SIDBStoreId = @lookupSIDBStoreId AND ST.CommCellId = @lookupCommCellId --AND
			--ST.IdxCacheId = IC.IdxCacheId AND
			--AP.IdxAccessPathId = ST.IdxAccessPathId AND
			--CL.Id = ST.ClientId
	END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'MMGetSIDBInfoAndFailoverOfflineAccessPath')
	delete from GxQscripts where name = 'MMGetSIDBInfoAndFailoverOfflineAccessPath'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetSIDBInfoAndFailoverOfflineAccessPath')
	delete from GXDBVersions where aliasname = 'MMGetSIDBInfoAndFailoverOfflineAccessPath'
GO

insert into GXDBVersions values(2, 'MMGetSIDBInfoAndFailoverOfflineAccessPath',  '00010052001400080000', 'MMGetSIDBInfoAndFailoverOfflineAccessPath', '00010052001400080000')
GO

