

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMGetRunningJobsForMountPath.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMGetRunningJobsForMountPath.sp,v $ $Id: MMGetRunningJobsForMountPath.sp,v 1.1.2.2 2020/06/24 05:44:50 prasanthm Exp $";
--  +-----------------------------------------------------------------------+
--  |       PROCEDURE	:	"MMGetRunningJobsForMountPath"               				|
--  |       Author	    :	prasanthm                            			|
--  | Execute the System stored procedure to fetch the physical files   	|
--  | .. for the (current) database.                    					|
--  +-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MMGetRunningJobsForMountPath')
BEGIN
	print '>>> Drop Stored Procedure: MMGetRunningJobsForMountPath <<<'
	drop procedure MMGetRunningJobsForMountPath
END
IF EXISTS (select * from GxQscripts where name='MMGetRunningJobsForMountPath')
	delete from GxQscripts where name = 'MMGetRunningJobsForMountPath'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetRunningJobsForMountPath')
	delete from GXDBVersions where aliasname = 'MMGetRunningJobsForMountPath'
GO
print '... Creating Procedure: MMGetRunningJobsForMountPath'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMGetRunningJobsForMountPath
  @i_MountpathId Integer,
  @i_LibraryId Integer,
  @i_HardDeleteLevel Integer
AS
  DECLARE @o_jobId INTEGER
DECLARE @jobIdList TABLE(JobId INTEGER)
DECLARE @MountpathsList TABLE(MountPathId INTEGER, MediaId INTEGER)
IF @i_HardDeleteLevel = 1		-- HARD_DELETE_MOUNTPATH
BEGIN
	INSERT INTO @MountpathsList
	SELECT MP.MountPathId, MS.MediaId FROM MMMountPath MP WITH(NOLOCK)
	INNER JOIN MMMediaSide MS WITH(NOLOCK) ON MS.MediaSideId = MP.MediaSideId
	WHERE MP.MountPathId = @i_MountpathId
END
ELSE							-- HARD_DELETE_LIBRARY
BEGIN
	INSERT INTO @MountpathsList
	SELECT MP.MountPathId, MS.MediaId FROM MMMountPath MP WITH(NOLOCK)
	INNER JOIN MMMediaSide MS WITH(NOLOCK) ON MS.MediaSideId = MP.MediaSideId
	WHERE MP.LibraryId = @i_LibraryId
END
-- Running jobs
INSERT INTO @jobIdList
SELECT DISTINCT JM.jobId
FROM @MountpathsList TMP
INNER JOIN MMResource RE WITH(NOLOCK) ON RE.MediaId = TMP.MediaId
INNER JOIN MMResourceToJob RJ WITH(NOLOCK) ON RJ.ReservationId = RE.ReservationId
INNER JOIN JMJobInfo JM WITH(NOLOCK) ON JM.jobId = RJ.JobId_h OR JM.jobId = RJ.JobId_l
-- Suspended, Waiting, pending jobs
INSERT INTO @jobIdList
SELECT DISTINCT JM.jobId
FROM @MountpathsList TMP
INNER JOIN JMJobResourceHistory RE WITH(NOLOCK) ON RE.MediaId = TMP.MediaId
INNER JOIN JMJobInfo JM WITH(NOLOCK) ON JM.jobId = RE.jobId
LEFT OUTER JOIN @jobIdList TJM ON TJM.jobId = JM.jobId
WHERE TJM.jobId IS NULL
SELECT jobId FROM @jobIdList
GO

IF EXISTS (select * from GxQscripts where name = 'MMGetRunningJobsForMountPath')
	delete from GxQscripts where name = 'MMGetRunningJobsForMountPath'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetRunningJobsForMountPath')
	delete from GXDBVersions where aliasname = 'MMGetRunningJobsForMountPath'
GO

insert into GXDBVersions values(2, 'MMGetRunningJobsForMountPath',  '00010001000200020000', 'MMGetRunningJobsForMountPath', '00010001000200020000')
GO

